/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.transaction.dao;

import gov.epa.cdx.model.transaction.DocumentHistory;
import gov.epa.cdx.model.transaction.TransactionHistory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.ResultReader;

public class TransactionHistoryResultReader
implements ResultReader {
    protected Map results = new HashMap();

    public List getResults() {
        return new ArrayList(this.results.values());
    }

    public void processRow(ResultSet rs) throws SQLException {
        TransactionHistory transaction;
        String transactionId = rs.getString("transaction_id");
        if (this.results.containsKey(transactionId)) {
            transaction = (TransactionHistory)this.results.get(transactionId);
        } else {
            transaction = new TransactionHistory();
            transaction.setId(transactionId);
            transaction.setStatus(rs.getString("trans_status_id"));
            transaction.setDataflow(rs.getString("dataflow_type_id"));
            transaction.setCreationTime((Date)rs.getTimestamp("created_tm"));
            this.results.put(transactionId, transaction);
        }
        DocumentHistory document = new DocumentHistory();
        document.setId(rs.getString("document_id"));
        document.setName(rs.getString("document_name_tx"));
        document.setStatus(rs.getString("validation_status_id"));
        document.setType(rs.getString("document_type_id"));
        transaction.getDocuments().add(document);
    }
}

