/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.trust;

import gov.epa.cdx.axis.trust.SecurityTokenPortType;
import gov.epa.cdx.axis.trust.client.SecurityTokenLocator;
import gov.epa.cdx.axis.trust.types.AuthMethod;
import gov.epa.cdx.axis.trust.types.PasswordType;
import gov.epa.cdx.axis.trust.types.TokenType;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.infrastructure.node.NodeMgr;
import gov.epa.cdx.logic.security.CdxSecurityManager;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.node.NodeVersion;
import gov.epa.cdx.model.node.NodeVersionVO;
import gov.epa.cdx.model.user.UserInfoVO;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis.AxisFault;

public class SecurityTokenManager {
    protected static LogInterface log;
    private static final NodeKey NASS_NODE_KEY;
    private static NodeVersionVO trustNodeVO;
    private static final String CATEGORY = "TrustTokenService";
    private static final String TOKEN_TYPE_KEY = "TokenType";
    private static final String AUTH_METHOD_KEY = "AuthMethod";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.trust.SecurityTokenManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        NASS_NODE_KEY = new NodeKey("trustNAAS", NodeVersion.V10);
        trustNodeVO = null;
    }

    public static String createSecurityToken(String issuer, UserInfoVO userInfo, String clientIP) throws CDXException {
        String sToken = "";
        StringBuffer userData = new StringBuffer();
        userData.append("name=" + userInfo.getFirstName() + " " + userInfo.getLastName());
        SecurityTokenManager.buildUserRoles(userInfo.getRoles(), userData);
        SecurityTokenManager.buildUserAdditionalData(userInfo.getAdditionalData(), userData);
        sToken = SecurityTokenManager.createSecurityToken(issuer, userInfo.getUserId(), userData.toString(), clientIP);
        return sToken;
    }

    public static String createSecurityToken(String issuer, String userID, String userData, String clientIP) throws CDXException {
        String sToken = "";
        String trustee = CdxSecurityManager.getId();
        PasswordType pwd = new PasswordType(CdxSecurityManager.getCredential());
        String tokenType = CDXPropertyManager.getProperty((String)CATEGORY, (String)TOKEN_TYPE_KEY);
        String authMethod = CDXPropertyManager.getProperty((String)CATEGORY, (String)AUTH_METHOD_KEY);
        try {
            AuthMethod am = AuthMethod.fromString((String)authMethod);
            TokenType tt = TokenType.fromString((String)tokenType);
            SecurityTokenPortType port = SecurityTokenManager.getPort();
            sToken = port.createSecurityToken(trustee, pwd, tt, issuer, am, userID, userData, clientIP);
        }
        catch (Exception e) {
            throw SecurityTokenManager.supportExceptions(e);
        }
        return sToken;
    }

    public static String validate(String sToken, String clientIP, String resourceURI) throws CDXException {
        String value = "";
        SecurityTokenPortType port = SecurityTokenManager.getPort();
        try {
            value = port.validate(sToken, clientIP, resourceURI);
        }
        catch (RemoteException e) {
            throw SecurityTokenManager.supportExceptions(e);
        }
        return value;
    }

    private static SecurityTokenPortType getPort() throws CDXException {
        SecurityTokenPortType port = null;
        String url = "";
        try {
            if (trustNodeVO == null) {
                trustNodeVO = NodeMgr.getNodeByNodeKey(NASS_NODE_KEY);
            }
            url = trustNodeVO.getUrl();
            SecurityTokenLocator locator = new SecurityTokenLocator();
            if (url == null) {
                url = locator.getSecurityTokenPortTypeAddress();
                port = locator.getSecurityTokenPortType();
            } else {
                URL portURL = new URL(url);
                port = locator.getSecurityTokenPortType(portURL);
            }
            if (port == null) {
                throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)new Exception("Couldn't open the port!"));
            }
        }
        catch (CDXException e) {
            throw e;
        }
        catch (MalformedURLException e) {
            log.error((Object)("Couldn't convert to URL object:" + url), (Throwable)e);
            throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        catch (Throwable th) {
            log.error((Object)("Couldn't connect to URL:" + url), th);
            throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, th);
        }
        return port;
    }

    private static void buildUserRoles(Collection roles, StringBuffer destination) {
        StringBuffer sb = new StringBuffer("&role=");
        if (roles != null) {
            Iterator iterator = roles.iterator();
            while (iterator.hasNext()) {
                Object role = iterator.next();
                sb.append(role + ",");
            }
            if (!sb.toString().equalsIgnoreCase("&role=")) {
                sb = sb.deleteCharAt(sb.length() - 1);
            }
        }
        destination.append(sb);
    }

    private static void buildUserAdditionalData(Map data, StringBuffer destination) {
        StringBuffer sb = new StringBuffer("");
        if (data != null) {
            Iterator iterator = data.keySet().iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                Object value = data.get(key);
                sb.append("&" + key + "=" + value);
            }
        }
        destination.append(sb);
    }

    private static CDXException supportExceptions(Exception ex) {
        CDXException cdxEx = new CDXException(CDXErrorCode.AUTHENTICATION_AUTHORIZATION_ERROR);
        log.error((Object)"Remote Call Exception:", (Throwable)ex);
        if (ex instanceof AxisFault) {
            AxisFault f = (AxisFault)ex;
            cdxEx.setNestedException((Throwable)new Exception(f.getFaultString()));
        } else {
            cdxEx.setNestedException((Throwable)ex);
        }
        return cdxEx;
    }
}

