/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.validation;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.util.GUID;
import gov.epa.cdx.infrastructure.distributor.DistributorFactory;
import gov.epa.cdx.infrastructure.document.DocumentMgr;
import gov.epa.cdx.infrastructure.node.NodeMgr;
import gov.epa.cdx.infrastructure.scheduler.TaskManager;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.node.NodeVersion;
import gov.epa.cdx.model.scheduler.TaskStatus;
import gov.epa.cdx.model.scheduler.TaskTypeVO;
import gov.epa.cdx.model.scheduler.TaskVO;
import gov.epa.cdx.model.transaction.TransactionVO;
import gov.epa.cdx.model.validation.AsynchronousDocumentValidationVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AsynchronousValidatorManager {
    public static final String ASYNCHRONOUS_VALIDATOR_DATAFLOW = "Validate";
    public static final NodeKey ASYNCHRONOUS_VALIDATOR_DATAFLOW_KEY = new NodeKey("Validate", NodeVersion.V10);
    public static final String ASYNCHRONOUS_VALIDATOR_AUTH_KEY = "Validate.Auth";
    public static final String ASYNCHRONOUS_VALIDATOR_USER_KEY = "Validate.User";
    public static final String ASYNCHRONOUS_VALIDATOR_RETURN_KEY = "Validate.Return";
    public static final String ASYNCHRONOUUS_VALIDATOR_TASK = "VALIDATE";
    protected static LogInterface log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.validation.AsynchronousValidatorManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public static void validate(AsynchronousDocumentValidationVO info, Map taskParameters) throws CDXException {
        TaskVO validationTask = null;
        try {
            String returnUrl = info.getSendResultTo() == null ? NodeMgr.getUrlByNode(ASYNCHRONOUS_VALIDATOR_RETURN_KEY) : info.getSendResultTo();
            String password = info.getPassword() == null ? NodeMgr.getUrlByNode(ASYNCHRONOUS_VALIDATOR_AUTH_KEY) : info.getPassword();
            String userId = info.getUserId() == null ? NodeMgr.getUrlByNode(ASYNCHRONOUS_VALIDATOR_USER_KEY) : info.getUserId();
            HashMap<String, String> validateParameters = new HashMap<String, String>();
            validateParameters.put("validationDocumentId", info.getDocumentId());
            validateParameters.put("validationDocumentType", info.getDocumentType());
            validateParameters.put("validationFormat", info.getFormat());
            validateParameters.put("validationType", info.getValidationType());
            validateParameters.put("validationUserId", userId);
            validateParameters.put("validationSendResultTo", returnUrl);
            validateParameters.put("validationPassword", password);
            if (taskParameters == null) {
                taskParameters = validateParameters;
            } else {
                taskParameters.putAll(validateParameters);
            }
            ArrayList<NodeKey> nodeKeys = new ArrayList<NodeKey>();
            nodeKeys.add(ASYNCHRONOUS_VALIDATOR_DATAFLOW_KEY);
            validationTask = new TaskVO(GUID.getGUID(), "Validate Document", new TaskTypeVO(ASYNCHRONOUUS_VALIDATOR_TASK), System.currentTimeMillis(), taskParameters, nodeKeys);
            TransactionVO tx = DocumentMgr.getTransactionForDocument(info.getDocumentId());
            validationTask.setTaskTransaction(ASYNCHRONOUS_VALIDATOR_DATAFLOW_KEY, tx);
            validationTask.setStatus(TaskStatus.InProgress);
            TaskManager.saveTask(validationTask);
            DistributorFactory.getDistributor(ASYNCHRONOUS_VALIDATOR_DATAFLOW).distribute(validationTask);
        }
        catch (Throwable t) {
            log.error((Object)"AsynchronousValidatorManager could not validate document", t);
            if (validationTask != null) {
                validationTask.setStatus(TaskStatus.Failure);
                TaskManager.setTaskStatus(validationTask);
            }
            throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)new Exception("AsynchronousValidatorManager could not validate document", t));
        }
    }
}

