/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.validation;

import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.infrastructure.validation.DocumentValidater;
import gov.epa.cdx.infrastructure.validation.validaters.XMLValidater;
import gov.epa.cdx.model.document.DocumentType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DocumentValidaterFactory {
    private Map validatersByDocType = new HashMap();

    private DocumentValidaterFactory() {
    }

    public static DocumentValidaterFactory NewInstance() {
        return new DocumentValidaterFactory();
    }

    public DocumentValidater getValidaterInstance(DocumentType docType) throws CDXException {
        if (!this.validatersByDocType.containsKey(docType) && docType.equals((Object)DocumentType.XML)) {
            this.validatersByDocType.put(docType, new XMLValidater());
        }
        return (DocumentValidater)this.validatersByDocType.get(docType);
    }

    public void dispose() {
        Iterator it = this.validatersByDocType.keySet().iterator();
        while (it.hasNext()) {
            ((DocumentValidater)this.validatersByDocType.get(it.next())).dispose();
        }
        this.validatersByDocType.clear();
        this.validatersByDocType = null;
    }
}

