/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.validation;

import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.infrastructure.document.DocumentMgr;
import gov.epa.cdx.infrastructure.validation.DocumentValidater;
import gov.epa.cdx.infrastructure.validation.DocumentValidaterFactory;
import gov.epa.cdx.infrastructure.validation.dao.DocumentValidationDAO;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.document.DocumentVO;
import gov.epa.cdx.model.transaction.TransactionVO;
import gov.epa.cdx.model.validation.DocumentValidationResultVO;
import gov.epa.cdx.model.validation.DocumentValidationStatus;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DocumentValidationManager {
    public static Map Validate(DocumentList docList, boolean throwExceptionOnFirstValidationFailure) throws CDXValidationException, CDXException {
        Collection docs = docList.getDocuments();
        HashMap<String, DocumentValidationResultVO> resultsByDocId = new HashMap<String, DocumentValidationResultVO>();
        DocumentValidaterFactory factory = DocumentValidaterFactory.NewInstance();
        Iterator it = docs.iterator();
        while (it.hasNext()) {
            DocumentVO nextDoc = (DocumentVO)it.next();
            DocumentValidationStatus status = DocumentValidationDAO.GeDocumentValidationStatus(nextDoc);
            if (status.equals(DocumentValidationStatus.VALIDATED) || status.equals(DocumentValidationStatus.FAILED) || status.equals(DocumentValidationStatus.VALIDATION_NOT_SUPPORTED)) {
                resultsByDocId.put(nextDoc.getID(), new DocumentValidationResultVO(nextDoc, status));
                continue;
            }
            DocumentValidater validater = factory.getValidaterInstance(nextDoc.getDocumentType());
            DocumentValidationResultVO validationResult = null;
            if (validater != null) {
                try {
                    validater.validate(nextDoc);
                    validationResult = new DocumentValidationResultVO(nextDoc, DocumentValidationStatus.VALIDATED);
                    resultsByDocId.put(nextDoc.getID(), validationResult);
                }
                catch (CDXValidationException e) {
                    if (throwExceptionOnFirstValidationFailure) {
                        throw e;
                    }
                    validationResult = new DocumentValidationResultVO(nextDoc, DocumentValidationStatus.FAILED, (Throwable)e);
                    resultsByDocId.put(nextDoc.getID(), validationResult);
                }
            } else {
                validationResult = new DocumentValidationResultVO(nextDoc, DocumentValidationStatus.VALIDATION_NOT_SUPPORTED);
                resultsByDocId.put(nextDoc.getID(), validationResult);
            }
            DocumentValidationDAO.SaveValidationStatus(validationResult);
        }
        factory.dispose();
        return resultsByDocId;
    }

    public static Map Validate(TransactionVO tranVO, boolean throwExceptionOnFirstValidationFailure) throws CDXValidationException, CDXException {
        return DocumentValidationManager.Validate(DocumentMgr.getDocumentsMetaData(tranVO.getTransactionID()), throwExceptionOnFirstValidationFailure);
    }
}

