/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.validation;

import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.infrastructure.document.DocumentMgr;
import gov.epa.cdx.infrastructure.validation.DocumentValidationManager;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentInterface;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.document.DocumentType;
import gov.epa.cdx.model.document.DocumentVO;
import gov.epa.cdx.model.transaction.TransactionVO;
import junit.framework.Assert;
import junit.framework.TestCase;

public class DocumentValidationManagerTest
extends TestCase {
    public DocumentValidationManagerTest() {
        super("DocumentValidationManagerTest");
    }

    public DocumentValidationManagerTest(String arg0) {
        super(arg0);
    }

    public void testValidateAllDocumentsViaTransactionVO() {
        TransactionVO transactionVO = null;
        try {
            transactionVO = this.createDocuments(1);
            System.out.println(DocumentValidationManager.Validate(transactionVO, false));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Problem validating documents");
        }
    }

    private TransactionVO createDocuments(int i) throws CDXException {
        TransactionVO transactionVO = null;
        DocumentList documentList = this.createDocumentList(i, true);
        transactionVO = DocumentMgr.createDocuments(null, documentList);
        return transactionVO;
    }

    private DocumentList createDocumentList(int row, boolean isDataRequired) throws CDXException {
        String xml;
        DocumentType[][] documentTypes = new DocumentType[][]{{DocumentType.XML, DocumentType.FLAT, DocumentType.BINARY}, {DocumentType.OTHER, DocumentType.XML, DocumentType.BINARY}, {DocumentType.XML, DocumentType.FLAT, DocumentType.OTHER}};
        String[][] names = new String[][]{{"Arty", "Denis", "Dodik"}, {"Bopsen", "Bulyul", "Shurik"}, {"Leto", "Zima", "Osyen"}};
        String[][] data = new String[][]{{"Ochen krupny kaban", "Bilyardist i lubitel poest'", "Shibko umny"}, {"Krasavitsa narodnaya", "Pobeditel' vseh kastrul'", "Razgovorchivy Myshonok"}, {"prishlo s dojdyami", "lyutaya razygralas'", "listya jeltye..."}};
        data[0][0] = xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><FacilitySiteDetails xmlns:xsi =\"http://www.w3.org/2000/10/XMLSchema-instance\"><FacilitySiteDetails>            <FacilitySite>                <FacilityRegistryIdentifier/>                <FacilitySiteName>Alliance Animal Clinic        </FacilitySiteName>                <FacilitySiteTypeName/>                <FederalFacilityIndicator/>                <TribalLandIndicator/>                <TribalLandName/>                <CongressionalDistrictNumber>3</CongressionalDistrictNumber>                <LegislativeDistrictNumber>49</LegislativeDistrictNumber>                <HUCCode/>            </FacilitySite>            <LocationAddress>                <LocationAddressText>903 Flack Ave                 </LocationAddressText>                <SupplementalLocationText>            </SupplementalLocationText>                <LocalityName>Alliance        </LocalityName>                <CountyStateFIPSCode>31013</CountyStateFIPSCode>                <CountyName>Box Butte   </CountyName>                <StateUSPSCode>NE</StateUSPSCode>                <StateName>NE</StateName>                <CountryName>USA</CountryName>                <LocationZIPCode>69301 2777</LocationZIPCode>                <LocationDescriptionText/>            </LocationAddress>            <DataSourceName>IIS</DataSourceName>            <LastReportedDate>1993-12-21</LastReportedDate>            <stateFacilitySystemAcronymName>IIS</stateFacilitySystemAcronymName>            <stateFacilityIdentifier>1715</stateFacilityIdentifier>        </FacilitySiteDetails></FacilitySiteDetails>";
        data[1][1] = xml;
        data[2][0] = xml;
        DocumentList documentList = new DocumentList(new DataflowTypeVO("TEST"));
        int k = 0;
        while (k < 3) {
            DocumentVO document = null;
            document = isDataRequired ? new DocumentVO(null, names[row][k], documentTypes[row][k], new DataflowTypeVO("TEST"), data[row][k].getBytes()) : new DocumentVO(null, names[row][k], documentTypes[row][k], new DataflowTypeVO("TEST"));
            documentList.addDocument((DocumentInterface)document);
            ++k;
        }
        return documentList;
    }
}

