/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.validation;

import gov.epa.cdx.axis.validatormgr.client.ValidatorRequestor;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXExternalServerException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.infrastructure.node.NodeMgr;
import gov.epa.cdx.logic.security.CdxSecurityManager;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.node.NodeVersion;
import gov.epa.cdx.model.node.NodeVersionVO;
import gov.epa.cdx.model.validation.DocumentValidationResultVO;
import gov.epa.cdx.model.validation.DocumentValidationVO;
import java.net.URL;

public class ValidatorManager {
    protected static LogInterface log;
    private static final NodeKey VALIDATOR_MGR_KEY;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.validation.ValidatorManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        VALIDATOR_MGR_KEY = new NodeKey("Validator", NodeVersion.V10);
    }

    public static ValidatorRequestor getValidatorRequestor() throws CDXExternalServerException {
        ValidatorRequestor validatorRequestor = null;
        try {
            NodeVersionVO nodeVersion = NodeMgr.getNodeByNodeKey(VALIDATOR_MGR_KEY);
            validatorRequestor = new ValidatorRequestor(new URL(nodeVersion.getUrl()));
        }
        catch (Exception ex) {
            throw new CDXExternalServerException(CDXErrorCode.HTTP_CONNECTION_FAILURE, (Throwable)ex);
        }
        return validatorRequestor;
    }

    public static DocumentValidationResultVO schemaValidate(DocumentValidationVO info) throws CDXException {
        DocumentValidationResultVO documentValidationResultVO = null;
        try {
            ValidatorRequestor validatorRequestor = ValidatorManager.getValidatorRequestor();
            ValidatorManager.populateCredentials(info);
            documentValidationResultVO = validatorRequestor.schemaValidate(info);
        }
        catch (Exception ex) {
            throw new CDXException(CDXErrorCode.VALIDATION_ERROR, (Throwable)ex);
        }
        return documentValidationResultVO;
    }

    public static DocumentValidationResultVO schematronValidate(DocumentValidationVO info) throws CDXException {
        DocumentValidationResultVO documentValidationResultVO = null;
        try {
            ValidatorRequestor validatorRequestor = ValidatorManager.getValidatorRequestor();
            ValidatorManager.populateCredentials(info);
            documentValidationResultVO = validatorRequestor.schematronValidate(info);
        }
        catch (Exception ex) {
            throw new CDXException(CDXErrorCode.VALIDATION_ERROR, (Throwable)ex);
        }
        return documentValidationResultVO;
    }

    public static DocumentValidationResultVO schematronAndSchemaValidate(DocumentValidationVO info) throws CDXException {
        DocumentValidationResultVO documentValidationResultVO = null;
        try {
            ValidatorRequestor validatorRequestor = ValidatorManager.getValidatorRequestor();
            ValidatorManager.populateCredentials(info);
            documentValidationResultVO = validatorRequestor.schematronAndSchemaValidate(info);
        }
        catch (Exception ex) {
            throw new CDXException(CDXErrorCode.VALIDATION_ERROR, (Throwable)ex);
        }
        return documentValidationResultVO;
    }

    private static void populateCredentials(DocumentValidationVO info) {
        if (info.getUserId() == null && info.getPassword() == null) {
            info.setUserId(CdxSecurityManager.getId());
            info.setPassword(CdxSecurityManager.getCredential());
        }
    }
}

