/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.validation.dao;

import gov.epa.cdx.commons.basedao.dao.BaseDAO;
import gov.epa.cdx.commons.exception.CDXDAOException;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentVO;
import gov.epa.cdx.model.validation.DocumentValidationResultVO;
import gov.epa.cdx.model.validation.DocumentValidationStatus;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class DocumentValidationDAO {
    protected static LogInterface log;
    private static String SELECT_SQL_SCHEMA_URLS_BY_DATAFLOW;
    private static String UPDATE_SQL_VALIDATION_STATUS;
    private static String SELECT_SQL_DOCUMENT_VALIDATION_STATUS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.validation.dao.DocumentValidationDAO");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        SELECT_SQL_SCHEMA_URLS_BY_DATAFLOW = "select * from CDX_DATAFLOW_SCHEMAS where DATAFLOW_TYPE_ID=?";
        UPDATE_SQL_VALIDATION_STATUS = "update CDX_DOCUMENTS set VALIDATION_STATUS_ID=? where DOCUMENT_ID=?";
        SELECT_SQL_DOCUMENT_VALIDATION_STATUS = "select VALIDATION_STATUS_ID from CDX_DOCUMENTS where DOCUMENT_ID=? ";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection GetSchemaURLsForDataFlowType(DataflowTypeVO type) throws CDXException {
        block12: {
            urls = new ArrayList<String>();
            connection = null;
            pstmt = null;
            result = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(DocumentValidationDAO.SELECT_SQL_SCHEMA_URLS_BY_DATAFLOW);
                    pstmt.setString(1, type.toString());
                    result = pstmt.executeQuery();
                    while (result.next()) {
                        urls.add(result.getString("SCHEMA_URL_TX"));
                    }
                }
                catch (CDXDAOException ex) {
                    DocumentValidationDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    DocumentValidationDAO.log.error((Object)("Unable to get Schema URLs For DataFlow Type: " + type), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    DocumentValidationDAO.log.error((Object)("Error happend inside DocumentValidationDAO class, GetSchemaURLsForDataflowTypeVO method,  for dataflow type: " + type), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var7_8) {
                var6_9 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception v0) {
                    DocumentValidationDAO.log.error((Object)"Couldn't close one of the following: connection or resultset or prepared statment");
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var7_8;
            }
            {
                var6_10 = null;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 189->205)] { 
lbl39:
            // 1 sources

            result.close();
            pstmt.close();
            break block12;
lbl42:
            // 1 sources

            catch (Exception v1) {
                DocumentValidationDAO.log.error((Object)"Couldn't close one of the following: connection or resultset or prepared statment");
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return urls;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int SaveValidationStatus(DocumentValidationResultVO validationResult) throws CDXException {
        block12: {
            connection = null;
            pstmt = null;
            result = 0;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(DocumentValidationDAO.UPDATE_SQL_VALIDATION_STATUS);
                    pstmt.setString(1, validationResult.getValidationStatus().getStatusDesc());
                    pstmt.setString(2, validationResult.getDocId());
                    result = pstmt.executeUpdate();
                    if (pstmt.executeUpdate() != 1) {
                        throw new CDXValidationException(CDXErrorCode.INVALID_DOCUMENT_ID);
                    }
                }
                catch (CDXDAOException ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentValidationDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException e) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentValidationDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (SQLException ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentValidationDAO.log.error((Object)"Unable to save Validation Status.", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentValidationDAO.log.error((Object)"Error happend inside DocumentValidationDAO class, SaveValidationStatus method ", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var6_8) {
                var5_9 = null;
                try {
                    pstmt.close();
                    throw var6_8;
                }
                catch (Exception v0) {
                    DocumentValidationDAO.log.error((Object)"Couldn't close prepared statment");
                }
                throw var6_8;
            }
            {
                var5_10 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 190->199)] { 
lbl41:
            // 1 sources

            pstmt.close();
            break block12;
lbl43:
            // 1 sources

            catch (Exception v1) {
                DocumentValidationDAO.log.error((Object)"Couldn't close prepared statment");
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DocumentValidationStatus GeDocumentValidationStatus(DocumentVO doc) throws CDXException {
        String status = null;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet result = null;
        try {
            try {
                connection = BaseDAO.getConnection();
                pstmt = connection.prepareStatement(SELECT_SQL_DOCUMENT_VALIDATION_STATUS);
                pstmt.setString(1, doc.getID());
                result = pstmt.executeQuery();
                if (!result.next()) {
                    log.error((Object)("No records  were retrieved from the database for document: " + doc.getID()));
                    throw new CDXValidationException(CDXErrorCode.INVALID_DOCUMENT_ID);
                }
                status = result.getString("VALIDATION_STATUS_ID");
            }
            catch (CDXDAOException ex) {
                log.error((Object)"", (Throwable)ex);
                throw ex;
            }
            catch (CDXValidationException e) {
                log.error((Object)"", (Throwable)e);
                throw e;
            }
            catch (SQLException ex) {
                log.error((Object)("Unable to get Document Validation Status for document: " + doc.getID()), (Throwable)ex);
                throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
            }
            catch (Exception ex) {
                log.error((Object)"Error happend inside DocumentValidationDAO class, GetDocumentValidationStatus method ", (Throwable)ex);
                throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                result.close();
                pstmt.close();
            }
            catch (Exception exception) {}
            BaseDAO.closeConnection((Connection)connection);
            throw throwable;
        }
        {
            Object var6_11 = null;
        }
        try {}
        catch (Exception exception) {}
        result.close();
        pstmt.close();
        BaseDAO.closeConnection((Connection)connection);
        return DocumentValidationStatus.getStatus((String)status);
    }
}

