/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.validation.validaters;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.infrastructure.servicelookup.dao.ServiceLookupDAO;
import gov.epa.cdx.infrastructure.validation.DocumentValidater;
import gov.epa.cdx.infrastructure.validation.dao.DocumentValidationDAO;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentVO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLValidater
implements DocumentValidater {
    private static String EXTERNAL_SCHEMA_PARSER_PROPERTY = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    private static String VALIDATION_PARSER_FEATURE = "http://xml.org/sax/features/validation";
    private static String SCHEMA_VALIDATION_PARSER_FEATURE = "http://apache.org/xml/features/validation/schema";
    protected SAXParser parser;
    private Map schemaURLsPerDataFlow;
    protected boolean validate = true;
    protected boolean schemaValidate = true;

    public XMLValidater() throws CDXException {
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
            this.parser.getXMLReader().setErrorHandler(new DefaultErrorHandler());
            this.schemaURLsPerDataFlow = new HashMap();
            Collection dataFlows = ServiceLookupDAO.getAllDataFlows();
            Iterator dfIt = dataFlows.iterator();
            while (dfIt.hasNext()) {
                String nextDataFlow = (String)dfIt.next();
                Collection urls = DocumentValidationDAO.GetSchemaURLsForDataFlowType(new DataflowTypeVO(nextDataFlow));
                StringBuffer urlBuff = new StringBuffer();
                Iterator urlsIt = urls.iterator();
                while (urlsIt.hasNext()) {
                    urlBuff.append(urlsIt.next());
                    if (!urlsIt.hasNext()) continue;
                    urlBuff.append(" ");
                }
                this.schemaURLsPerDataFlow.put(new DataflowTypeVO(nextDataFlow), urlBuff.toString());
                this.parser.getXMLReader().setFeature(VALIDATION_PARSER_FEATURE, this.validate);
                this.parser.getXMLReader().setFeature(SCHEMA_VALIDATION_PARSER_FEATURE, this.schemaValidate);
                this.parser.setProperty(EXTERNAL_SCHEMA_PARSER_PROPERTY, "");
            }
        }
        catch (SAXNotRecognizedException e) {
            throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        catch (SAXNotSupportedException e) {
            throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        catch (SAXException e) {
            throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    public boolean validate(DocumentVO doc) throws CDXValidationException {
        try {
            this.parser.setProperty(EXTERNAL_SCHEMA_PARSER_PROPERTY, this.schemaURLsPerDataFlow.get(doc.getDataflowTypeVO().getDataflowType()));
            this.parser.parse((InputStream)new ByteArrayInputStream(doc.getData()), (DefaultHandler)new DefaultErrorHandler());
        }
        catch (SAXNotRecognizedException e) {
            throw new CDXValidationException(CDXErrorCode.VALIDATION_ERROR, (Throwable)e);
        }
        catch (SAXNotSupportedException e) {
            throw new CDXValidationException(CDXErrorCode.VALIDATION_ERROR, (Throwable)e);
        }
        catch (IOException e) {
            throw new CDXValidationException(CDXErrorCode.VALIDATION_ERROR, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new CDXValidationException(CDXErrorCode.VALIDATION_ERROR, (Throwable)e);
        }
        catch (SAXParseException e) {
            throw new CDXValidationException(CDXErrorCode.VALIDATION_ERROR, (Throwable)e);
        }
        catch (SAXException e) {
            throw new CDXValidationException(CDXErrorCode.VALIDATION_ERROR, (Throwable)e);
        }
        catch (Throwable e) {
            throw new CDXValidationException(CDXErrorCode.VALIDATION_ERROR, e);
        }
        return true;
    }

    public SAXParser getParser() {
        return this.parser;
    }

    public Map getSchemaURLsPerDataFlow() {
        return this.schemaURLsPerDataFlow;
    }

    public boolean isSchemaValidate() {
        return this.schemaValidate;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setParser(SAXParser parser) {
        this.parser = parser;
    }

    public void setSchemaURLsPerDataFlow(Map schemaURLsPerDataFlow) {
        this.schemaURLsPerDataFlow = schemaURLsPerDataFlow;
    }

    public void setSchemaValidate(boolean schemaValidate) {
        this.schemaValidate = schemaValidate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void dispose() {
        this.parser = null;
        this.schemaURLsPerDataFlow.clear();
        this.schemaURLsPerDataFlow = null;
    }

    private class DefaultErrorHandler
    extends DefaultHandler
    implements ErrorHandler {
        DefaultErrorHandler() {
        }

        public void error(SAXParseException e) throws SAXParseException {
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXParseException {
            throw e;
        }

        public void warning(SAXParseException e) throws SAXParseException {
            throw e;
        }
    }
}

