/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.requestor;

import gov.epa.cdx.axis.v10.client.NodeRequestor;
import gov.epa.cdx.axis.v10.impl.DocumentConverter;
import gov.epa.cdx.axis.v10.vo.NodeDocument;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXServerException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.logic.security.CdxSecurityManager;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.node.NodeVersionVO;
import gov.epa.cdx.model.security.LoginVO;
import java.net.MalformedURLException;
import java.net.URL;

public class DownloadManager {
    protected static LogInterface log;
    protected static Audit audit;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.requestor.DownloadManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.epa.cdx.logic.requestor.DownloadManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        audit = new Audit(clazz2.getName());
    }

    private DownloadManager() {
    }

    public static DocumentList dowload(LoginVO loginVO, String transactionId, NodeVersionVO nodeVersionVO, String dataFlow, DocumentList documents) throws CDXException {
        try {
            NodeDocument[] nodeDocuments = null;
            URL nodeURL = null;
            try {
                nodeURL = new URL(nodeVersionVO.getUrl());
            }
            catch (MalformedURLException malformedURLError) {
                String message = "URL: " + nodeVersionVO.getUrl() + "for Node " + nodeVersionVO.getNodeId() + "is invalid URL. ";
                log.error((Object)message, (Throwable)malformedURLError);
                audit.failure(transactionId, message, malformedURLError);
                throw new CDXException(CDXErrorCode.HTTP_URL_ERROR, (Throwable)malformedURLError);
            }
            String authToken = CdxSecurityManager.login(loginVO).getAuthToken();
            NodeRequestor requestor = new NodeRequestor(nodeURL);
            if (documents == null) {
                nodeDocuments = requestor.downloadAllDocumentsByTransaction(authToken, transactionId, dataFlow);
            } else {
                nodeDocuments = DocumentConverter.DocumentListToCdx((DocumentList)documents, (int)1);
                nodeDocuments = requestor.download(authToken, transactionId, dataFlow, nodeDocuments);
            }
            documents = DocumentConverter.CdxToDocumentList((NodeDocument[])nodeDocuments, (String)dataFlow);
            return documents;
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            String message = "Download from node " + nodeVersionVO.getName() + " at URL " + nodeVersionVO.getUrl() + " for Dataflow: " + dataFlow;
            audit.failure(transactionId, message, ex);
            throw new CDXServerException(CDXErrorCode.REQUESTOR_DOWNLOAD_SERVICE_ERROR, (Throwable)ex);
        }
    }
}

