/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.requestor;

import gov.epa.cdx.axis.v10.client.NodeRequestor;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXServerException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.logic.security.CdxSecurityManager;
import gov.epa.cdx.model.node.NodeVersionVO;
import gov.epa.cdx.model.security.LoginVO;
import gov.epa.cdx.model.transaction.Status;
import java.net.MalformedURLException;
import java.net.URL;

public class GetStatusManager {
    protected static LogInterface log;
    protected static Audit audit;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.requestor.GetStatusManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.epa.cdx.logic.requestor.GetStatusManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        audit = new Audit(clazz2.getName());
    }

    private GetStatusManager() {
    }

    public static Status getStatus(LoginVO loginVO, String transactionId, NodeVersionVO nodeVersion) throws CDXException {
        String status = null;
        URL nodeURL = null;
        String nodeName = String.valueOf(nodeVersion.getName()) + " " + nodeVersion.getVersion();
        try {
            nodeURL = new URL(nodeVersion.getUrl());
        }
        catch (MalformedURLException malformedURLError) {
            String message = "URL: " + nodeVersion.getUrl() + "for Node " + nodeVersion.getNodeId() + "is invalid URL. ";
            log.error((Object)message, (Throwable)malformedURLError);
            audit.failure(transactionId, message, malformedURLError);
            throw new CDXException(CDXErrorCode.HTTP_URL_ERROR, (Throwable)malformedURLError);
        }
        NodeRequestor requestor = new NodeRequestor(nodeURL);
        try {
            String authToken = CdxSecurityManager.login(loginVO).getAuthToken();
            status = requestor.getStatus(authToken, transactionId);
            audit.success(transactionId, "Node " + nodeName + " reported status for this transaction as " + status);
        }
        catch (Exception exc) {
            log.error((Object)"Unable to Perform Query Web Service", (Throwable)exc);
            audit.failure(transactionId, "Failure to GetStatus from Node " + nodeName + " at URL" + nodeURL.toString(), exc);
            throw new CDXServerException(CDXErrorCode.REQUESTOR_QUERY_SERVICE_ERROR, (Throwable)exc);
        }
        return Status.getStatusById((String)status);
    }
}

