/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.requestor;

import gov.epa.cdx.axis.fault.FaultErrorCode;
import gov.epa.cdx.axis.fault.FaultHandler;
import gov.epa.cdx.axis.security.NetworkSecurityNodePortType;
import gov.epa.cdx.axis.security.client.CdxSecurityLocator;
import gov.epa.cdx.axis.security.client.NetworkSecurityBindingStub;
import gov.epa.cdx.axis.security.enum.AuthMethod;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXExternalServerException;
import gov.epa.cdx.commons.exception.CDXSecurityException;
import gov.epa.cdx.commons.exception.CDXServerException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.util.net.URLUtils;
import gov.epa.cdx.model.node.NodeVersionVO;
import gov.epa.cdx.model.security.AuthTokenVO;
import gov.epa.cdx.model.security.AuthorizationVO;
import gov.epa.cdx.model.security.LoginVO;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.Service;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Stub;

public class NAASManager {
    private static LogInterface log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.requestor.NAASManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public static AuthTokenVO executeLogin(NodeVersionVO nodeVersion, LoginVO loginVO) throws CDXException {
        AuthTokenVO token = null;
        String value = null;
        AuthMethod authMethod = null;
        NetworkSecurityNodePortType client = null;
        authMethod = AuthMethod.fromString((String)loginVO.getCredentialType().toString());
        client = (NetworkSecurityNodePortType)NAASManager.getStub(nodeVersion);
        try {
            value = loginVO.getLoginType() == 1 ? client.auth(loginVO.getUserID(), (String)loginVO.getCredential(), authMethod) : client.centralAuth(loginVO.getUserID(), (String)loginVO.getCredential(), authMethod, loginVO.getClientHostIP());
            token = new AuthTokenVO(loginVO.getClientHostIP(), loginVO.getNodeVersion(), value);
            token.setClientIP(loginVO.getClientHostIP());
            token.setUserId(loginVO.getUserID());
        }
        catch (RemoteException ex) {
            if (ex instanceof AxisFault) {
                throw new CDXSecurityException(CDXErrorCode.AUTHENTICATION_AUTHORIZATION_ERROR, (Throwable)ex);
            }
            throw new CDXExternalServerException(CDXErrorCode.EXTERNAL_SERVER_ERROR, (Throwable)ex);
        }
        return token;
    }

    public static AuthTokenVO executeValidate(NodeVersionVO nodeVersion, AuthTokenVO authVO) throws CDXException {
        String value = null;
        NetworkSecurityNodePortType client = null;
        client = (NetworkSecurityNodePortType)NAASManager.getStub(nodeVersion);
        AuthorizationVO authorizationVO = authVO.getAuthorizationVO();
        try {
            String resourceURI = NAASManager.createResourceURI(authorizationVO);
            value = client.validate(authVO.getAuthToken(), authVO.getClientHostIP(), resourceURI);
            authVO.setUserId(value);
            authVO.setClientIP(authVO.getClientIP());
        }
        catch (RemoteException ex) {
            try {
                FaultErrorCode code = FaultHandler.getErrorCode((RemoteException)ex);
                if (code.equals((Object)FaultErrorCode.ACCESS_DENIED)) {
                    throw new CDXSecurityException(CDXErrorCode.LACK_OF_PRIVILEGE, (Throwable)ex);
                }
                if (code.equals((Object)FaultErrorCode.INVALID_TOKEN)) {
                    throw new CDXSecurityException(CDXErrorCode.SECURITY_TOKEN_INVALID, (Throwable)ex);
                }
            }
            catch (CDXValidationException cDXValidationException) {
                throw new CDXSecurityException(CDXErrorCode.AUTHENTICATION_AUTHORIZATION_ERROR, (Throwable)ex);
            }
        }
        return authVO;
    }

    private static Stub getStub(NodeVersionVO nodeVersionVO) throws CDXException {
        NetworkSecurityBindingStub clientStub = null;
        URL portURL = URLUtils.getURL((String)nodeVersionVO.getUrl());
        CdxSecurityLocator locator = new CdxSecurityLocator();
        NetworkSecurityBindingStub _stub = null;
        try {
            _stub = new NetworkSecurityBindingStub(portURL, (Service)locator);
        }
        catch (Exception ex) {
            log.error((Object)"Could not create Axis Client Stub for NAAS", (Throwable)ex);
            throw new CDXServerException(CDXErrorCode.HTTP_URL_BIND_ERROR, (Throwable)ex);
        }
        _stub.setPortName(locator.getNetworkSecurityNodePortTypeWSDDServiceName());
        clientStub = _stub;
        return clientStub;
    }

    private static String createResourceURI(AuthorizationVO authorizationVO) {
        StringBuffer res = new StringBuffer(AuthorizationVO.getNodeURL());
        res.append("?node=");
        res.append(AuthorizationVO.getNodeName());
        res.append("&method=");
        res.append(authorizationVO.getMethod());
        String request = authorizationVO.getRequest();
        if (request != null) {
            res.append("&request=");
            res.append(authorizationVO.getRequest());
            res.append("&params=");
            String[] param = authorizationVO.getParameters();
            int i = 0;
            while (i < param.length) {
                res.append(param[i]);
                if (i < param.length - 1) {
                    res.append(";");
                }
                ++i;
            }
        }
        if (authorizationVO.getDataFlow() != null) {
            if (request == null) {
                res.append("&params=");
            } else {
                res.append(";");
            }
            String df = "Data_Flow_" + authorizationVO.getDataFlow() + ";";
            res.append(df.toLowerCase());
        }
        return res.toString();
    }
}

