/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.requestor;

import gov.epa.cdx.axis.v10.client.NodeRequestor;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXServerException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.infrastructure.node.NodeMgr;
import gov.epa.cdx.infrastructure.servicelookup.ServiceLookupMgr;
import gov.epa.cdx.logic.security.CdxSecurityManager;
import gov.epa.cdx.model.node.NodeVersionVO;
import gov.epa.cdx.model.security.LoginVO;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;

public class SolicitManager {
    protected static LogInterface log;
    protected static Audit audit;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.requestor.SolicitManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.epa.cdx.logic.requestor.SolicitManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        audit = new Audit(clazz2.getName());
    }

    private SolicitManager() {
    }

    public static String solicitDataflow(LoginVO loginVO, String transactionId, NodeVersionVO nodeVersion, Map parameterMap) throws CDXException {
        return SolicitManager.performSolicit(loginVO, transactionId, nodeVersion, parameterMap, transactionId);
    }

    public static String solicit(LoginVO loginVO, String transactionId, NodeVersionVO nodeVersion, Map parameterMap) throws CDXException {
        String returnURL = NodeMgr.getCurrentServerURL();
        return SolicitManager.performSolicit(loginVO, transactionId, nodeVersion, parameterMap, returnURL);
    }

    private static String performSolicit(LoginVO loginVO, String transactionId, NodeVersionVO nodeVersion, Map parameterMap, String returnURL) throws CDXException {
        URL nodeURL = null;
        try {
            nodeURL = new URL(nodeVersion.getUrl());
        }
        catch (MalformedURLException malformedURLError) {
            String message = "URL: " + nodeVersion.getUrl() + "for Node " + nodeVersion.getNodeId() + "is invalid URL. ";
            log.error((Object)message, (Throwable)malformedURLError);
            audit.failure(transactionId, message, malformedURLError);
            throw new CDXException(CDXErrorCode.HTTP_URL_ERROR, (Throwable)malformedURLError);
        }
        NodeRequestor requestor = new NodeRequestor(nodeURL);
        String serviceName = (String)parameterMap.get("ServiceTypeKey");
        String message = SolicitManager.createAuditMessage(serviceName, parameterMap);
        String externalTransactionId = null;
        try {
            String authToken = CdxSecurityManager.login(loginVO).getAuthToken();
            String[] serviceParametersValues = ServiceLookupMgr.orderParameters(parameterMap, serviceName);
            externalTransactionId = requestor.solicit(authToken, returnURL, serviceName, serviceParametersValues);
            audit.success(transactionId, message);
        }
        catch (Exception exc) {
            log.error((Object)"Unable to Perform Solicit Web Service", (Throwable)exc);
            audit.failure(transactionId, SolicitManager.createAuditMessage(serviceName, parameterMap), exc);
            throw new CDXServerException(CDXErrorCode.REQUESTOR_SOLICIT_SERVICE_ERROR, (Throwable)exc);
        }
        return externalTransactionId;
    }

    private static String createAuditMessage(String serviceName, Map parameterMap) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Solicit: ");
        buffer.append(serviceName);
        buffer.append(" Parameters: ");
        Iterator it = parameterMap.keySet().iterator();
        while (it.hasNext()) {
            String parameterName = (String)it.next();
            buffer.append(parameterName);
            buffer.append("=");
            buffer.append(parameterMap.get(parameterName));
            buffer.append(" ");
        }
        return buffer.toString();
    }
}

