/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.requestor;

import gov.epa.cdx.axis.v10.client.NodeRequestor;
import gov.epa.cdx.axis.v10.impl.DocumentConverter;
import gov.epa.cdx.axis.v10.vo.NodeDocument;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXServerException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.logic.security.CdxSecurityManager;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.node.NodeVersionVO;
import gov.epa.cdx.model.security.LoginVO;
import java.net.MalformedURLException;
import java.net.URL;

public class SubmitManager {
    protected static LogInterface log;
    protected static Audit audit;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.requestor.SubmitManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.epa.cdx.logic.requestor.SubmitManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        audit = new Audit(clazz2.getName());
    }

    private SubmitManager() {
    }

    public static String submit(LoginVO loginVO, String transactionId, NodeVersionVO nodeVersionVO, DataflowTypeVO dataflowType, DocumentList documents) throws CDXException {
        try {
            String dataFlow = dataflowType.toString();
            URL nodeURL = null;
            try {
                nodeURL = new URL(nodeVersionVO.getUrl());
            }
            catch (MalformedURLException malformedURLError) {
                String message = "URL: " + nodeVersionVO.getUrl() + "for Node " + nodeVersionVO.getNodeId() + "is invalid URL. ";
                log.error((Object)message, (Throwable)malformedURLError);
                audit.failure(transactionId, message, malformedURLError);
                throw new CDXException(CDXErrorCode.HTTP_URL_ERROR, (Throwable)malformedURLError);
            }
            String authToken = CdxSecurityManager.login(loginVO).getAuthToken();
            NodeRequestor requestor = new NodeRequestor(nodeURL);
            NodeDocument[] nodeDocuments = DocumentConverter.DocumentListToCdx((DocumentList)documents, (int)1);
            String receivedTransactionId = requestor.submit(authToken, transactionId, dataFlow, nodeDocuments);
            return receivedTransactionId;
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            String message = "Submission to node " + nodeVersionVO.getName() + " at URL " + nodeVersionVO.getUrl() + " for Dataflow: " + dataflowType;
            audit.failure(transactionId, message, ex);
            throw new CDXServerException(CDXErrorCode.REQUESTOR_SUBMIT_SERVICE_ERROR, (Throwable)ex);
        }
    }
}

