/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.requestor;

import gov.epa.cdx.axis.appidmapping.client.AppIdMappingRequestor;
import gov.epa.cdx.axis.appidmapping.vo.AppMap;
import gov.epa.cdx.axis.legacymgr.client.LegacymgrRequestor;
import gov.epa.cdx.axis.policymgr.client.PolicymgrRequestor;
import gov.epa.cdx.axis.usermgr.client.UsermgrRequestor;
import gov.epa.cdx.axis.usermgr.vo.UserInfo;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXExternalServerException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.infrastructure.node.NodeMgr;
import gov.epa.cdx.logic.security.CdxSecurityManager;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.node.NodeVersion;
import gov.epa.cdx.model.node.NodeVersionVO;
import java.math.BigInteger;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class UserManager {
    protected static Audit audit;
    protected static LogInterface log;
    private static final NodeKey LEGACY_MGR_KEY;
    private static final NodeKey POLICY_MGR_KEY;
    private static final NodeKey USER_MGR_KEY;
    private static final NodeKey MAPPING_MGR_KEY;
    public static final int LOWERLIMIT = 0;
    public static final int UPPERLIMIT = -1;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.requestor.UserManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        audit = new Audit(clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.epa.cdx.logic.requestor.UserManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz2.getName());
        LEGACY_MGR_KEY = new NodeKey("Legacy Mgr", NodeVersion.V10);
        POLICY_MGR_KEY = new NodeKey("Policy Mgr", NodeVersion.V10);
        USER_MGR_KEY = new NodeKey("User Mgr", NodeVersion.V10);
        MAPPING_MGR_KEY = new NodeKey("Mapping Mgr", NodeVersion.V10);
    }

    public static UsermgrRequestor getUsermgrRequestor() throws CDXExternalServerException {
        UsermgrRequestor usermgrRequestor = null;
        try {
            String userMgmtURL = null;
            if (CDXPropertyManager.getProperty((String)"TestOnly", (String)"database_available", (String)"yes").toString().compareToIgnoreCase("no") == 0) {
                userMgmtURL = "https://naas.epacdxnode.net/xml/usermgr.wsdl";
            } else {
                NodeVersionVO nodeVersion = NodeMgr.getNodeByNodeKey(USER_MGR_KEY);
                userMgmtURL = nodeVersion.getUrl();
            }
            usermgrRequestor = new UsermgrRequestor(new URL(userMgmtURL));
        }
        catch (Exception ex) {
            throw new CDXExternalServerException(CDXErrorCode.HTTP_CONNECTION_FAILURE, (Throwable)ex);
        }
        return usermgrRequestor;
    }

    public static String getUsermgrUrl() throws CDXException {
        String userMgmtURL = "";
        try {
            NodeVersionVO nodeVersion = NodeMgr.getNodeByNodeKey(USER_MGR_KEY);
            userMgmtURL = nodeVersion.getUrl();
        }
        catch (Exception ex) {
            throw new CDXExternalServerException(CDXErrorCode.HTTP_URL_ERROR, (Throwable)ex);
        }
        return userMgmtURL;
    }

    public static String getStateAffiliation(String userEmail, String transactionId) throws CDXException {
        String stateAffiliation = "";
        Exception exception = new Exception();
        stateAffiliation = UserManager.getStateAffiliationFromMapper(userEmail);
        if (stateAffiliation == null || stateAffiliation.length() <= 0) {
            try {
                UserInfo userInfo = UserManager.getUserProfile(userEmail, transactionId);
                stateAffiliation = userInfo.getAffiliate();
            }
            catch (Exception ex) {
                CDXErrorCode errorCode;
                if (ex instanceof CDXException && (errorCode = ((CDXException)((Object)ex)).getCDXErrorCode()).equals((Object)CDXErrorCode.INVALID_USER_OR_NOT_ADMINISTRATOR)) {
                    throw (CDXException)((Object)ex);
                }
                exception = ex;
            }
        }
        if (stateAffiliation == null || stateAffiliation.trim().length() <= 0) {
            audit.failure(transactionId, "No state affiliation for user: " + userEmail, exception);
            throw new CDXException(CDXErrorCode.NO_STATE_AFFILIATION);
        }
        return stateAffiliation;
    }

    public static UserInfo getUserProfile(String userEmail, String transactionId) throws CDXException {
        UserInfo[] userInfo = null;
        try {
            UsermgrRequestor usermgrRequestor = UserManager.getUsermgrRequestor();
            userInfo = usermgrRequestor.getUserList(CdxSecurityManager.getId(), CdxSecurityManager.getCredential(), userEmail, "", BigInteger.valueOf(0L), BigInteger.valueOf(-1L));
        }
        catch (Exception ex) {
            audit.failure(transactionId, "Invalid administrator account [" + CdxSecurityManager.getId() + "] or unknown user[" + userEmail + "]", ex);
            throw new CDXException(CDXErrorCode.INVALID_USER_OR_NOT_ADMINISTRATOR, (Throwable)ex);
        }
        return userInfo[0];
    }

    private static LegacymgrRequestor getLegacymgrRequestor() throws CDXExternalServerException {
        LegacymgrRequestor legacymgrRequestor = null;
        try {
            String legacyMgmtURL = null;
            if (CDXPropertyManager.getProperty((String)"TestOnly", (String)"database_available", (String)"yes").toString().compareToIgnoreCase("no") == 0) {
                legacyMgmtURL = "https://naas.epacdxnode.net/xml/LegacyId.wsdl";
            } else {
                NodeVersionVO nodeVersion = NodeMgr.getNodeByNodeKey(LEGACY_MGR_KEY);
                legacyMgmtURL = nodeVersion.getUrl();
            }
            legacymgrRequestor = new LegacymgrRequestor(new URL(legacyMgmtURL));
        }
        catch (Exception ex) {
            throw new CDXExternalServerException(CDXErrorCode.HTTP_CONNECTION_FAILURE, (Throwable)ex);
        }
        return legacymgrRequestor;
    }

    public static String extractLegacyIdFromUserId(String userEmail) {
        String legacyId = "";
        StringTokenizer tokenizer = new StringTokenizer(userEmail, "@");
        legacyId = tokenizer.nextToken().toUpperCase();
        return legacyId;
    }

    public static PolicymgrRequestor getPolicymgrRequestor() throws CDXExternalServerException {
        PolicymgrRequestor policymgrRequestor = null;
        try {
            String policyMgmtURL = null;
            if (CDXPropertyManager.getProperty((String)"TestOnly", (String)"database_available", (String)"yes").toString().compareToIgnoreCase("no") == 0) {
                policyMgmtURL = "https://naas.epacdxnode.net/xml/policy.wsdl";
            } else {
                NodeVersionVO nodeVersion = NodeMgr.getNodeByNodeKey(POLICY_MGR_KEY);
                policyMgmtURL = nodeVersion.getUrl();
            }
            policymgrRequestor = new PolicymgrRequestor(new URL(policyMgmtURL));
        }
        catch (Exception ex) {
            throw new CDXExternalServerException(CDXErrorCode.HTTP_CONNECTION_FAILURE, (Throwable)ex);
        }
        return policymgrRequestor;
    }

    public static String getLegacyIdFromCDX(String userId) throws CDXException {
        return UserManager.getLegacyIdFromCDX(userId, null);
    }

    public static String getLegacyIdFromCDX(String userId, String dataflowName) throws CDXException {
        log.debug((Object)"In UserManager.getLegacyIdFromCDX");
        String legacyId = UserManager.getApplicationIdFromMapping(userId, dataflowName);
        if (legacyId == null || legacyId.length() <= 0) {
            log.debug((Object)"Unable to locate the legacy id from the mapping table. Attempting the alternative path; LegacymgrRequestor");
            LegacymgrRequestor legacymgrRequestor = UserManager.getLegacymgrRequestor();
            try {
                legacyId = legacymgrRequestor.getLegacyId(CdxSecurityManager.getId(), CdxSecurityManager.getCredential(), userId);
                log.debug((Object)"Legacy id was found using the LegacymgrRequestor");
            }
            catch (Exception ex) {
                CDXException exception = new CDXException(CDXErrorCode.HTTP_CONNECTION_FAILURE, (Throwable)ex);
                throw exception;
            }
        }
        if (legacyId.length() < 1) {
            String defaultId = "CDX";
            log.debug((Object)("Using the default legacyId of:" + defaultId));
            legacyId = CDXPropertyManager.getProperty((String)"CDXDefault", (String)"DefaultUserId", (String)defaultId);
        }
        return legacyId;
    }

    private static String getStateAffiliationFromMapper(String userId) throws CDXException {
        log.debug((Object)"In UserManager.getStateAffiliationFromMapper");
        return UserManager.getApplicationIdFromMapping(userId, "STATE");
    }

    private static String getApplicationIdFromMapping(String userId, String dataflowName) throws CDXException {
        log.debug((Object)"In UserManager.getApplicationIdFromMapping");
        String applicationId = null;
        if (userId != null) {
            String adminId = CdxSecurityManager.getId();
            String credential = CdxSecurityManager.getCredential();
            try {
                AppIdMappingRequestor appIdMappingRequestor = UserManager.getMappingRequestor();
                AppMap[] result = appIdMappingRequestor.getApplicationMap(adminId, credential, userId, dataflowName);
                int i = 0;
                if (i < result.length) {
                    AppMap appMap = result[i];
                    applicationId = appMap.getApplicationId();
                }
            }
            catch (RemoteException re) {
                log.error((Object)"Exception when calling appIdMappingRequestor.getApplicationIdFromMapping", (Throwable)re);
            }
        }
        return applicationId;
    }

    private static String getUserDataFromMapping(String userId, String dataflowName) throws CDXException {
        log.debug((Object)"In UserManager.getUserDataFromMapping");
        String userData = null;
        if (userId != null && dataflowName != null) {
            String adminId = CdxSecurityManager.getId();
            String credential = CdxSecurityManager.getCredential();
            try {
                AppIdMappingRequestor appIdMappingRequestor = UserManager.getMappingRequestor();
                AppMap[] result = appIdMappingRequestor.getApplicationMap(adminId, credential, userId, dataflowName);
                int i = 0;
                if (i < result.length) {
                    AppMap appMap = result[i];
                    userData = appMap.getApplicationId();
                }
            }
            catch (RemoteException re) {
                log.error((Object)"Exception when calling appIdMappingRequestor.getUserDataFromMapping", (Throwable)re);
            }
        }
        return userData;
    }

    public static String setMapping(String dataFlow, String user, String userData, String applicationId) throws Exception {
        String adminId = CdxSecurityManager.getId();
        String credential = CdxSecurityManager.getCredential();
        String result = "";
        try {
            AppIdMappingRequestor appIdMappingRequestor = UserManager.getMappingRequestor();
            result = appIdMappingRequestor.setApplicationMap(adminId, credential, user, dataFlow, applicationId, userData);
        }
        catch (RemoteException re) {
            log.debug((Object)"Error when invoking the setApplicationMap web service");
            throw re;
        }
        return result;
    }

    public static ArrayList getMapping(String dataflow, String user) throws CDXException {
        return UserManager.getMapping(dataflow, user, null);
    }

    public static ArrayList getMapping(String dataflow, String user, String dataflowFilter) throws CDXException {
        log.debug((Object)("In UserManager.getMapping -- dataflow:" + dataflow + ", user:" + user + ",dataflowFilter:" + dataflowFilter));
        String adminId = CdxSecurityManager.getId();
        String credential = CdxSecurityManager.getCredential();
        AppMap[] serviceResult = null;
        AppMap vo = new AppMap();
        ArrayList<AppMap> records = new ArrayList<AppMap>();
        try {
            AppIdMappingRequestor appIdMappingRequestor = UserManager.getMappingRequestor();
            serviceResult = appIdMappingRequestor.getApplicationMap(adminId, credential, user, dataflow);
            int i = 0;
            while (i < serviceResult.length) {
                AppMap appMap = serviceResult[i];
                String userId = appMap.getUserId();
                String application = appMap.getApplication();
                String applicationId = appMap.getApplicationId();
                String userData = appMap.getUserData();
                if (dataflowFilter == null || dataflowFilter.equals("ALL") || dataflowFilter.equals(application)) {
                    vo = new AppMap();
                    if (userId != null) {
                        vo.setUserId(userId);
                    }
                    if (application != null) {
                        vo.setApplication(application);
                    }
                    if (applicationId != null) {
                        vo.setApplicationId(applicationId);
                    }
                    if (userData != null) {
                        vo.setUserData(userData);
                    }
                    records.add(vo);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw (CDXException)((Object)e);
        }
        return records;
    }

    public static String deleteMapping(String dataFlow, String userId) throws Exception {
        String adminId = CdxSecurityManager.getId();
        String credential = CdxSecurityManager.getCredential();
        String result = "";
        try {
            AppIdMappingRequestor appIdMappingRequestor = UserManager.getMappingRequestor();
            result = appIdMappingRequestor.deleteApplicationMap(adminId, credential, userId, dataFlow);
        }
        catch (RemoteException re) {
            log.debug((Object)"RemoteException when attempting to call the delete mapping web service");
            throw re;
        }
        return result;
    }

    private static AppIdMappingRequestor getMappingRequestor() throws CDXExternalServerException {
        AppIdMappingRequestor mappingRequestor = null;
        try {
            NodeVersionVO nodeVersion = NodeMgr.getNodeByNodeKey(MAPPING_MGR_KEY);
            String mappingURL = nodeVersion.getUrl();
            mappingRequestor = new AppIdMappingRequestor(new URL(mappingURL));
        }
        catch (Exception ex) {
            throw new CDXExternalServerException(CDXErrorCode.HTTP_CONNECTION_FAILURE, (Throwable)ex);
        }
        return mappingRequestor;
    }
}

