/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.scheduler;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.commons.util.CDXSystemManager;
import gov.epa.cdx.commons.util.EncoderDecoder;
import gov.epa.cdx.commons.util.GUID;
import gov.epa.cdx.infrastructure.scheduler.TaskManager;
import gov.epa.cdx.model.node.NodeVersion;
import gov.epa.cdx.model.scheduler.TaskVO;
import gov.epa.cdx.model.security.CredentialType;
import gov.epa.cdx.model.security.LoginVO;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.jdbcjobstore.JobStoreTX;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import org.quartz.utils.ConnectionProvider;
import org.quartz.utils.DBConnectionManager;
import org.quartz.utils.JNDIConnectionProvider;

public class BaseJob {
    private static LogInterface log;
    private static final String SCHEDULER_CATEGORY_KEY = "Scheduler";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.BaseJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public static Boolean jobExists(String jobId) throws CDXException {
        try {
            StdScheduler sched = (StdScheduler)BaseJob.getSchedulerInstance();
            JobDetail detail = sched.getJobDetail(jobId, BaseJob.getGroupName());
            if (detail == null) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (SchedulerException schedulerException) {
            throw new CDXException(CDXErrorCode.SCHEDULER_ERROR);
        }
    }

    public static Collection getTriggersForJob(String jobId) throws CDXException {
        try {
            StdScheduler sched = (StdScheduler)BaseJob.getSchedulerInstance();
            Trigger[] triggers = sched.getTriggersOfJob(jobId, BaseJob.getGroupName());
            List<Trigger> col = Arrays.asList(triggers);
            return col;
        }
        catch (SchedulerException schedulerException) {
            throw new CDXException(CDXErrorCode.SCHEDULER_ERROR);
        }
    }

    public static Collection searchJobs() throws CDXException {
        try {
            StdScheduler sched = (StdScheduler)BaseJob.getSchedulerInstance();
            String[] jobNames = sched.getJobNames(BaseJob.getGroupName());
            List<String> col = Arrays.asList(jobNames);
            return col;
        }
        catch (SchedulerException schedulerException) {
            throw new CDXException(CDXErrorCode.SCHEDULER_ERROR);
        }
    }

    public static TaskVO getTask(JobExecutionContext context) throws JobExecutionException {
        String taskId = context.getJobDetail().getName();
        TaskVO task = null;
        try {
            task = TaskManager.loadTask(taskId);
        }
        catch (CDXException ex) {
            log.error((Object)("Problem loading task with Task Id: " + taskId));
            throw new JobExecutionException((Exception)((Object)ex));
        }
        return task;
    }

    public static void unscheduleJob(String jobId) throws CDXException {
        try {
            Scheduler sched = BaseJob.getSchedulerInstance();
            Trigger[] triggers = sched.getTriggersOfJob(jobId, BaseJob.getGroupName());
            int counter = 0;
            while (counter < triggers.length) {
                sched.unscheduleJob(triggers[counter].getName(), triggers[counter].getGroup());
                ++counter;
            }
        }
        catch (SchedulerException schedulerException) {
            throw new CDXException(CDXErrorCode.SCHEDULER_ERROR);
        }
    }

    public static void pauseJob(String jobId) throws CDXException {
        try {
            Scheduler sched = BaseJob.getSchedulerInstance();
            sched.pauseJob(jobId, BaseJob.getGroupName());
        }
        catch (SchedulerException schedulerException) {
            throw new CDXException(CDXErrorCode.SCHEDULER_ERROR);
        }
    }

    public static void resumeJob(String jobId) throws CDXException {
        try {
            Scheduler sched = BaseJob.getSchedulerInstance();
            sched.resumeJob(jobId, BaseJob.getGroupName());
        }
        catch (SchedulerException schedulerException) {
            throw new CDXException(CDXErrorCode.SCHEDULER_ERROR);
        }
    }

    public static String getTriggerStatusString(String triggerId) throws CDXException {
        try {
            Scheduler sched = BaseJob.getSchedulerInstance();
            int state = sched.getTriggerState(triggerId, BaseJob.getGroupName());
            String statusString = "";
            switch (state) {
                case 0: {
                    statusString = "Normal";
                    break;
                }
                case 2: {
                    statusString = "Complete";
                    break;
                }
                case 3: {
                    statusString = "Error";
                    break;
                }
                case 1: {
                    statusString = "Paused";
                    break;
                }
            }
            return statusString;
        }
        catch (SchedulerException schedulerException) {
            throw new CDXException(CDXErrorCode.SCHEDULER_ERROR);
        }
    }

    public static void runNow(String jobId) throws CDXException {
        try {
            StdScheduler scheduler = (StdScheduler)BaseJob.getSchedulerInstance();
            scheduler.triggerJob(jobId, BaseJob.getGroupName());
        }
        catch (SchedulerException schedulerException) {
            throw new CDXException(CDXErrorCode.SCHEDULER_ERROR);
        }
    }

    public static void uscheduleTrigger(String triggerId) throws CDXException {
        try {
            Scheduler sched = BaseJob.getSchedulerInstance();
            sched.unscheduleJob(triggerId, BaseJob.getGroupName());
        }
        catch (SchedulerException schedulerException) {
            throw new CDXException(CDXErrorCode.SCHEDULER_ERROR);
        }
    }

    public static void reschedule(String oldJobID, Date scheduleDate) throws JobExecutionException {
        try {
            Scheduler scheduler = BaseJob.getSchedulerInstance();
            SimpleTrigger trigger = new SimpleTrigger(GUID.getGUID(), BaseJob.getGroupName(), scheduleDate);
            trigger.setJobGroup(BaseJob.getGroupName());
            trigger.setJobName(oldJobID);
            Date ft = scheduler.scheduleJob((Trigger)trigger);
            log.info((Object)("Rescheduled: " + oldJobID + " will run at: " + ft + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval()));
        }
        catch (Exception ex) {
            throw new JobExecutionException(ex);
        }
    }

    public static void schedule(String taskId, Class jobClass) throws CDXException {
        try {
            Scheduler scheduler = BaseJob.getSchedulerInstance();
            JobDetail job = new JobDetail(taskId, BaseJob.getGroupName(), jobClass);
            job.setDurability(true);
            SimpleTrigger trigger = new SimpleTrigger(GUID.getGUID(), BaseJob.getGroupName());
            Date ft = scheduler.scheduleJob(job, (Trigger)trigger);
            log.info((Object)(String.valueOf(job.getFullName()) + " will run at: " + ft + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval()));
        }
        catch (Exception exception) {
            throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR);
        }
    }

    public static void schedule(String taskId, Date startDate, long repeatInterval, Class jobClass, JobDataMap jobData) throws CDXException {
        try {
            Scheduler scheduler = BaseJob.getSchedulerInstance();
            JobDetail job = new JobDetail(taskId, BaseJob.getGroupName(), jobClass);
            job.setDurability(true);
            if (jobData != null) {
                job.setJobDataMap(jobData);
            }
            SimpleTrigger trigger = repeatInterval == 0L ? new SimpleTrigger(GUID.getGUID(), BaseJob.getGroupName(), startDate) : new SimpleTrigger(GUID.getGUID(), BaseJob.getGroupName(), startDate, null, SimpleTrigger.REPEAT_INDEFINITELY, repeatInterval);
            trigger.setMisfireInstruction(2);
            Date ft = scheduler.scheduleJob(job, (Trigger)trigger);
            log.info((Object)(String.valueOf(job.getFullName()) + " " + job.getJobClass().getName() + " will run at: " + ft + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR);
        }
    }

    public static void schedule(String taskId, Date startDate, long repeatInterval, Class jobClass) throws CDXException {
        BaseJob.schedule(taskId, startDate, repeatInterval, jobClass, null);
    }

    public static Scheduler getSchedulerInstance() throws CDXException {
        try {
            DirectSchedulerFactory factory = DirectSchedulerFactory.getInstance();
            String SCHEDULER_NAME = CDXPropertyManager.getProperty((String)SCHEDULER_CATEGORY_KEY, (String)"Name");
            return factory.getScheduler(SCHEDULER_NAME);
        }
        catch (SchedulerException schedulerException) {
            throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR);
        }
    }

    public static void initScheduler() throws Exception {
        String DATASOURCE = CDXPropertyManager.getProperty((String)"DatabaseAccess", (String)"DefaultDataSource");
        String SCHEDULER_CATEGORY_KEY = SCHEDULER_CATEGORY_KEY;
        String SCHEDULER_NAME = CDXPropertyManager.getProperty((String)SCHEDULER_CATEGORY_KEY, (String)"Name");
        String SCHEDULER_INSTANCE_ID = CDXPropertyManager.getProperty((String)SCHEDULER_CATEGORY_KEY, (String)"InstanceId");
        String DELEGATE_CLASS = CDXPropertyManager.getProperty((String)SCHEDULER_CATEGORY_KEY, (String)"DriverDelegate");
        String TABLE_PREFIX = CDXPropertyManager.getProperty((String)SCHEDULER_CATEGORY_KEY, (String)"TablePrefix");
        int MAX_THREADS = Integer.parseInt(CDXPropertyManager.getProperty((String)SCHEDULER_CATEGORY_KEY, (String)"MaxThreads"));
        try {
            SimpleThreadPool threadPool = new SimpleThreadPool(MAX_THREADS, 5);
            threadPool.initialize();
            DBConnectionManager.getInstance().addConnectionProvider(DATASOURCE, (ConnectionProvider)new JNDIConnectionProvider(DATASOURCE, true));
            JobStoreTX jdbcJobStore = new JobStoreTX();
            jdbcJobStore.setDriverDelegateClass(DELEGATE_CLASS);
            jdbcJobStore.setDataSource(DATASOURCE);
            jdbcJobStore.setTablePrefix(TABLE_PREFIX);
            jdbcJobStore.setInstanceId(SCHEDULER_INSTANCE_ID);
            DirectSchedulerFactory.getInstance().createScheduler(SCHEDULER_NAME, SCHEDULER_INSTANCE_ID, (ThreadPool)threadPool, (JobStore)jdbcJobStore);
            DirectSchedulerFactory.getInstance().getScheduler(SCHEDULER_NAME).start();
            log.debug((Object)("Found " + DirectSchedulerFactory.getInstance().getAllSchedulers().size() + " Schedulers within the JVM."));
        }
        catch (Exception ex) {
            log.fatal((Object)"Could not instantiate Scheduler. Scheduling features will not be available", (Throwable)ex);
            throw ex;
        }
    }

    public static String getGroupName() {
        return CDXPropertyManager.getProperty((String)SCHEDULER_CATEGORY_KEY, (String)"Group");
    }

    public static LoginVO getLogin(Map serviceParameters) throws CDXException {
        String userId = (String)serviceParameters.get("NodeUserId");
        String password = (String)serviceParameters.get("NodeCredential");
        password = EncoderDecoder.decode((String)password);
        if (userId == null) {
            userId = CDXPropertyManager.getEncryptedProperty((String)"NAAS", (String)"VersionKey", (String)"epacdxnode@csc.com");
            password = CDXPropertyManager.getEncryptedProperty((String)"NAAS", (String)"LicenseTypeKey", (String)"nodeone");
        }
        LoginVO login = new LoginVO(CDXSystemManager.getCurrentServerPrivateIP(), NodeVersion.V10, userId, CredentialType.PASSWORD, (Object)password);
        login.setLoginType(1);
        return login;
    }
}

