/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.scheduler;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.util.GUID;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.infrastructure.distributor.DistributorFactory;
import gov.epa.cdx.infrastructure.document.DocumentMgr;
import gov.epa.cdx.infrastructure.node.NodeMgr;
import gov.epa.cdx.infrastructure.scheduler.TaskManager;
import gov.epa.cdx.infrastructure.transaction.TransactionMgr;
import gov.epa.cdx.logic.requestor.DownloadManager;
import gov.epa.cdx.logic.scheduler.BaseJob;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.distributor.Distributor;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.node.NodeVO;
import gov.epa.cdx.model.node.NodeVersionVO;
import gov.epa.cdx.model.scheduler.TaskStatus;
import gov.epa.cdx.model.scheduler.TaskTypeVO;
import gov.epa.cdx.model.scheduler.TaskVO;
import gov.epa.cdx.model.security.AuthTokenVO;
import gov.epa.cdx.model.security.LoginVO;
import gov.epa.cdx.model.transaction.Status;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DataCollectionDownloadJob
implements Job {
    protected static LogInterface log;
    protected static Audit audit;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataCollectionDownloadJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataCollectionDownloadJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        audit = new Audit(clazz2.getName());
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        TaskVO task = BaseJob.getTask(context);
        String transactionId = null;
        try {
            task.setStatus(TaskStatus.InProgress);
            TaskManager.setTaskStatus(task);
            Map serviceParameters = task.getTaskParameters();
            Collection taskNodeKeys = task.getTaskNodeKeys();
            NodeKey nodeKey = (NodeKey)taskNodeKeys.iterator().next();
            TransactionVO transactionVO = task.getTaskTransaction(nodeKey);
            transactionId = transactionVO.getTransactionID();
            audit.info(transactionId, "Collecting data from: " + nodeKey.getID());
            DocumentList documentList = this.executeNode(nodeKey, serviceParameters, transactionVO);
            audit.success(transactionId, documentList.toString());
            task.setStatus(TaskStatus.Success);
            TaskManager.setTaskStatus(task);
        }
        catch (CDXException ex) {
            task.setStatus(TaskStatus.Failure);
            try {
                TaskManager.setTaskStatus(task);
            }
            catch (CDXException cDXException) {}
            log.error((Object)"Failed To Perform the Download Task", (Throwable)ex);
            audit.failure(transactionId, ex.getMessage(), ex);
            throw new JobExecutionException((Exception)((Object)ex));
        }
    }

    private DocumentList executeNode(NodeKey nodeKey, Map serviceParameters, TransactionVO transactionVO) throws CDXException {
        String dataFlow = (String)serviceParameters.get("DataFlowKey");
        try {
            TransactionMgr.updateTransactionStatus(transactionVO.getTransactionID(), Status.PENDING);
            NodeVersionVO nodeVersionVO = NodeMgr.getNodeByNodeKey(nodeKey);
            LoginVO login = BaseJob.getLogin(serviceParameters);
            DocumentList documentList = DownloadManager.dowload(login, transactionVO.getTransactionID(), nodeVersionVO, dataFlow, null);
            documentList.setTransaction(transactionVO);
            DocumentMgr.createDocuments(transactionVO, documentList);
            TransactionMgr.updateTransactionStatus(transactionVO.getTransactionID(), Status.PROCESSED);
            NodeVO nodeVO = NodeMgr.getNode(dataFlow);
            AuthTokenVO authVO = new AuthTokenVO();
            authVO.setClientHostIP(nodeVO.getHostIp());
            Distributor distributor = DistributorFactory.getDistributor(dataFlow);
            distributor.prepareDistribution(authVO, documentList);
            return documentList;
        }
        catch (RemoteException remoteException) {
            audit.failure(transactionVO.getTransactionID(), "Remote prepareDistribution call for dataflow [" + dataFlow + "] failed.", remoteException);
            throw new CDXException(CDXErrorCode.SERVICEPROVIDER_REMOTE_CALL_FAILED);
        }
        catch (CDXException cdxException) {
            TransactionMgr.updateTransactionStatus(transactionVO.getTransactionID(), Status.FAILED);
            log.error((Object)"Failed to Execute Download Request for the Node", (Throwable)cdxException);
            throw cdxException;
        }
    }

    public static TaskVO schedule(NodeKey nodeKey, DataflowTypeVO dataflowType, TransactionVO transactionVO) throws CDXException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("DataFlowKey", dataflowType.toString());
        ArrayList<NodeKey> nodeKeys = new ArrayList<NodeKey>();
        nodeKeys.add(nodeKey);
        TaskVO taskVO = new TaskVO(GUID.getGUID(), "Download from Remote Node", new TaskTypeVO("DOWNLOAD"), System.currentTimeMillis(), parameters, nodeKeys);
        taskVO.setTaskTransaction(nodeKey, transactionVO);
        taskVO.setStatus(TaskStatus.NotStarted);
        TaskManager.saveTask(taskVO);
        String string = taskVO.getTaskID();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataCollectionDownloadJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BaseJob.schedule(string, clazz);
        return taskVO;
    }
}

