/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.scheduler;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.infrastructure.distributor.DistributorFactory;
import gov.epa.cdx.infrastructure.document.DocumentMgr;
import gov.epa.cdx.infrastructure.node.NodeMgr;
import gov.epa.cdx.infrastructure.scheduler.TaskManager;
import gov.epa.cdx.infrastructure.transaction.TransactionMgr;
import gov.epa.cdx.logic.requestor.QueryManager;
import gov.epa.cdx.logic.scheduler.BaseJob;
import gov.epa.cdx.model.distributor.Distributor;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.node.NodeVO;
import gov.epa.cdx.model.node.NodeVersionVO;
import gov.epa.cdx.model.scheduler.TaskStatus;
import gov.epa.cdx.model.scheduler.TaskVO;
import gov.epa.cdx.model.security.AuthTokenVO;
import gov.epa.cdx.model.security.LoginVO;
import gov.epa.cdx.model.transaction.Status;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DataCollectionQueryJob
implements Job {
    protected static LogInterface log;
    protected static Audit audit;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataCollectionQueryJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataCollectionQueryJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        audit = new Audit(clazz2.getName());
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        TaskVO task = BaseJob.getTask(context);
        String transactionId = null;
        AuthTokenVO auth = null;
        try {
            task.setStatus(TaskStatus.InProgress);
            TaskManager.setTaskStatus(task);
            Map serviceParameters = task.getTaskParameters();
            Collection taskNodeKeys = task.getTaskNodeKeys();
            NodeKey nodeKey = (NodeKey)taskNodeKeys.iterator().next();
            TransactionVO transactionVO = task.getTaskTransaction(nodeKey);
            transactionId = transactionVO.getTransactionID();
            auth = new AuthTokenVO();
            auth.setUserId((String)task.getTaskParameters().get("NodeUserId"));
            audit.info(transactionId, "Collecting data from: " + nodeKey.getID(), auth);
            DocumentList documentList = this.executeNode(nodeKey, serviceParameters, transactionVO);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String dateString = format.format(new Date(System.currentTimeMillis()));
            TaskManager.updateTaskParameterValue(task.getTaskID(), "ChangeDate", dateString);
            audit.success(transactionId, documentList.toString(), auth);
            task.setStatus(TaskStatus.Success);
            TaskManager.setTaskStatus(task);
        }
        catch (CDXException ex) {
            task.setStatus(TaskStatus.Failure);
            try {
                TaskManager.setTaskStatus(task);
            }
            catch (CDXException cDXException) {}
            log.error((Object)"Failed To Perform the Query Task", (Throwable)ex);
            audit.failure(transactionId, ex.getMessage(), ex, auth);
            throw new JobExecutionException((Exception)((Object)ex));
        }
    }

    private DocumentList executeNode(NodeKey nodeKey, Map serviceParameters, TransactionVO transactionVO) throws CDXException {
        String dataFlow = (String)serviceParameters.get("DataFlowKey");
        try {
            TransactionMgr.updateTransactionStatus(transactionVO.getTransactionID(), Status.PENDING);
            NodeVersionVO nodeVersionVO = NodeMgr.getNodeByNodeKey(nodeKey);
            LoginVO login = BaseJob.getLogin(serviceParameters);
            DocumentList documentList = QueryManager.query(login, transactionVO.getTransactionID(), nodeVersionVO, serviceParameters);
            documentList.setTransaction(transactionVO);
            DocumentMgr.createDocuments(transactionVO, documentList);
            TransactionMgr.updateTransactionStatus(transactionVO.getTransactionID(), Status.PROCESSED);
            NodeVO nodeVO = NodeMgr.getNode(dataFlow);
            AuthTokenVO authVO = new AuthTokenVO();
            authVO.setClientHostIP(nodeVO.getHostIp());
            Distributor distributor = DistributorFactory.getDistributor(dataFlow);
            distributor.prepareDistribution(authVO, documentList);
            return documentList;
        }
        catch (RemoteException remoteException) {
            audit.failure(transactionVO.getTransactionID(), "Remote prepareDistribution call for dataflow [" + dataFlow + "] failed.", remoteException);
            throw new CDXException(CDXErrorCode.SERVICEPROVIDER_REMOTE_CALL_FAILED);
        }
        catch (CDXException cdxException) {
            TransactionMgr.updateTransactionStatus(transactionVO.getTransactionID(), Status.FAILED);
            log.error((Object)"Failed to Execute Query Request for the Node", (Throwable)cdxException);
            throw cdxException;
        }
    }

    public static void schedule(TaskVO taskVO, Date startDate, long repeatInterval) throws CDXException {
        TaskManager.saveTask(taskVO);
        String string = taskVO.getTaskID();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataCollectionQueryJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BaseJob.schedule(string, startDate, repeatInterval, clazz);
    }
}

