/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.scheduler;

import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.util.GUID;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.infrastructure.document.DocumentMgr;
import gov.epa.cdx.infrastructure.node.NodeMgr;
import gov.epa.cdx.infrastructure.scheduler.TaskManager;
import gov.epa.cdx.logic.requestor.SubmitManager;
import gov.epa.cdx.logic.scheduler.BaseJob;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.node.NodeVersionVO;
import gov.epa.cdx.model.scheduler.TaskStatus;
import gov.epa.cdx.model.scheduler.TaskTypeVO;
import gov.epa.cdx.model.scheduler.TaskVO;
import gov.epa.cdx.model.security.LoginVO;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DataDeliverySubmitJob
implements Job {
    protected static LogInterface log;
    protected static Audit audit;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataDeliverySubmitJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataDeliverySubmitJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        audit = new Audit(clazz2.getName());
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        TaskVO task = BaseJob.getTask(context);
        TransactionVO transactionVO = null;
        try {
            task.setStatus(TaskStatus.InProgress);
            TaskManager.setTaskStatus(task);
            Iterator taskNodeKeys = task.getTaskNodeKeys().iterator();
            NodeKey nodeKey = (NodeKey)taskNodeKeys.next();
            NodeVersionVO nodeVersionVO = NodeMgr.getNodeByNodeKey(nodeKey);
            String dataFlow = (String)task.getTaskParameters().get("DataFlowKey");
            DataflowTypeVO dataFlowType = new DataflowTypeVO(dataFlow);
            transactionVO = task.getTaskTransaction(nodeKey);
            DocumentList documentList = DocumentMgr.getAllDocuments(transactionVO.getTransactionID());
            String message = "Dataflow: " + dataFlowType.toString() + " Node: " + nodeVersionVO.getName() + " URL: " + nodeVersionVO.getUrl() + " " + documentList.toString();
            audit.info(transactionVO.getTransactionID(), message);
            Map serviceParameters = task.getTaskParameters();
            LoginVO login = BaseJob.getLogin(serviceParameters);
            SubmitManager.submit(login, transactionVO.getTransactionID(), nodeVersionVO, dataFlowType, documentList);
            task.setStatus(TaskStatus.Success);
            TaskManager.setTaskStatus(task);
            audit.success(transactionVO.getTransactionID(), message);
        }
        catch (CDXException cdxException) {
            task.setStatus(TaskStatus.Failure);
            try {
                TaskManager.setTaskStatus(task);
            }
            catch (CDXException cDXException) {}
            log.error((Object)"Fail To Perform the Task", (Throwable)cdxException);
            audit.failure(transactionVO.getTransactionID(), cdxException.toString(), cdxException);
            throw new JobExecutionException((Exception)((Object)cdxException));
        }
    }

    public static void schedule(NodeKey nodeKey, Map parameters, TransactionVO transactionVO) throws CDXException {
        ArrayList<NodeKey> nodeKeys = new ArrayList<NodeKey>();
        nodeKeys.add(nodeKey);
        TaskVO taskVO = new TaskVO(GUID.getGUID(), "Submit to the node", new TaskTypeVO("SUBMIT"), System.currentTimeMillis(), parameters, nodeKeys);
        taskVO.setTaskTransaction(nodeKey, transactionVO);
        taskVO.setStatus(TaskStatus.NotStarted);
        TaskManager.saveTask(taskVO);
        String string = taskVO.getTaskID();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataDeliverySubmitJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BaseJob.schedule(string, clazz);
    }
}

