/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.scheduler;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.infrastructure.document.DocumentMgr;
import gov.epa.cdx.infrastructure.extractor.ExtractorManager;
import gov.epa.cdx.infrastructure.node.NodeMgr;
import gov.epa.cdx.infrastructure.scheduler.TaskManager;
import gov.epa.cdx.infrastructure.validation.AsynchronousValidatorManager;
import gov.epa.cdx.logic.requestor.SubmitManager;
import gov.epa.cdx.logic.scheduler.BaseJob;
import gov.epa.cdx.logic.serviceprovider.ServiceProviderEngine;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.document.DocumentType;
import gov.epa.cdx.model.document.DocumentVO;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.node.NodeVersionVO;
import gov.epa.cdx.model.scheduler.TaskStatus;
import gov.epa.cdx.model.scheduler.TaskTypeVO;
import gov.epa.cdx.model.scheduler.TaskVO;
import gov.epa.cdx.model.security.AuthTokenVO;
import gov.epa.cdx.model.security.LoginVO;
import gov.epa.cdx.model.transaction.TransactionVO;
import gov.epa.cdx.model.validation.AsynchronousDocumentValidationVO;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DataGenerationFromQuerySubmitJob
implements Job {
    protected static LogInterface log;
    protected static Audit audit;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataGenerationFromQuerySubmitJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataGenerationFromQuerySubmitJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        audit = new Audit(clazz2.getName());
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        TaskVO task = BaseJob.getTask(context);
        String transactionId = null;
        AuthTokenVO auth = null;
        try {
            task.setStatus(TaskStatus.InProgress);
            TaskManager.setTaskStatus(task);
            Map serviceParameters = task.getTaskParameters();
            auth = new AuthTokenVO();
            auth.setUserId((String)serviceParameters.get("NodeUserId"));
            TaskTypeVO taskType = task.getTaskType();
            String fileType = null;
            if (taskType.getType().equals("DATA_FLOW_QUERY")) {
                fileType = DocumentType.XML.toString();
                serviceParameters.put("IncludeHeader", new Boolean(false));
                serviceParameters.put("FileType", fileType);
            } else {
                fileType = DocumentType.ZIP.toString();
                serviceParameters.put("IncludeHeader", new Boolean(true));
                serviceParameters.put("FileType", fileType);
            }
            byte[] data = ServiceProviderEngine.query(serviceParameters);
            transactionId = DataGenerationFromQuerySubmitJob.submit(task, data);
        }
        catch (CDXException ex) {
            if (ex.getCDXErrorCode() == CDXErrorCode.PROVIDER_IS_NOT_READY_WITH_DOCUMENTS) {
                String retryInterval = CDXPropertyManager.getProperty((String)"Provider", (String)"retryInterval", (String)"60");
                long rerunTime = System.currentTimeMillis() + Long.parseLong(retryInterval);
                BaseJob.reschedule(task.getTaskID(), new Date(rerunTime));
            }
            task.setStatus(TaskStatus.Failure);
            try {
                TaskManager.setTaskStatus(task);
            }
            catch (CDXException cDXException) {}
            log.error((Object)"Failed To Perform the Query/Submit Task", (Throwable)ex);
            audit.failure(transactionId, ex.getMessage(), ex, auth);
            throw new JobExecutionException((Exception)((Object)ex));
        }
    }

    private static String submit(TaskVO task, byte[] data) throws CDXException {
        Map serviceParameters = task.getTaskParameters();
        String transactionId = null;
        AuthTokenVO auth = new AuthTokenVO();
        auth.setUserId((String)serviceParameters.get("NodeUserId"));
        String serviceName = (String)serviceParameters.get("ServiceTypeKey");
        String dataFlow = (String)serviceParameters.get("DataFlowKey");
        DataflowTypeVO dataFlowType = new DataflowTypeVO(dataFlow);
        Collection taskNodeKeys = task.getTaskNodeKeys();
        NodeKey nodeKey = (NodeKey)taskNodeKeys.iterator().next();
        NodeVersionVO nodeVersion = NodeMgr.getNodeByNodeKey(nodeKey);
        String fileType = (String)serviceParameters.get("FileType");
        String dataFlowFileType = CDXPropertyManager.getProperty((String)"Data Flow File Type", (String)dataFlow, (String)fileType);
        String documentName = DataGenerationFromQuerySubmitJob.createDocumentName(nodeVersion, dataFlow, serviceName, dataFlowFileType);
        DocumentList documentList = new DocumentList(dataFlowType);
        documentList.addDocument(documentName, dataFlowFileType, dataFlow, data);
        String submissionType = (String)serviceParameters.get("SubmissionType");
        if (submissionType != null && !"Submit".equals(submissionType) && serviceParameters.containsKey("Schema") && serviceParameters.containsKey("ValidationType")) {
            TransactionVO transactionVO = DocumentMgr.createDocuments(task.getTaskTransaction(nodeKey), documentList);
            transactionId = transactionVO.getTransactionID();
            String validationType = (String)serviceParameters.get("ValidationType");
            DocumentVO originalDocument = (DocumentVO)documentList.getDocument(documentName);
            String validateDocID = null;
            Boolean hasHeaders = (Boolean)serviceParameters.get("IncludeHeader");
            if (hasHeaders.booleanValue()) {
                try {
                    DocumentVO payload = ExtractorManager.extractPayload(originalDocument);
                    documentName = payload.getName();
                    validateDocID = DocumentMgr.createDocument(transactionVO, payload);
                }
                catch (Exception exception) {
                    validateDocID = originalDocument.getID();
                }
            } else {
                validateDocID = originalDocument.getID();
            }
            AsynchronousDocumentValidationVO validation = new AsynchronousDocumentValidationVO();
            validation.setDocumentId(validateDocID);
            validation.setDocumentType((String)serviceParameters.get("Schema"));
            validation.setFormat(dataFlowFileType);
            validation.setValidationType(validationType);
            HashMap<String, String> taskParameters = new HashMap<String, String>();
            taskParameters.put("UserId", auth.getUserId());
            taskParameters.put("DocumentId", originalDocument.getID());
            audit.info(transactionId, "Submitting document for validation. Name: " + documentName);
            AsynchronousValidatorManager.validate(validation, taskParameters);
            task.setStatus(TaskStatus.InProgress);
            TaskManager.setTaskStatus(task);
        } else {
            LoginVO login = BaseJob.getLogin(serviceParameters);
            transactionId = SubmitManager.submit(login, null, nodeVersion, dataFlowType, documentList);
            audit.info(task.getTaskTransaction(nodeKey).getTransactionID(), "Submited data to : " + nodeVersion.getName() + " for dataflow: " + dataFlow + " service: " + serviceName, auth);
            TransactionVO transactionVO = task.getTaskTransaction(nodeKey);
            DocumentMgr.createDocuments(transactionVO, documentList);
            TaskManager.updateTaskParameterValue(task.getTaskID(), "ExternalTransactionId", transactionId);
            task.setStatus(TaskStatus.Success);
            TaskManager.setTaskStatus(task);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String dateString = format.format(new Date(System.currentTimeMillis()));
        TaskManager.updateTaskParameterValue(task.getTaskID(), "ChangeDate", dateString);
        return transactionId;
    }

    private static String createDocumentName(NodeVersionVO nodeVersion, String dataFlow, String serviceName, String dataFlowFileType) throws CDXException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd-HH-mm-ss a");
        String timeStamp = formatter.format(new Date());
        String fileName = String.valueOf(nodeVersion.getName()) + "_" + dataFlow + "_" + serviceName + "_" + timeStamp + "." + dataFlowFileType;
        return fileName;
    }

    public static void schedule(TaskVO taskVO, Date startDate, long repeatInterval) throws CDXException {
        TaskManager.saveTask(taskVO);
        String string = taskVO.getTaskID();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataGenerationFromQuerySubmitJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BaseJob.schedule(string, startDate, repeatInterval, clazz);
    }
}

