/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.scheduler;

import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXSchedulerException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.infrastructure.scheduler.TaskManager;
import gov.epa.cdx.infrastructure.transaction.TransactionMgr;
import gov.epa.cdx.logic.scheduler.BaseJob;
import gov.epa.cdx.logic.serviceprovider.ServiceProviderEngine;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.scheduler.TaskStatus;
import gov.epa.cdx.model.scheduler.TaskVO;
import gov.epa.cdx.model.transaction.Status;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DataGenerationFromSolicitDistributionJob
implements Job {
    protected static LogInterface log;
    protected static Audit audit;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataGenerationFromSolicitDistributionJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataGenerationFromSolicitDistributionJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        audit = new Audit(clazz2.getName());
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        TaskVO task = BaseJob.getTask(context);
        String taskId = task.getTaskID();
        String transactionId = null;
        try {
            task.setStatus(TaskStatus.InProgress);
            TaskManager.setTaskStatus(task);
            Map serviceParameters = task.getTaskParameters();
            Collection taskNodeKeys = task.getTaskNodeKeys();
            NodeKey nodeKey = (NodeKey)taskNodeKeys.iterator().next();
            TransactionVO transactionVO = task.getTaskTransaction(nodeKey);
            transactionId = transactionVO.getTransactionID();
            String dataflow = (String)serviceParameters.get("DataFlowKey");
            audit.info(transactionId, "Soliciting data from: " + dataflow + " service provider");
            ServiceProviderEngine.solicit(transactionId, serviceParameters);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String dateString = format.format(new Date(System.currentTimeMillis()));
            TaskManager.updateTaskParameterValue(task.getTaskID(), "ChangeDate", dateString);
            audit.success(transactionId, "Solicit results (if any) successfully distributed to: " + dataflow + " service consumer");
            task.setStatus(TaskStatus.Success);
            TaskManager.setTaskStatus(task);
        }
        catch (CDXSchedulerException ex) {
            audit.failure(transactionId, ex.getMessage(), ex);
            BaseJob.reschedule(taskId, ex.getRerunDate());
            try {
                TransactionMgr.updateTransactionStatus(transactionId, Status.RESCHEDULED);
            }
            catch (CDXException cDXException) {}
        }
        catch (CDXException ex) {
            task.setStatus(TaskStatus.Failure);
            try {
                TransactionMgr.updateTransactionStatus(transactionId, Status.FAILED);
                TaskManager.setTaskStatus(task);
            }
            catch (CDXException cDXException) {}
            log.error((Object)"Failed To Perform the Solicit Task", (Throwable)ex);
            audit.failure(transactionId, ex.getMessage(), ex);
            throw new JobExecutionException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            task.setStatus(TaskStatus.Failure);
            try {
                TransactionMgr.updateTransactionStatus(transactionId, Status.FAILED);
                TaskManager.setTaskStatus(task);
            }
            catch (CDXException cDXException) {}
            log.error((Object)"Failed To Perform the Solicit Task", (Throwable)ex);
            audit.failure(transactionId, ex.getMessage(), ex);
            throw new JobExecutionException(ex);
        }
    }

    public static void schedule(TaskVO taskVO, Date startDate, long repeatInterval) throws CDXException {
        TaskManager.saveTask(taskVO);
        String string = taskVO.getTaskID();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataGenerationFromSolicitDistributionJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BaseJob.schedule(string, startDate, repeatInterval, clazz);
    }
}

