/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.scheduler;

import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.commons.util.GUID;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.infrastructure.distributor.DistributorFactory;
import gov.epa.cdx.infrastructure.scheduler.TaskManager;
import gov.epa.cdx.logic.scheduler.BaseJob;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.distributor.Distributor;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.node.NodeVersion;
import gov.epa.cdx.model.scheduler.TaskStatus;
import gov.epa.cdx.model.scheduler.TaskTypeVO;
import gov.epa.cdx.model.scheduler.TaskVO;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DataflowDistributionJob
implements Job {
    protected static LogInterface log;
    protected static Audit audit;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataflowDistributionJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataflowDistributionJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        audit = new Audit(clazz2.getName());
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        log.debug((Object)"In Dataflow Distribution Job now.");
        TaskVO task = BaseJob.getTask(context);
        TransactionVO transactionVO = null;
        String dataFlow = null;
        try {
            task.setStatus(TaskStatus.InProgress);
            TaskManager.setTaskStatus(task);
            Map serviceParameters = task.getTaskParameters();
            dataFlow = (String)serviceParameters.get("DataFlowKey");
            Iterator taskNodeKeys = task.getTaskNodeKeys().iterator();
            NodeKey nodeKey = (NodeKey)taskNodeKeys.next();
            transactionVO = task.getTaskTransaction(nodeKey);
            audit.info(transactionVO.getTransactionID(), "Dataflow: " + dataFlow + ", Distribution Parameters: " + serviceParameters.toString());
            Distributor distributor = DistributorFactory.getDistributor(dataFlow);
            TaskStatus status = distributor.distribute(task);
            task.setStatus(status);
            if (task.getStatus().equals((Object)TaskStatus.Failure)) {
                TaskManager.setTaskStatus(task);
                Exception ex = new Exception("Distribution/Notification failed for Dataflow: " + dataFlow);
                audit.failure(transactionVO.getTransactionID(), ex.getMessage(), ex);
            } else {
                task.setStatus(TaskStatus.Success);
                TaskManager.setTaskStatus(task);
                audit.success(transactionVO.getTransactionID(), "Distribution/Notification successful for Dataflow: " + dataFlow);
            }
        }
        catch (Exception cdxException) {
            task.setStatus(TaskStatus.Failure);
            try {
                TaskManager.setTaskStatus(task);
            }
            catch (CDXException cDXException) {}
            log.error((Object)"Failed To Perform the Distribution Task", (Throwable)cdxException);
            audit.failure(transactionVO.getTransactionID(), cdxException.getMessage(), cdxException);
            String retryInterval = CDXPropertyManager.getProperty((String)"Scheduler", (String)"retryInterval", (String)"3600000");
            long rerunTime = System.currentTimeMillis() + Long.parseLong(retryInterval);
            BaseJob.reschedule(task.getTaskID(), new Date(rerunTime));
        }
    }

    public static void schedule(TransactionVO transactionVO, DataflowTypeVO dataFlowType, Map parameters) throws CDXException {
        TaskVO newTaskVO = null;
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        NodeKey nodeKey = new NodeKey(dataFlowType.toString(), NodeVersion.V10);
        ArrayList<NodeKey> nodeKeys = new ArrayList<NodeKey>();
        nodeKeys.add(nodeKey);
        parameters.put("DataFlowKey", dataFlowType.toString());
        newTaskVO = new TaskVO(GUID.getGUID(), "Distribute to the data flow", new TaskTypeVO("DISTRIBUTE"), System.currentTimeMillis(), parameters, nodeKeys);
        newTaskVO.setTaskTransaction(nodeKey, transactionVO);
        audit.info(transactionVO.getTransactionID(), "Distribution task created for Dataflow: " + dataFlowType.toString());
        TaskManager.saveTask(newTaskVO);
        String string = newTaskVO.getTaskID();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataflowDistributionJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BaseJob.schedule(string, clazz);
    }
}

