/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.scheduler;

import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.infrastructure.scheduler.TaskManager;
import gov.epa.cdx.infrastructure.statusprovider.StatusProviderFactory;
import gov.epa.cdx.logic.scheduler.BaseJob;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.scheduler.TaskStatus;
import gov.epa.cdx.model.scheduler.TaskVO;
import gov.epa.cdx.model.statusprovider.StatusProvider;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DataflowGetStatusJob
implements Job {
    protected static LogInterface log;
    protected static Audit audit;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataflowGetStatusJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataflowGetStatusJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        audit = new Audit(clazz2.getName());
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        TaskVO task = BaseJob.getTask(context);
        Map serviceParameters = task.getTaskParameters();
        Iterator taskNodeKeys = task.getTaskNodeKeys().iterator();
        NodeKey nodeKey = (NodeKey)taskNodeKeys.next();
        TransactionVO transactionVO = task.getTaskTransaction(nodeKey);
        String transactionId = transactionVO.getTransactionID();
        String dataflow = "";
        try {
            task.setStatus(TaskStatus.InProgress);
            TaskManager.setTaskStatus(task);
            dataflow = (String)serviceParameters.get("DataFlowKey");
            StatusProvider spi = StatusProviderFactory.getStatusProvider(dataflow.toString());
            TaskStatus status = spi.getStatus(task);
            if (!status.toString().equalsIgnoreCase(TaskStatus.Success.toString())) {
                audit.failure(transactionId, "Status returned <" + status.toString() + "> from dataflow <" + dataflow + ">", null);
            }
            task.setStatus(TaskStatus.Success);
            TaskManager.setTaskStatus(task);
        }
        catch (Exception ex) {
            audit.failure(transactionId, "Error retrieving status from dataflow <" + dataflow + ">", ex);
            try {
                task.setStatus(TaskStatus.Failure);
                TaskManager.setTaskStatus(task);
            }
            catch (CDXException e) {
                log.error((Object)"Recording the status of task failed.", (Throwable)e);
            }
        }
    }

    public static void schedule(TaskVO taskVO, Date startDate, long repeatInterval) throws CDXException {
        TaskManager.saveTask(taskVO);
        String string = taskVO.getTaskID();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataflowGetStatusJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BaseJob.schedule(string, startDate, repeatInterval, clazz);
    }
}

