/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.scheduler;

import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.util.GUID;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.infrastructure.scheduler.TaskManager;
import gov.epa.cdx.infrastructure.statusnotifier.StatusNotifierFactory;
import gov.epa.cdx.logic.scheduler.BaseJob;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.node.NodeVersion;
import gov.epa.cdx.model.scheduler.TaskStatus;
import gov.epa.cdx.model.scheduler.TaskTypeVO;
import gov.epa.cdx.model.scheduler.TaskVO;
import gov.epa.cdx.model.statusnotifier.StatusNotifier;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DataflowSetStatusJob
implements Job {
    protected static LogInterface log;
    protected static Audit audit;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataflowSetStatusJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataflowSetStatusJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        audit = new Audit(clazz2.getName());
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        TaskVO task = BaseJob.getTask(context);
        Map serviceParameters = task.getTaskParameters();
        Iterator taskNodeKeys = task.getTaskNodeKeys().iterator();
        NodeKey nodeKey = (NodeKey)taskNodeKeys.next();
        TransactionVO transactionVO = task.getTaskTransaction(nodeKey);
        String transactionId = transactionVO.getTransactionID();
        String dataflow = "";
        try {
            task.setStatus(TaskStatus.InProgress);
            TaskManager.setTaskStatus(task);
            dataflow = (String)serviceParameters.get("DataFlowKey");
            StatusNotifier spi = StatusNotifierFactory.getStatusNotifier(dataflow.toString());
            spi.setStatus(task);
            task.setStatus(TaskStatus.Success);
            TaskManager.setTaskStatus(task);
        }
        catch (Exception ex) {
            audit.failure(transactionId, "Error setting status in dataflow <" + dataflow + ">", ex);
            try {
                task.setStatus(TaskStatus.Failure);
                TaskManager.setTaskStatus(task);
            }
            catch (CDXException e) {
                log.error((Object)"Recording the status of task failed.", (Throwable)e);
            }
        }
    }

    public static void schedule(TransactionVO transactionVO, DataflowTypeVO dataFlowType, Map parameters) throws CDXException {
        TaskVO newTaskVO = null;
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        NodeKey nodeKey = new NodeKey(dataFlowType.toString(), NodeVersion.V10);
        ArrayList<NodeKey> nodeKeys = new ArrayList<NodeKey>();
        nodeKeys.add(nodeKey);
        parameters.put("DataFlowKey", dataFlowType.toString());
        String status = (String)parameters.get("GetStatus");
        newTaskVO = new TaskVO(GUID.getGUID(), "Notify data flow of status update", new TaskTypeVO("SETSTATUS"), System.currentTimeMillis(), parameters, nodeKeys);
        newTaskVO.setTaskTransaction(nodeKey, transactionVO);
        audit.info(transactionVO.getTransactionID(), "Status <" + status + "> notification task created for <" + dataFlowType.toString() + ">");
        TaskManager.saveTask(newTaskVO);
        String string = newTaskVO.getTaskID();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataflowSetStatusJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BaseJob.schedule(string, clazz);
    }
}

