/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.scheduler;

import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXSchedulerException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.util.GUID;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.infrastructure.scheduler.TaskManager;
import gov.epa.cdx.logic.scheduler.BaseJob;
import gov.epa.cdx.logic.serviceprovider.ServiceProviderEngine;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.node.NodeVersion;
import gov.epa.cdx.model.scheduler.TaskStatus;
import gov.epa.cdx.model.scheduler.TaskTypeVO;
import gov.epa.cdx.model.scheduler.TaskVO;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DataflowSolicitJob
implements Job {
    protected static LogInterface log;
    protected static Audit audit;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataflowSolicitJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataflowSolicitJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        audit = new Audit(clazz2.getName());
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        TaskVO task = BaseJob.getTask(context);
        String taskId = task.getTaskID();
        Map serviceParameters = task.getTaskParameters();
        NodeKey nodeKey = (NodeKey)task.getTaskNodeKeys().iterator().next();
        TransactionVO transactionVO = task.getTaskTransaction(nodeKey);
        try {
            task.setStatus(TaskStatus.InProgress);
            TaskManager.setTaskStatus(task);
            ServiceProviderEngine.solicit(transactionVO.getTransactionID(), serviceParameters);
            task.setStatus(TaskStatus.Success);
            TaskManager.setTaskStatus(task);
        }
        catch (CDXSchedulerException ex) {
            try {
                task.setStatus(TaskStatus.Failure);
                TaskManager.setTaskStatus(task);
            }
            catch (CDXException e) {
                log.error((Object)"Recording the status of task failed.", (Throwable)e);
            }
            BaseJob.reschedule(taskId, ex.getRerunDate());
        }
        catch (CDXException cDXException) {
            try {
                task.setStatus(TaskStatus.Failure);
                TaskManager.setTaskStatus(task);
            }
            catch (CDXException e) {
                log.error((Object)"This shouldnt have happened, there was some type of error in ServiceProviderEngine.", (Throwable)e);
            }
        }
    }

    public static Map loadParameters(String transactionId) throws CDXException {
        TaskVO taskVO = TaskManager.loadTaskByTransactionIdAndTaskType(transactionId, new TaskTypeVO("DATA_FLOW_ASYNC_QUERY"));
        return taskVO.getTaskParameters();
    }

    public static void schedule(TransactionVO transactionVO, DataflowTypeVO dataFlowType, Map parameters, Date scheduleDate, long repeatInterval) throws CDXException {
        NodeKey nodeKey = new NodeKey(dataFlowType.toString(), NodeVersion.V10);
        ArrayList<NodeKey> nodeKeys = new ArrayList<NodeKey>();
        nodeKeys.add(nodeKey);
        TaskVO taskVO = new TaskVO(GUID.getGUID(), "Solicit on dataflow", new TaskTypeVO("DATA_FLOW_ASYNC_QUERY"), scheduleDate.getTime(), parameters, nodeKeys);
        taskVO.setTaskTransaction(nodeKey, transactionVO);
        taskVO.setStatus(TaskStatus.NotStarted);
        TaskManager.saveTask(taskVO);
        String string = taskVO.getTaskID();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataflowSolicitJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BaseJob.schedule(string, scheduleDate, repeatInterval, clazz);
    }

    public static void schedule(TaskVO taskVO, Date startDate, long repeatInterval) throws CDXException {
        TaskManager.saveTask(taskVO);
        String string = taskVO.getTaskID();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.DataflowSolicitJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BaseJob.schedule(string, startDate, repeatInterval, clazz);
    }
}

