/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.scheduler;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXSchedulerException;
import gov.epa.cdx.commons.jndi.JNDIManager;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.logic.scheduler.BaseJob;
import gov.epa.cdx.model.scheduler.TaskVO;
import gov.epa.cdx.model.scheduler.job.JobHome;
import gov.epa.cdx.model.scheduler.job.JobRemote;
import java.rmi.RemoteException;
import java.util.Date;
import javax.ejb.CreateException;
import javax.rmi.PortableRemoteObject;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class RemoteJobInvokerJob
implements Job {
    protected static LogInterface log;
    protected static Audit audit;
    private static final String JNDI_KEY = "JNDI";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.RemoteJobInvokerJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.RemoteJobInvokerJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        audit = new Audit(clazz2.getName());
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        TaskVO task = BaseJob.getTask(context);
        String JNDI = (String)context.getJobDetail().getJobDataMap().get((Object)JNDI_KEY);
        JobRemote remoteRef = null;
        try {
            Object obj = JNDIManager.getObject((String)JNDI);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("gov.epa.cdx.model.scheduler.job.JobHome");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            JobHome home = (JobHome)PortableRemoteObject.narrow((Object)obj, (Class)clazz);
            remoteRef = home.create();
        }
        catch (CreateException createException) {
            log.fatal((Object)"Could not create Distributor Bean", (Throwable)createException);
        }
        catch (RemoteException remoteException) {
            log.fatal((Object)"Remote Exception occured while creating Distributor Bean", (Throwable)remoteException);
        }
        catch (CDXException jndiException) {
            log.fatal((Object)"Could not find job in JNDI", (Throwable)jndiException);
        }
        try {
            remoteRef.execute(task);
        }
        catch (RemoteException remote) {
            log.fatal((Object)"Remote Exception occured", (Throwable)remote);
        }
        catch (CDXSchedulerException ex) {
            BaseJob.reschedule(task.getTaskID(), ex.getRerunDate());
        }
    }

    public static void schedule(String taskId, Date startDate, long repeatInterval, String JNDI) throws CDXException {
        JobDataMap jobData = new JobDataMap();
        jobData.put(JNDI_KEY, JNDI);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.scheduler.RemoteJobInvokerJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BaseJob.schedule(taskId, startDate, repeatInterval, clazz, jobData);
    }

    public static void reschedule(String taskId, long rerunTime) throws CDXException {
        try {
            BaseJob.reschedule(taskId, new Date(rerunTime));
        }
        catch (Exception ex) {
            throw new CDXException(CDXErrorCode.SCHEDULER_ERROR, (Throwable)ex);
        }
    }
}

