/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.security;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXSecurityException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.commons.util.CDXSystemManager;
import gov.epa.cdx.infrastructure.node.NodeMgr;
import gov.epa.cdx.logic.requestor.NAASManager;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.node.NodeVersion;
import gov.epa.cdx.model.node.NodeVersionVO;
import gov.epa.cdx.model.security.AuthTokenVO;
import gov.epa.cdx.model.security.CredentialType;
import gov.epa.cdx.model.security.LoginVO;

public class CdxSecurityManager {
    protected static LogInterface log;
    private static final NodeKey PRIMARY_CAS_KEY;
    private static final NodeKey BACKUP_CAS_KEY;
    private static NodeVersionVO primaryNodeVO;
    private static NodeVersionVO backupNodeVO;
    private static String id;
    private static String credential;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.security.CdxSecurityManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        PRIMARY_CAS_KEY = new NodeKey("primaryCAS", NodeVersion.V10);
        BACKUP_CAS_KEY = new NodeKey("backupCAS", NodeVersion.V10);
        primaryNodeVO = null;
        backupNodeVO = null;
        id = CDXPropertyManager.getEncryptedProperty((String)"NAAS", (String)"VersionKey", (String)"epacdxnode@csc.com");
        credential = CDXPropertyManager.getEncryptedProperty((String)"NAAS", (String)"LicenseTypeKey", (String)"nodeone");
    }

    public static AuthTokenVO selfLogin() throws CDXException {
        CdxSecurityManager.initialize();
        AuthTokenVO token = null;
        LoginVO login = new LoginVO(CDXSystemManager.getCurrentServerPrivateIP(), NodeVersion.V10, id, CredentialType.PASSWORD, (Object)credential);
        login.setLoginType(1);
        token = CdxSecurityManager.login(login);
        return token;
    }

    public static AuthTokenVO login(LoginVO loginVO) throws CDXException {
        CdxSecurityManager.initialize();
        AuthTokenVO result = null;
        try {
            result = NAASManager.executeLogin(primaryNodeVO, loginVO);
        }
        catch (CDXException ex) {
            CDXErrorCode errCode = ex.getCDXErrorCode();
            if (errCode.equals((Object)CDXErrorCode.HTTP_CONNECTION_FAILURE) || errCode.equals((Object)CDXErrorCode.HTTP_URL_BIND_ERROR) || errCode.equals((Object)CDXErrorCode.HTTP_URL_ERROR)) {
                log.info((Object)"Primary NAAS is not available!!", ex.getNestedException());
                try {
                    result = NAASManager.executeLogin(backupNodeVO, loginVO);
                }
                catch (CDXException cdxEx) {
                    throw new CDXSecurityException(CDXErrorCode.AUTHENTICATION_AUTHORIZATION_ERROR, (Throwable)cdxEx);
                }
            }
            throw new CDXSecurityException(CDXErrorCode.AUTHENTICATION_AUTHORIZATION_ERROR, (Throwable)ex);
        }
        return result;
    }

    public static AuthTokenVO validateAuthToken(AuthTokenVO authTokenVO) throws CDXException {
        CdxSecurityManager.initialize();
        AuthTokenVO tokenResult = null;
        try {
            tokenResult = NAASManager.executeValidate(primaryNodeVO, authTokenVO);
        }
        catch (CDXException ex) {
            CDXErrorCode errCode = ex.getCDXErrorCode();
            if (errCode.equals((Object)CDXErrorCode.HTTP_CONNECTION_FAILURE) || errCode.equals((Object)CDXErrorCode.HTTP_URL_BIND_ERROR) || errCode.equals((Object)CDXErrorCode.HTTP_URL_ERROR)) {
                log.info((Object)"Primary NAAS is not available!!", ex.getNestedException());
                try {
                    tokenResult = NAASManager.executeValidate(backupNodeVO, authTokenVO);
                }
                catch (CDXException cdxEx) {
                    throw new CDXSecurityException(CDXErrorCode.AUTHENTICATION_AUTHORIZATION_ERROR, (Throwable)cdxEx);
                }
            }
            throw ex;
        }
        return tokenResult;
    }

    private static void initialize() throws CDXException {
        try {
            if (primaryNodeVO == null) {
                primaryNodeVO = NodeMgr.getNodeByNodeKey(PRIMARY_CAS_KEY);
            }
            if (backupNodeVO == null) {
                backupNodeVO = NodeMgr.getNodeByNodeKey(BACKUP_CAS_KEY);
            }
        }
        catch (CDXException cdxEx) {
            throw cdxEx;
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
    }

    public static String getId() {
        return id;
    }

    public static String getCredential() {
        return credential;
    }
}

