/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.logic.serviceprovider;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXSchedulerException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.util.tools.MapToStringConverter;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.infrastructure.document.DocumentMgr;
import gov.epa.cdx.infrastructure.node.NodeMgr;
import gov.epa.cdx.infrastructure.servicelookup.ServiceLookupMgr;
import gov.epa.cdx.infrastructure.serviceprovider.ServiceProviderFactory;
import gov.epa.cdx.infrastructure.transaction.TransactionMgr;
import gov.epa.cdx.logic.scheduler.DataDeliverySubmitJob;
import gov.epa.cdx.logic.scheduler.DataflowSolicitJob;
import gov.epa.cdx.model.commons.QueryVO;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.security.AuthTokenVO;
import gov.epa.cdx.model.serviceprovider.ServiceProvider;
import gov.epa.cdx.model.transaction.Status;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Map;

public class ServiceProviderEngine {
    protected static LogInterface log;
    protected static Audit audit;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.logic.serviceprovider.ServiceProviderEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.epa.cdx.logic.serviceprovider.ServiceProviderEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        audit = new Audit(clazz2.getName());
    }

    public static byte[] query(AuthTokenVO token, QueryVO queryVO) throws CDXException {
        Map parameters = ServiceLookupMgr.mapQueryParameters(queryVO);
        String serviceName = queryVO.getServiceName();
        parameters.put("requestName", serviceName);
        DataflowTypeVO dataflow = ServiceLookupMgr.getDataflowByServiceName(serviceName);
        parameters.put("DataFlowKey", dataflow.getDataflowType());
        ServiceProvider spi = ServiceProviderFactory.getServiceProvider(dataflow.toString(), serviceName);
        String transactionID = queryVO.getTransactionId();
        parameters.put("tranID", transactionID);
        parameters.put("TransactionId", transactionID);
        audit.info(transactionID, queryVO.toString(), token);
        byte[] resultXMLContent = null;
        try {
            resultXMLContent = spi.query(token, parameters);
        }
        catch (RemoteException remoteException) {
            audit.failure(transactionID, queryVO.toString(), remoteException, token);
            throw new CDXException(CDXErrorCode.SERVICEPROVIDER_REMOTE_CALL_FAILED, (Throwable)remoteException);
        }
        catch (CDXException exception) {
            audit.failure(transactionID, queryVO.toString(), exception, token);
            throw exception;
        }
        return resultXMLContent;
    }

    public static byte[] query(Map parameters) throws CDXException {
        String serviceName = (String)parameters.get("ServiceTypeKey");
        DataflowTypeVO dataflow = ServiceLookupMgr.getDataflowByServiceName(serviceName);
        parameters.put("DataFlowKey", dataflow.getDataflowType());
        ServiceProvider spi = ServiceProviderFactory.getServiceProvider(dataflow.toString(), serviceName);
        byte[] resultXMLContent = null;
        try {
            resultXMLContent = spi.query(null, parameters);
        }
        catch (RemoteException remoteException) {
            throw new CDXException(CDXErrorCode.SERVICEPROVIDER_REMOTE_CALL_FAILED, (Throwable)remoteException);
        }
        return resultXMLContent;
    }

    public static TransactionVO prepareSolicit(AuthTokenVO token, QueryVO queryVO) throws CDXException {
        Map parameters = ServiceLookupMgr.mapQueryParameters(queryVO);
        String serviceName = queryVO.getServiceName();
        parameters.put("requestName", serviceName);
        DataflowTypeVO dataflow = ServiceLookupMgr.getDataflowByServiceName(serviceName);
        parameters.put("DataFlowKey", dataflow.getDataflowType());
        ServiceProvider spi = ServiceProviderFactory.getServiceProvider(dataflow.toString(), serviceName);
        String transactionID = queryVO.getTransactionId();
        parameters.put("tranID", transactionID);
        parameters.put("TransactionId", transactionID);
        TransactionVO transactionVO = TransactionMgr.getTransaction(transactionID);
        audit.info(transactionID, queryVO.toString(), token);
        Date scheduleDate = null;
        try {
            scheduleDate = spi.prepareSolicit(token, transactionID, parameters);
        }
        catch (RemoteException remoteException) {
            audit.failure(transactionID, queryVO.toString(), remoteException, token);
            throw new CDXException(CDXErrorCode.SERVICEPROVIDER_REMOTE_CALL_FAILED, (Throwable)remoteException);
        }
        catch (CDXException exception) {
            audit.failure(transactionID, queryVO.toString(), exception, token);
            throw exception;
        }
        audit.success(transactionID, "Solicit will run on " + scheduleDate, token);
        return transactionVO;
    }

    public static void solicit(String transactionId, Map parameters) throws CDXSchedulerException, CDXException {
        DocumentList documents = ServiceProviderEngine.performSolicit(transactionId, parameters);
        if (documents != null) {
            ServiceProviderEngine.scheduleSubmitReturn(TransactionMgr.getTransaction(transactionId), parameters);
        }
    }

    private static DocumentList performSolicit(String transactionId, Map parameters) throws CDXSchedulerException, CDXException {
        audit.info(transactionId, MapToStringConverter.convert((Map)parameters));
        String serviceName = (String)parameters.get("ServiceTypeKey");
        String dataflowName = (String)parameters.get("DataFlowKey");
        ServiceProvider spi = ServiceProviderEngine.getServiceProvider(transactionId, dataflowName, serviceName);
        DocumentList documents = null;
        try {
            documents = spi.solicit(transactionId, parameters);
        }
        catch (RemoteException remoteException) {
            audit.failure(transactionId, "Remote solicit call for service name [" + serviceName + "] and dataflow [" + dataflowName + "] failed.", remoteException);
            throw new CDXException(CDXErrorCode.SERVICEPROVIDER_REMOTE_CALL_FAILED, (Throwable)remoteException);
        }
        catch (CDXSchedulerException exception) {
            String message = null;
            message = exception.getRerunDate() != null ? "Solicit run failed, service provider requested rerun date of " + exception.getRerunDate().toString() + "." : "Solicit run failed, service provider did not request a rerun.";
            audit.failure(transactionId, message, exception);
            throw exception;
        }
        catch (Exception exception) {
            String message = "Solicit run failed with the following exception: " + exception.toString() + ".";
            audit.failure(transactionId, message, exception);
            throw new CDXException(CDXErrorCode.SERVICEPROVIDER_REMOTE_CALL_FAILED, (Throwable)exception);
        }
        if (documents != null) {
            TransactionVO transactionVO = TransactionMgr.getTransaction(transactionId);
            documents.setTransaction(transactionVO);
            DocumentMgr.createDocuments(transactionVO, documents);
            TransactionMgr.updateTransactionStatus(transactionId, Status.PROCESSED);
            audit.success(transactionId, documents.toString());
        } else {
            TransactionMgr.updateTransactionStatus(transactionId, Status.PENDING);
            String message = "No documents delivered -- transaction is still incomplete - ";
            audit.success(transactionId, message);
        }
        return documents;
    }

    public static void notifySolicit(AuthTokenVO token, String transactionId, DocumentList documents) throws CDXException {
        String serviceName = null;
        String dataflowName = null;
        TransactionVO transactionVO = null;
        try {
            Map parameters = DataflowSolicitJob.loadParameters(transactionId);
            audit.info(transactionId, MapToStringConverter.convert((Map)parameters), token);
            serviceName = (String)parameters.get("ServiceTypeKey");
            dataflowName = (String)parameters.get("DataFlowKey");
            ServiceProvider spi = ServiceProviderEngine.getServiceProvider(transactionId, dataflowName, serviceName);
            transactionVO = TransactionMgr.getTransaction(transactionId);
            documents.setTransaction(transactionVO);
            spi.notifySolicit(transactionId, parameters, documents);
        }
        catch (RemoteException remoteException) {
            audit.failure(transactionId, "Remote notifySolicit call for service name [" + serviceName + "] and dataflow [" + dataflowName + "] failed.", remoteException);
            throw new CDXException(CDXErrorCode.SERVICEPROVIDER_REMOTE_CALL_FAILED, (Throwable)remoteException);
        }
        catch (CDXException exception) {
            audit.failure(transactionId, "Remote notifySolicit call for service name [" + serviceName + "] and dataflow [" + dataflowName + "] failed.", exception, token);
            throw exception;
        }
        DocumentMgr.createDocuments(transactionVO, documents);
        String message = "Notification Documents: " + documents.toString() + " ";
        audit.success(transactionId, message, token);
    }

    public static void finalizeSolicit(AuthTokenVO token, String transactionId, DocumentList documents) throws CDXException {
        Map parameters = DataflowSolicitJob.loadParameters(transactionId);
        audit.info(transactionId, MapToStringConverter.convert((Map)parameters), token);
        String serviceName = (String)parameters.get("ServiceTypeKey");
        String dataflowName = (String)parameters.get("DataFlowKey");
        ServiceProvider spi = ServiceProviderEngine.getServiceProvider(transactionId, dataflowName, serviceName);
        TransactionVO transactionVO = TransactionMgr.getTransaction(transactionId);
        documents.setTransaction(transactionVO);
        DocumentList documentsAfterServiceProviderCall = null;
        try {
            documentsAfterServiceProviderCall = spi.finalizeSolicit(transactionId, parameters, documents);
        }
        catch (RemoteException remoteException) {
            audit.failure(transactionId, "Remote finalizeSolicit call for service name [" + serviceName + "] and dataflow [" + dataflowName + "] failed.", remoteException);
            throw new CDXException(CDXErrorCode.SERVICEPROVIDER_REMOTE_CALL_FAILED, (Throwable)remoteException);
        }
        catch (CDXException exception) {
            audit.failure(transactionId, "Remote finalizeSolicit call for service name [" + serviceName + "] and dataflow [" + dataflowName + "] failed.", exception, token);
            throw exception;
        }
        if (documentsAfterServiceProviderCall != null && !documentsAfterServiceProviderCall.getDocuments().isEmpty()) {
            DocumentMgr.createDocuments(transactionVO, documentsAfterServiceProviderCall);
            String requestorUrl = (String)parameters.get("RequestorUrlKey");
            if (requestorUrl == null) {
                TransactionMgr.updateTransactionStatus(transactionId, Status.COMPLETED);
            } else {
                TransactionMgr.updateTransactionStatus(transactionId, Status.PROCESSED);
                ServiceProviderEngine.scheduleSubmitReturn(transactionVO, parameters);
            }
            String message = "Documents before service provider: " + documents.toString() + " After: " + documentsAfterServiceProviderCall.toString();
            audit.success(transactionId, message, token);
        } else {
            TransactionMgr.updateTransactionStatus(transactionId, Status.FAILED);
            String message = "Documents returned by the service provider were either null or contained no documents " + documentsAfterServiceProviderCall;
            audit.failure(transactionId, message, null, token);
        }
    }

    private static void scheduleSubmitReturn(TransactionVO transactionVO, Map parameters) throws CDXException {
        String requestorUrl = (String)parameters.get("RequestorUrlKey");
        if (requestorUrl != null) {
            NodeKey nodeKey = NodeMgr.getNodeByUrl(requestorUrl);
            DataDeliverySubmitJob.schedule(nodeKey, parameters, transactionVO);
        }
    }

    private static ServiceProvider getServiceProvider(String transactionId, String dataflowName, String serviceName) throws CDXException {
        try {
            ServiceProvider spi = ServiceProviderFactory.getServiceProvider(dataflowName, serviceName);
            return spi;
        }
        catch (CDXException ex) {
            String message = "Configuration Error - couldn't load service provider for " + serviceName + " service " + " which belongs to " + dataflowName + " dataflow.";
            log.fatal((Object)message, (Throwable)ex);
            audit.failure(transactionId, message, ex);
            TransactionMgr.updateTransactionStatus(transactionId, Status.FAILED);
            throw ex;
        }
    }
}

