/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.ChannelSubsystem;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.RequestSubsystem;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Vector;

public class ChannelSftp
extends ChannelSubsystem {
    private static final byte SSH_FXP_INIT = 1;
    private static final byte SSH_FXP_VERSION = 2;
    private static final byte SSH_FXP_OPEN = 3;
    private static final byte SSH_FXP_CLOSE = 4;
    private static final byte SSH_FXP_READ = 5;
    private static final byte SSH_FXP_WRITE = 6;
    private static final byte SSH_FXP_LSTAT = 7;
    private static final byte SSH_FXP_FSTAT = 8;
    private static final byte SSH_FXP_SETSTAT = 9;
    private static final byte SSH_FXP_FSETSTAT = 10;
    private static final byte SSH_FXP_OPENDIR = 11;
    private static final byte SSH_FXP_READDIR = 12;
    private static final byte SSH_FXP_REMOVE = 13;
    private static final byte SSH_FXP_MKDIR = 14;
    private static final byte SSH_FXP_RMDIR = 15;
    private static final byte SSH_FXP_REALPATH = 16;
    private static final byte SSH_FXP_STAT = 17;
    private static final byte SSH_FXP_RENAME = 18;
    private static final byte SSH_FXP_READLINK = 19;
    private static final byte SSH_FXP_SYMLINK = 20;
    private static final byte SSH_FXP_STATUS = 101;
    private static final byte SSH_FXP_HANDLE = 102;
    private static final byte SSH_FXP_DATA = 103;
    private static final byte SSH_FXP_NAME = 104;
    private static final byte SSH_FXP_ATTRS = 105;
    private static final byte SSH_FXP_EXTENDED = -56;
    private static final byte SSH_FXP_EXTENDED_REPLY = -55;
    private static final int SSH_FXF_READ = 1;
    private static final int SSH_FXF_WRITE = 2;
    private static final int SSH_FXF_APPEND = 4;
    private static final int SSH_FXF_CREAT = 8;
    private static final int SSH_FXF_TRUNC = 16;
    private static final int SSH_FXF_EXCL = 32;
    private static final int SSH_FILEXFER_ATTR_SIZE = 1;
    private static final int SSH_FILEXFER_ATTR_UIDGID = 2;
    private static final int SSH_FILEXFER_ATTR_PERMISSIONS = 4;
    private static final int SSH_FILEXFER_ATTR_ACMODTIME = 8;
    private static final int SSH_FILEXFER_ATTR_EXTENDED = Integer.MIN_VALUE;
    public static final int SSH_FX_OK = 0;
    public static final int SSH_FX_EOF = 1;
    public static final int SSH_FX_NO_SUCH_FILE = 2;
    public static final int SSH_FX_PERMISSION_DENIED = 3;
    public static final int SSH_FX_FAILURE = 4;
    public static final int SSH_FX_BAD_MESSAGE = 5;
    public static final int SSH_FX_NO_CONNECTION = 6;
    public static final int SSH_FX_CONNECTION_LOST = 7;
    public static final int SSH_FX_OP_UNSUPPORTED = 8;
    private boolean interactive = false;
    private int count = 1;
    private Buffer buf;
    private Packet packet = new Packet(this.buf);
    private String version = "3";
    private int server_version = 3;
    private static final String file_separator = File.separator;
    private static final char file_separatorc = File.separatorChar;
    private String cwd;
    private String home;
    private String lcwd;

    ChannelSftp() {
        this.setSubsystem("sftp");
    }

    public void init() {
    }

    public void start() {
        try {
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            this.io.setOutputStream(pipedOutputStream);
            PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
            this.io.setInputStream(pipedInputStream);
            RequestSubsystem requestSubsystem = new RequestSubsystem("sftp");
            requestSubsystem.request(this.session, this);
            this.thread = this;
            this.buf = new Buffer();
            this.packet = new Packet(this.buf);
            int n = 0;
            boolean bl = false;
            this.sendINIT();
            this.buf.rewind();
            n = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int n2 = this.buf.getInt();
            int n3 = this.buf.getByte();
            this.server_version = this.buf.getInt();
            this.sendREALPATH(".".getBytes());
            this.buf.rewind();
            n = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            n2 = this.buf.getInt();
            n3 = this.buf.getByte();
            this.buf.getInt();
            n = this.buf.getInt();
            byte[] byArray = this.buf.getString();
            this.home = this.cwd = new String(byArray);
            byArray = this.buf.getString();
            this.lcwd = new File(".").getCanonicalPath();
        }
        catch (Exception exception) {}
    }

    public void quit() {
        this.disconnect();
    }

    public void exit() {
        this.disconnect();
    }

    public void lcd(String string) throws SftpException {
        if (!ChannelSftp.isLocalAbsolutePath(string)) {
            string = this.lcwd + file_separator + string;
        }
        if (new File(string).isDirectory()) {
            try {
                string = new File(string).getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lcwd = string;
            return;
        }
        throw new SftpException(2, "No such directory");
    }

    public void cd(String string) throws SftpException {
        try {
            Vector vector;
            if (!string.startsWith("/")) {
                string = this.cwd + "/" + string;
            }
            if ((vector = this.glob_remote(string)).size() != 1) {
                throw new SftpException(4, vector.toString());
            }
            string = (String)vector.elementAt(0);
            this.sendREALPATH(string.getBytes());
            this.buf.rewind();
            int n = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int n2 = this.buf.getInt();
            int n3 = this.buf.getByte();
            if (n3 != 101 && n3 != 104) {
                throw new SftpException(4, "");
            }
            if (n3 == 101) {
                this.buf.getInt();
                n = this.buf.getInt();
                byte[] byArray = this.buf.getString();
                throw new SftpException(n, new String(byArray));
            }
            this.buf.getInt();
            n = this.buf.getInt();
            byte[] byArray = this.buf.getString();
            if (byArray != null && byArray[0] != 47) {
                byArray = (this.cwd + "/" + new String(byArray)).getBytes();
            }
            this.cwd = new String(byArray);
            byArray = this.buf.getString();
            n = this.buf.getInt();
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            throw new SftpException(4, "");
        }
    }

    public void put(String string, String string2) throws SftpException {
        this.put(string, string2, null);
    }

    public void put(String string, String string2, SftpProgressMonitor sftpProgressMonitor) throws SftpException {
        if (!ChannelSftp.isLocalAbsolutePath(string)) {
            string = this.lcwd + file_separator + string;
        }
        if (!string2.startsWith("/")) {
            string2 = this.cwd + "/" + string2;
        }
        try {
            Vector vector = this.glob_remote(string2);
            if (vector.size() != 1) {
                throw new SftpException(4, vector.toString());
            }
            string2 = (String)vector.elementAt(0);
            boolean bl = this.isRemoteDir(string2);
            vector = this.glob_local(string);
            int n = 0;
            while (n < vector.size()) {
                String string3 = (String)vector.elementAt(n);
                String string4 = string2;
                if (bl) {
                    int n2;
                    if (!string4.endsWith("/")) {
                        string4 = string4 + "/";
                    }
                    string4 = (n2 = string3.lastIndexOf(file_separatorc)) == -1 ? string4 + string3 : string4 + string3.substring(n2 + 1);
                }
                if (sftpProgressMonitor != null) {
                    sftpProgressMonitor.init(0, string3, string4, new File(string3).length());
                }
                FileInputStream fileInputStream = new FileInputStream(string3);
                this.put(fileInputStream, string4, sftpProgressMonitor);
                fileInputStream.close();
                ++n;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            throw new SftpException(4, "");
        }
    }

    public void put(InputStream inputStream, String string) throws SftpException {
        this.put(inputStream, string, null);
    }

    public void put(InputStream inputStream, String string, SftpProgressMonitor sftpProgressMonitor) throws SftpException {
        try {
            Vector vector;
            if (!string.startsWith("/")) {
                string = this.cwd + "/" + string;
            }
            if ((vector = this.glob_remote(string)).size() != 1) {
                throw new SftpException(4, vector.toString());
            }
            string = (String)vector.elementAt(0);
            if (this.isRemoteDir(string)) {
                throw new SftpException(4, string + " is a directory");
            }
            this.sendOPENW(string.getBytes());
            this.buf.rewind();
            int n = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int n2 = this.buf.getInt();
            int n3 = this.buf.getByte();
            if (n3 != 101 && n3 != 102) {
                throw new SftpException(4, "");
            }
            if (n3 == 101) {
                this.buf.getInt();
                n = this.buf.getInt();
                this.throwStatusError(this.buf, n);
            }
            this.buf.getInt();
            byte[] byArray = this.buf.getString();
            byte[] byArray2 = new byte[1024];
            long l = 0L;
            while ((n = inputStream.read(byArray2, 0, 1024)) > 0) {
                this.sendWRITE(byArray, l, byArray2, 0, n);
                l += (long)n;
                this.buf.rewind();
                this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                n2 = this.buf.getInt();
                n3 = this.buf.getByte();
                if (n3 != 101) break;
                this.buf.getInt();
                if (this.buf.getInt() == 0 && (sftpProgressMonitor == null || sftpProgressMonitor.count(n))) continue;
            }
            this.sendCLOSE(byArray);
            if (sftpProgressMonitor != null) {
                sftpProgressMonitor.end();
            }
            this.buf.rewind();
            n = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            n2 = this.buf.getInt();
            n3 = this.buf.getByte();
            if (n3 != 101) {
                throw new SftpException(4, "");
            }
            this.buf.getInt();
            n = this.buf.getInt();
            if (n == 0) {
                return;
            }
            this.throwStatusError(this.buf, n);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            throw new SftpException(4, "");
        }
    }

    public OutputStream put(String string) throws SftpException {
        if (!string.startsWith("/")) {
            string = this.cwd + "/" + string;
        }
        try {
            Vector vector = this.glob_remote(string);
            if (vector.size() != 1) {
                throw new SftpException(4, vector.toString());
            }
            string = (String)vector.elementAt(0);
            if (this.isRemoteDir(string)) {
                throw new SftpException(4, string + " is a directory");
            }
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            final PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
            final ChannelSftp channelSftp = this;
            final String string2 = string;
            new Thread(new Runnable(){

                public void run() {
                    try {
                        channelSftp.put(pipedInputStream, string2);
                    }
                    catch (Exception exception) {
                        System.out.println("!!" + exception);
                    }
                    try {
                        pipedInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }).start();
            return pipedOutputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            throw new SftpException(4, "");
        }
    }

    public void get(String string, String string2) throws SftpException {
        this.get(string, string2, null);
    }

    public void get(String string, String string2, SftpProgressMonitor sftpProgressMonitor) throws SftpException {
        if (!string.startsWith("/")) {
            string = this.cwd + "/" + string;
        }
        if (!ChannelSftp.isLocalAbsolutePath(string2)) {
            string2 = this.lcwd + file_separator + string2;
        }
        try {
            Vector vector = this.glob_remote(string);
            int n = 0;
            while (n < vector.size()) {
                String string3 = string2;
                String string4 = (String)vector.elementAt(n);
                if (new File(string3).isDirectory()) {
                    int n2;
                    if (!string3.endsWith(file_separator)) {
                        string3 = string3 + file_separator;
                    }
                    string3 = (n2 = string4.lastIndexOf(47)) == -1 ? string3 + string : string3 + string4.substring(n2 + 1);
                }
                if (sftpProgressMonitor != null) {
                    SftpATTRS sftpATTRS = this.stat(string4);
                    sftpProgressMonitor.init(1, string4, string3, sftpATTRS.getSize());
                }
                FileOutputStream fileOutputStream = new FileOutputStream(string3);
                this.get(string4, fileOutputStream, sftpProgressMonitor);
                fileOutputStream.close();
                ++n;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            throw new SftpException(4, "");
        }
    }

    public void get(String string, OutputStream outputStream) throws SftpException {
        this.get(string, outputStream, null);
    }

    public void get(String string, OutputStream outputStream, SftpProgressMonitor sftpProgressMonitor) throws SftpException {
        try {
            Vector vector;
            if (!string.startsWith("/")) {
                string = this.cwd + "/" + string;
            }
            if ((vector = this.glob_remote(string)).size() != 1) {
                throw new SftpException(4, vector.toString());
            }
            string = (String)vector.elementAt(0);
            this.sendOPENR(string.getBytes());
            this.buf.rewind();
            int n = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int n2 = this.buf.getInt();
            int n3 = this.buf.getByte();
            if (n3 != 101 && n3 != 102) {
                throw new SftpException(4, "");
            }
            if (n3 == 101) {
                this.buf.getInt();
                n = this.buf.getInt();
                this.throwStatusError(this.buf, n);
            }
            this.buf.getInt();
            byte[] byArray = this.buf.getString();
            byte[] byArray2 = null;
            long l = 0L;
            while (true) {
                this.sendREAD(byArray, l, 1000);
                this.buf.rewind();
                n = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                n2 = this.buf.getInt();
                n3 = this.buf.getByte();
                this.buf.getInt();
                if (n3 != 101 && n3 != 103 || n3 == 101 && this.buf.getInt() == 1) break;
                byArray2 = this.buf.getString();
                outputStream.write(byArray2, 0, byArray2.length);
                outputStream.flush();
                if (sftpProgressMonitor != null && !sftpProgressMonitor.count(byArray2.length)) break;
                l += (long)byArray2.length;
            }
            this.sendCLOSE(byArray);
            if (sftpProgressMonitor != null) {
                sftpProgressMonitor.end();
            }
            this.buf.rewind();
            n = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            n2 = this.buf.getInt();
            n3 = this.buf.getByte();
            if (n3 != 101) {
                throw new SftpException(4, "");
            }
            this.buf.getInt();
            n = this.buf.getInt();
            if (n == 0) {
                return;
            }
            this.throwStatusError(this.buf, n);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            throw new SftpException(4, "");
        }
    }

    public InputStream get(String string) throws SftpException {
        if (!string.startsWith("/")) {
            string = this.cwd + "/" + string;
        }
        try {
            Vector vector = this.glob_remote(string);
            if (vector.size() != 1) {
                throw new SftpException(4, vector.toString());
            }
            string = (String)vector.elementAt(0);
            this.stat(string);
            PipedInputStream pipedInputStream = new PipedInputStream();
            final PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
            final ChannelSftp channelSftp = this;
            final String string2 = string;
            new Thread(new Runnable(){

                public void run() {
                    try {
                        channelSftp.get(string2, pipedOutputStream);
                    }
                    catch (Exception exception) {
                        System.out.println("!!" + exception);
                    }
                    try {
                        pipedOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }).start();
            while (pipedInputStream.available() == 0) {
                Thread.sleep(1000L);
            }
            return pipedInputStream;
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            throw new SftpException(4, "");
        }
    }

    /*
     * Unable to fully structure code
     */
    public Vector ls(String var1_1) throws SftpException {
        try {
            if (!var1_1.startsWith("/")) {
                var1_1 = this.cwd + "/" + var1_1;
            }
            var2_2 = var1_1;
            var3_4 = null;
            if (!this.isRemoteDir(var2_2)) {
                var4_5 = var1_1.lastIndexOf(47);
                var2_2 = var1_1.substring(0, var4_5);
                var3_4 = var1_1.substring(var4_5 + 1).getBytes();
            }
            this.sendOPENDIR(var2_2.getBytes());
            this.buf.rewind();
            var4_5 = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            var5_6 = this.buf.getInt();
            var6_7 = this.buf.getByte();
            if (var6_7 != 101 && var6_7 != 102) {
                throw new SftpException(4, "");
            }
            if (var6_7 == 101) {
                this.buf.getInt();
                var4_5 = this.buf.getInt();
                this.throwStatusError(this.buf, var4_5);
            }
            this.buf.getInt();
            var7_8 = this.buf.getString();
            var8_9 = new Vector<String>();
            block2: while (true) {
                this.sendREADDIR(var7_8);
                this.buf.rewind();
                this.buf.index = var4_5 = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                var5_6 = this.buf.getInt();
                var5_6 -= var4_5 - 4;
                var6_7 = this.buf.getByte();
                if (var6_7 != 101 && var6_7 != 104) {
                    throw new SftpException(4, "");
                }
                if (var6_7 == 101) break;
                this.buf.getInt();
                var9_10 = this.buf.getInt();
                while (true) {
                    if (var9_10 <= 0) continue block2;
                    if (var5_6 > 0) {
                        this.buf.shift();
                        var4_5 = this.io.in.read(this.buf.buffer, this.buf.index, this.buf.buffer.length - this.buf.index);
                        if (var4_5 > 0) ** break;
                        continue block2;
                        this.buf.index += var4_5;
                        var5_6 -= var4_5;
                    }
                    var12_12 = this.buf.getString();
                    var10_11 = this.buf.getString();
                    var13_13 = new String(var10_11);
                    var14_14 = SftpATTRS.getATTR(this.buf);
                    if (var3_4 == null || this.glob(var3_4, var12_12)) {
                        var8_9.addElement(var13_13);
                    }
                    --var9_10;
                }
                break;
            }
            this.sendCLOSE(var7_8);
            this.buf.rewind();
            var4_5 = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            var5_6 = this.buf.getInt();
            var6_7 = this.buf.getByte();
            if (var6_7 != 101) {
                throw new SftpException(4, "");
            }
            this.buf.getInt();
            var4_5 = this.buf.getInt();
            if (var4_5 == 0) {
                return var8_9;
            }
            this.throwStatusError(this.buf, var4_5);
        }
        catch (Exception var2_3) {
            if (var2_3 instanceof SftpException) {
                throw (SftpException)var2_3;
            }
            throw new SftpException(4, "");
        }
        return null;
    }

    public void symlink(String string, String string2) throws SftpException {
        if (this.server_version < 3) {
            throw new SftpException(4, "The remote sshd is too old to support symlink operation.");
        }
        try {
            Vector vector;
            if (!string.startsWith("/")) {
                string = this.cwd + "/" + string;
            }
            if (!string2.startsWith("/")) {
                string2 = this.cwd + "/" + string2;
            }
            if ((vector = this.glob_remote(string)).size() != 1) {
                throw new SftpException(4, vector.toString());
            }
            string = (String)vector.elementAt(0);
            this.sendSYMLINK(string.getBytes(), string2.getBytes());
            this.buf.rewind();
            int n = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int n2 = this.buf.getInt();
            int n3 = this.buf.getByte();
            if (n3 != 101) {
                throw new SftpException(4, "");
            }
            this.buf.getInt();
            n = this.buf.getInt();
            if (n == 0) {
                return;
            }
            this.throwStatusError(this.buf, n);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            throw new SftpException(4, "");
        }
    }

    public void rename(String string, String string2) throws SftpException {
        if (this.server_version < 2) {
            throw new SftpException(4, "The remote sshd is too old to support rename operation.");
        }
        try {
            Vector vector;
            if (!string.startsWith("/")) {
                string = this.cwd + "/" + string;
            }
            if (!string2.startsWith("/")) {
                string2 = this.cwd + "/" + string2;
            }
            if ((vector = this.glob_remote(string)).size() != 1) {
                throw new SftpException(4, vector.toString());
            }
            string = (String)vector.elementAt(0);
            vector = this.glob_remote(string2);
            if (vector.size() >= 2) {
                throw new SftpException(4, vector.toString());
            }
            if (vector.size() == 1) {
                string2 = (String)vector.elementAt(0);
            }
            this.sendRENAME(string.getBytes(), string2.getBytes());
            this.buf.rewind();
            int n = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int n2 = this.buf.getInt();
            int n3 = this.buf.getByte();
            if (n3 != 101) {
                throw new SftpException(4, "");
            }
            this.buf.getInt();
            n = this.buf.getInt();
            if (n == 0) {
                return;
            }
            this.throwStatusError(this.buf, n);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            throw new SftpException(4, "");
        }
    }

    public void rm(String string) throws SftpException {
        try {
            if (!string.startsWith("/")) {
                string = this.cwd + "/" + string;
            }
            Vector vector = this.glob_remote(string);
            int n = 0;
            while (n < vector.size()) {
                string = (String)vector.elementAt(n);
                this.sendREMOVE(string.getBytes());
                this.buf.rewind();
                int n2 = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                int n3 = this.buf.getInt();
                int n4 = this.buf.getByte();
                if (n4 != 101) {
                    throw new SftpException(4, "");
                }
                this.buf.getInt();
                n2 = this.buf.getInt();
                if (n2 != 0) {
                    this.throwStatusError(this.buf, n2);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            throw new SftpException(4, "");
        }
    }

    boolean isRemoteDir(String string) {
        try {
            this.sendSTAT(string.getBytes());
            this.buf.rewind();
            int n = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int n2 = this.buf.getInt();
            int n3 = this.buf.getByte();
            if (n3 != 105) {
                return false;
            }
            this.buf.getInt();
            SftpATTRS sftpATTRS = SftpATTRS.getATTR(this.buf);
            return sftpATTRS.isDir();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void chgrp(int n, String string) throws SftpException {
        try {
            if (!string.startsWith("/")) {
                string = this.cwd + "/" + string;
            }
            Vector vector = this.glob_remote(string);
            int n2 = 0;
            while (n2 < vector.size()) {
                string = (String)vector.elementAt(n2);
                this.sendSTAT(string.getBytes());
                this.buf.rewind();
                int n3 = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                int n4 = this.buf.getInt();
                int n5 = this.buf.getByte();
                if (n5 != 105) {
                    throw new SftpException(4, "");
                }
                this.buf.getInt();
                SftpATTRS sftpATTRS = SftpATTRS.getATTR(this.buf);
                sftpATTRS.setUIDGID(sftpATTRS.uid, n);
                this.sendSETSTAT(string.getBytes(), sftpATTRS);
                this.buf.rewind();
                n3 = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                n4 = this.buf.getInt();
                n5 = this.buf.getByte();
                if (n5 != 101) {
                    throw new SftpException(4, "");
                }
                this.buf.getInt();
                n3 = this.buf.getInt();
                if (n3 != 0) {
                    this.throwStatusError(this.buf, n3);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            throw new SftpException(4, "");
        }
    }

    public void chown(int n, String string) throws SftpException {
        try {
            if (!string.startsWith("/")) {
                string = this.cwd + "/" + string;
            }
            Vector vector = this.glob_remote(string);
            int n2 = 0;
            while (n2 < vector.size()) {
                string = (String)vector.elementAt(n2);
                this.sendSTAT(string.getBytes());
                this.buf.rewind();
                int n3 = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                int n4 = this.buf.getInt();
                int n5 = this.buf.getByte();
                if (n5 != 105) {
                    throw new SftpException(4, "");
                }
                this.buf.getInt();
                SftpATTRS sftpATTRS = SftpATTRS.getATTR(this.buf);
                sftpATTRS.setUIDGID(n, sftpATTRS.gid);
                this.sendSETSTAT(string.getBytes(), sftpATTRS);
                this.buf.rewind();
                n3 = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                n4 = this.buf.getInt();
                n5 = this.buf.getByte();
                if (n5 != 101) {
                    throw new SftpException(4, "");
                }
                this.buf.getInt();
                n3 = this.buf.getInt();
                if (n3 != 0) {
                    this.throwStatusError(this.buf, n3);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            throw new SftpException(4, "");
        }
    }

    public void chmod(int n, String string) throws SftpException {
        try {
            if (!string.startsWith("/")) {
                string = this.cwd + "/" + string;
            }
            Vector vector = this.glob_remote(string);
            int n2 = 0;
            while (n2 < vector.size()) {
                string = (String)vector.elementAt(n2);
                this.sendSTAT(string.getBytes());
                this.buf.rewind();
                int n3 = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                int n4 = this.buf.getInt();
                int n5 = this.buf.getByte();
                if (n5 != 105) {
                    throw new SftpException(4, "");
                }
                this.buf.getInt();
                SftpATTRS sftpATTRS = SftpATTRS.getATTR(this.buf);
                sftpATTRS.setPERMISSIONS(n);
                this.sendSETSTAT(string.getBytes(), sftpATTRS);
                this.buf.rewind();
                n3 = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                n4 = this.buf.getInt();
                n5 = this.buf.getByte();
                if (n5 != 101) {
                    throw new SftpException(4, "");
                }
                this.buf.getInt();
                n3 = this.buf.getInt();
                if (n3 != 0) {
                    this.throwStatusError(this.buf, n3);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            throw new SftpException(4, "");
        }
    }

    public void rmdir(String string) throws SftpException {
        try {
            if (!string.startsWith("/")) {
                string = this.cwd + "/" + string;
            }
            Vector vector = this.glob_remote(string);
            int n = 0;
            while (n < vector.size()) {
                string = (String)vector.elementAt(n);
                this.sendRMDIR(string.getBytes());
                this.buf.rewind();
                int n2 = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
                int n3 = this.buf.getInt();
                int n4 = this.buf.getByte();
                if (n4 != 101) {
                    throw new SftpException(4, "");
                }
                this.buf.getInt();
                n2 = this.buf.getInt();
                if (n2 != 0) {
                    this.throwStatusError(this.buf, n2);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            throw new SftpException(4, "");
        }
    }

    public void mkdir(String string) throws SftpException {
        try {
            if (!string.startsWith("/")) {
                string = this.cwd + "/" + string;
            }
            this.sendMKDIR(string.getBytes(), null);
            this.buf.rewind();
            int n = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int n2 = this.buf.getInt();
            int n3 = this.buf.getByte();
            if (n3 != 101) {
                throw new SftpException(4, "");
            }
            this.buf.getInt();
            n = this.buf.getInt();
            if (n == 0) {
                return;
            }
            this.throwStatusError(this.buf, n);
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            throw new SftpException(4, "");
        }
    }

    public SftpATTRS stat(String string) throws SftpException {
        try {
            if (!string.startsWith("/")) {
                string = this.cwd + "/" + string;
            }
            this.sendSTAT(string.getBytes());
            this.buf.rewind();
            int n = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int n2 = this.buf.getInt();
            int n3 = this.buf.getByte();
            if (n3 != 105) {
                if (n3 == 101) {
                    this.buf.getInt();
                    n = this.buf.getInt();
                    this.throwStatusError(this.buf, n);
                }
                throw new SftpException(4, "");
            }
            this.buf.getInt();
            SftpATTRS sftpATTRS = SftpATTRS.getATTR(this.buf);
            return sftpATTRS;
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            throw new SftpException(4, "");
        }
    }

    public SftpATTRS lstat(String string) throws SftpException {
        try {
            if (!string.startsWith("/")) {
                string = this.cwd + "/" + string;
            }
            this.sendLSTAT(string.getBytes());
            this.buf.rewind();
            int n = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            int n2 = this.buf.getInt();
            int n3 = this.buf.getByte();
            if (n3 != 105) {
                if (n3 == 101) {
                    this.buf.getInt();
                    n = this.buf.getInt();
                    this.throwStatusError(this.buf, n);
                }
                throw new SftpException(4, "");
            }
            this.buf.getInt();
            SftpATTRS sftpATTRS = SftpATTRS.getATTR(this.buf);
            return sftpATTRS;
        }
        catch (Exception exception) {
            if (exception instanceof SftpException) {
                throw (SftpException)exception;
            }
            throw new SftpException(4, "");
        }
    }

    public String pwd() {
        return this.cwd;
    }

    public String lpwd() {
        return this.lcwd;
    }

    public String version() {
        return this.version;
    }

    private void sendINIT() throws Exception {
        this.packet.reset();
        this.putHEAD((byte)1, 5);
        this.buf.putInt(3);
        this.session.write(this.packet, this, 9);
    }

    private void sendREALPATH(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)16, byArray);
    }

    private void sendSTAT(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)17, byArray);
    }

    private void sendLSTAT(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)7, byArray);
    }

    private void sendFSTAT(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)8, byArray);
    }

    private void sendSETSTAT(byte[] byArray, SftpATTRS sftpATTRS) throws Exception {
        this.packet.reset();
        this.putHEAD((byte)9, 9 + byArray.length + sftpATTRS.length());
        this.buf.putInt(this.count++);
        this.buf.putString(byArray);
        sftpATTRS.dump(this.buf);
        this.session.write(this.packet, this, 9 + byArray.length + sftpATTRS.length() + 4);
    }

    private void sendREMOVE(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)13, byArray);
    }

    private void sendMKDIR(byte[] byArray, SftpATTRS sftpATTRS) throws Exception {
        this.packet.reset();
        this.putHEAD((byte)14, 9 + byArray.length + (sftpATTRS != null ? sftpATTRS.length() : 4));
        this.buf.putInt(this.count++);
        this.buf.putString(byArray);
        if (sftpATTRS != null) {
            sftpATTRS.dump(this.buf);
        } else {
            this.buf.putInt(0);
        }
        this.session.write(this.packet, this, 9 + byArray.length + (sftpATTRS != null ? sftpATTRS.length() : 4) + 4);
    }

    private void sendRMDIR(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)15, byArray);
    }

    private void sendSYMLINK(byte[] byArray, byte[] byArray2) throws Exception {
        this.sendPacketPath((byte)20, byArray, byArray2);
    }

    private void sendREADLINK(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)19, byArray);
    }

    private void sendOPENDIR(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)11, byArray);
    }

    private void sendREADDIR(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)12, byArray);
    }

    private void sendRENAME(byte[] byArray, byte[] byArray2) throws Exception {
        this.sendPacketPath((byte)18, byArray, byArray2);
    }

    private void sendCLOSE(byte[] byArray) throws Exception {
        this.sendPacketPath((byte)4, byArray);
    }

    private void sendOPENR(byte[] byArray) throws Exception {
        this.sendOPEN(byArray, 1);
    }

    private void sendOPENW(byte[] byArray) throws Exception {
        this.sendOPEN(byArray, 26);
    }

    private void sendOPEN(byte[] byArray, int n) throws Exception {
        this.packet.reset();
        this.putHEAD((byte)3, 17 + byArray.length);
        this.buf.putInt(this.count++);
        this.buf.putString(byArray);
        this.buf.putInt(n);
        this.buf.putInt(0);
        this.session.write(this.packet, this, 17 + byArray.length + 4);
    }

    private void sendPacketPath(byte by, byte[] byArray) throws Exception {
        this.packet.reset();
        this.putHEAD(by, 9 + byArray.length);
        this.buf.putInt(this.count++);
        this.buf.putString(byArray);
        this.session.write(this.packet, this, 9 + byArray.length + 4);
    }

    private void sendPacketPath(byte by, byte[] byArray, byte[] byArray2) throws Exception {
        this.packet.reset();
        this.putHEAD(by, 13 + byArray.length + byArray2.length);
        this.buf.putInt(this.count++);
        this.buf.putString(byArray);
        this.buf.putString(byArray2);
        this.session.write(this.packet, this, 13 + byArray.length + byArray2.length + 4);
    }

    private void sendWRITE(byte[] byArray, long l, byte[] byArray2, int n, int n2) throws Exception {
        this.packet.reset();
        this.putHEAD((byte)6, 21 + byArray.length + n2);
        this.buf.putInt(this.count++);
        this.buf.putString(byArray);
        this.buf.putLong(l);
        this.buf.putString(byArray2, n, n2);
        this.session.write(this.packet, this, 21 + byArray.length + n2 + 4);
    }

    private void sendREAD(byte[] byArray, long l, int n) throws Exception {
        this.packet.reset();
        this.putHEAD((byte)5, 21 + byArray.length);
        this.buf.putInt(this.count++);
        this.buf.putString(byArray);
        this.buf.putLong(l);
        this.buf.putInt(n);
        this.session.write(this.packet, this, 21 + byArray.length + 4);
    }

    private void putHEAD(byte by, int n) throws Exception {
        this.buf.putByte((byte)94);
        this.buf.putInt(this.recipient);
        this.buf.putInt(n + 4);
        this.buf.putInt(n);
        this.buf.putByte(by);
    }

    /*
     * Unable to fully structure code
     */
    private Vector glob_remote(String var1_1) throws Exception {
        var2_2 = new Vector<String>();
        var3_3 = var1_1.getBytes();
        var4_4 = var3_3.length - 1;
        while (var4_4 >= 0) {
            if (var3_3[var4_4] == 42 || var3_3[var4_4] == 63) break;
            --var4_4;
        }
        if (var4_4 >= 0) ** GOTO lbl13
        var2_2.addElement(var1_1);
        return var2_2;
        while (var3_3[var4_4] != 47) {
            --var4_4;
lbl13:
            // 2 sources

            if (var4_4 >= 0) continue;
        }
        if (var4_4 < 0) {
            var2_2.addElement(var1_1);
            return var2_2;
        }
        if (var4_4 == 0) {
            var5_5 = new byte[]{47};
        } else {
            var5_5 = new byte[var4_4];
            System.arraycopy(var3_3, 0, var5_5, 0, var4_4);
        }
        var6_6 = new byte[var3_3.length - var4_4 - 1];
        System.arraycopy(var3_3, var4_4 + 1, var6_6, 0, var6_6.length);
        this.sendOPENDIR(var5_5);
        this.buf.rewind();
        var4_4 = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
        var7_7 = this.buf.getInt();
        var8_8 = this.buf.getByte();
        if (var8_8 != 101 && var8_8 != 102) {
            throw new SftpException(4, "");
        }
        if (var8_8 == 101) {
            this.buf.getInt();
            var4_4 = this.buf.getInt();
            this.throwStatusError(this.buf, var4_4);
        }
        this.buf.getInt();
        var9_9 = this.buf.getString();
        block2: while (true) {
            this.sendREADDIR(var9_9);
            this.buf.rewind();
            this.buf.index = var4_4 = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
            var7_7 = this.buf.getInt();
            var7_7 -= var4_4 - 4;
            var8_8 = this.buf.getByte();
            if (var8_8 != 101 && var8_8 != 104) {
                throw new SftpException(4, "");
            }
            if (var8_8 == 101) break;
            this.buf.getInt();
            var10_10 = this.buf.getInt();
            while (true) {
                if (var10_10 <= 0) continue block2;
                if (var7_7 > 0) {
                    this.buf.shift();
                    var4_4 = this.io.in.read(this.buf.buffer, this.buf.index, this.buf.buffer.length - this.buf.index);
                    if (var4_4 > 0) ** break;
                    continue block2;
                    this.buf.index += var4_4;
                    var7_7 -= var4_4;
                }
                var13_12 = this.buf.getString();
                var11_11 = this.buf.getString();
                var14_13 = SftpATTRS.getATTR(this.buf);
                if (this.glob(var6_6, var13_12)) {
                    var2_2.addElement(new String(var5_5) + "/" + new String(var13_12));
                }
                --var10_10;
            }
            break;
        }
        this.sendCLOSE(var9_9);
        this.buf.rewind();
        var4_4 = this.io.in.read(this.buf.buffer, 0, this.buf.buffer.length);
        var7_7 = this.buf.getInt();
        var8_8 = this.buf.getByte();
        if (var8_8 != 101) {
            throw new SftpException(4, "");
        }
        this.buf.getInt();
        var4_4 = this.buf.getInt();
        if (var4_4 == 0) {
            return var2_2;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Vector glob_local(String var1_1) throws Exception {
        var2_2 = new Vector<String>();
        var3_3 = var1_1.getBytes();
        var4_4 = var3_3.length - 1;
        while (var4_4 >= 0) {
            if (var3_3[var4_4] == 42 || var3_3[var4_4] == 63) break;
            --var4_4;
        }
        if (var4_4 >= 0) ** GOTO lbl13
        var2_2.addElement(var1_1);
        return var2_2;
        while (var3_3[var4_4] != ChannelSftp.file_separatorc) {
            --var4_4;
lbl13:
            // 2 sources

            if (var4_4 >= 0) continue;
        }
        if (var4_4 < 0) {
            var2_2.addElement(var1_1);
            return var2_2;
        }
        if (var4_4 == 0) {
            var5_5 = new byte[]{(byte)ChannelSftp.file_separatorc};
        } else {
            var5_5 = new byte[var4_4];
            System.arraycopy(var3_3, 0, var5_5, 0, var4_4);
        }
        var6_6 = new byte[var3_3.length - var4_4 - 1];
        System.arraycopy(var3_3, var4_4 + 1, var6_6, 0, var6_6.length);
        try {
            var7_7 = new File(new String(var5_5)).list();
            var8_9 = 0;
            while (var8_9 < var7_7.length) {
                if (this.glob(var6_6, var7_7[var8_9].getBytes())) {
                    var2_2.addElement(new String(var5_5) + ChannelSftp.file_separator + var7_7[var8_9]);
                }
                ++var8_9;
            }
        }
        catch (Exception var7_8) {}
        return var2_2;
    }

    private boolean glob(byte[] byArray, byte[] byArray2) {
        return this.glob(byArray, 0, byArray2, 0);
    }

    private boolean glob(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = byArray.length;
        if (n3 == 0) {
            return false;
        }
        int n4 = byArray2.length;
        int n5 = n;
        int n6 = n2;
        while (n5 < n3 && n6 < n4) {
            if (byArray[n5] == 92) {
                if (n5 + 1 == n3) {
                    return false;
                }
                if (byArray[++n5] != byArray2[n6]) {
                    return false;
                }
                ++n5;
                ++n6;
                continue;
            }
            if (byArray[n5] == 42) {
                if (n3 == n5 + 1) {
                    return true;
                }
                byte by = byArray[++n5];
                while (n6 < n4) {
                    if (by == byArray2[n6] && this.glob(byArray, n5, byArray2, n6)) {
                        return true;
                    }
                    ++n6;
                }
                return false;
            }
            if (byArray[n5] == 63) {
                ++n5;
                ++n6;
                continue;
            }
            if (byArray[n5] != byArray2[n6]) {
                return false;
            }
            ++n5;
            ++n6;
        }
        return n5 == n3 && n6 == n4;
    }

    private void throwStatusError(Buffer buffer, int n) throws SftpException {
        if (this.server_version >= 3) {
            byte[] byArray = buffer.getString();
            throw new SftpException(n, new String(byArray));
        }
        throw new SftpException(n, "Failure");
    }

    private static boolean isLocalAbsolutePath(String string) {
        return new File(string).isAbsolute();
    }

    public static class Ssh_exp_name {
        private String filename;
        private String longname;
        private SftpATTRS attrs;

        Ssh_exp_name(String string, String string2, SftpATTRS sftpATTRS) {
            this.setFilename(string);
            this.setLongname(string2);
            this.setAttrs(sftpATTRS);
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String string) {
            this.filename = string;
        }

        public String getLongname() {
            return this.longname;
        }

        public void setLongname(String string) {
            this.longname = string;
        }

        public SftpATTRS getAttrs() {
            return this.attrs;
        }

        public void setAttrs(SftpATTRS sftpATTRS) {
            this.attrs = sftpATTRS;
        }

        public String toString() {
            return this.attrs.toString() + " " + this.filename;
        }
    }
}

