/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Util;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Vector;

class KnownHosts {
    private static final String _known_hosts = "known_hosts";
    static final int OK = 0;
    static final int NOT_INCLUDED = 1;
    static final int CHANGED = 2;
    static final int SSHDSS = 0;
    static final int SSHRSA = 1;
    private String known_hosts = null;
    private Vector pool = new Vector();
    static final byte[] space = new byte[]{32};
    static final byte[] sshdss = "ssh-dss".getBytes();
    static final byte[] sshrsa = "ssh-rsa".getBytes();
    static final byte[] cr = "\n".getBytes();

    KnownHosts() {
    }

    void setKnownHosts(String string) {
        this.known_hosts = string;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            FileInputStream fileInputStream = new FileInputStream(this.known_hosts);
            block2: while (true) {
                int n;
                stringBuffer.setLength(0);
                while ((n = fileInputStream.read()) != -1) {
                    if (n != 32) {
                        stringBuffer.append((char)n);
                        continue;
                    }
                    String string2 = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    while ((n = fileInputStream.read()) != -1) {
                        int n2;
                        if (n == 32) {
                            n2 = stringBuffer.toString().equals("ssh-dss") ? 0 : 1;
                        } else {
                            stringBuffer.append((char)n);
                            continue;
                        }
                        stringBuffer.setLength(0);
                        while ((n = fileInputStream.read()) != -1) {
                            if (n == 13) continue;
                            if (n != 10) {
                                stringBuffer.append((char)n);
                                continue;
                            }
                            String string3 = stringBuffer.toString();
                            HostKey hostKey = new HostKey(string2, n2, Util.fromBase64(string3.getBytes(), 0, string3.length()));
                            this.pool.addElement(hostKey);
                            continue block2;
                            break;
                        }
                        break block2;
                        break;
                    }
                    break block2;
                    continue block2;
                }
                break;
            }
            fileInputStream.close();
        }
        catch (Exception exception) {}
    }

    String getKnownHostsFile() {
        return this.known_hosts;
    }

    int check(String string, byte[] byArray) {
        int n = this.getType(byArray);
        int n2 = 0;
        while (n2 < this.pool.size()) {
            HostKey hostKey = (HostKey)this.pool.elementAt(n2);
            if (this.isIncluded(hostKey.host, string) && hostKey.type == n) {
                if (Arrays.equals(hostKey.key, byArray)) {
                    return 0;
                }
                return 2;
            }
            ++n2;
        }
        return 1;
    }

    void insert(String string, byte[] byArray) {
        HostKey hostKey;
        int n = this.getType(byArray);
        int n2 = 0;
        while (n2 < this.pool.size()) {
            hostKey = (HostKey)this.pool.elementAt(n2);
            if (!this.isIncluded(hostKey.host, string) || hostKey.type == n) {
                // empty if block
            }
            ++n2;
        }
        hostKey = new HostKey(string, n, byArray);
        this.pool.addElement(hostKey);
    }

    void sync() throws IOException {
        this.sync(this.known_hosts);
    }

    void sync(String string) throws IOException {
        if (string == null) {
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.dump(fileOutputStream);
        fileOutputStream.close();
    }

    void dump(OutputStream outputStream) throws IOException {
        try {
            int n = 0;
            while (n < this.pool.size()) {
                HostKey hostKey = (HostKey)this.pool.elementAt(n);
                hostKey.dump(outputStream);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private int getType(byte[] byArray) {
        if (byArray[8] == 100) {
            return 0;
        }
        return 1;
    }

    private String deleteSubString(String string, String string2) {
        int n = 0;
        int n2 = string2.length();
        int n3 = string.length();
        while (n < n3) {
            int n4 = string.indexOf(44, n);
            if (n4 == -1) break;
            if (!string2.equals(string.substring(n, n4))) {
                n = n4 + 1;
                continue;
            }
            return string.substring(0, n) + string.substring(n4 + 1);
        }
        if (string.endsWith(string2) && n3 - n == n2) {
            return string.substring(0, n2 == n3 ? 0 : n3 - n2 - 1);
        }
        return string;
    }

    private boolean isIncluded(String string, String string2) {
        int n = 0;
        int n2 = string2.length();
        int n3 = string.length();
        while (n < n3) {
            int n4 = string.indexOf(44, n);
            if (n4 == -1) {
                if (n2 != n3 - n) {
                    return false;
                }
                return string.regionMatches(true, n, string2, 0, n2);
            }
            if (n2 == n4 - n && string.regionMatches(true, n, string2, 0, n2)) {
                return true;
            }
            n = n4 + 1;
        }
        return false;
    }

    class HostKey {
        String host;
        int type;
        byte[] key;

        HostKey(String string, int n, byte[] byArray) {
            this.host = string;
            this.type = n;
            this.key = byArray;
        }

        void dump(OutputStream outputStream) throws IOException {
            outputStream.write(this.host.getBytes());
            outputStream.write(space);
            if (this.type == 0) {
                outputStream.write(sshdss);
            } else {
                outputStream.write(sshrsa);
            }
            outputStream.write(space);
            outputStream.write(Util.toBase64(this.key, 0, this.key.length));
            outputStream.write(cr);
        }
    }
}

