/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SftpATTRS {
    static final int S_ISUID = 2048;
    static final int S_ISGID = 1024;
    static final int S_ISVTX = 512;
    static final int S_IRUSR = 256;
    static final int S_IWUSR = 128;
    static final int S_IXUSR = 64;
    static final int S_IREAD = 256;
    static final int S_IWRITE = 128;
    static final int S_IEXEC = 64;
    static final int S_IRGRP = 32;
    static final int S_IWGRP = 16;
    static final int S_IXGRP = 8;
    static final int S_IROTH = 4;
    static final int S_IWOTH = 2;
    static final int S_IXOTH = 1;
    public static final int SSH_FILEXFER_ATTR_SIZE = 1;
    public static final int SSH_FILEXFER_ATTR_UIDGID = 2;
    public static final int SSH_FILEXFER_ATTR_PERMISSIONS = 4;
    public static final int SSH_FILEXFER_ATTR_ACMODTIME = 8;
    public static final int SSH_FILEXFER_ATTR_EXTENDED = Integer.MIN_VALUE;
    static final int S_IFDIR = 16384;
    int flags = 0;
    long size;
    int uid;
    int gid;
    int permissions;
    int atime;
    int mtime;
    String[] extended = null;

    String getPermissionsString() {
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.isDir()) {
            stringBuffer.append('d');
        } else {
            stringBuffer.append('-');
        }
        if ((this.permissions & 0x100) != 0) {
            stringBuffer.append('r');
        } else {
            stringBuffer.append('-');
        }
        if ((this.permissions & 0x80) != 0) {
            stringBuffer.append('w');
        } else {
            stringBuffer.append('-');
        }
        if ((this.permissions & 0x800) != 0) {
            stringBuffer.append('s');
        } else if ((this.permissions & 0x40) != 0) {
            stringBuffer.append('x');
        } else {
            stringBuffer.append('-');
        }
        if ((this.permissions & 0x20) != 0) {
            stringBuffer.append('r');
        } else {
            stringBuffer.append('-');
        }
        if ((this.permissions & 0x10) != 0) {
            stringBuffer.append('w');
        } else {
            stringBuffer.append('-');
        }
        if ((this.permissions & 0x400) != 0) {
            stringBuffer.append('s');
        } else if ((this.permissions & 8) != 0) {
            stringBuffer.append('x');
        } else {
            stringBuffer.append('-');
        }
        if ((this.permissions & 4) != 0) {
            stringBuffer.append('r');
        } else {
            stringBuffer.append('-');
        }
        if ((this.permissions & 2) != 0) {
            stringBuffer.append('w');
        } else {
            stringBuffer.append('-');
        }
        if ((this.permissions & 1) != 0) {
            stringBuffer.append('x');
        } else {
            stringBuffer.append('-');
        }
        return stringBuffer.toString();
    }

    public String getAtimeString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        return simpleDateFormat.format(new Date(this.atime));
    }

    public String getMtimeString() {
        Date date = new Date((long)this.mtime * 1000L);
        return date.toString();
    }

    static SftpATTRS getATTR(Buffer buffer) {
        int n;
        SftpATTRS sftpATTRS = new SftpATTRS();
        sftpATTRS.flags = buffer.getInt();
        if ((sftpATTRS.flags & 1) != 0) {
            sftpATTRS.size = buffer.getLong();
        }
        if ((sftpATTRS.flags & 2) != 0) {
            sftpATTRS.uid = buffer.getInt();
            sftpATTRS.gid = buffer.getInt();
        }
        if ((sftpATTRS.flags & 4) != 0) {
            sftpATTRS.permissions = buffer.getInt();
        }
        if ((sftpATTRS.flags & 8) != 0) {
            sftpATTRS.atime = buffer.getInt();
        }
        if ((sftpATTRS.flags & 8) != 0) {
            sftpATTRS.mtime = buffer.getInt();
        }
        if ((sftpATTRS.flags & Integer.MIN_VALUE) != 0 && (n = buffer.getInt()) > 0) {
            sftpATTRS.extended = new String[n * 2];
            int n2 = 0;
            while (n2 < n) {
                sftpATTRS.extended[n2 * 2] = new String(buffer.getString());
                sftpATTRS.extended[n2 * 2 + 1] = new String(buffer.getString());
                ++n2;
            }
        }
        return sftpATTRS;
    }

    int length() {
        int n = 4;
        if ((this.flags & 1) != 0) {
            n += 8;
        }
        if ((this.flags & 2) != 0) {
            n += 8;
        }
        if ((this.flags & 4) != 0) {
            n += 4;
        }
        if ((this.flags & 8) != 0) {
            n += 8;
        }
        if ((this.flags & Integer.MIN_VALUE) != 0) {
            n += 4;
            int n2 = this.extended.length / 2;
            if (n2 > 0) {
                int n3 = 0;
                while (n3 < n2) {
                    n += 4;
                    n += this.extended[n3 * 2].length();
                    n += 4;
                    n += this.extended[n3 * 2 + 1].length();
                    ++n3;
                }
            }
        }
        return n;
    }

    void dump(Buffer buffer) {
        int n;
        buffer.putInt(this.flags);
        if ((this.flags & 1) != 0) {
            buffer.putLong(this.size);
        }
        if ((this.flags & 2) != 0) {
            buffer.putInt(this.uid);
            buffer.putInt(this.gid);
        }
        if ((this.flags & 4) != 0) {
            buffer.putInt(this.permissions);
        }
        if ((this.flags & 8) != 0) {
            buffer.putInt(this.atime);
        }
        if ((this.flags & 8) != 0) {
            buffer.putInt(this.mtime);
        }
        if ((this.flags & Integer.MIN_VALUE) != 0 && (n = this.extended.length / 2) > 0) {
            int n2 = 0;
            while (n2 < n) {
                buffer.putString(this.extended[n2 * 2].getBytes());
                buffer.putString(this.extended[n2 * 2 + 1].getBytes());
                ++n2;
            }
        }
    }

    void setSIZE(long l) {
        this.flags |= 1;
        this.size = l;
    }

    void setUIDGID(int n, int n2) {
        this.flags |= 2;
        this.uid = n;
        this.gid = n2;
    }

    void setACMODTIME(int n, int n2) {
        this.flags |= 8;
        this.atime = n;
        this.mtime = n2;
    }

    void setPERMISSIONS(int n) {
        this.flags |= 4;
        this.permissions = n;
    }

    public boolean isDir() {
        return (this.flags & 4) != 0 && (this.permissions & 0x4000) != 0;
    }

    public int getFlags() {
        return this.flags;
    }

    public long getSize() {
        return this.size;
    }

    public int getUId() {
        return this.uid;
    }

    public int getGId() {
        return this.gid;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public int getATime() {
        return this.atime;
    }

    public int getMTime() {
        return this.mtime;
    }

    public String[] getExtended() {
        return this.extended;
    }

    public String toString() {
        return this.getPermissionsString() + " " + this.getUId() + " " + this.getGId() + " " + this.getSize() + " " + this.getMtimeString();
    }
}

