/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jce;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.DH;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.KeyExchange;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.jce.SHA1;
import com.jcraft.jsch.jce.SignatureDSA;
import com.jcraft.jsch.jce.SignatureRSA;
import java.security.MessageDigest;

public class DHGEX
extends KeyExchange {
    static final int SSH_MSG_KEX_DH_GEX_GROUP = 31;
    static final int SSH_MSG_KEX_DH_GEX_INIT = 32;
    static final int SSH_MSG_KEX_DH_GEX_REPLY = 33;
    static int min = 1024;
    static int preferred = 1024;
    static int max = 1024;
    static final int RSA = 0;
    static final int DSS = 1;
    private int type = 0;
    private int state;
    DH dh;
    HASH sha;
    byte[] K;
    byte[] H;
    byte[] V_S;
    byte[] V_C;
    byte[] I_S;
    byte[] I_C;
    byte[] K_S;
    private Buffer buf;
    private Packet packet;
    private byte[] p;
    private byte[] g;
    private byte[] e;
    private byte[] f;
    static String[] chars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public void init(Session session, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws Exception {
        this.V_S = byArray;
        this.V_C = byArray2;
        this.I_S = byArray3;
        this.I_C = byArray4;
        this.sha = new SHA1();
        this.sha.init();
        this.buf = new Buffer();
        this.packet = new Packet(this.buf);
        try {
            Class<?> clazz = Class.forName(session.getConfig("dh"));
            this.dh = (DH)clazz.newInstance();
            this.dh.init();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        this.packet.reset();
        this.buf.putByte((byte)34);
        this.buf.putInt(min);
        this.buf.putInt(preferred);
        this.buf.putInt(max);
        session.write(this.packet);
        this.state = 31;
    }

    public boolean next(Session session, Buffer buffer) throws Exception {
        switch (this.state) {
            case 31: {
                buffer.getInt();
                buffer.getByte();
                int n = buffer.getByte();
                if (n != 31) {
                    System.err.println("type: must be 31 " + n);
                    return false;
                }
                this.p = buffer.getMPInt();
                this.g = buffer.getMPInt();
                this.dh.setP(this.p);
                this.dh.setG(this.g);
                this.e = this.dh.getE();
                this.packet.reset();
                this.buf.putByte((byte)32);
                this.buf.putMPInt(this.e);
                session.write(this.packet);
                this.state = 33;
                return true;
            }
            case 33: {
                int n = buffer.getInt();
                n = buffer.getByte();
                n = buffer.getByte();
                if (n != 33) {
                    System.err.println("type: must be 33 " + n);
                    return false;
                }
                this.K_S = buffer.getString();
                byte[] byArray = buffer.getMPInt();
                byte[] byArray2 = buffer.getString();
                this.dh.setF(byArray);
                this.K = this.dh.getK();
                this.buf.reset();
                this.buf.putString(this.V_C);
                this.buf.putString(this.V_S);
                this.buf.putString(this.I_C);
                this.buf.putString(this.I_S);
                this.buf.putString(this.K_S);
                this.buf.putInt(min);
                this.buf.putInt(preferred);
                this.buf.putInt(max);
                this.buf.putMPInt(this.p);
                this.buf.putMPInt(this.g);
                this.buf.putMPInt(this.e);
                this.buf.putMPInt(byArray);
                this.buf.putMPInt(this.K);
                byte[] byArray3 = new byte[this.buf.getLength()];
                this.buf.getByte(byArray3);
                this.sha.update(byArray3, 0, byArray3.length);
                this.H = this.sha.digest();
                int n2 = 0;
                n = 0;
                n = this.K_S[n2++] << 24 & 0xFF000000 | this.K_S[n2++] << 16 & 0xFF0000 | this.K_S[n2++] << 8 & 0xFF00 | this.K_S[n2++] & 0xFF;
                String string = new String(this.K_S, n2, n);
                n2 += n;
                boolean bl = false;
                if (string.equals("ssh-rsa")) {
                    this.type = 0;
                    n = this.K_S[n2++] << 24 & 0xFF000000 | this.K_S[n2++] << 16 & 0xFF0000 | this.K_S[n2++] << 8 & 0xFF00 | this.K_S[n2++] & 0xFF;
                    byte[] byArray4 = new byte[n];
                    System.arraycopy(this.K_S, n2, byArray4, 0, n);
                    n2 += n;
                    byte[] byArray5 = byArray4;
                    n = this.K_S[n2++] << 24 & 0xFF000000 | this.K_S[n2++] << 16 & 0xFF0000 | this.K_S[n2++] << 8 & 0xFF00 | this.K_S[n2++] & 0xFF;
                    byArray4 = new byte[n];
                    System.arraycopy(this.K_S, n2, byArray4, 0, n);
                    n2 += n;
                    byte[] byArray6 = byArray4;
                    SignatureRSA signatureRSA = new SignatureRSA();
                    signatureRSA.init();
                    signatureRSA.setPubKey(byArray5, byArray6);
                    signatureRSA.update(this.H);
                    bl = signatureRSA.verify(byArray2);
                } else if (string.equals("ssh-dss")) {
                    byte[] byArray7 = null;
                    this.type = 1;
                    n = this.K_S[n2++] << 24 & 0xFF000000 | this.K_S[n2++] << 16 & 0xFF0000 | this.K_S[n2++] << 8 & 0xFF00 | this.K_S[n2++] & 0xFF;
                    byte[] byArray8 = new byte[n];
                    System.arraycopy(this.K_S, n2, byArray8, 0, n);
                    n2 += n;
                    this.p = byArray8;
                    n = this.K_S[n2++] << 24 & 0xFF000000 | this.K_S[n2++] << 16 & 0xFF0000 | this.K_S[n2++] << 8 & 0xFF00 | this.K_S[n2++] & 0xFF;
                    byArray8 = new byte[n];
                    System.arraycopy(this.K_S, n2, byArray8, 0, n);
                    n2 += n;
                    byArray7 = byArray8;
                    n = this.K_S[n2++] << 24 & 0xFF000000 | this.K_S[n2++] << 16 & 0xFF0000 | this.K_S[n2++] << 8 & 0xFF00 | this.K_S[n2++] & 0xFF;
                    byArray8 = new byte[n];
                    System.arraycopy(this.K_S, n2, byArray8, 0, n);
                    n2 += n;
                    this.g = byArray8;
                    n = this.K_S[n2++] << 24 & 0xFF000000 | this.K_S[n2++] << 16 & 0xFF0000 | this.K_S[n2++] << 8 & 0xFF00 | this.K_S[n2++] & 0xFF;
                    byArray8 = new byte[n];
                    System.arraycopy(this.K_S, n2, byArray8, 0, n);
                    n2 += n;
                    byArray = byArray8;
                    SignatureDSA signatureDSA = new SignatureDSA();
                    signatureDSA.init();
                    signatureDSA.setPubKey(byArray, this.p, byArray7, this.g);
                    signatureDSA.update(this.H);
                    bl = signatureDSA.verify(byArray2);
                } else {
                    System.out.println("unknow alg");
                }
                this.state = 0;
                return bl;
            }
        }
        return false;
    }

    public byte[] getK() {
        return this.K;
    }

    public byte[] getH() {
        return this.H;
    }

    public HASH getHash() {
        return this.sha;
    }

    public byte[] getHostKey() {
        return this.K_S;
    }

    public String getFingerPrint() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(this.K_S, 0, this.K_S.length);
            byte[] byArray = messageDigest.digest();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < byArray.length) {
                int n2 = byArray[n] & 0xFF;
                stringBuffer.append(chars[n2 >>> 4 & 0xF]);
                stringBuffer.append(chars[n2 & 0xF]);
                if (n + 1 < byArray.length) {
                    stringBuffer.append(":");
                }
                ++n;
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "???";
        }
    }

    public String getKeyType() {
        if (this.type == 1) {
            return "DSA";
        }
        return "RSA";
    }

    public int getState() {
        return this.state;
    }
}

