/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.corba;

import com.sun.corba.ee.internal.corba.EncapsOutputStream;
import com.sun.corba.ee.internal.corba.TypeCodeInputStream;
import com.sun.corba.ee.internal.iiop.CDROutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

final class TypeCodeOutputStream
extends EncapsOutputStream {
    private OutputStream enclosure = null;
    private Map typeMap = null;
    private boolean isEncapsulation = false;

    public TypeCodeOutputStream(ORB oRB) {
        super(oRB, false);
    }

    public TypeCodeOutputStream(ORB oRB, boolean bl2) {
        super(oRB, bl2);
    }

    public InputStream create_input_stream() {
        TypeCodeInputStream typeCodeInputStream = new TypeCodeInputStream(this.orb(), this.getByteBuffer(), this.getIndex(), this.isLittleEndian());
        return typeCodeInputStream;
    }

    public void setEnclosingOutputStream(OutputStream outputStream) {
        this.enclosure = outputStream;
    }

    public TypeCodeOutputStream getTopLevelStream() {
        if (this.enclosure == null) {
            return this;
        }
        if (this.enclosure instanceof TypeCodeOutputStream) {
            return ((TypeCodeOutputStream)this.enclosure).getTopLevelStream();
        }
        return this;
    }

    public int getTopLevelPosition() {
        if (this.enclosure != null && this.enclosure instanceof TypeCodeOutputStream) {
            int n2 = ((TypeCodeOutputStream)this.enclosure).getTopLevelPosition() + this.getPosition();
            if (this.isEncapsulation) {
                n2 += 4;
            }
            return n2;
        }
        return this.getPosition();
    }

    public void addIDAtPosition(String string, int n2) {
        if (this.typeMap == null) {
            this.typeMap = new HashMap(16);
        }
        this.typeMap.put(string, new Integer(n2));
    }

    public int getPositionForID(String string) {
        if (this.typeMap == null) {
            throw new MARSHAL("Referenced type of indirect type not marshaled!");
        }
        return (Integer)this.typeMap.get(string);
    }

    public void writeRawBuffer(org.omg.CORBA.portable.OutputStream outputStream, int n2) {
        outputStream.write_long(n2);
        outputStream.write_octet_array(this.getByteBuffer(), 4, this.getIndex() - 4);
    }

    public TypeCodeOutputStream createEncapsulation(ORB oRB) {
        TypeCodeOutputStream typeCodeOutputStream = new TypeCodeOutputStream(oRB, this.isLittleEndian());
        typeCodeOutputStream.setEnclosingOutputStream(this);
        typeCodeOutputStream.makeEncapsulation();
        return typeCodeOutputStream;
    }

    protected void makeEncapsulation() {
        this.putEndian();
        this.isEncapsulation = true;
    }

    public static TypeCodeOutputStream wrapOutputStream(OutputStream outputStream) {
        boolean bl2 = outputStream instanceof CDROutputStream ? ((CDROutputStream)outputStream).isLittleEndian() : false;
        TypeCodeOutputStream typeCodeOutputStream = new TypeCodeOutputStream(outputStream.orb(), bl2);
        typeCodeOutputStream.setEnclosingOutputStream(outputStream);
        return typeCodeOutputStream;
    }

    public int getPosition() {
        return this.getIndex();
    }

    public int getRealIndex(int n2) {
        int n3 = this.getTopLevelPosition();
        return n3;
    }

    byte[] getTypeCodeBuffer() {
        byte[] byArray = this.getByteBuffer();
        byte[] byArray2 = new byte[this.getIndex() - 4];
        System.arraycopy(byArray, 4, byArray2, 0, this.getIndex() - 4);
        return byArray2;
    }

    public void printTypeMap() {
        System.out.println("typeMap = {");
        Iterator iterator = this.typeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Integer n2 = (Integer)this.typeMap.get(string);
            System.out.println("  key = " + string + ", value = " + n2);
        }
        System.out.println("}");
    }
}

