/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.sun.corba.ee.internal.corba.TypeCodeImpl;
import com.sun.corba.ee.internal.core.ClientSubcontract;
import com.sun.corba.ee.internal.core.CodeSetConversion;
import com.sun.corba.ee.internal.core.GIOPVersion;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.core.ORBVersionImpl;
import com.sun.corba.ee.internal.iiop.BufferManagerWrite;
import com.sun.corba.ee.internal.iiop.ByteBufferWithInfo;
import com.sun.corba.ee.internal.iiop.CDROutputStreamBase;
import com.sun.corba.ee.internal.orbutil.CacheTable;
import com.sun.corba.ee.internal.orbutil.ORBUtility;
import com.sun.corba.ee.internal.orbutil.RepositoryIdFactory;
import com.sun.corba.ee.internal.orbutil.RepositoryIdStrings;
import com.sun.corba.ee.internal.orbutil.RepositoryIdUtility;
import com.sun.corba.se.internal.util.Utility;
import com.sun.org.omg.CORBA.portable.ValueHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.CustomMarshal;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.DataOutputStream;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;

public class CDROutputStream_1_0
extends CDROutputStreamBase {
    private static final int INDIRECTION_TAG = -1;
    protected boolean littleEndian;
    protected BufferManagerWrite bufferManagerWrite;
    ByteBufferWithInfo bbwi;
    protected com.sun.corba.ee.internal.corba.ORB orb;
    protected boolean debug = false;
    protected int blockSizeIndex = -1;
    protected int blockSizePosition = 0;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final String kWriteMethod = "write";
    private CacheTable codebaseCache = null;
    private CacheTable valueCache = null;
    private CacheTable repositoryIdCache = null;
    private int end_flag = 0;
    private int chunkedValueNestingLevel = 0;
    private boolean mustChunk = false;
    protected boolean inBlock = false;
    private int end_flag_position = 0;
    private int end_flag_index = 0;
    private ValueHandler valueHandler = null;
    private RepositoryIdUtility repIdUtil;
    private RepositoryIdStrings repIdStrs;
    private CodeSetConversion.CTBConverter charConverter;
    private CodeSetConversion.CTBConverter wcharConverter;
    private static final String _id = "IDL:omg.org/CORBA/DataOutputStream:1.0";
    private static final String[] _ids = new String[]{"IDL:omg.org/CORBA/DataOutputStream:1.0"};
    static /* synthetic */ Class class$org$omg$CORBA$portable$OutputStream;

    protected void init(ORB oRB, boolean bl2, int n2, BufferManagerWrite bufferManagerWrite) {
        this.orb = (com.sun.corba.ee.internal.corba.ORB)oRB;
        if (this.orb != null) {
            this.debug = this.orb.transportDebugFlag;
        }
        this.littleEndian = bl2;
        this.bufferManagerWrite = bufferManagerWrite;
        this.bbwi = this.bufferManagerWrite.getInitialBuffer(n2);
        this.createRepositoryIdHandlers();
    }

    private final void createRepositoryIdHandlers() {
        if (this.orb != null) {
            this.repIdUtil = RepositoryIdFactory.getRepIdUtility(this.orb);
            this.repIdStrs = RepositoryIdFactory.getRepIdStringsFactory(this.orb);
        } else {
            this.repIdUtil = RepositoryIdFactory.getRepIdUtility();
            this.repIdStrs = RepositoryIdFactory.getRepIdStringsFactory();
        }
    }

    public BufferManagerWrite getBufferManager() {
        return this.bufferManagerWrite;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.bbwi.index];
        System.arraycopy(this.bbwi.buf, 0, byArray, 0, this.bbwi.index);
        return byArray;
    }

    public GIOPVersion getGIOPVersion() {
        return GIOPVersion.V1_0;
    }

    protected void handleSpecialChunkBegin(int n2) {
    }

    protected void handleSpecialChunkEnd() {
    }

    protected final int computeAlignment(int n2) {
        int n3;
        if (n2 > 1 && (n3 = this.bbwi.index & n2 - 1) != 0) {
            return n2 - n3;
        }
        return 0;
    }

    protected void alignAndReserve(int n2, int n3) {
        this.bbwi.index += this.computeAlignment(n2);
        if (this.bbwi.index + n3 > this.bbwi.buflen) {
            this.grow(n2, n3);
        }
    }

    protected void grow(int n2, int n3) {
        this.bbwi.needed = n3;
        this.bufferManagerWrite.overflow(this.bbwi);
    }

    public final void putEndian() throws SystemException {
        this.write_boolean(this.littleEndian);
    }

    public final boolean littleEndian() {
        return this.littleEndian;
    }

    void freeInternalCaches() {
        if (this.codebaseCache != null) {
            this.codebaseCache.done();
        }
        if (this.valueCache != null) {
            this.valueCache.done();
        }
        if (this.repositoryIdCache != null) {
            this.repositoryIdCache.done();
        }
    }

    public final void write_longdouble(double d10) {
        throw new NO_IMPLEMENT(1398079692, CompletionStatus.COMPLETED_MAYBE);
    }

    public void write_octet(byte by2) {
        if (this.bbwi.index + 1 > this.bbwi.buflen) {
            this.alignAndReserve(1, 1);
        }
        this.bbwi.buf[this.bbwi.index++] = by2;
    }

    public final void write_boolean(boolean bl2) {
        this.write_octet(bl2 ? (byte)1 : 0);
    }

    public void write_char(char c10) {
        CodeSetConversion.CTBConverter cTBConverter = this.getCharConverter();
        cTBConverter.convert(c10);
        if (cTBConverter.getNumBytes() > 1) {
            throw new DATA_CONVERSION(1398079697, CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_octet(cTBConverter.getBytes()[0]);
    }

    private final void writeLittleEndianWchar(char c10) {
        this.bbwi.buf[this.bbwi.index++] = (byte)(c10 & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(c10 >>> 8 & 0xFF);
    }

    private final void writeBigEndianWchar(char c10) {
        this.bbwi.buf[this.bbwi.index++] = (byte)(c10 >>> 8 & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(c10 & 0xFF);
    }

    private final void writeLittleEndianShort(short s2) {
        this.bbwi.buf[this.bbwi.index++] = (byte)(s2 & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(s2 >>> 8 & 0xFF);
    }

    private final void writeBigEndianShort(short s2) {
        this.bbwi.buf[this.bbwi.index++] = (byte)(s2 >>> 8 & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(s2 & 0xFF);
    }

    private final void writeLittleEndianLong(int n2) {
        this.bbwi.buf[this.bbwi.index++] = (byte)(n2 & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(n2 >>> 8 & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(n2 >>> 16 & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(n2 >>> 24 & 0xFF);
    }

    private final void writeBigEndianLong(int n2) {
        this.bbwi.buf[this.bbwi.index++] = (byte)(n2 >>> 24 & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(n2 >>> 16 & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(n2 >>> 8 & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(n2 & 0xFF);
    }

    private final void writeLittleEndianLongLong(long l2) {
        this.bbwi.buf[this.bbwi.index++] = (byte)(l2 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l2 >>> 8 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l2 >>> 16 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l2 >>> 24 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l2 >>> 32 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l2 >>> 40 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l2 >>> 48 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l2 >>> 56 & 0xFFL);
    }

    private final void writeBigEndianLongLong(long l2) {
        this.bbwi.buf[this.bbwi.index++] = (byte)(l2 >>> 56 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l2 >>> 48 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l2 >>> 40 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l2 >>> 32 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l2 >>> 24 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l2 >>> 16 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l2 >>> 8 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l2 & 0xFFL);
    }

    public void write_wchar(char c10) {
        if (ORBUtility.isForeignORB(this.orb)) {
            throw new MARSHAL(1398079705, CompletionStatus.COMPLETED_MAYBE);
        }
        this.alignAndReserve(2, 2);
        if (this.littleEndian) {
            this.writeLittleEndianWchar(c10);
        } else {
            this.writeBigEndianWchar(c10);
        }
    }

    public void write_short(short s2) {
        this.alignAndReserve(2, 2);
        if (this.littleEndian) {
            this.writeLittleEndianShort(s2);
        } else {
            this.writeBigEndianShort(s2);
        }
    }

    public final void write_ushort(short s2) {
        this.write_short(s2);
    }

    public void write_long(int n2) {
        this.alignAndReserve(4, 4);
        if (this.littleEndian) {
            this.writeLittleEndianLong(n2);
        } else {
            this.writeBigEndianLong(n2);
        }
    }

    public final void write_ulong(int n2) {
        this.write_long(n2);
    }

    public void write_longlong(long l2) {
        this.alignAndReserve(8, 8);
        if (this.littleEndian) {
            this.writeLittleEndianLongLong(l2);
        } else {
            this.writeBigEndianLongLong(l2);
        }
    }

    public final void write_ulonglong(long l2) {
        this.write_longlong(l2);
    }

    public final void write_float(float f2) {
        this.write_long(Float.floatToIntBits(f2));
    }

    public final void write_double(double d10) {
        this.write_longlong(Double.doubleToLongBits(d10));
    }

    public void write_string(String string) {
        if (string == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        CodeSetConversion.CTBConverter cTBConverter = this.getCharConverter();
        cTBConverter.convert(string);
        int n2 = cTBConverter.getNumBytes() + 1;
        this.handleSpecialChunkBegin(this.computeAlignment(4) + 4 + n2);
        this.write_long(n2);
        this.internalWriteOctetArray(cTBConverter.getBytes(), 0, cTBConverter.getNumBytes());
        this.write_octet((byte)0);
        this.handleSpecialChunkEnd();
    }

    public void write_wstring(String string) {
        if (string == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        if (ORBUtility.isForeignORB(this.orb)) {
            throw new MARSHAL(1398079705, CompletionStatus.COMPLETED_MAYBE);
        }
        int n2 = string.length() + 1;
        this.handleSpecialChunkBegin(4 + n2 * 2 + this.computeAlignment(4));
        this.write_long(n2);
        int n3 = 0;
        while (n3 < n2 - 1) {
            this.write_wchar(string.charAt(n3));
            ++n3;
        }
        this.write_short((short)0);
        this.handleSpecialChunkEnd();
    }

    void internalWriteOctetArray(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        while (n4 < n3 + n2) {
            int n5;
            int n6;
            if (this.bbwi.index + 1 > this.bbwi.buflen) {
                this.alignAndReserve(1, 1);
            }
            int n7 = (n6 = n3 + n2 - n4) < (n5 = this.bbwi.buf.length - this.bbwi.index) ? n6 : n5;
            System.arraycopy(byArray, n4, this.bbwi.buf, this.bbwi.index, n7);
            this.bbwi.index += n7;
            n4 += n7;
        }
    }

    public final void write_octet_array(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(n3);
        this.internalWriteOctetArray(byArray, n2, n3);
        this.handleSpecialChunkEnd();
    }

    public void write_Principal(Principal principal) {
        this.write_long(principal.name().length);
        this.write_octet_array(principal.name(), 0, principal.name().length);
    }

    public void write_any(Any any) {
        if (any == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_TypeCode(any.type());
        any.write_value((org.omg.CORBA.portable.OutputStream)this.parent);
    }

    public void write_TypeCode(TypeCode typeCode) {
        if (typeCode == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        TypeCodeImpl typeCodeImpl = typeCode instanceof TypeCodeImpl ? (TypeCodeImpl)typeCode : new TypeCodeImpl((ORB)this.orb, typeCode);
        typeCodeImpl.write_value(this.parent);
    }

    public void write_Object(Object object) {
        if (object == null) {
            IOR.NULL.write(this.parent);
            return;
        }
        ObjectImpl objectImpl = (ObjectImpl)object;
        ClientSubcontract clientSubcontract = null;
        try {
            clientSubcontract = (ClientSubcontract)objectImpl._get_delegate();
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            this.debugPrintThrowable(bAD_OPERATION);
        }
        catch (BAD_INV_ORDER bAD_INV_ORDER) {
            this.debugPrintThrowable(bAD_INV_ORDER);
        }
        if (clientSubcontract == null) {
            if (object instanceof Stub) {
                try {
                    ((Stub)object).connect((ORB)this.orb);
                }
                catch (RemoteException remoteException) {
                    this.debugPrintThrowable(remoteException);
                    throw new MARSHAL("Error connecting servant: " + remoteException.getMessage(), 1398079709, CompletionStatus.COMPLETED_MAYBE);
                }
            } else {
                this.orb.connect(object);
            }
            clientSubcontract = (ClientSubcontract)objectImpl._get_delegate();
        }
        IOR iOR = clientSubcontract.marshal();
        iOR.write(this.parent);
    }

    public void write_abstract_interface(java.lang.Object object) {
        boolean bl2 = false;
        Object object2 = null;
        if (object != null && object instanceof Object) {
            object2 = (Object)object;
            bl2 = true;
        }
        this.write_boolean(bl2);
        if (bl2) {
            this.write_Object(object2);
        } else {
            try {
                this.write_value((Serializable)object);
            }
            catch (ClassCastException classCastException) {
                if (object instanceof Serializable) {
                    throw classCastException;
                }
                ORBUtility.throwNotSerializableForCorba(object.getClass().getName());
            }
        }
    }

    public void write_value(Serializable serializable, Class clazz) {
        this.write_value(serializable);
    }

    public void write_value(Serializable serializable, String string) {
        if (serializable == null) {
            this.write_long(0);
            return;
        }
        if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
            this.writeIndirection(-1, this.valueCache.getVal(serializable));
            return;
        }
        Class<?> clazz = serializable.getClass();
        boolean bl2 = this.mustChunk;
        if (this.inBlock) {
            this.end_block();
        }
        if (clazz.isArray()) {
            if (this.valueHandler == null) {
                this.valueHandler = ORBUtility.createValueHandler(this.orb);
            }
            if (this.mustChunk) {
                int n2 = this.writeValueTag(true, false, Util.getCodebase(clazz));
                this.write_repositoryId(this.repIdStrs.createSequenceRepID(clazz));
                this.updateIndirectionTable(n2, serializable, serializable);
                this.start_block();
                --this.end_flag;
                --this.chunkedValueNestingLevel;
                this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n3 = this.writeValueTag(false, false, Util.getCodebase(clazz));
                this.write_repositoryId(this.repIdStrs.createSequenceRepID(clazz));
                this.updateIndirectionTable(n3, serializable, serializable);
                --this.end_flag;
                this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
                this.writeEndTag(false);
            }
        } else if (serializable instanceof ValueBase) {
            this.mustChunk = true;
            int n4 = this.writeValueTag(true, false, Util.getCodebase(clazz));
            String string2 = ((ValueBase)serializable)._truncatable_ids()[0];
            this.write_repositoryId(string2);
            this.updateIndirectionTable(n4, serializable, serializable);
            this.start_block();
            --this.end_flag;
            --this.chunkedValueNestingLevel;
            this.writeIDLValue(serializable, string2);
            this.end_block();
            this.writeEndTag(true);
        } else if (this.shouldWriteAsIDLEntity(serializable)) {
            this.writeIDLEntity((IDLEntity)serializable);
        } else if (serializable instanceof String) {
            if (this.mustChunk) {
                int n5 = this.writeValueTag(true, false, null);
                this.write_repositoryId(this.repIdStrs.getWStringValueRepId());
                this.updateIndirectionTable(n5, serializable, serializable);
                this.start_block();
                --this.end_flag;
                --this.chunkedValueNestingLevel;
                this.write_wstring((String)((java.lang.Object)serializable));
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n6 = this.writeValueTag(false, false, null);
                this.write_repositoryId(this.repIdStrs.getWStringValueRepId());
                this.updateIndirectionTable(n6, serializable, serializable);
                --this.end_flag;
                this.write_wstring((String)((java.lang.Object)serializable));
                this.writeEndTag(false);
            }
        } else if (serializable instanceof Class) {
            this.writeClass(string, (Class)serializable);
        } else {
            Serializable serializable2;
            if (this.valueHandler == null) {
                this.valueHandler = ORBUtility.createValueHandler(this.orb);
            }
            if ((serializable = this.valueHandler.writeReplace(serializable2 = serializable)) == null) {
                this.write_long(0);
                return;
            }
            if (serializable != serializable2) {
                if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
                    this.writeIndirection(-1, this.valueCache.getVal(serializable));
                    return;
                }
                clazz = serializable.getClass();
            }
            if (this.mustChunk || this.valueHandler.isCustomMarshaled(clazz)) {
                this.mustChunk = true;
                int n7 = this.writeValueTag(true, false, Util.getCodebase(clazz));
                this.write_repositoryId(this.repIdStrs.createForJavaType(clazz));
                this.updateIndirectionTable(n7, serializable, serializable2);
                --this.end_flag;
                --this.chunkedValueNestingLevel;
                this.start_block();
                this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n8 = this.writeValueTag(false, false, Util.getCodebase(clazz));
                this.write_repositoryId(this.repIdStrs.createForJavaType(clazz));
                this.updateIndirectionTable(n8, serializable, serializable2);
                --this.end_flag;
                this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
                this.writeEndTag(false);
            }
        }
        this.mustChunk = bl2;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public void write_value(Serializable serializable) {
        if (serializable == null) {
            this.write_long(0);
            return;
        }
        if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
            this.writeIndirection(-1, this.valueCache.getVal(serializable));
            return;
        }
        Class<?> clazz = serializable.getClass();
        boolean bl2 = this.mustChunk;
        if (this.inBlock) {
            this.end_block();
        }
        if (clazz.isArray()) {
            if (this.valueHandler == null) {
                this.valueHandler = ORBUtility.createValueHandler(this.orb);
            }
            if (this.mustChunk) {
                int n2 = this.writeValueTag(true, false, Util.getCodebase(clazz));
                this.write_repositoryId(this.repIdStrs.createSequenceRepID(clazz));
                this.updateIndirectionTable(n2, serializable, serializable);
                this.start_block();
                --this.end_flag;
                --this.chunkedValueNestingLevel;
                this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n3 = this.writeValueTag(false, false, Util.getCodebase(clazz));
                this.write_repositoryId(this.repIdStrs.createSequenceRepID(clazz));
                this.updateIndirectionTable(n3, serializable, serializable);
                --this.end_flag;
                this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
                this.writeEndTag(false);
            }
        } else if (serializable instanceof ValueBase) {
            this.mustChunk = true;
            int n4 = this.writeValueTag(true, false, Util.getCodebase(clazz));
            String string = ((ValueBase)serializable)._truncatable_ids()[0];
            this.write_repositoryId(string);
            this.updateIndirectionTable(n4, serializable, serializable);
            this.start_block();
            --this.end_flag;
            --this.chunkedValueNestingLevel;
            this.writeIDLValue(serializable, string);
            this.end_block();
            this.writeEndTag(true);
        } else if (this.shouldWriteAsIDLEntity(serializable)) {
            this.writeIDLEntity((IDLEntity)serializable);
        } else if (serializable instanceof String) {
            if (this.mustChunk) {
                int n5 = this.writeValueTag(true, false, null);
                this.write_repositoryId(this.repIdStrs.getWStringValueRepId());
                this.updateIndirectionTable(n5, serializable, serializable);
                this.start_block();
                --this.end_flag;
                --this.chunkedValueNestingLevel;
                this.write_wstring((String)((java.lang.Object)serializable));
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n6 = this.writeValueTag(false, false, null);
                this.write_repositoryId(this.repIdStrs.getWStringValueRepId());
                this.updateIndirectionTable(n6, serializable, serializable);
                --this.end_flag;
                this.write_wstring((String)((java.lang.Object)serializable));
                this.writeEndTag(false);
            }
        } else if (serializable instanceof Class) {
            this.writeClass(this.repIdStrs.getClassDescValueRepId(), (Class)serializable);
        } else {
            Serializable serializable2;
            if (this.valueHandler == null) {
                this.valueHandler = ORBUtility.createValueHandler(this.orb);
            }
            if ((serializable = this.valueHandler.writeReplace(serializable2 = serializable)) == null) {
                this.write_long(0);
                return;
            }
            if (serializable != serializable2) {
                if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
                    this.writeIndirection(-1, this.valueCache.getVal(serializable));
                    return;
                }
                clazz = serializable.getClass();
            }
            if (this.mustChunk || this.valueHandler.isCustomMarshaled(clazz)) {
                this.mustChunk = true;
                int n7 = this.writeValueTag(true, false, Util.getCodebase(clazz));
                this.write_repositoryId(this.repIdStrs.createForJavaType(clazz));
                this.updateIndirectionTable(n7, serializable, serializable2);
                --this.end_flag;
                --this.chunkedValueNestingLevel;
                this.start_block();
                this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n8 = this.writeValueTag(false, false, Util.getCodebase(clazz));
                this.write_repositoryId(this.repIdStrs.createForJavaType(clazz));
                this.updateIndirectionTable(n8, serializable, serializable2);
                --this.end_flag;
                this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
                this.writeEndTag(false);
            }
        }
        this.mustChunk = bl2;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        int n2;
        if (serializable == null) {
            this.write_long(0);
            return;
        }
        if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
            this.writeIndirection(-1, this.valueCache.getVal(serializable));
            return;
        }
        boolean bl2 = this.mustChunk;
        boolean bl3 = false;
        if (boxedValueHelper instanceof ValueHelper) {
            try {
                n2 = ((ValueHelper)boxedValueHelper).get_type().type_modifier();
            }
            catch (BadKind badKind) {
                n2 = 0;
            }
            if (serializable instanceof CustomMarshal && n2 == 1) {
                bl3 = true;
                this.mustChunk = true;
            }
            if (n2 == 3) {
                this.mustChunk = true;
            }
        }
        if (this.mustChunk) {
            if (this.inBlock) {
                this.end_block();
            }
            n2 = this.writeValueTag(true, false, Util.getCodebase(serializable.getClass()));
            this.write_repositoryId(boxedValueHelper.get_id());
            this.updateIndirectionTable(n2, serializable, serializable);
            this.start_block();
            --this.end_flag;
            --this.chunkedValueNestingLevel;
            if (bl3) {
                ((CustomMarshal)serializable).marshal((DataOutputStream)this.parent);
            } else {
                boxedValueHelper.write_value((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
            }
            this.end_block();
            this.writeEndTag(true);
        } else {
            n2 = this.writeValueTag(false, false, Util.getCodebase(serializable.getClass()));
            this.write_repositoryId(boxedValueHelper.get_id());
            this.updateIndirectionTable(n2, serializable, serializable);
            --this.end_flag;
            boxedValueHelper.write_value((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
            this.writeEndTag(false);
        }
        this.mustChunk = bl2;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public int get_offset() {
        return this.bbwi.index;
    }

    public void start_block() {
        if (this.debug) {
            this.debugPrintMessage("CDROutputStream_1_0 start_block, index" + this.bbwi.index);
        }
        this.write_long(0);
        this.inBlock = true;
        this.blockSizePosition = this.get_offset();
        this.blockSizeIndex = this.bbwi.index;
        if (this.debug) {
            this.debugPrintMessage("CDROutputStream_1_0 start_block, blockSizeIndex " + this.blockSizeIndex);
        }
    }

    protected void writeLongWithoutAlign(int n2) {
        if (this.littleEndian) {
            this.writeLittleEndianLong(n2);
        } else {
            this.writeBigEndianLong(n2);
        }
    }

    public void end_block() {
        if (this.debug) {
            this.debugPrintMessage("CDROutputStream_1_0.java end_block");
        }
        if (!this.inBlock) {
            return;
        }
        if (this.debug) {
            this.debugPrintMessage("CDROutputStream_1_0.java end_block, in a block");
        }
        this.inBlock = false;
        if (this.get_offset() == this.blockSizePosition) {
            this.bbwi.index -= 4;
            this.blockSizeIndex = -1;
            this.blockSizePosition = -1;
            return;
        }
        int n2 = this.bbwi.index;
        this.bbwi.index = this.blockSizeIndex - 4;
        this.writeLongWithoutAlign(n2 - this.blockSizeIndex);
        this.bbwi.index = n2;
        this.blockSizeIndex = -1;
        this.blockSizePosition = -1;
    }

    public ORB orb() {
        return this.orb;
    }

    public final void write_boolean_array(boolean[] blArray, int n2, int n3) {
        if (blArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(n3);
        int n4 = 0;
        while (n4 < n3) {
            this.write_boolean(blArray[n2 + n4]);
            ++n4;
        }
        this.handleSpecialChunkEnd();
    }

    public final void write_char_array(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(n3);
        int n4 = 0;
        while (n4 < n3) {
            this.write_char(cArray[n2 + n4]);
            ++n4;
        }
        this.handleSpecialChunkEnd();
    }

    public void write_wchar_array(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(2) + n3 * 2);
        int n4 = 0;
        while (n4 < n3) {
            this.write_wchar(cArray[n2 + n4]);
            ++n4;
        }
        this.handleSpecialChunkEnd();
    }

    public final void write_short_array(short[] sArray, int n2, int n3) {
        if (sArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(2) + n3 * 2);
        int n4 = 0;
        while (n4 < n3) {
            this.write_short(sArray[n2 + n4]);
            ++n4;
        }
        this.handleSpecialChunkEnd();
    }

    public final void write_ushort_array(short[] sArray, int n2, int n3) {
        this.write_short_array(sArray, n2, n3);
    }

    public final void write_long_array(int[] nArray, int n2, int n3) {
        if (nArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(4) + n3 * 4);
        int n4 = 0;
        while (n4 < n3) {
            this.write_long(nArray[n2 + n4]);
            ++n4;
        }
        this.handleSpecialChunkEnd();
    }

    public final void write_ulong_array(int[] nArray, int n2, int n3) {
        this.write_long_array(nArray, n2, n3);
    }

    public final void write_longlong_array(long[] lArray, int n2, int n3) {
        if (lArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(8) + n3 * 8);
        int n4 = 0;
        while (n4 < n3) {
            this.write_longlong(lArray[n2 + n4]);
            ++n4;
        }
        this.handleSpecialChunkEnd();
    }

    public final void write_ulonglong_array(long[] lArray, int n2, int n3) {
        this.write_longlong_array(lArray, n2, n3);
    }

    public final void write_float_array(float[] fArray, int n2, int n3) {
        if (fArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(4) + n3 * 4);
        int n4 = 0;
        while (n4 < n3) {
            this.write_float(fArray[n2 + n4]);
            ++n4;
        }
        this.handleSpecialChunkEnd();
    }

    public final void write_double_array(double[] dArray, int n2, int n3) {
        if (dArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(8) + n3 * 8);
        int n4 = 0;
        while (n4 < n3) {
            this.write_double(dArray[n2 + n4]);
            ++n4;
        }
        this.handleSpecialChunkEnd();
    }

    public void write_string_array(String[] stringArray, int n2, int n3) {
        if (stringArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        int n4 = 0;
        while (n4 < n3) {
            this.write_string(stringArray[n2 + n4]);
            ++n4;
        }
    }

    public void write_wstring_array(String[] stringArray, int n2, int n3) {
        if (stringArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        int n4 = 0;
        while (n4 < n3) {
            this.write_wstring(stringArray[n2 + n4]);
            ++n4;
        }
    }

    public final void write_any_array(Any[] anyArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            this.write_any(anyArray[n2 + n4]);
            ++n4;
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.bbwi.buf, 0, this.bbwi.index);
    }

    public void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream outputStream) {
        outputStream.write_long(this.bbwi.index);
        outputStream.write_octet_array(this.bbwi.buf, 0, this.bbwi.index);
    }

    public final int getSize() {
        return this.bbwi.index;
    }

    public int getIndex() {
        return this.bbwi.index;
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public void setIndex(int n2) {
        this.bbwi.index = n2;
    }

    public ByteBufferWithInfo getByteBufferWithInfo() {
        return this.bbwi;
    }

    public void setByteBufferWithInfo(ByteBufferWithInfo byteBufferWithInfo) {
        this.bbwi = byteBufferWithInfo;
    }

    public byte[] getByteBuffer() {
        return this.bbwi.buf;
    }

    public void setByteBuffer(byte[] byArray) {
        this.bbwi.buf = byArray;
    }

    private final void updateIndirectionTable(int n2, java.lang.Object object, java.lang.Object object2) {
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(true);
        }
        this.valueCache.put(object, n2);
        if (object2 != object) {
            this.valueCache.put(object2, n2);
        }
    }

    private final void write_repositoryId(String string) {
        if (this.repositoryIdCache != null && this.repositoryIdCache.containsKey(string)) {
            this.writeIndirection(-1, this.repositoryIdCache.getVal(string));
            return;
        }
        this.write_string(string);
    }

    private void write_codebase(String string, int n2) {
        if (this.codebaseCache != null && this.codebaseCache.containsKey(string)) {
            this.writeIndirection(-1, this.codebaseCache.getVal(string));
        } else {
            this.write_string(string);
            if (this.codebaseCache == null) {
                this.codebaseCache = new CacheTable(true);
            }
            this.codebaseCache.put(string, n2);
        }
    }

    private final int writeValueTag(boolean bl2, boolean bl3, String string) {
        int n2 = 0;
        if (bl2 && bl3) {
            if (string == null) {
                this.write_long(this.repIdUtil.getStandardRMIChunkedNoRepStrId());
                n2 = this.get_offset() - 4;
            } else {
                this.write_long(this.repIdUtil.getCodeBaseRMIChunkedNoRepStrId());
                n2 = this.get_offset() - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (bl2 && !bl3) {
            if (string == null) {
                this.write_long(this.repIdUtil.getStandardRMIChunkedId());
                n2 = this.get_offset() - 4;
            } else {
                this.write_long(this.repIdUtil.getCodeBaseRMIChunkedId());
                n2 = this.get_offset() - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (string == null) {
            this.write_long(this.repIdUtil.getStandardRMIUnchunkedId());
            n2 = this.get_offset() - 4;
        } else {
            this.write_long(this.repIdUtil.getCodeBaseRMIUnchunkedId());
            n2 = this.get_offset() - 4;
            this.write_codebase(string, this.get_offset());
        }
        return n2;
    }

    private void writeIDLValue(Serializable serializable, String string) {
        if (serializable instanceof StreamableValue) {
            ((StreamableValue)serializable)._write((org.omg.CORBA.portable.OutputStream)this.parent);
        } else if (serializable instanceof CustomValue) {
            ((CustomValue)serializable).marshal((DataOutputStream)this.parent);
        } else {
            BoxedValueHelper boxedValueHelper = Utility.getHelper(serializable.getClass(), null, (String)string);
            boolean bl2 = false;
            if (boxedValueHelper instanceof ValueHelper && serializable instanceof CustomMarshal) {
                try {
                    if (((ValueHelper)boxedValueHelper).get_type().type_modifier() == 1) {
                        bl2 = true;
                    }
                }
                catch (BadKind badKind) {
                    this.debugPrintThrowable(badKind);
                    throw new MARSHAL();
                }
            }
            if (bl2) {
                ((CustomMarshal)serializable).marshal((DataOutputStream)this.parent);
            } else {
                boxedValueHelper.write_value((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
            }
        }
    }

    private void writeEndTag(boolean bl2) {
        if (bl2) {
            if (this.get_offset() == this.end_flag_position && this.bbwi.index == this.end_flag_index) {
                this.bbwi.index -= 4;
            }
            this.writeNestingLevel();
            this.end_flag_index = this.bbwi.index;
            this.end_flag_position = this.get_offset();
            ++this.chunkedValueNestingLevel;
        }
        ++this.end_flag;
    }

    private void writeNestingLevel() {
        if (this.orb == null || ORBVersionImpl.FOREIGN.equals(this.orb.getORBVersion()) || ORBVersionImpl.NEWER.compareTo(this.orb.getORBVersion()) <= 0) {
            this.write_long(this.chunkedValueNestingLevel);
        } else {
            this.write_long(this.end_flag);
        }
    }

    private void writeClass(String string, Class clazz) {
        if (this.mustChunk) {
            int n2 = this.writeValueTag(true, false, null);
            this.updateIndirectionTable(n2, clazz, clazz);
            if (string != null) {
                this.write_repositoryId(string);
            } else {
                this.write_repositoryId(this.repIdStrs.getClassDescValueRepId());
            }
            this.start_block();
            --this.end_flag;
            --this.chunkedValueNestingLevel;
            this.writeClassBody(clazz);
            this.end_block();
            this.writeEndTag(true);
        } else {
            int n3 = this.writeValueTag(false, false, null);
            this.updateIndirectionTable(n3, clazz, clazz);
            if (string != null) {
                this.write_repositoryId(string);
            } else {
                this.write_repositoryId(this.repIdStrs.getClassDescValueRepId());
            }
            --this.end_flag;
            this.writeClassBody(clazz);
            this.writeEndTag(false);
        }
    }

    private void writeClassBody(Class clazz) {
        if (this.orb == null || ORBVersionImpl.FOREIGN.equals(this.orb.getORBVersion()) || ORBVersionImpl.NEWER.compareTo(this.orb.getORBVersion()) <= 0) {
            this.write_value((Serializable)((java.lang.Object)Util.getCodebase((Class)clazz)));
            this.write_value((Serializable)((java.lang.Object)this.repIdStrs.createForAnyType(clazz)));
        } else {
            this.write_value((Serializable)((java.lang.Object)this.repIdStrs.createForAnyType(clazz)));
            this.write_value((Serializable)((java.lang.Object)Util.getCodebase((Class)clazz)));
        }
    }

    private boolean shouldWriteAsIDLEntity(Serializable serializable) {
        return serializable instanceof IDLEntity && !(serializable instanceof ValueBase) && !(serializable instanceof Object);
    }

    private void writeIDLEntity(IDLEntity iDLEntity) {
        this.mustChunk = true;
        String string = this.repIdStrs.createForJavaType((Serializable)iDLEntity);
        Class<?> clazz = iDLEntity.getClass();
        String string2 = Util.getCodebase(clazz);
        int n2 = this.writeValueTag(true, false, string2);
        this.updateIndirectionTable(n2, iDLEntity, iDLEntity);
        this.write_repositoryId(string);
        --this.end_flag;
        --this.chunkedValueNestingLevel;
        this.start_block();
        try {
            ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
            final Class clazz2 = Utility.loadClassForClass((String)(clazz.getName() + "Helper"), (String)string2, (ClassLoader)classLoader, clazz, (ClassLoader)classLoader);
            final Class[] classArray = new Class[]{class$org$omg$CORBA$portable$OutputStream == null ? (class$org$omg$CORBA$portable$OutputStream = CDROutputStream_1_0.class$("org.omg.CORBA.portable.OutputStream")) : class$org$omg$CORBA$portable$OutputStream, clazz};
            Method method = null;
            try {
                method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public java.lang.Object run() throws NoSuchMethodException {
                        return clazz2.getDeclaredMethod(CDROutputStream_1_0.kWriteMethod, classArray);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (NoSuchMethodException)privilegedActionException.getException();
            }
            java.lang.Object[] objectArray = new java.lang.Object[]{this.parent, iDLEntity};
            method.invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.debugPrintThrowable(classNotFoundException);
            throw new MARSHAL(classNotFoundException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.debugPrintThrowable(noSuchMethodException);
            throw new MARSHAL(noSuchMethodException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.debugPrintThrowable(illegalAccessException);
            throw new MARSHAL(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            this.debugPrintThrowable(invocationTargetException);
            throw new MARSHAL(invocationTargetException.getMessage());
        }
        this.end_block();
        this.writeEndTag(true);
    }

    public void write_Abstract(java.lang.Object object) {
        this.write_abstract_interface(object);
    }

    public void write_Value(Serializable serializable) {
        this.write_value(serializable);
    }

    public void write_fixed(BigDecimal bigDecimal, short s2, short s3) {
        String string;
        String string2;
        int n2;
        String string3 = bigDecimal.toString();
        if (string3.charAt(0) == '-' || string3.charAt(0) == '+') {
            string3 = string3.substring(1);
        }
        if ((n2 = string3.indexOf(46)) == -1) {
            string2 = string3;
            string = null;
        } else if (n2 == 0) {
            string2 = null;
            string = string3;
        } else {
            string2 = string3.substring(0, n2);
            string = string3.substring(n2 + 1);
        }
        StringBuffer stringBuffer = new StringBuffer(s2);
        if (string != null) {
            stringBuffer.append(string);
        }
        while (stringBuffer.length() < s3) {
            stringBuffer.append('0');
        }
        if (string2 != null) {
            stringBuffer.insert(0, string2);
        }
        while (stringBuffer.length() < s2) {
            stringBuffer.insert(0, '0');
        }
        this.write_fixed(stringBuffer.toString(), bigDecimal.signum());
    }

    public void write_fixed(BigDecimal bigDecimal) {
        this.write_fixed(bigDecimal.toString(), bigDecimal.signum());
    }

    public void write_fixed(String string, int n2) {
        char c10;
        int n3 = string.length();
        byte by2 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            c10 = string.charAt(n5);
            if (c10 != '-' && c10 != '+' && c10 != '.') {
                ++n4;
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < n3) {
            c10 = string.charAt(n6);
            if (c10 != '-' && c10 != '+' && c10 != '.') {
                byte by3 = (byte)Character.digit(c10, 10);
                if (by3 == -1) {
                    this.debugPrintMessage("Digit is -1, throwing MARSHAL");
                    throw new MARSHAL();
                }
                if (n4 % 2 == 0) {
                    by2 = (byte)(by2 | by3);
                    this.write_octet(by2);
                    by2 = 0;
                } else {
                    by2 = (byte)(by2 | by3 << 4);
                }
                --n4;
            }
            ++n6;
        }
        by2 = n2 == -1 ? (byte)((byte)(by2 | 0xD)) : (byte)((byte)(by2 | 0xC));
        this.write_octet(by2);
    }

    public String[] _truncatable_ids() {
        if (_ids == null) {
            return null;
        }
        return (String[])_ids.clone();
    }

    public void printBuffer() {
        CDROutputStream_1_0.printBuffer(this.bbwi);
    }

    public static void printBuffer(ByteBufferWithInfo byteBufferWithInfo) {
        System.out.println("+++++++ Output Buffer ++++++++");
        System.out.println();
        System.out.println("Current index: " + byteBufferWithInfo.index);
        System.out.println("Total length : " + byteBufferWithInfo.buflen);
        System.out.println();
        char[] cArray = new char[16];
        try {
            int n2 = 0;
            while (n2 < byteBufferWithInfo.index) {
                int n3;
                int n4 = 0;
                while (n4 < 16 && n4 + n2 < byteBufferWithInfo.index) {
                    String string;
                    n3 = byteBufferWithInfo.buf[n2 + n4];
                    if (n3 < 0) {
                        n3 = 256 + n3;
                    }
                    if ((string = Integer.toHexString(n3)).length() == 1) {
                        string = "0" + string;
                    }
                    System.out.print(string + " ");
                    ++n4;
                }
                while (n4 < 16) {
                    System.out.print("   ");
                    ++n4;
                }
                n3 = 0;
                while (n3 < 16 && n3 + n2 < byteBufferWithInfo.index) {
                    cArray[n3] = Character.isLetterOrDigit((char)byteBufferWithInfo.buf[n2 + n3]) ? (int)byteBufferWithInfo.buf[n2 + n3] : 46;
                    ++n3;
                }
                System.out.println(new String(cArray, 0, n3));
                n2 += 16;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.out.println("++++++++++++++++++++++++++++++");
    }

    public void writeIndirection(int n2, int n3) {
        this.handleSpecialChunkBegin(this.computeAlignment(4) + 8);
        this.write_long(n2);
        this.write_long(n3 - this.parent.getRealIndex(this.get_offset()));
        this.handleSpecialChunkEnd();
    }

    protected CodeSetConversion.CTBConverter getCharConverter() {
        if (this.charConverter == null) {
            this.charConverter = this.parent.createCharCTBConverter();
        }
        return this.charConverter;
    }

    protected CodeSetConversion.CTBConverter getWCharConverter() {
        if (this.wcharConverter == null) {
            this.wcharConverter = this.parent.createWCharCTBConverter();
        }
        return this.wcharConverter;
    }

    protected void debugPrintThrowable(Throwable throwable) {
        if (this.debug && throwable != null) {
            throwable.printStackTrace();
        }
    }

    protected void debugPrintMessage(String string) {
        if (this.debug) {
            ORBUtility.dprint(this, string);
        }
    }

    void alignOnBoundary(int n2) {
        this.alignAndReserve(n2, 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

