/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop.messages;

import com.sun.corba.ee.internal.core.GIOPVersion;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.core.ServiceContexts;
import com.sun.corba.ee.internal.iiop.CDRInputStream;
import com.sun.corba.ee.internal.iiop.CDROutputStream;
import com.sun.corba.ee.internal.iiop.MessageMediator;
import com.sun.corba.ee.internal.iiop.ORB;
import com.sun.corba.ee.internal.iiop.messages.AddressingDispositionHelper;
import com.sun.corba.ee.internal.iiop.messages.Message_1_2;
import com.sun.corba.ee.internal.iiop.messages.ReplyMessage;
import com.sun.corba.ee.internal.orbutil.ORBClassLoader;
import com.sun.corba.ee.internal.orbutil.ORBUtility;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public final class ReplyMessage_1_2
extends Message_1_2
implements ReplyMessage {
    private ORB orb = null;
    private int reply_status = 0;
    private ServiceContexts service_contexts = null;
    private IOR ior = null;
    private String exClassName = null;
    private int minorCode = 0;
    private CompletionStatus completionStatus = null;
    private short addrDisposition = 0;

    ReplyMessage_1_2(ORB oRB) {
        this.orb = oRB;
    }

    ReplyMessage_1_2(ORB oRB, int n2, int n3, ServiceContexts serviceContexts, IOR iOR) {
        super(1195986768, GIOPVersion.V1_2, (byte)0, (byte)1, 0);
        this.orb = oRB;
        this.request_id = n2;
        this.reply_status = n3;
        this.service_contexts = serviceContexts;
        this.ior = iOR;
    }

    public int getRequestId() {
        return this.request_id;
    }

    public int getReplyStatus() {
        return this.reply_status;
    }

    public short getAddrDisposition() {
        return this.addrDisposition;
    }

    public ServiceContexts getServiceContexts() {
        return this.service_contexts;
    }

    public void setServiceContexts(ServiceContexts serviceContexts) {
        this.service_contexts = serviceContexts;
    }

    public SystemException getSystemException() {
        SystemException systemException = null;
        try {
            systemException = (SystemException)((Object)ORBClassLoader.loadClass(this.exClassName).newInstance());
        }
        catch (Exception exception) {
            throw new INTERNAL("BAD SystemException: " + this.exClassName, 0, CompletionStatus.COMPLETED_MAYBE);
        }
        systemException.minor = this.minorCode;
        systemException.completed = this.completionStatus;
        return systemException;
    }

    public IOR getIOR() {
        return this.ior;
    }

    public void setIOR(IOR iOR) {
        this.ior = iOR;
    }

    public void read(org.omg.CORBA.portable.InputStream inputStream) {
        block10: {
            block9: {
                super.read(inputStream);
                this.request_id = inputStream.read_ulong();
                this.reply_status = inputStream.read_long();
                ReplyMessage_1_2.isValidReplyStatus(this.reply_status);
                this.service_contexts = new ServiceContexts((InputStream)inputStream, GIOPVersion.V1_2);
                ((CDRInputStream)inputStream).alignOnBoundary(8);
                if (this.reply_status != 2) break block9;
                String string = inputStream.read_string();
                this.exClassName = ORBUtility.classNameOf(string);
                this.minorCode = inputStream.read_long();
                int n2 = inputStream.read_long();
                switch (n2) {
                    case 0: {
                        this.completionStatus = CompletionStatus.COMPLETED_YES;
                        break block10;
                    }
                    case 1: {
                        this.completionStatus = CompletionStatus.COMPLETED_NO;
                        break block10;
                    }
                    case 2: {
                        this.completionStatus = CompletionStatus.COMPLETED_MAYBE;
                        break block10;
                    }
                    default: {
                        throw new INTERNAL("BAD completion status: " + n2, 0, CompletionStatus.COMPLETED_MAYBE);
                    }
                }
            }
            if (this.reply_status != 1) {
                if (this.reply_status == 3 || this.reply_status == 4) {
                    CDRInputStream cDRInputStream = (CDRInputStream)inputStream;
                    this.ior = new IOR(cDRInputStream);
                } else if (this.reply_status == 5) {
                    this.addrDisposition = AddressingDispositionHelper.read(inputStream);
                }
            }
        }
    }

    public void write(org.omg.CORBA.portable.OutputStream outputStream) {
        super.write(outputStream);
        outputStream.write_ulong(this.request_id);
        outputStream.write_long(this.reply_status);
        if (this.service_contexts != null) {
            this.service_contexts.write((OutputStream)outputStream, GIOPVersion.V1_2);
        } else {
            ServiceContexts.writeNullServiceContext((OutputStream)outputStream);
        }
        ((CDROutputStream)outputStream).alignOnBoundary(8);
    }

    public static void isValidReplyStatus(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new INTERNAL(1398079710, CompletionStatus.COMPLETED_MAYBE);
            }
        }
    }

    public final void callback(MessageMediator messageMediator) throws IOException {
        messageMediator.handleInput(this);
    }
}

