/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb;

import com.sun.ejb.EJBObjectInputStream;
import com.sun.ejb.EJBObjectOutputStream;
import com.sun.enterprise.log.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.ejb.EJBException;

public class EJBUtils {
    private static final boolean debug = false;

    public static void throwEJBException(Exception ex2) throws EJBException {
        Log.err.println(ex2);
        if (ex2 instanceof EJBException) {
            throw (EJBException)ex2;
        }
        if (ex2 instanceof IllegalArgumentException || ex2 instanceof IllegalStateException) {
            throw (RuntimeException)ex2;
        }
        throw new EJBException(ex2);
    }

    public static final byte[] serializeObject(Object obj) throws IOException {
        final ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = (ObjectOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new EJBObjectOutputStream(bos);
                }
            });
        }
        catch (PrivilegedActionException ex2) {
            throw (IOException)ex2.getException();
        }
        oos.writeObject(obj);
        oos.flush();
        byte[] data = bos.toByteArray();
        oos.close();
        bos.close();
        return data;
    }

    public static final Object deserializeObject(byte[] data, final ClassLoader loader) throws Exception {
        if (data == null) {
            return null;
        }
        final ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ObjectInputStream ois = null;
        if (loader != null) {
            try {
                ois = (ObjectInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new EJBObjectInputStream(bis, loader);
                    }
                });
            }
            catch (PrivilegedActionException ex2) {
                throw (IOException)ex2.getException();
            }
        } else {
            ois = new ObjectInputStream(bis);
        }
        return ois.readObject();
    }
}

