/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.CMPClassGenerator;
import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.ejb.codegen.HomeGenerator;
import com.sun.ejb.codegen.PersistentStateGenerator;
import com.sun.ejb.codegen.WrapperGenerator;
import com.sun.enterprise.deployment.AbstractArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.DeploymentContext;
import com.sun.enterprise.deployment.DirectoryArchive;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.tools.deployment.backend.DeploymentSession;
import com.sun.enterprise.tools.deployment.backend.JarRepository;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.TypeUtil;
import com.sun.tools.javac.Main;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class GeneratorDriver {
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$ejb$codegen$GeneratorDriver == null ? (class$com$sun$ejb$codegen$GeneratorDriver = GeneratorDriver.class$("com.sun.ejb.codegen.GeneratorDriver")) : class$com$sun$ejb$codegen$GeneratorDriver);
    private static final String fs = File.separator;
    private static final char fsc = File.separatorChar;
    private static final String ps = File.pathSeparator;
    private static final String ORG_OMG_STUB_PREFIX = "org.omg.stub.";
    private static final String COM_SUN_PREFIX = "com.sun.";
    static /* synthetic */ Class class$com$sun$ejb$codegen$GeneratorDriver;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$javax$ejb$EJBHome;
    static /* synthetic */ Class class$javax$ejb$EJBObject;

    private GeneratorDriver() {
    }

    private static void generateCode(DeploymentContext context, Generator gen, Vector files) throws Exception {
        try {
            String genClass = gen.getGeneratedClass();
            OutputStream out = context.createOutputStream(genClass);
            gen.generate(out);
            out.close();
            String genFile = context.getFileName(genClass);
            if (!files.contains(genFile)) {
                files.addElement(genFile);
            }
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
        }
    }

    private static void compileAndRmic(DeploymentContext context, File jarFile, Vector files, Set extraStubClasses, Vector webInfs, Vector warStubClasses) throws GeneratorException, IOException {
        sun.rmi.rmic.Main comp;
        DeploymentSession session = context.getSession();
        if (files.size() == 0 && extraStubClasses.size() == 0 && warStubClasses.size() == 0) {
            System.out.println(localStrings.getLocalString("generator.nothing_to_compile", "No code generation required"));
            GeneratorDriver.progressEvent("Ejb Compilation complete", session);
            GeneratorDriver.progressEvent("Ejb Compilation complete", session);
            return;
        }
        GeneratorDriver.progress(localStrings.getLocalString("generator.compiling_wrapper", "Compiling wrapper code."), session);
        if (files.size() > 0) {
            GeneratorDriver.compileClasses(context, jarFile, files);
            if (session != null && session.isCancelled()) {
                return;
            }
            GeneratorDriver.progressEvent("Ejb Compilation complete", session);
        }
        GeneratorDriver.progress(localStrings.getLocalString("generator.compiling_rmi_iiop", "Compiling RMI-IIOP code."), session);
        int numRmicArgs = 9 + files.size() + extraStubClasses.size() + warStubClasses.size();
        String[] rmicArgs = new String[numRmicArgs];
        int rmicCnt = 0;
        rmicArgs[rmicCnt++] = "-iiop";
        rmicArgs[rmicCnt++] = "-poa";
        rmicArgs[rmicCnt++] = "-alwaysgenerate";
        rmicArgs[rmicCnt++] = "-keepgenerated";
        rmicArgs[rmicCnt++] = "-g";
        rmicArgs[rmicCnt++] = "-classpath";
        String classPath = context.getClassPath() + ps;
        int i2 = 0;
        while (i2 < webInfs.size()) {
            classPath = classPath + webInfs.elementAt(i2);
            classPath = classPath + ps;
            ++i2;
        }
        rmicArgs[rmicCnt++] = classPath;
        rmicArgs[rmicCnt++] = "-d";
        rmicArgs[rmicCnt++] = context.getOutputDirectory().toString();
        String cname = "";
        Enumeration e12 = files.elements();
        while (e12.hasMoreElements()) {
            String file = (String)e12.nextElement();
            String className = context.getClassName(file);
            System.out.println("rmic " + className + "...");
            rmicArgs[rmicCnt++] = className;
            cname = cname + " " + className;
        }
        Iterator extraIter = extraStubClasses.iterator();
        while (extraIter.hasNext()) {
            String next = (String)extraIter.next();
            System.out.println("rmic " + next + "...");
            rmicArgs[rmicCnt++] = next;
        }
        int i3 = 0;
        while (i3 < warStubClasses.size()) {
            String className = (String)warStubClasses.elementAt(i3);
            System.out.println("rmic " + className + "...");
            rmicArgs[rmicCnt++] = className;
            ++i3;
        }
        try {
            comp = new sun.rmi.rmic.Main(System.err, "rmic");
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            System.err.println("Could not invoke rmic..");
            throw new GeneratorException("Could not invoke rmic");
        }
        if (!comp.compile(rmicArgs)) {
            System.err.println("rmic compilation failed...");
            throw new GeneratorException("rmic compilation failed.");
        }
        if (session != null && session.isCancelled()) {
            return;
        }
        GeneratorDriver.progressEvent("Ejb Compilation complete", session);
    }

    private static void compileClasses(DeploymentContext context, File jarFile, Vector files) throws GeneratorException {
        Integer result;
        int size = files.size();
        if (size == 0) {
            return;
        }
        Enumeration e10 = files.elements();
        String[] javacArgs = new String[4 + size];
        int cnt = 0;
        javacArgs[cnt++] = "-d";
        javacArgs[cnt++] = context.getOutputDirectory().toString();
        javacArgs[cnt++] = "-classpath";
        javacArgs[cnt++] = context.getClassPath();
        while (e10.hasMoreElements()) {
            String file = (String)e10.nextElement();
            javacArgs[cnt++] = file;
            System.out.println(localStrings.getLocalString("generator.compile", "Compiling {0} ...", new Object[]{file}));
        }
        try {
            Main compiler = new Main();
            Method meth = compiler.getClass().getMethod("compile", array$Ljava$lang$String == null ? (array$Ljava$lang$String = GeneratorDriver.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            result = (Integer)meth.invoke((Object)compiler, new Object[]{javacArgs});
        }
        catch (Exception t2) {
            System.err.println(t2);
            System.err.println(localStrings.getLocalString("generator.compile_failed", "Compilation failed..."));
            throw new GeneratorException("Could not invoke javac.");
        }
        if (result != 0) {
            System.err.println(localStrings.getLocalString("generator.compile_failed", "Compilation failed..."));
            throw new GeneratorException("Compilation failed.");
        }
        int i2 = 0;
        while (i2 < files.size()) {
            String javaFile = (String)files.elementAt(i2);
            String classFile = javaFile.substring(context.getTempDirectory().toString().length() + File.separator.length(), javaFile.indexOf(".java")) + ".class";
            files.setElementAt(classFile, i2);
            ++i2;
        }
    }

    private static void processReusableGeneratedFiles(DeploymentContext context, Vector descriptors, Vector allFiles, File oldServerJar) throws IOException {
        if (oldServerJar == null || descriptors.size() == 0) {
            return;
        }
        int FILES_PER_DESC = 6;
        int totalNumFiles = descriptors.size() * 6;
        String[] files = new String[totalNumFiles];
        int i2 = 0;
        while (i2 < descriptors.size()) {
            EjbDescriptor desc = (EjbDescriptor)descriptors.elementAt(i2);
            GeneratedNames names = new GeneratedNames(desc);
            int baseFileIndex = i2 * 6;
            files[baseFileIndex + 0] = names.getEjbObjectImplClass();
            files[baseFileIndex + 1] = names.getHomeImplClass();
            files[baseFileIndex + 2] = names.getHomeTieClass();
            files[baseFileIndex + 3] = names.getHomeStubClass();
            files[baseFileIndex + 4] = names.getRemoteStubClass();
            files[baseFileIndex + 5] = names.getEjbObjectTieClass();
            ++i2;
        }
        JarFile jar = new JarFile(oldServerJar);
        int i3 = 0;
        while (i3 < files.length) {
            ZipEntry ze = jar.getEntry(files[i3].replace(File.separatorChar, '/'));
            InputStream is = jar.getInputStream(ze);
            context.getArchive().addEntry(files[i3].replace(File.separatorChar, '/'), is);
            is.close();
            ++i3;
        }
    }

    private static void addGeneratedFiles(DeploymentContext context, Vector dds, Set extraStubClasses, Vector serverFiles, Vector allClientFiles) {
        int ddIndex = 0;
        while (ddIndex < dds.size()) {
            EjbDescriptor dd2 = (EjbDescriptor)dds.elementAt(ddIndex);
            GeneratedNames names = new GeneratedNames(dd2);
            String homeStubClass = context.getOutputDirectory() + fs + names.getHomeStubClass();
            serverFiles.addElement(homeStubClass);
            allClientFiles.addElement(homeStubClass);
            String tieClassName = context.getOutputDirectory() + fs + names.getHomeTieClass();
            serverFiles.addElement(tieClassName);
            String remoteStub = context.getOutputDirectory() + fs + names.getRemoteStubClass();
            serverFiles.addElement(remoteStub);
            allClientFiles.addElement(remoteStub);
            String ejbObjectTie = context.getOutputDirectory() + fs + names.getEjbObjectTieClass();
            serverFiles.addElement(ejbObjectTie);
            ++ddIndex;
        }
        Iterator iter = extraStubClasses.iterator();
        while (iter.hasNext()) {
            String next = (String)iter.next();
            String stubFile = context.getOutputDirectory() + fs + GeneratedNames.getStubName(next).replace('.', fsc) + ".class";
            serverFiles.add(stubFile);
            allClientFiles.add(stubFile);
        }
    }

    private static boolean ddHasUniqueInterfaces(Vector deploymentDescriptors, EjbDescriptor ddToCheck) {
        boolean hasUniqueInterfaces = true;
        if (!ddToCheck.isRemoteInterfacesSupported()) {
            return false;
        }
        int i2 = 0;
        while (i2 < deploymentDescriptors.size()) {
            EjbDescriptor currentDD = (EjbDescriptor)deploymentDescriptors.elementAt(i2);
            if (currentDD.isRemoteInterfacesSupported() && currentDD.getHomeClassName().equals(ddToCheck.getHomeClassName()) && currentDD.getRemoteClassName().equals(ddToCheck.getRemoteClassName()) && currentDD.getEjbClassName().equals(ddToCheck.getEjbClassName())) {
                hasUniqueInterfaces = false;
                break;
            }
            ++i2;
        }
        return hasUniqueInterfaces;
    }

    private static String cookJar(DeploymentContext context, File original, File dst, File clientDst, Vector allServerFiles, Vector allClientFiles) throws IOException {
        String appName = context.getApplication().getName();
        DeploymentSession session = context.getSession();
        int sz = allServerFiles.size();
        int clientSz = allClientFiles.size();
        boolean index = false;
        boolean clientIndex = false;
        Vector<String> genFilesUnique = new Vector<String>();
        Vector<String> clientGenFilesUnique = new Vector<String>();
        int i2 = 0;
        while (i2 < allServerFiles.size()) {
            String nextFileToAdd = (String)allServerFiles.elementAt(i2);
            if (!genFilesUnique.contains(nextFileToAdd)) {
                genFilesUnique.addElement(nextFileToAdd);
            }
            ++i2;
        }
        int k2 = 0;
        while (k2 < allClientFiles.size()) {
            String nextFileToAdd = (String)allClientFiles.elementAt(k2);
            if (!clientGenFilesUnique.contains(nextFileToAdd)) {
                clientGenFilesUnique.addElement(nextFileToAdd);
            }
            ++k2;
        }
        GeneratorDriver.progress(localStrings.getLocalString("generator.making_server_jars", "making server JARs"), session);
        GeneratorDriver.makeJar(context, original, dst, genFilesUnique);
        GeneratorDriver.progressEvent("Server JARs made", session);
        GeneratorDriver.progress(localStrings.getLocalString("generator.making_client_jars", "making client JARs"), session);
        GeneratorDriver.makeJar(context, original, clientDst, clientGenFilesUnique);
        GeneratorDriver.progressEvent("Client JARs made", session);
        return dst.toString();
    }

    private static void makeJar(DeploymentContext context, File inputJarFile, File outputJarFile, Vector files) throws IOException {
        String appName = context.getApplication().getName();
        if (outputJarFile.exists()) {
            System.out.println("Warning: " + outputJarFile + " already exists.");
        }
        AbstractArchive newArchive = context.getArchive().copy();
        Enumeration e10 = files.elements();
        while (e10.hasMoreElements()) {
            String longName = (String)e10.nextElement();
            newArchive.addEntry(new File(longName));
        }
        newArchive.makeJar(outputJarFile);
    }

    private static boolean descriptorRequiresCodeGen(EjbDescriptor desc, File oldServerJar, File ejbJar) {
        boolean codeGenRequired = false;
        HashSet<String> allInterfaces = new HashSet<String>();
        String homeName = desc.getHomeClassName();
        String remoteName = desc.getRemoteClassName();
        String bean = desc.getEjbClassName();
        allInterfaces.add(homeName);
        allInterfaces.add(remoteName);
        allInterfaces.add(bean);
        try {
            JarClassLoader jcl = new JarClassLoader(ejbJar.toString());
            Set homeSuperInterfaces = TypeUtil.getSuperInterfaces(jcl, homeName, "javax.ejb.EJBHome");
            Set remoteSuperInterfaces = TypeUtil.getSuperInterfaces(jcl, remoteName, "javax.ejb.EJBObject");
            allInterfaces.addAll(homeSuperInterfaces);
            allInterfaces.addAll(remoteSuperInterfaces);
            Iterator iter = allInterfaces.iterator();
            while (iter.hasNext()) {
                String className = (String)iter.next();
                String entryName = className.replace('.', fsc) + ".class";
                if (FileUtil.jarEntriesEqual(oldServerJar, entryName, ejbJar, entryName)) continue;
                codeGenRequired = true;
                break;
            }
        }
        catch (Exception e10) {
            codeGenRequired = true;
        }
        return codeGenRequired;
    }

    private static boolean hasDescriptorChanged(EjbDescriptor desc, File oldServerJar, File ejbJar) {
        return true;
    }

    public static String preDeploy(DeploymentContext context, File dstJar, File clientDstJar, File oldServerJar) throws GeneratorException, ClassNotFoundException, IOException, Exception {
        Application application = context.getApplication();
        DeploymentSession session = context.getSession();
        File srcDir = context.getSourceDirectory();
        if (application == null) {
            throw new IOException("ERROR: Application object not provided");
        }
        File srcJar = application.getApplicationArchivist().getApplicationFile();
        final ClassLoader jcl = context.getClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(jcl);
                return null;
            }
        });
        Vector<EjbDescriptor> deploymentDescriptors = new Vector<EjbDescriptor>();
        HashSet<String> ejbHomeInterfaces = new HashSet<String>();
        HashSet<String> ejbRemoteInterfaces = new HashSet<String>();
        Enumeration e10 = application.getEjbDescriptors().elements();
        int ejbCount = 0;
        while (e10.hasMoreElements()) {
            ++ejbCount;
            EjbDescriptor next = (EjbDescriptor)e10.nextElement();
            if (next instanceof EjbMessageBeanDescriptor) continue;
            ejbHomeInterfaces.add(next.getHomeClassName());
            ejbRemoteInterfaces.add(next.getRemoteClassName());
            deploymentDescriptors.addElement(next);
        }
        GeneratorDriver.progress(localStrings.getLocalString("generator.processing_beans", "Processing beans..."), session);
        Vector cmpFiles = new Vector();
        int i2 = 0;
        while (i2 < deploymentDescriptors.size()) {
            EjbDescriptor desc = (EjbDescriptor)deploymentDescriptors.elementAt(i2);
            if (desc instanceof EjbCMPEntityDescriptor) {
                CMPClassGenerator gen = new CMPClassGenerator(context, desc, cmpFiles);
                GeneratorDriver.generateCode(context, gen, cmpFiles);
                String concreteClassName = ((Generator)gen).getGeneratedClass();
                EjbCMPEntityDescriptor entd = (EjbCMPEntityDescriptor)desc;
                if (entd.isEJB20()) {
                    PersistentStateGenerator pgen = new PersistentStateGenerator(context, desc, cmpFiles, concreteClassName);
                    GeneratorDriver.generateCode(context, pgen, cmpFiles);
                    entd.setStateImplClassName(((Generator)pgen).getGeneratedClass());
                }
                desc.setEjbClassName(concreteClassName);
                entd.setEjbImplementationImplClassName(concreteClassName);
            }
            ++i2;
        }
        Iterator itr = application.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor bundle = (EjbBundleDescriptor)itr.next();
            Iterator rels = bundle.getRelationships().iterator();
            while (rels.hasNext()) {
                RelationshipDescriptor rd = (RelationshipDescriptor)rels.next();
                if (rd.isOneOne()) continue;
                JoinObjectDescriptor desc = rd.getJoinDescriptor();
                if (desc == null) {
                    throw new RuntimeException("ERROR: no JoinObjectDescriptor for 1-many/many-many relationship. Possible cause: SQL generator has not been run.");
                }
                CMPClassGenerator gen = new CMPClassGenerator(context, desc, cmpFiles);
                GeneratorDriver.generateCode(context, gen, cmpFiles);
                desc.setJoinObjectClass(((Generator)gen).getGeneratedClass());
            }
        }
        GeneratorDriver.compileClasses(context, srcDir, cmpFiles);
        Vector localFiles = new Vector();
        int i3 = 0;
        while (i3 < deploymentDescriptors.size()) {
            EjbDescriptor desc = (EjbDescriptor)deploymentDescriptors.elementAt(i3);
            if (desc.isLocalInterfacesSupported()) {
                Generator gen = new HomeGenerator(context, desc, true, localFiles);
                GeneratorDriver.generateCode(context, gen, localFiles);
                desc.setLocalHomeImplClassName(gen.getGeneratedClass());
                gen = new WrapperGenerator(context, desc, true, localFiles);
                GeneratorDriver.generateCode(context, gen, localFiles);
                desc.setEJBLocalObjectImplClassName(gen.getGeneratedClass());
            }
            ++i3;
        }
        GeneratorDriver.compileClasses(context, srcDir, localFiles);
        Vector<EjbDescriptor> descriptorsEligibleForCodegen = new Vector<EjbDescriptor>();
        Vector<EjbDescriptor> duplicateDescs = new Vector<EjbDescriptor>();
        int i4 = 0;
        while (i4 < deploymentDescriptors.size()) {
            EjbDescriptor dd2 = (EjbDescriptor)deploymentDescriptors.elementAt(i4);
            if (!(dd2 instanceof EjbMessageBeanDescriptor)) {
                if (GeneratorDriver.ddHasUniqueInterfaces(descriptorsEligibleForCodegen, dd2)) {
                    descriptorsEligibleForCodegen.add(dd2);
                } else {
                    duplicateDescs.add(dd2);
                }
            }
            ++i4;
        }
        boolean reuse = true;
        if (oldServerJar != null) {
            Vector<String> existingClasses = new Vector<String>();
            int i5 = 0;
            while (i5 < descriptorsEligibleForCodegen.size()) {
                EjbDescriptor desc = (EjbDescriptor)descriptorsEligibleForCodegen.elementAt(i5);
                if (existingClasses.contains(desc.getHomeClassName()) || existingClasses.contains(desc.getRemoteClassName()) || existingClasses.contains(desc.getEjbClassName())) {
                    reuse = false;
                    break;
                }
                existingClasses.add(desc.getHomeClassName());
                existingClasses.add(desc.getRemoteClassName());
                existingClasses.add(desc.getEjbClassName());
                ++i5;
            }
        } else {
            reuse = false;
        }
        Vector<EjbDescriptor> descriptorsRequiringCodeGen = new Vector<EjbDescriptor>();
        Vector<EjbDescriptor> reusableDescriptors = new Vector<EjbDescriptor>();
        if (reuse) {
            int i6 = 0;
            while (i6 < descriptorsEligibleForCodegen.size()) {
                EjbDescriptor desc = (EjbDescriptor)descriptorsEligibleForCodegen.elementAt(i6);
                EjbBundleDescriptor bundleDesc = desc.getEjbBundleDescriptor();
                Archivist archivist = bundleDesc.getArchivist();
                File ejbJar = new File(context.getSourceDirectory(), archivist.getArchiveUri());
                if (GeneratorDriver.descriptorRequiresCodeGen(desc, oldServerJar, ejbJar)) {
                    descriptorsRequiringCodeGen.add(desc);
                } else {
                    reusableDescriptors.add(desc);
                    desc.setEJBObjectImplClassName(WrapperGenerator.getDefaultEJBObjectImplClassName(desc));
                    desc.setRemoteHomeImplClassName(HomeGenerator.getDefaultRemoteHomeImplClassName(desc));
                }
                ++i6;
            }
        } else {
            descriptorsRequiringCodeGen = descriptorsEligibleForCodegen;
        }
        HashSet<String> extraStubClasses = new HashSet<String>();
        Iterator entriesIterator = context.getArchive().iterator();
        while (entriesIterator.hasNext()) {
            String nextClassName = null;
            String entry = (String)entriesIterator.next();
            if (!entry.endsWith(".class")) continue;
            nextClassName = context.getClassName(entry);
            try {
                Class<?> nextClass = jcl.loadClass(nextClassName);
                if (!(class$javax$ejb$EJBHome == null ? GeneratorDriver.class$("javax.ejb.EJBHome") : class$javax$ejb$EJBHome).isAssignableFrom(nextClass) && !(class$javax$ejb$EJBObject == null ? GeneratorDriver.class$("javax.ejb.EJBObject") : class$javax$ejb$EJBObject).isAssignableFrom(nextClass) || ejbHomeInterfaces.contains(nextClassName) || ejbRemoteInterfaces.contains(nextClassName)) continue;
                extraStubClasses.add(nextClassName.replace('/', '.'));
            }
            catch (Throwable t2) {
                // empty catch block
            }
        }
        Vector<String> warStubClasses = new Vector<String>();
        Hashtable<String, Vector<String>> webArchivists = new Hashtable<String, Vector<String>>();
        Vector<Object> webInfs = new Vector<Object>();
        Vector<File> warTmpDirs = new Vector<File>();
        Set wars = application.getWebBundleDescriptors();
        Iterator it = wars.iterator();
        boolean warCount = false;
        while (it.hasNext()) {
            File libDir;
            WebBundleDescriptor wbd = (WebBundleDescriptor)it.next();
            WebBundleArchivist arch = (WebBundleArchivist)wbd.getArchivist();
            boolean hasEjbRef = false;
            Enumeration ejbRefs = wbd.getEjbReferences();
            while (ejbRefs.hasMoreElements()) {
                EjbReferenceDescriptor ejbRef = (EjbReferenceDescriptor)ejbRefs.nextElement();
                if (ejbRef.isLocal()) continue;
                hasEjbRef = true;
                break;
            }
            if (!hasEjbRef) continue;
            File warFile = File.createTempFile("warTMP", ".war");
            File tempDir = new File(warFile.getParent(), warFile.getName() + "DIR");
            tempDir.mkdirs();
            warTmpDirs.add(tempDir);
            Archivist.extractJarFile(new File(context.getSourceDirectory() + File.separator + arch.getArchiveUri()), tempDir);
            Vector clNames = arch.getClassNames();
            File webInfDir = new File(tempDir, "WEB-INF");
            File webInfClassDir = new File(webInfDir, "classes");
            Vector<URL> classPathUrls = new Vector<URL>();
            if (webInfClassDir.exists()) {
                classPathUrls.add(webInfClassDir.toURL());
            }
            if ((libDir = new File(webInfDir, "lib")).exists()) {
                File[] libFiles = libDir.listFiles();
                int i7 = 0;
                while (i7 < libFiles.length) {
                    if (libFiles[i7].getName().endsWith(".jar")) {
                        File jar = libFiles[i7];
                        classPathUrls.add(jar.toURL());
                        webInfs.add(jar.getAbsolutePath());
                        JarFile jarFile = new JarFile(jar);
                        Enumeration<JarEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry entry = entries.nextElement();
                            String ename = entry.getName();
                            if (!ename.endsWith(".class")) continue;
                            String className = ename.substring(0, ename.indexOf(".class"));
                            className = className.replace('/', '.');
                            clNames.add(className);
                        }
                    }
                    ++i7;
                }
            }
            URL[] urls = new URL[classPathUrls.size()];
            urls = classPathUrls.toArray(urls);
            URLClassLoader cl2 = new URLClassLoader(urls);
            int i8 = 0;
            while (i8 < clNames.size()) {
                String nextClassName = (String)clNames.elementAt(i8);
                try {
                    Class<?> nextClass = cl2.loadClass(nextClassName);
                    if (!(!(class$javax$ejb$EJBHome == null ? GeneratorDriver.class$("javax.ejb.EJBHome") : class$javax$ejb$EJBHome).isAssignableFrom(nextClass) && !(class$javax$ejb$EJBObject == null ? GeneratorDriver.class$("javax.ejb.EJBObject") : class$javax$ejb$EJBObject).isAssignableFrom(nextClass) || ejbHomeInterfaces.contains(nextClassName) || ejbRemoteInterfaces.contains(nextClassName) || extraStubClasses.contains(nextClassName))) {
                        warStubClasses.add(nextClassName);
                        webInfs.add(webInfClassDir);
                        Vector<String> stubsPerWar = (Vector<String>)webArchivists.get(arch.getArchiveUri());
                        if (stubsPerWar == null) {
                            stubsPerWar = new Vector<String>();
                        }
                        stubsPerWar.add(nextClassName);
                        webArchivists.put(arch.getArchiveUri(), stubsPerWar);
                    }
                }
                catch (Throwable t3) {
                    // empty catch block
                }
                ++i8;
            }
            warFile.delete();
        }
        Vector homeRemoteFiles = new Vector();
        int i9 = 0;
        while (i9 < descriptorsRequiringCodeGen.size()) {
            EjbDescriptor desc = (EjbDescriptor)descriptorsRequiringCodeGen.elementAt(i9);
            if (desc.isRemoteInterfacesSupported()) {
                Generator gen = new HomeGenerator(context, desc, false, homeRemoteFiles);
                GeneratorDriver.generateCode(context, gen, homeRemoteFiles);
                desc.setRemoteHomeImplClassName(gen.getGeneratedClass());
                gen = new WrapperGenerator(context, desc, false, homeRemoteFiles);
                GeneratorDriver.generateCode(context, gen, homeRemoteFiles);
                desc.setEJBObjectImplClassName(gen.getGeneratedClass());
            }
            if (session != null && session.isCancelled()) {
                return "";
            }
            ++i9;
        }
        if (ejbCount > 0) {
            GeneratorDriver.progressEvent("Ejb Code Generation complete", session);
        }
        GeneratorDriver.compileAndRmic(context, srcDir, homeRemoteFiles, extraStubClasses, webInfs, warStubClasses);
        if (reuse) {
            GeneratorDriver.processReusableGeneratedFiles(context, reusableDescriptors, homeRemoteFiles, oldServerJar);
        }
        int i10 = 0;
        while (i10 < duplicateDescs.size()) {
            int j2 = 0;
            while (j2 < descriptorsEligibleForCodegen.size()) {
                EjbDescriptor dupDD = (EjbDescriptor)duplicateDescs.elementAt(i10);
                EjbDescriptor genDD = (EjbDescriptor)descriptorsEligibleForCodegen.elementAt(j2);
                if (dupDD.isRemoteInterfacesSupported() && genDD.isRemoteInterfacesSupported() && dupDD.getHomeClassName().equals(genDD.getHomeClassName()) && dupDD.getRemoteClassName().equals(genDD.getRemoteClassName()) && dupDD.getEjbClassName().equals(genDD.getEjbClassName())) {
                    dupDD.setRemoteHomeImplClassName(genDD.getRemoteHomeImplClassName());
                    dupDD.setEJBObjectImplClassName(genDD.getEJBObjectImplClassName());
                }
                ++j2;
            }
            ++i10;
        }
        Enumeration warFileToUpdate = webArchivists.keys();
        while (warFileToUpdate.hasMoreElements()) {
            String archiveUri = (String)warFileToUpdate.nextElement();
            Vector allClasses = (Vector)webArchivists.get(archiveUri);
            File newWar = File.createTempFile("war-tmp", ".war", context.getOutputDirectory());
            FileOutputStream fos = new FileOutputStream(newWar);
            ZipOutputStream zos = new ZipOutputStream(fos);
            Archivist.addJarToOutput(zos, new JarFile(context.getSourceDirectory() + File.separator + archiveUri), new Vector());
            int i11 = 0;
            while (i11 < allClasses.size()) {
                String className = (String)allClasses.elementAt(i11);
                String stubName = GeneratedNames.getStubName(className);
                String stubFileName = stubName.replace('.', fsc) + ".class";
                File stubFile = new File(context.getOutputDirectory(), stubFileName);
                String entryName = "WEB-INF/classes/" + stubName.replace('.', '/') + ".class";
                FileInputStream fis = new FileInputStream(stubFile);
                zos.putNextEntry(new JarEntry(entryName));
                Archivist.copy(fis, zos);
                zos.closeEntry();
                fis.close();
                ++i11;
            }
            zos.close();
            File oldArchivist = new File(context.getOutputDirectory(), archiveUri);
            if (oldArchivist.exists()) {
                oldArchivist.delete();
            }
            newWar.renameTo(oldArchivist);
        }
        int i12 = 0;
        while (i12 < warTmpDirs.size()) {
            GeneratorDriver.deleteDir((File)warTmpDirs.elementAt(i12));
            ++i12;
        }
        if (session != null && session.isCancelled()) {
            return "";
        }
        Vector allClientFiles = new Vector();
        Vector allServerFiles = new Vector();
        allServerFiles.addAll(homeRemoteFiles);
        GeneratorDriver.addGeneratedFiles(context, descriptorsEligibleForCodegen, extraStubClasses, allServerFiles, allClientFiles);
        allServerFiles.addAll(cmpFiles);
        allServerFiles.addAll(localFiles);
        if (session != null && session.isCancelled()) {
            return "";
        }
        File runtimeInfo = new File(context.getOutputDirectory(), "META-INF/sun-j2ee-ri.xml");
        application.getApplicationArchivist().writeRuntimeInfo(runtimeInfo);
        context.getArchive().addEntry(runtimeInfo);
        String s2 = GeneratorDriver.cookJar(context, srcJar, dstJar, clientDstJar, allServerFiles, allClientFiles);
        return s2;
    }

    private static void deleteDir(File dir) {
        File[] files = dir.listFiles();
        int i2 = 0;
        while (i2 < files.length) {
            if (files[i2].isDirectory()) {
                GeneratorDriver.deleteDir(files[i2]);
            } else {
                files[i2].delete();
            }
            ++i2;
        }
        dir.delete();
    }

    public static void main(String[] args) {
        ORBManager.init(args, null);
        int i2 = 0;
        while (i2 < args.length) {
            try {
                String cookedJar = args[i2].substring(0, args[i2].lastIndexOf(46));
                String clientJar = cookedJar + "Client.jar";
                cookedJar = cookedJar + "Cooked.jar";
                File file = new File(cookedJar);
                File clientFile = new File(clientJar);
                String tmp = System.getProperty("user.dir");
                tmp = tmp + File.separator + "explodedTMP";
                File out = new File(tmp);
                out.mkdirs();
                JarClassLoader jcl = new JarClassLoader();
                jcl.addDir(out.toURL());
                System.out.println("Added " + out.toURL() + " to classLoader");
                Application application = ApplicationArchivist.open(new File(args[i2]), jcl);
                System.out.println(jcl.getClassPath());
                System.out.println("Saving in " + out.getAbsolutePath());
                DirectoryArchive dArchive = new DirectoryArchive(out.getAbsolutePath());
                application.getApplicationArchivist().saveInClassLoadableFormat(dArchive);
                DeploymentContext context = new DeploymentContext(dArchive, application);
                File serverFile = null;
                String serverFileName = JarRepository.getServerJarFilename(application.getName());
                if (serverFileName != null) {
                    System.out.println("Doing redeploy with " + serverFileName);
                    serverFile = new File(serverFileName);
                }
                GeneratorDriver.preDeploy(context, file, clientFile, serverFile);
            }
            catch (GeneratorException ex2) {
                System.out.println(ex2);
            }
            catch (ClassNotFoundException ex3) {
                System.err.println(ex3);
            }
            catch (IOException ex4) {
                System.err.println(ex4);
            }
            catch (Exception ex5) {
                ex5.printStackTrace();
            }
            ++i2;
        }
        System.exit(0);
    }

    private static void progress(String message, DeploymentSession session) {
        if (session != null) {
            try {
                session.setStatusMessage(message);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void progressEvent(String eventType, DeploymentSession session) {
        if (session != null) {
            try {
                session.notification(new NotificationEvent("", eventType, ""));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class GeneratedNames {
        private String homeImplClass;
        private String homeTieClass;
        private String homeStubClass;
        private String remoteStubClass;
        private String ejbObjectTieClass;
        private String ejbObjectImplClass;

        static String getStubName(String fullName) {
            String className = fullName;
            String packageName = "";
            int lastDot = fullName.lastIndexOf(46);
            if (lastDot != -1) {
                className = fullName.substring(lastDot + 1, fullName.length());
                packageName = fullName.substring(0, lastDot + 1);
            }
            String stubName = packageName + "_" + className + "_Stub";
            if (fullName.startsWith(GeneratorDriver.COM_SUN_PREFIX)) {
                stubName = GeneratorDriver.ORG_OMG_STUB_PREFIX + stubName;
            }
            return stubName;
        }

        private String getTieName(String fullName) {
            String className = fullName;
            String packageName = "";
            int lastDot = fullName.lastIndexOf(46);
            if (lastDot != -1) {
                className = fullName.substring(lastDot + 1, fullName.length());
                packageName = fullName.substring(0, lastDot + 1);
            }
            String tieName = packageName + "_" + className + "_Tie";
            if (fullName.startsWith(GeneratorDriver.COM_SUN_PREFIX)) {
                tieName = GeneratorDriver.ORG_OMG_STUB_PREFIX + tieName;
            }
            return tieName;
        }

        public GeneratedNames(EjbDescriptor desc) {
            this.ejbObjectImplClass = desc.getEJBObjectImplClassName().replace('.', fsc) + ".class";
            this.ejbObjectTieClass = this.getTieName(desc.getEJBObjectImplClassName()).replace('.', fsc) + ".class";
            this.homeImplClass = desc.getRemoteHomeImplClassName().replace('.', fsc) + ".class";
            this.homeTieClass = this.getTieName(desc.getRemoteHomeImplClassName()).replace('.', fsc) + ".class";
            this.homeStubClass = GeneratedNames.getStubName(desc.getHomeClassName()).replace('.', fsc) + ".class";
            this.remoteStubClass = GeneratedNames.getStubName(desc.getRemoteClassName()).replace('.', fsc) + ".class";
        }

        public String getEjbObjectImplClass() {
            return this.ejbObjectImplClass;
        }

        public String getHomeImplClass() {
            return this.homeImplClass;
        }

        public String getHomeTieClass() {
            return this.homeTieClass;
        }

        public String getHomeStubClass() {
            return this.homeStubClass;
        }

        public String getRemoteStubClass() {
            return this.remoteStubClass;
        }

        public String getEjbObjectTieClass() {
            return this.ejbObjectTieClass;
        }
    }
}

