/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.Container;
import com.sun.ejb.ContainerFactory;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.BeanContext;
import com.sun.ejb.containers.ContainerSynchronization;
import com.sun.ejb.containers.EntityContainer;
import com.sun.ejb.containers.MessageBeanContainer;
import com.sun.ejb.containers.PMTransactionManagerImpl;
import com.sun.ejb.containers.RecyclerImpl;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.containers.StatelessSessionContainer;
import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.log.Log;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.ejb.NoSuchObjectLocalException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public final class ContainerFactoryImpl
implements ContainerFactory {
    private static final boolean debug = false;
    public static final byte HOME_KEY = -1;
    public static final byte[] homeInstanceKey = new byte[]{-1};
    private PMTransactionManagerImpl pmtm;
    private RecyclerImpl recycler;
    private Hashtable syncTable = new Hashtable();
    private Hashtable containers = new Hashtable();
    private ThreadLocal threadLocalContext = new ThreadLocal();
    private Hashtable txBeanTable = new Hashtable();

    public ContainerFactoryImpl() {
        this.recycler = new RecyclerImpl(this);
        this.pmtm = new PMTransactionManagerImpl();
    }

    public TransactionManager getTransactionMgr() {
        return this.pmtm;
    }

    RecyclerImpl getRecycler() {
        return this.recycler;
    }

    public Container createContainer(EjbDescriptor ejbDescriptor, ClassLoader loader, SecurityManager sm) throws Exception {
        BaseContainer container = null;
        boolean hasHome = true;
        try {
            if (ejbDescriptor instanceof EjbSessionDescriptor) {
                EjbSessionDescriptor sd = (EjbSessionDescriptor)ejbDescriptor;
                container = sd.isStateless() ? new StatelessSessionContainer(ejbDescriptor, loader) : new StatefulSessionContainer(ejbDescriptor, loader);
            } else if (ejbDescriptor instanceof EjbMessageBeanDescriptor) {
                container = new MessageBeanContainer(ejbDescriptor, loader);
                hasHome = false;
            } else {
                container = new EntityContainer(ejbDescriptor, loader);
                ((EntityContainer)container).setTxBeanTable(this.txBeanTable);
            }
            this.containers.put(new Long(ejbDescriptor.getUniqueId()), container);
            container.setSecurityManager(sm);
            if (hasHome) {
                container.initializeHome();
            }
            return container;
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
            throw ex2;
        }
    }

    public Container getContainer(long ejbId) {
        return (Container)this.containers.get(new Long(ejbId));
    }

    public void removeContainer(long ejbId) {
        this.containers.remove(new Long(ejbId));
    }

    public Enumeration listContainers() {
        return this.containers.elements();
    }

    public Remote getTargetObject(long ejbId, byte[] instanceKey) {
        final BaseContainer container = (BaseContainer)this.containers.get(new Long(ejbId));
        if (container == null) {
            throw new NoSuchObjectLocalException("Bean does not exist");
        }
        BeanContext bc2 = new BeanContext();
        final Thread currentThread = Thread.currentThread();
        bc2.previousClassLoader = currentThread.getContextClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                currentThread.setContextClassLoader(container.getClassLoader());
                return null;
            }
        });
        Stack<BeanContext> beanContextStack = (Stack<BeanContext>)this.threadLocalContext.get();
        if (beanContextStack == null) {
            beanContextStack = new Stack<BeanContext>();
            this.threadLocalContext.set(beanContextStack);
        }
        beanContextStack.push(bc2);
        Remote target = instanceKey.length == 1 && instanceKey[0] == -1 ? container.getEJBHome() : container.getEJBObject(instanceKey);
        return target;
    }

    public void releaseTargetObject(Remote remoteObj) {
        try {
            Stack beanContextStack = (Stack)this.threadLocalContext.get();
            final BeanContext bc2 = (BeanContext)beanContextStack.pop();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread.currentThread().setContextClassLoader(bc2.previousClassLoader);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public EjbDescriptor getEjbDescriptor(long ejbId) {
        Container c10 = (Container)this.containers.get(new Long(ejbId));
        if (c10 == null) {
            return null;
        }
        return c10.getEjbDescriptor();
    }

    ContainerSynchronization getContainerSync(Transaction tx) throws RollbackException, SystemException {
        ContainerSynchronization sync = (ContainerSynchronization)this.syncTable.get(tx);
        if (sync == null) {
            sync = new ContainerSynchronization(tx, this);
            tx.registerSynchronization(sync);
            this.syncTable.put(tx, sync);
        }
        return sync;
    }

    void removeContainerSync(Transaction tx) {
        this.syncTable.remove(tx);
        this.txBeanTable.remove(tx);
    }
}

