/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.ComponentContext;
import com.sun.ejb.Invocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.EJBObjectImpl;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.StatefulSessionStore;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.util.Utility;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionSynchronization;
import javax.rmi.PortableRemoteObject;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public final class StatefulSessionContainer
extends BaseContainer {
    static final int PASSIVE = 1;
    static final int READY = 2;
    static final int INVOKING = 3;
    static final int INCOMPLETE_TX = 4;
    static final int DESTROYED = 5;
    private long instanceCount = 1L;
    private StatefulSessionStore statefulBeanStore = new StatefulSessionStore();

    protected StatefulSessionContainer(EjbDescriptor desc, ClassLoader loader) throws Exception {
        super(desc, loader);
    }

    boolean isIdentical(EJBObjectImpl ejbo, EJBObject other) throws RemoteException {
        if (other == ejbo) {
            return true;
        }
        try {
            return this.protocolMgr.isIdentical(ejbo.getStub(), other);
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
            throw new RemoteException("Error during isIdentical.", ex2);
        }
    }

    EJBObject createEJBObject() throws CreateException, RemoteException {
        try {
            SessionContextImpl context = this.createBeanInstance();
            EJBObjectImpl ejbo = this.createEJBObject(context);
            context.setState(2);
            return ejbo;
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
            if (ex2 instanceof EJBException) {
                throw (EJBException)ex2;
            }
            throw new CreateException("ERROR creating stateful SessionBean: " + ex2);
        }
    }

    EJBLocalObject createEJBLocalObject() throws CreateException {
        try {
            SessionContextImpl context = this.createBeanInstance();
            EJBLocalObjectImpl localObj = this.createEJBLocalObject(context);
            context.setState(2);
            return localObj;
        }
        catch (Exception ex2) {
            Log.err.println(ex2);
            if (ex2 instanceof EJBException) {
                throw (EJBException)ex2;
            }
            throw new CreateException("ERROR creating stateful SessionBean: " + ex2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SessionContextImpl createBeanInstance() throws Exception {
        SessionContextImpl sessionContextImpl;
        ComponentInvocation ci2 = null;
        try {
            SessionBean ejb = (SessionBean)this.ejbClass.newInstance();
            SessionContextImpl context = new SessionContextImpl(ejb, this);
            ci2 = new ComponentInvocation(ejb, this);
            this.invocationManager.preInvoke(ci2);
            ejb.setSessionContext(context);
            context.touch();
            Long instanceKey = this.createNewInstanceKey();
            this.statefulBeanStore.storeEJB(instanceKey, context);
            context.setInstanceKey(instanceKey);
            this.recycler.initSoftRef(context);
            sessionContextImpl = context;
            Object var7_6 = null;
            if (ci2 == null) return sessionContextImpl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (ci2 == null) throw throwable;
            this.invocationManager.postInvoke(ci2);
            throw throwable;
        }
        this.invocationManager.postInvoke(ci2);
        return sessionContextImpl;
    }

    private Long createNewInstanceKey() {
        long key;
        StatefulSessionContainer statefulSessionContainer = this;
        synchronized (statefulSessionContainer) {
            key = this.instanceCount++;
        }
        return new Long(key);
    }

    private EJBLocalObjectImpl createEJBLocalObject(SessionContextImpl context) throws Exception {
        if (context.getEJBLocalObjectImpl() != null) {
            return context.getEJBLocalObjectImpl();
        }
        EJBLocalObjectImpl localObj = (EJBLocalObjectImpl)this.localEjbObjectClass.newInstance();
        localObj.setContainer(this);
        context.setEJBLocalObjectImpl(localObj);
        localObj.setContext(context);
        localObj.setKey(context.getInstanceKey());
        if (this.isRemote) {
            this.createEJBObject(context);
        }
        return localObj;
    }

    private EJBObjectImpl createEJBObject(SessionContextImpl context) throws Exception {
        if (context.getEJBObjectImpl() != null) {
            return context.getEJBObjectImpl();
        }
        EJBObjectImpl ejbo = (EJBObjectImpl)this.ejbObjectClass.newInstance();
        ejbo.setContainer(this);
        context.setEJBObjectImpl(ejbo);
        ejbo.setContext(context);
        Long lkey = (Long)context.getInstanceKey();
        ejbo.setKey(lkey);
        byte[] instanceKey = new byte[8];
        Utility.longToBytes(lkey, instanceKey, 0);
        Object stub = this.protocolMgr.createReference(ejbo, this.ejbDescriptor.getUniqueId(), instanceKey);
        EJBObject ejbStub = (EJBObject)PortableRemoteObject.narrow((Object)stub, (Class)this.remoteIntf);
        context.setEJBStub(ejbStub);
        ejbo.setStub(ejbStub);
        if (this.isLocal) {
            this.createEJBLocalObject(context);
        }
        return ejbo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeBean(EJBLocalRemoteObject ejbo, Method removeMethod, boolean local) throws RemoveException, EJBException {
        Invocation i2;
        block11: {
            i2 = new Invocation();
            i2.ejbObject = ejbo;
            i2.isLocal = local;
            i2.method = removeMethod;
            try {
                try {
                    this.preInvoke(i2);
                    this.removeBean(i2);
                }
                catch (Exception e10) {
                    Log.err.println(e10);
                    i2.exception = e10;
                    Object var7_6 = null;
                    if (AppVerification.doInstrument()) {
                        AppVerification.getInstrumentLogger().doInstrumentForEjb(this.ejbDescriptor, this.ejbRemoveMethod, i2.exception);
                    }
                    this.postInvoke(i2);
                    break block11;
                }
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (AppVerification.doInstrument()) {
                    AppVerification.getInstrumentLogger().doInstrumentForEjb(this.ejbDescriptor, this.ejbRemoveMethod, i2.exception);
                }
                this.postInvoke(i2);
                throw throwable;
            }
            if (AppVerification.doInstrument()) {
                AppVerification.getInstrumentLogger().doInstrumentForEjb(this.ejbDescriptor, this.ejbRemoveMethod, i2.exception);
            }
            this.postInvoke(i2);
        }
        if (i2.exception == null) {
            return;
        }
        if (i2.exception instanceof RemoveException) {
            throw (RemoveException)i2.exception;
        }
        if (i2.exception instanceof RuntimeException) {
            throw (RuntimeException)i2.exception;
        }
        if (i2.exception instanceof Exception) {
            throw new EJBException((Exception)i2.exception);
        }
        throw new EJBException(i2.exception.getMessage());
    }

    private void removeBean(Invocation inv) throws RemoveException {
        try {
            SessionContextImpl sc = (SessionContextImpl)inv.context;
            Transaction tc = sc.getTransaction();
            if (tc != null && tc.getStatus() != 6) {
                throw new RemoveException("Cannot remove EJB: transaction in progress");
            }
            SessionBean sb = (SessionBean)sc.getEJB();
            sb.ejbRemove();
            this.forceDestroyBean(sc);
        }
        catch (EJBException ex2) {
            Log.err.println(ex2);
            throw ex2;
        }
        catch (RemoveException ex3) {
            Log.err.println(ex3);
            throw ex3;
        }
        catch (Exception ex4) {
            Log.err.println(ex4);
            throw new EJBException(ex4);
        }
    }

    void forceDestroyBean(EJBContextImpl ctx) {
        SessionContextImpl sc;
        SessionContextImpl sessionContextImpl = sc = (SessionContextImpl)ctx;
        synchronized (sessionContextImpl) {
            if (sc.getState() == 5) {
                return;
            }
            sc.setState(5);
            Transaction prevTx = sc.getTransaction();
            try {
                if (prevTx != null && prevTx.getStatus() != 6) {
                    prevTx.setRollbackOnly();
                }
            }
            catch (SystemException ex2) {
                throw new EJBException(ex2);
            }
            catch (IllegalStateException ex3) {
                throw new EJBException(ex3);
            }
            Long instanceKey = (Long)sc.getInstanceKey();
            this.statefulBeanStore.deleteEJB(instanceKey);
            if (this.isRemote) {
                EJBObjectImpl ejbo = sc.getEJBObjectImpl();
                ejbo.clearContext();
                ejbo.setRemoved(true);
                sc.setEJBObjectImpl(null);
                this.protocolMgr.destroyReference(ejbo, this.ejbDescriptor.getUniqueId());
            }
            if (this.isLocal) {
                EJBLocalObjectImpl localObj = sc.getEJBLocalObjectImpl();
                localObj.clearContext();
                localObj.setRemoved(true);
                sc.setEJBLocalObjectImpl(null);
            }
            this.transactionManager.componentDestroyed(sc.getEJB());
        }
    }

    Enumeration listActiveEJBs() {
        return this.statefulBeanStore.listActiveEJBs();
    }

    void timeoutBeans(int timeout) {
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        Enumeration beans = this.statefulBeanStore.listActiveEJBs();
        while (beans.hasMoreElements()) {
            try {
                EJBContextImpl ctx = (EJBContextImpl)beans.nextElement();
                int lastUsage = (int)(ctx.getLastTimeUsed() / 1000L);
                if (timeout <= 0 || currentTime - lastUsage <= timeout) continue;
                EJBContextImpl eJBContextImpl = ctx;
                synchronized (eJBContextImpl) {
                    if (ctx.getState() != 3) {
                        try {
                            SessionBean sb = (SessionBean)ctx.getEJB();
                            sb.ejbRemove();
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                        this.forceDestroyBean(ctx);
                    }
                }
            }
            catch (Exception ex3) {
                // empty catch block
            }
        }
    }

    EJBObject getEJBObject(byte[] instanceKey) {
        Long lkey = new Long(Utility.bytesToLong(instanceKey, 0));
        SessionContextImpl sc = this.statefulBeanStore.lookupEJB(lkey, this, null);
        if (sc == null) {
            throw new NoSuchObjectLocalException("The EJB does not exist.");
        }
        SessionContextImpl sessionContextImpl = sc;
        synchronized (sessionContextImpl) {
            if (sc.getState() == 1 && ((sc = this.statefulBeanStore.lookupEJB(lkey, this, null)) == null || sc.getEJBObjectImpl() == null)) {
                throw new NoSuchObjectLocalException("The EJB does not exist.");
            }
            EJBObjectImpl eJBObjectImpl = sc.getEJBObjectImpl();
            return eJBObjectImpl;
        }
    }

    EJBLocalObjectImpl getEJBLocalObject(Object key) {
        Long lkey = (Long)key;
        SessionContextImpl sc = this.statefulBeanStore.lookupEJB(lkey, this, null);
        if (sc == null || sc.getState() == 5) {
            try {
                EJBLocalObjectImpl localObj = (EJBLocalObjectImpl)this.localEjbObjectClass.newInstance();
                localObj.setContainer(this);
                localObj.setKey(key);
                localObj.setRemoved(true);
                return localObj;
            }
            catch (Exception ex2) {
                throw new EJBException(ex2);
            }
        }
        return sc.getEJBLocalObjectImpl();
    }

    void checkExists(EJBLocalRemoteObject ejbObj) {
        if (ejbObj.isRemoved()) {
            throw new NoSuchObjectLocalException("Bean has been removed");
        }
    }

    public ComponentContext getContext(Invocation inv) {
        EJBLocalRemoteObject ejbo = inv.ejbObject;
        SessionContextImpl sc = ejbo.getContext();
        Long key = (Long)ejbo.getKey();
        if (sc == null) {
            sc = this.statefulBeanStore.lookupEJB(key, this, ejbo);
        }
        if (sc == null || sc.getState() == 5) {
            throw new NoSuchObjectLocalException("The EJB does not exist.");
        }
        SessionContextImpl sessionContextImpl = sc;
        synchronized (sessionContextImpl) {
            if (sc.getState() == 1) {
                sc = this.statefulBeanStore.lookupEJB(key, this, ejbo);
            }
            SessionContextImpl sessionContextImpl2 = sc;
            synchronized (sessionContextImpl2) {
                if (sc.getState() == 5) {
                    throw new NoSuchObjectLocalException("The EJB does not exist.");
                }
                if (sc.getState() == 3) {
                    throw new EJBException("SessionBean is executing another request");
                }
                sc.setState(3);
            }
        }
        sc.touch();
        return sc;
    }

    public void releaseContext(Invocation inv) {
        SessionContextImpl sc = (SessionContextImpl)inv.context;
        if (sc.getState() == 5) {
            return;
        }
        Transaction tx = sc.getTransaction();
        try {
            if (tx == null || tx.getStatus() == 6) {
                if (sc.getState() != 2) {
                    sc.setState(2);
                    if (sc.isAfterCompletionDelayed()) {
                        this.callEjbAfterCompletion(sc, sc.getCompletedTxStatus());
                    }
                }
            } else {
                sc.setState(4);
            }
        }
        catch (SystemException ex2) {
            throw new EJBException(ex2);
        }
    }

    void afterBegin(EJBContextImpl context) {
        if (this.isBeanManagedTran) {
            return;
        }
        EnterpriseBean ejb = context.getEJB();
        if (ejb instanceof SessionSynchronization) {
            SessionSynchronization sync = (SessionSynchronization)((Object)ejb);
            try {
                sync.afterBegin();
            }
            catch (Exception ex2) {
                this.forceDestroyBean(context);
                throw new EJBException("Error during SessionSynchronization.afterBegin(), EJB instance discarded");
            }
        }
    }

    void beforeCompletion(EJBContextImpl context) {
        if (this.isBeanManagedTran) {
            return;
        }
        EnterpriseBean ejb = context.getEJB();
        if (!(ejb instanceof SessionSynchronization)) {
            return;
        }
        ComponentInvocation ci2 = new ComponentInvocation(ejb, this);
        this.invocationManager.preInvoke(ci2);
        try {
            try {
                this.transactionManager.enlistComponentResources();
                ((SessionSynchronization)((Object)ejb)).beforeCompletion();
            }
            catch (Exception ex2) {
                try {
                    this.forceDestroyBean(context);
                }
                catch (Exception e10) {
                    // empty catch block
                }
                throw new EJBException("Error during SessionSynchronization.beforeCompletion, EJB instance discarded");
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.invocationManager.postInvoke(ci2);
            throw throwable;
        }
        this.invocationManager.postInvoke(ci2);
    }

    void afterCompletion(EJBContextImpl context, int status) {
        if (context.getState() == 5) {
            return;
        }
        SessionContextImpl sc = (SessionContextImpl)context;
        EnterpriseBean ejb = sc.getEJB();
        boolean committed = status == 3 || status == 6;
        sc.setTransaction(null);
        if (!this.isBeanManagedTran && ejb instanceof SessionSynchronization) {
            if (sc.getState() == 3 && !sc.isTxCompleting()) {
                sc.setAfterCompletionDelayed(true);
                sc.setCompletedTxStatus(committed);
                return;
            }
            this.callEjbAfterCompletion(sc, committed);
        }
        sc.setState(2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void callEjbAfterCompletion(SessionContextImpl context, boolean status) {
        EnterpriseBean ejb = context.getEJB();
        ComponentInvocation ci2 = new ComponentInvocation(ejb, this);
        this.invocationManager.preInvoke(ci2);
        try {
            try {
                ((SessionSynchronization)((Object)ejb)).afterCompletion(status);
                context.setAfterCompletionDelayed(false);
                context.setTxCompleting(false);
            }
            catch (Exception ex2) {
                try {
                    this.forceDestroyBean(context);
                }
                catch (Exception e10) {
                    // empty catch block
                }
                Log.err.println(ex2);
                Object var8_6 = null;
                this.invocationManager.postInvoke(ci2);
                return;
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.invocationManager.postInvoke(ci2);
            throw throwable;
        }
        this.invocationManager.postInvoke(ci2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void passivateEJB(ComponentContext context) {
        SessionContextImpl sc = (SessionContextImpl)context;
        if (sc.getState() == 5) {
            return;
        }
        if (!this.statefulBeanStore.isPassivationEnabled()) {
            return;
        }
        SessionBean ejb = (SessionBean)sc.getEJB();
        ComponentInvocation ci2 = new ComponentInvocation(ejb, this);
        this.invocationManager.preInvoke(ci2);
        boolean success = false;
        SessionContextImpl sessionContextImpl = sc;
        synchronized (sessionContextImpl) {
            block15: {
                try {
                    block14: {
                        try {
                            if (sc.getState() != 2) break block14;
                            sc.setState(1);
                            ejb.ejbPassivate();
                            if (this.isRemote) {
                                EJBObjectImpl ejbo = sc.getEJBObjectImpl();
                                ejbo.clearContext();
                                sc.setEJBObjectImpl(null);
                                this.protocolMgr.destroyReference(ejbo, this.ejbDescriptor.getUniqueId());
                            }
                            if (this.isLocal) {
                                EJBLocalObjectImpl localObj = sc.getEJBLocalObjectImpl();
                                localObj.clearContext();
                                sc.setEJBLocalObjectImpl(null);
                            }
                            success = true;
                        }
                        catch (Exception ex2) {
                            try {
                                this.forceDestroyBean(sc);
                            }
                            catch (Exception e10) {
                            }
                            Object var10_11 = null;
                            this.invocationManager.postInvoke(ci2);
                            break block15;
                        }
                    }
                    Object var10_10 = null;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    this.invocationManager.postInvoke(ci2);
                    throw throwable;
                }
                this.invocationManager.postInvoke(ci2);
            }
            System.err.println("success = " + success);
            if (success) {
                boolean saved = this.statefulBeanStore.passivateEJB(sc, (Long)sc.getInstanceKey());
                if (saved) return;
                this.activateEJB(sc, (Long)sc.getInstanceKey(), null);
            } else {
                if (sc.getState() == 5) return;
                this.recycler.initSoftRef(sc);
            }
            return;
        }
    }

    void activateEJB(SessionContextImpl context, Long lkey, EJBLocalRemoteObject ejbObject) {
        SessionBean ejb = (SessionBean)context.getEJB();
        ComponentInvocation ci2 = new ComponentInvocation(ejb, this);
        this.invocationManager.preInvoke(ci2);
        try {
            try {
                context.touch();
                context.setContainer(this);
                context.setState(2);
                context.setInstanceKey(lkey);
                if (ejbObject == null) {
                    this.createEJBObject(context);
                } else if (ejbObject instanceof EJBObjectImpl) {
                    context.setEJBObjectImpl((EJBObjectImpl)ejbObject);
                    ejbObject.setContext(context);
                    ejbObject.setKey(lkey);
                    if (this.isLocal) {
                        this.createEJBLocalObject(context);
                    }
                } else if (ejbObject instanceof EJBLocalObjectImpl) {
                    context.setEJBLocalObjectImpl((EJBLocalObjectImpl)ejbObject);
                    ejbObject.setContext(context);
                    ejbObject.setKey(lkey);
                    if (this.isRemote) {
                        this.createEJBObject(context);
                    }
                }
                ejb.ejbActivate();
                this.recycler.initSoftRef(context);
            }
            catch (Exception ex2) {
                throw new EJBException("Unable to activate EJB");
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.invocationManager.postInvoke(ci2);
            throw throwable;
        }
        this.invocationManager.postInvoke(ci2);
    }

    public void undeploy() {
        this.undeployed = true;
        Enumeration elements = this.statefulBeanStore.listActiveEJBs();
        while (elements.hasMoreElements()) {
            SessionContextImpl ctx = (SessionContextImpl)elements.nextElement();
            if (ctx.getContainer() != this) continue;
            this.protocolMgr.destroyReference(ctx.getEJBObjectImpl(), this.ejbDescriptor.getUniqueId());
            this.statefulBeanStore.deleteEJB((Long)ctx.getInstanceKey());
            this.transactionManager.componentDestroyed(ctx.getEJB());
        }
        this.statefulBeanStore = null;
        super.undeploy();
    }
}

