/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.AbstractSchemaName;
import com.sun.ejb.ejbql.BinaryOperator;
import com.sun.ejb.ejbql.BinaryOperatorExpression;
import com.sun.ejb.ejbql.CmrField;
import com.sun.ejb.ejbql.CollectionIdentificationVar;
import com.sun.ejb.ejbql.EjbQLQuery;
import com.sun.ejb.ejbql.Element;
import com.sun.ejb.ejbql.Expression;
import com.sun.ejb.ejbql.ExpressionBase;
import com.sun.ejb.ejbql.FromClause;
import com.sun.ejb.ejbql.IdentificationVar;
import com.sun.ejb.ejbql.Literal;
import com.sun.ejb.ejbql.NavigationExpression;
import com.sun.ejb.ejbql.NavigationOperator;
import com.sun.ejb.ejbql.NullExpression;
import com.sun.ejb.ejbql.Operator;
import com.sun.ejb.ejbql.OperatorExpression;
import com.sun.ejb.ejbql.RelationshipInfo;
import com.sun.ejb.ejbql.SelectClause;
import com.sun.ejb.ejbql.SelectField;
import com.sun.ejb.ejbql.Symbol;
import com.sun.ejb.ejbql.UnaryOperator;
import com.sun.ejb.ejbql.UnaryOperatorExpression;
import com.sun.ejb.ejbql.VisitorAdapter;
import com.sun.ejb.ejbql.WhereClause;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class CodeGeneratingVisitor
extends VisitorAdapter {
    private static final boolean debug = false;
    private EjbQLQuery query_;
    private StringBuffer sqlString_;
    private StringBuffer selectString_;
    private StringBuffer fromString_;
    private StringBuffer whereString_;
    private StringBuffer derivedConditionsString_;
    private Hashtable tableAliasPaths_;
    private Hashtable joinTableAliasPaths_;
    private Hashtable joinPathExprs_;
    private Hashtable fromClauseEntries_;
    private int tempTableAliasIndex_;
    private static final String SPACE = " ";
    private static final String PATH_EXPR_NAME_SEP = ".";
    private static final String TEMP_ALIAS_ROOT = "@tmp";
    private static final String ESCAPE_FUNCTION_BEGIN = "{fn ";
    private static final String ESCAPE_FUNCTION_END = "}";
    private int numSimpleConditionalExpr;

    public CodeGeneratingVisitor(EjbQLQuery query) {
        super(1);
        this.query_ = query;
        this.selectString_ = new StringBuffer();
        this.fromString_ = new StringBuffer();
        this.whereString_ = new StringBuffer();
        this.derivedConditionsString_ = new StringBuffer();
        this.tableAliasPaths_ = new Hashtable();
        this.joinPathExprs_ = new Hashtable();
        this.joinTableAliasPaths_ = new Hashtable();
        this.fromClauseEntries_ = new Hashtable();
        AbstractSchemaName schemaForThisPersistentObj = this.query_.getAbstractSchema();
        ListIterator childrenPass1 = this.query_.getFromClause().getChildren(this.getTraversalType());
        while (childrenPass1.hasNext()) {
            IdentificationVar next = (IdentificationVar)childrenPass1.next();
            String identVarName = next.getName();
            this.addTableToFromClause(next.getTableName(), this.surroundWithQuotes(identVarName));
        }
        ListIterator childrenPass2 = this.query_.getFromClause().getChildren(this.getTraversalType());
        while (childrenPass2.hasNext()) {
            IdentificationVar next = (IdentificationVar)childrenPass2.next();
            if (!next.isCollectionIdentVar()) continue;
            CollectionIdentificationVar collectionIdentVar = (CollectionIdentificationVar)next;
            NavigationExpression navExpr = collectionIdentVar.getNavigationExpression();
            String exprPath = this.getNavExprPrefix(navExpr);
            String identVarName = next.getName();
            this.tableAliasPaths_.put(exprPath, this.surroundWithQuotes(identVarName));
            this.processPathExpr(navExpr);
        }
        this.numSimpleConditionalExpr = 0;
        if (this.query_.hasWhereClause()) {
            WhereClause whereClause = this.query_.getWhereClause();
            SimpleConditionalExprVisitor visitor = new SimpleConditionalExprVisitor();
            List simpleConditionalExpr = visitor.getSimpleConditionalExpressions(whereClause);
            this.numSimpleConditionalExpr = simpleConditionalExpr.size();
        }
    }

    public String generateSql() {
        this.tempTableAliasIndex_ = 1;
        this.query_.accept(this);
        if (this.whereString_.length() > 0) {
            this.whereString_.insert(0, "WHERE ");
            if (this.derivedConditionsString_.length() > 0) {
                this.derivedConditionsString_.insert(0, " AND ");
            }
        } else if (this.derivedConditionsString_.length() > 0) {
            this.derivedConditionsString_.insert(0, "WHERE ");
        }
        String sqlQuery = this.selectString_.toString() + this.fromString_.toString() + this.whereString_.toString() + this.derivedConditionsString_.toString();
        return sqlQuery;
    }

    private void processPathExpr(NavigationExpression navigationExpr) {
        this.processPathExpr(navigationExpr, this.derivedConditionsString_);
    }

    private void processPathExpr(NavigationExpression navigationExpr, StringBuffer output) {
        ListIterator children = navigationExpr.getChildren(this.getTraversalType());
        IdentificationVar identVar = (IdentificationVar)children.next();
        String pathToSymbol = new String(identVar.getName());
        ExpressionBase source = identVar;
        String sourceTable = this.surroundWithQuotes(identVar.getName());
        StringBuffer entirePathExprJoin = new StringBuffer();
        int numJoinsForPathExpr = 0;
        while (children.hasNext()) {
            String joinString;
            NavigationOperator nextOp = (NavigationOperator)children.next();
            Symbol nextSymbol = (Symbol)children.next();
            if (nextSymbol.isCmpField()) break;
            CmrField sink = (CmrField)nextSymbol;
            if (!children.hasNext() && !sink.hasJoinTable()) break;
            pathToSymbol = pathToSymbol + PATH_EXPR_NAME_SEP + nextSymbol.getName();
            boolean newJoin = true;
            String sinkTable = null;
            if (this.tableAliasPaths_.containsKey(pathToSymbol)) {
                if (this.joinPathExprs_.containsKey(pathToSymbol)) {
                    newJoin = false;
                }
                sinkTable = (String)this.tableAliasPaths_.get(pathToSymbol);
            } else {
                sinkTable = this.generateTempTableAlias();
                this.tableAliasPaths_.put(pathToSymbol, sinkTable);
                this.addTableToFromClause(nextSymbol.getTableName(), sinkTable);
            }
            RelationshipInfo relInfo = new RelationshipInfo(sink);
            if (newJoin) {
                String joinTable = null;
                if (sink.hasJoinTable()) {
                    joinTable = this.generateTempTableAlias();
                    this.joinTableAliasPaths_.put(pathToSymbol, joinTable);
                    this.addTableToFromClause(relInfo.getJoinTableName(), joinTable);
                }
                joinString = this.generateJoin(relInfo, sourceTable, joinTable, sinkTable);
                this.joinPathExprs_.put(pathToSymbol, joinString);
            } else {
                joinString = (String)this.joinPathExprs_.get(pathToSymbol);
            }
            if (numJoinsForPathExpr > 0) {
                entirePathExprJoin.append(" AND ");
            }
            ++numJoinsForPathExpr;
            entirePathExprJoin.append(joinString);
            if (!children.hasNext()) continue;
            source = sink;
            sourceTable = sinkTable;
        }
        if (numJoinsForPathExpr > 0) {
            this.parenthesize(entirePathExprJoin);
            if (output.length() > 0) {
                output.append(" AND ");
            }
            output.append(entirePathExprJoin.toString());
        }
    }

    private int countJoins(NavigationExpression navigationExpr) {
        ListIterator children = navigationExpr.getChildren(this.getTraversalType());
        IdentificationVar identVar = (IdentificationVar)children.next();
        int numJoinsForPathExpr = 0;
        while (children.hasNext()) {
            NavigationOperator nextOp = (NavigationOperator)children.next();
            Symbol nextSymbol = (Symbol)children.next();
            if (nextSymbol.isCmpField()) break;
            CmrField sink = (CmrField)nextSymbol;
            if (!children.hasNext() && !sink.hasJoinTable()) break;
            ++numJoinsForPathExpr;
        }
        return numJoinsForPathExpr;
    }

    public void visitSelectClause(SelectClause selectClause) {
        this.sqlString_ = this.selectString_;
        this.sqlString_.append("SELECT ");
        Expression expr = selectClause.getExpression();
        String tableAlias = null;
        Iterator fieldNames = null;
        if (expr.isOperatorExpression()) {
            OperatorExpression opExpr = (OperatorExpression)expr;
            Operator operator = opExpr.getOperator();
            if (operator.isUnary()) {
                this.sqlString_.append("* ");
                return;
            }
            BinaryOperatorExpression selectFieldExpr = (BinaryOperatorExpression)opExpr;
            NavigationExpression navExpr = (NavigationExpression)selectFieldExpr.getFirstExpression();
            SelectField selectField = (SelectField)selectFieldExpr.getSecondExpression();
            tableAlias = this.getTableAliasFromNavExpr(navExpr);
            HashSet<String> fields = new HashSet<String>();
            fields.add(selectField.getFieldName());
            fieldNames = fields.iterator();
        }
        if (this.query_.hasDistinctResults()) {
            this.sqlString_.append("DISTINCT ");
        }
        if (tableAlias == null) {
            if (expr.isNavigationExpression()) {
                NavigationExpression navExpr = (NavigationExpression)expr;
                this.processPathExpr(navExpr);
                tableAlias = this.getTableAliasFromNavExpr(navExpr);
                fieldNames = navExpr.getFieldNames();
                if (navExpr.endsInCmrField() && !navExpr.getLastExpressionCmr().hasJoinTable()) {
                    this.addNotNullChecks(navExpr);
                }
            } else {
                IdentificationVar identVar = (IdentificationVar)expr;
                tableAlias = this.getTableAliasFromIdentVar(identVar);
                fieldNames = identVar.getFieldNames();
            }
        }
        while (fieldNames.hasNext()) {
            String next = (String)fieldNames.next();
            this.sqlString_.append(tableAlias + PATH_EXPR_NAME_SEP + next + SPACE);
            if (!fieldNames.hasNext()) continue;
            this.sqlString_.append(", ");
        }
    }

    public void visitFromClause(FromClause fromClause) {
    }

    public void visitWhereClause(WhereClause whereClause) {
        this.sqlString_ = this.whereString_;
        super.visitWhereClause(whereClause);
    }

    public void visitLikeExpression(OperatorExpression expression) {
        this.visitOperatorExpression(expression);
    }

    public void visitEmptyCollectionExpression(OperatorExpression expression) {
        UnaryOperatorExpression emptyCollectionExpr = (UnaryOperatorExpression)expression;
        UnaryOperator emptyOperator = (UnaryOperator)emptyCollectionExpr.getOperator();
        NavigationExpression navExpr = (NavigationExpression)emptyCollectionExpr.getExpression();
        String subQueryString = this.generateSubQuery(navExpr);
        this.sqlString_.append("( ");
        if (emptyOperator.equals(UnaryOperator.IS_EMPTY)) {
            this.sqlString_.append("NOT EXISTS ");
        } else {
            this.sqlString_.append("EXISTS ");
        }
        this.sqlString_.append("(" + subQueryString + ")");
        this.sqlString_.append(")");
    }

    public void visitNullComparisonExpression(OperatorExpression expression) {
        UnaryOperatorExpression nullCompExpr = (UnaryOperatorExpression)expression;
        UnaryOperator nullCompOperator = (UnaryOperator)nullCompExpr.getOperator();
        NavigationExpression navExpr = (NavigationExpression)nullCompExpr.getExpression();
        Symbol endSymbol = navExpr.getLastExpression();
        StringBuffer sqlForIsNull = new StringBuffer();
        if (endSymbol.isCmrField() && ((CmrField)endSymbol).hasJoinTable()) {
            String subQueryString = this.generateSubQuery(navExpr);
            if (nullCompOperator.equals(UnaryOperator.IS_NULL)) {
                sqlForIsNull.append("NOT EXISTS ");
            } else {
                sqlForIsNull.append("EXISTS ");
            }
            sqlForIsNull.append("( " + subQueryString + " ) ");
        } else {
            if (this.exprNeedsIsolation(nullCompExpr)) {
                String subQueryString = this.generateSimpleConditionSubQuery(nullCompExpr);
                this.sqlString_.append(" EXISTS (" + subQueryString + ") ");
                return;
            }
            this.processPathExpr(navExpr, sqlForIsNull);
            if (sqlForIsNull.length() > 0) {
                sqlForIsNull.append(" AND ");
            }
            String operatorString = (String)nullCompExpr.getPrintStrings().next();
            String tableAlias = this.getTableAliasFromNavExpr(navExpr);
            Iterator fieldNames = navExpr.getFieldNames();
            int fieldCount = 0;
            while (fieldNames.hasNext()) {
                String next = (String)fieldNames.next();
                ++fieldCount;
                sqlForIsNull.append(tableAlias + PATH_EXPR_NAME_SEP + next + SPACE);
                sqlForIsNull.append(operatorString + SPACE);
                if (!fieldNames.hasNext()) continue;
                sqlForIsNull.append("AND ");
            }
        }
        this.parenthesize(sqlForIsNull);
        this.sqlString_.append(sqlForIsNull.toString());
    }

    private String generateSimpleConditionSubQuery(OperatorExpression opExpr) {
        EjbQLQuery subQuery = new EjbQLQuery(this.query_.getPersistenceDescriptor(), this.query_.getQueryMethod(), true);
        UnaryOperatorExpression selectAll = new UnaryOperatorExpression(new NullExpression(), UnaryOperator.SELECT_ALL);
        subQuery.setSelectClause(new SelectClause(selectAll));
        subQuery.setWhereClause(new WhereClause(opExpr));
        CodeGeneratingVisitor subQueryCodeGenerator = new CodeGeneratingVisitor(subQuery);
        String subQueryString = subQueryCodeGenerator.generateSql();
        return subQueryString;
    }

    private String generateSubQuery(NavigationExpression navExpr) {
        IdentificationVar mainIdentVar = navExpr.getFirstExpression();
        UnaryOperatorExpression selectAll = new UnaryOperatorExpression(mainIdentVar, UnaryOperator.SELECT_ALL);
        return this.generateSubQuery(navExpr, new SelectClause(selectAll));
    }

    private String generateSubQuery(NavigationExpression navExpr, SelectClause selectClause) {
        EjbQLQuery subQuery = new EjbQLQuery(this.query_.getPersistenceDescriptor(), this.query_.getQueryMethod(), true);
        IdentificationVar mainIdentVar = navExpr.getFirstExpression();
        subQuery.setSelectClause(selectClause);
        FromClause fromClause = subQuery.getFromClause();
        fromClause.addIdentVar(new CollectionIdentificationVar("@_" + mainIdentVar.getName(), navExpr));
        CodeGeneratingVisitor subQueryCodeGenerator = new CodeGeneratingVisitor(subQuery);
        String subQueryString = subQueryCodeGenerator.generateSql();
        return subQueryString;
    }

    public void visitInExpression(OperatorExpression expression) {
        BinaryOperatorExpression inExpr = (BinaryOperatorExpression)expression;
        if (this.exprNeedsIsolation(inExpr)) {
            String subQueryString = this.generateSimpleConditionSubQuery(inExpr);
            this.sqlString_.append(" EXISTS (" + subQueryString + ") ");
            return;
        }
        BinaryOperator inOperator = (BinaryOperator)inExpr.getOperator();
        NavigationExpression navExpr = (NavigationExpression)inExpr.getFirstExpression();
        Expression stringAggregation = inExpr.getSecondExpression();
        this.visitNavigationExpression(navExpr);
        ListIterator children = stringAggregation.getChildren(this.getTraversalType());
        this.sqlString_.append((inOperator.equals(BinaryOperator.IN_STRINGS) ? "IN" : "NOT IN") + " (");
        while (children.hasNext()) {
            Expression next = (Expression)children.next();
            next.accept(this);
            if (!children.hasNext()) continue;
            this.sqlString_.append(" , ");
        }
        this.sqlString_.append(")");
    }

    public void visitMemberOfExpression(OperatorExpression expression) {
        BinaryOperatorExpression memberOfExpr = (BinaryOperatorExpression)expression;
        BinaryOperator memberOfOperator = (BinaryOperator)expression.getOperator();
        Expression firstExpr = memberOfExpr.getFirstExpression();
        NavigationExpression secondExpr = (NavigationExpression)memberOfExpr.getSecondExpression();
        if (firstExpr.isNavigationExpression() && this.exprNeedsIsolation(memberOfExpr, (NavigationExpression)firstExpr)) {
            String subQueryString = this.generateSimpleConditionSubQuery(memberOfExpr);
            this.sqlString_.append(" EXISTS (" + subQueryString + ") ");
            return;
        }
        StringBuffer sqlForMemberOf = new StringBuffer();
        String firstExprTableAlias = null;
        Iterator firstExprFieldNames = null;
        if (firstExpr.isNavigationExpression()) {
            NavigationExpression navExpr = (NavigationExpression)firstExpr;
            this.processPathExpr(navExpr, sqlForMemberOf);
            if (sqlForMemberOf.length() > 0) {
                sqlForMemberOf.append(" AND ");
            }
            firstExprTableAlias = this.getTableAliasFromNavExpr(navExpr);
            firstExprFieldNames = navExpr.getFieldNames();
        } else if (firstExpr.isIdentificationVar()) {
            IdentificationVar identVar = (IdentificationVar)firstExpr;
            firstExprTableAlias = this.getTableAliasFromIdentVar(identVar);
            firstExprFieldNames = identVar.getFieldNames();
        }
        Iterator secondExprFieldNames = secondExpr.getFieldNames();
        while (secondExprFieldNames.hasNext()) {
            String leftSide = firstExprTableAlias == null ? "?" : firstExprTableAlias + PATH_EXPR_NAME_SEP + firstExprFieldNames.next();
            sqlForMemberOf.append(leftSide + SPACE);
            sqlForMemberOf.append(memberOfOperator.equals(BinaryOperator.MEMBER_OF) ? "IN " : "NOT IN ");
            SelectField selectField = new SelectField((String)secondExprFieldNames.next());
            BinaryOperatorExpression subQueryExpr = new BinaryOperatorExpression(secondExpr, selectField, BinaryOperator.SELECT_FIELD);
            String subQuery = this.generateSubQuery(secondExpr, new SelectClause(subQueryExpr));
            sqlForMemberOf.append(this.parenthesize(subQuery));
            if (!secondExprFieldNames.hasNext()) continue;
            sqlForMemberOf.append(" AND ");
        }
        this.parenthesize(sqlForMemberOf);
        this.sqlString_.append(sqlForMemberOf.toString());
    }

    public void visitNavigationExpression(NavigationExpression navigationExpr) {
        this.processPathExpr(navigationExpr);
        String tableAlias = this.getTableAliasFromNavExpr(navigationExpr);
        String fieldName = (String)navigationExpr.getFieldNames().next();
        this.sqlString_.append(tableAlias);
        this.sqlString_.append(NavigationOperator.CMP_OP.getPrintString());
        this.sqlString_.append(fieldName + SPACE);
    }

    public void visitOperatorExpression(OperatorExpression operatorExpression) {
        Operator operator = operatorExpression.getOperator();
        Iterator operatorPrintStrings = operatorExpression.getPrintStrings();
        ListIterator children = operatorExpression.getChildren(this.getTraversalType());
        if (this.exprNeedsIsolation(operatorExpression)) {
            String subQueryString = this.generateSimpleConditionSubQuery(operatorExpression);
            this.sqlString_.append(" EXISTS (" + subQueryString + ") ");
            return;
        }
        this.sqlString_.append("(");
        if (operator.isFunction()) {
            String firstOperatorString = (String)operatorPrintStrings.next();
            this.sqlString_.append(ESCAPE_FUNCTION_BEGIN);
            this.sqlString_.append(firstOperatorString);
            this.sqlString_.append("(");
            while (children.hasNext()) {
                Expression next = (Expression)children.next();
                next.accept(this);
                if (!children.hasNext()) continue;
                this.sqlString_.append(" , ");
            }
            this.sqlString_.append(") }");
        } else if (operator.isUnary()) {
            UnaryOperator unaryOperator = (UnaryOperator)operator;
            Expression expression = (Expression)children.next();
            String firstOperatorString = (String)operatorPrintStrings.next();
            if (unaryOperator.isPreOperator()) {
                this.sqlString_.append(firstOperatorString + SPACE);
                expression.accept(this);
            } else {
                expression.accept(this);
                this.sqlString_.append(SPACE + firstOperatorString);
            }
        } else {
            boolean persistentObjectComparison = false;
            if (operator.equals(BinaryOperator.EQUAL) || operator.equals(BinaryOperator.NOT_EQUAL)) {
                BinaryOperatorExpression binaryOpExpr = (BinaryOperatorExpression)operatorExpression;
                Expression firstExpr = binaryOpExpr.getFirstExpression();
                Expression secondExpr = binaryOpExpr.getSecondExpression();
                if (firstExpr.isIdentificationVar() || firstExpr.isNavigationExpression() && ((NavigationExpression)firstExpr).endsInCmrField()) {
                    this.generatePersistentObjectComparisonSQL(binaryOpExpr);
                    persistentObjectComparison = true;
                }
            }
            if (!persistentObjectComparison) {
                while (children.hasNext()) {
                    Expression next = (Expression)children.next();
                    next.accept(this);
                    if (!operatorPrintStrings.hasNext()) continue;
                    this.sqlString_.append(SPACE + operatorPrintStrings.next() + SPACE);
                }
            }
        }
        this.sqlString_.append(")");
    }

    private boolean exprNeedsIsolation(OperatorExpression operatorExpr, NavigationExpression navExpr) {
        return operatorExpr.isSimpleCondition() && this.numSimpleConditionalExpr > 1 && !this.query_.isSubQuery() && this.countJoins(navExpr) > 0;
    }

    private boolean exprNeedsIsolation(OperatorExpression operatorExpr) {
        boolean isolate = false;
        if (operatorExpr.isSimpleCondition() && this.numSimpleConditionalExpr > 1 && !this.query_.isSubQuery()) {
            NavigationExpressionVisitor visitor = new NavigationExpressionVisitor();
            List navExprs = visitor.getNavigationExpressions(operatorExpr);
            Iterator iter = navExprs.iterator();
            while (iter.hasNext()) {
                NavigationExpression next = (NavigationExpression)iter.next();
                if (this.countJoins(next) <= 0) continue;
                isolate = true;
                break;
            }
        }
        return isolate;
    }

    public void visitLiteral(Literal literal) {
        this.sqlString_.append(literal.toSql() + SPACE);
    }

    public void visitSymbol(Symbol symbol) {
        this.sqlString_.append(symbol.toSql() + SPACE);
    }

    private String getTableAliasFromIdentVar(IdentificationVar identVar) {
        String tableAlias;
        if (identVar.isRangeIdentVar()) {
            tableAlias = this.surroundWithQuotes(identVar.getName());
        } else {
            CollectionIdentificationVar collectionIdentVar = (CollectionIdentificationVar)identVar;
            NavigationExpression navExpr = collectionIdentVar.getNavigationExpression();
            tableAlias = this.getTableAliasFromNavExpr(navExpr);
        }
        return tableAlias;
    }

    private String getTableAliasFromNavExpr(NavigationExpression navExpr) {
        String navExprPrefix = this.getNavExprPrefix(navExpr);
        String tableAlias = this.surroundWithQuotes(navExprPrefix);
        Symbol lastSymbol = navExpr.getLastExpression();
        if (lastSymbol.isCmrField() && ((CmrField)lastSymbol).hasJoinTable()) {
            if (this.joinTableAliasPaths_.containsKey(navExprPrefix)) {
                tableAlias = (String)this.joinTableAliasPaths_.get(navExprPrefix);
            }
        } else if (this.tableAliasPaths_.containsKey(navExprPrefix)) {
            tableAlias = (String)this.tableAliasPaths_.get(navExprPrefix);
        }
        return tableAlias;
    }

    private String getTableNameFromNavExpr(NavigationExpression navExpr) {
        String tableAlias = this.getTableAliasFromNavExpr(navExpr);
        return (String)this.fromClauseEntries_.get(tableAlias);
    }

    private String getNavExprPrefix(NavigationExpression navigationExpr) {
        ListIterator children = navigationExpr.getChildren(this.getTraversalType());
        IdentificationVar identVar = (IdentificationVar)children.next();
        StringBuffer prefix = new StringBuffer(identVar.getName());
        while (children.hasNext()) {
            NavigationOperator nextOp = (NavigationOperator)children.next();
            Symbol nextSymbol = (Symbol)children.next();
            if (!children.hasNext() && (!nextSymbol.isCmrField() || !((CmrField)nextSymbol).hasJoinTable())) continue;
            prefix.append(PATH_EXPR_NAME_SEP + nextSymbol.getName());
        }
        return prefix.toString();
    }

    private void addNotNullChecks(NavigationExpression navExpr) {
        StringBuffer isNotNullCheckCode = new StringBuffer();
        String tableAlias = this.getTableAliasFromNavExpr(navExpr);
        Iterator fieldNames = navExpr.getFieldNames();
        String isNotNullOpStr = UnaryOperator.IS_NOT_NULL.getPrintString();
        while (fieldNames.hasNext()) {
            String next = (String)fieldNames.next();
            if (isNotNullCheckCode.length() > 0) {
                isNotNullCheckCode.append("AND ");
            }
            isNotNullCheckCode.append(tableAlias + PATH_EXPR_NAME_SEP + next + SPACE + isNotNullOpStr + SPACE);
        }
        this.parenthesize(isNotNullCheckCode);
        if (this.derivedConditionsString_.length() > 0) {
            this.derivedConditionsString_.append(" AND ");
        }
        this.derivedConditionsString_.append(isNotNullCheckCode.toString());
    }

    /*
     * Unable to fully structure code
     */
    private String generateJoin(RelationshipInfo relationshipInfo, String sourceTable, String joinTable, String sinkTable) {
        block4: {
            sourceFields = relationshipInfo.getSourceFields();
            sinkFields = relationshipInfo.getSinkFields();
            thisJoin = new StringBuffer();
            if (!relationshipInfo.hasJoinTable()) ** GOTO lbl30
            joinSourceFields = relationshipInfo.getJoinSourceFields();
            joinSinkFields = relationshipInfo.getJoinSinkFields();
            if (sinkTable == null) ** GOTO lbl24
            while (joinSourceFields.hasNext()) {
                this.join(sourceTable, (String)sourceFields.next(), joinTable, (String)joinSourceFields.next(), thisJoin);
                thisJoin.append(" AND ");
            }
            while (joinSinkFields.hasNext()) {
                this.join(joinTable, (String)joinSinkFields.next(), sinkTable, (String)sinkFields.next(), thisJoin);
                if (!joinSinkFields.hasNext()) continue;
                thisJoin.append(" AND ");
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                this.join(sourceTable, (String)sourceFields.next(), joinTable, (String)joinSourceFields.next(), thisJoin);
                if (!joinSourceFields.hasNext()) continue;
                thisJoin.append(" AND ");
lbl24:
                // 3 sources

                ** while (joinSourceFields.hasNext())
            }
lbl25:
            // 1 sources

            break block4;
lbl-1000:
            // 1 sources

            {
                this.join(sourceTable, (String)sourceFields.next(), sinkTable, (String)sinkFields.next(), thisJoin);
                if (!sourceFields.hasNext()) continue;
                thisJoin.append(" AND ");
lbl30:
                // 3 sources

                ** while (sourceFields.hasNext())
            }
        }
        this.parenthesize(thisJoin);
        return thisJoin.toString();
    }

    private void join(String sourceTable, String sourceColumn, String sinkTable, String sinkColumn, StringBuffer buffer) {
        buffer.append(sourceTable + PATH_EXPR_NAME_SEP + sourceColumn);
        buffer.append(" = ");
        buffer.append(sinkTable + PATH_EXPR_NAME_SEP + sinkColumn);
    }

    private void generatePersistentObjectComparisonSQL(BinaryOperatorExpression binaryOpExpr) {
        Expression firstExpr = binaryOpExpr.getFirstExpression();
        Expression secondExpr = binaryOpExpr.getSecondExpression();
        String tableAlias1 = null;
        String tableAlias2 = null;
        Iterator fieldNames1 = new HashSet().iterator();
        Iterator fieldNames2 = new HashSet().iterator();
        StringBuffer pObjCompSql = new StringBuffer();
        StringBuffer joins = new StringBuffer();
        if (firstExpr.isNavigationExpression()) {
            NavigationExpression navExpr1 = (NavigationExpression)firstExpr;
            this.processPathExpr(navExpr1, joins);
            tableAlias1 = this.getTableAliasFromNavExpr(navExpr1);
            fieldNames1 = navExpr1.getFieldNames();
        } else {
            IdentificationVar identVar1 = (IdentificationVar)firstExpr;
            tableAlias1 = this.getTableAliasFromIdentVar(identVar1);
            fieldNames1 = identVar1.getFieldNames();
        }
        if (secondExpr.isNavigationExpression()) {
            NavigationExpression navExpr2 = (NavigationExpression)secondExpr;
            this.processPathExpr(navExpr2, joins);
            tableAlias2 = this.getTableAliasFromNavExpr(navExpr2);
            fieldNames2 = navExpr2.getFieldNames();
        } else if (secondExpr.isIdentificationVar()) {
            IdentificationVar identVar2 = (IdentificationVar)secondExpr;
            tableAlias2 = this.getTableAliasFromIdentVar(identVar2);
            fieldNames2 = identVar2.getFieldNames();
        }
        String operatorString = (String)binaryOpExpr.getPrintStrings().next();
        int fieldCount = 0;
        while (fieldNames1.hasNext() || fieldNames2.hasNext()) {
            if (fieldCount > 0) {
                pObjCompSql.append("AND ");
            }
            ++fieldCount;
            String nextField1 = (String)fieldNames1.next();
            pObjCompSql.append(tableAlias1 + PATH_EXPR_NAME_SEP + nextField1 + SPACE);
            pObjCompSql.append(operatorString + SPACE);
            if (tableAlias2 == null) {
                pObjCompSql.append("? ");
                continue;
            }
            String nextField2 = (String)fieldNames2.next();
            pObjCompSql.append(tableAlias2 + PATH_EXPR_NAME_SEP + nextField2 + SPACE);
        }
        if (fieldCount > 1) {
            this.parenthesize(pObjCompSql);
        }
        if (joins.length() > 0) {
            pObjCompSql.append(" AND " + joins.toString());
        }
        this.parenthesize(pObjCompSql);
        this.sqlString_.append(pObjCompSql.toString());
    }

    private String generateTempTableAlias() {
        String tempTableAlias = TEMP_ALIAS_ROOT + this.tempTableAliasIndex_;
        ++this.tempTableAliasIndex_;
        return this.surroundWithQuotes(tempTableAlias);
    }

    private String parenthesize(String buffer) {
        return "(" + buffer + ")";
    }

    private void parenthesize(StringBuffer buffer) {
        if (buffer.length() > 0) {
            buffer.insert(0, "(");
            buffer.append(")");
        }
    }

    private String surroundWithQuotes(String name) {
        return "\"" + name + "\"";
    }

    private void addTableToFromClause(String tableName, String tableAlias) {
        if (this.fromString_.length() > 0) {
            this.fromString_.append(", ");
        } else {
            this.fromString_.insert(0, "FROM ");
        }
        this.fromString_.append(tableName);
        if (!tableName.endsWith(SPACE)) {
            this.fromString_.append(SPACE);
        }
        this.fromString_.append(tableAlias + SPACE);
        this.fromClauseEntries_.put(tableAlias, tableName);
    }

    private static class SimpleConditionalExprVisitor
    extends VisitorAdapter {
        private List simpleConditionalExpressions_ = new LinkedList();

        public SimpleConditionalExprVisitor() {
            super(1);
        }

        public List getSimpleConditionalExpressions(Element element) {
            this.simpleConditionalExpressions_ = new LinkedList();
            element.accept(this);
            return this.simpleConditionalExpressions_;
        }

        public void visitOperatorExpression(OperatorExpression operatorExpr) {
            if (operatorExpr.isSimpleCondition()) {
                this.simpleConditionalExpressions_.add(operatorExpr);
            } else {
                super.visitOperatorExpression(operatorExpr);
            }
        }
    }

    private static class NavigationExpressionVisitor
    extends VisitorAdapter {
        private List navigationExpressions_ = new LinkedList();

        public NavigationExpressionVisitor() {
            super(1);
        }

        public List getNavigationExpressions(Element element) {
            this.navigationExpressions_ = new LinkedList();
            element.accept(this);
            return this.navigationExpressions_;
        }

        public void visitNavigationExpression(NavigationExpression navigationExpr) {
            this.navigationExpressions_.add(navigationExpr);
        }
    }
}

