/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.AbstractSchemaName;
import com.sun.ejb.ejbql.BinaryOperator;
import com.sun.ejb.ejbql.BinaryOperatorExpression;
import com.sun.ejb.ejbql.BooleanLiteral;
import com.sun.ejb.ejbql.CmpField;
import com.sun.ejb.ejbql.CmrField;
import com.sun.ejb.ejbql.EjbQLQuery;
import com.sun.ejb.ejbql.Expression;
import com.sun.ejb.ejbql.IdentificationVar;
import com.sun.ejb.ejbql.InputParam;
import com.sun.ejb.ejbql.Literal;
import com.sun.ejb.ejbql.NavigationExpression;
import com.sun.ejb.ejbql.Operator;
import com.sun.ejb.ejbql.OperatorExpression;
import com.sun.ejb.ejbql.QueryParam;
import com.sun.ejb.ejbql.SelectClause;
import com.sun.ejb.ejbql.VisitorAdapter;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import java.lang.reflect.Field;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class RuntimeInfoVisitor
extends VisitorAdapter {
    private static final boolean debug = false;
    private EjbQLQuery query_;
    private PersistentFieldInfo cmpFieldInfo_;
    private PersistenceDescriptor ejbObjReturnDesc_;
    private List queryParams_;

    public RuntimeInfoVisitor(EjbQLQuery query) {
        super(1);
        this.query_ = query;
        this.queryParams_ = new Vector();
        this.cmpFieldInfo_ = null;
        this.ejbObjReturnDesc_ = null;
    }

    public void generateRuntimeInfo() {
        this.query_.accept(this);
    }

    public boolean getReturnsCmpField() {
        return this.cmpFieldInfo_ != null;
    }

    public boolean getReturnsEjb() {
        return this.ejbObjReturnDesc_ != null;
    }

    public int getCmpFieldReturnJdbcType() {
        if (!this.getReturnsCmpField()) {
            throw new IllegalStateException();
        }
        return this.cmpFieldInfo_.jdbcType;
    }

    public PersistenceDescriptor getEjbDescriptor() {
        if (!this.getReturnsEjb()) {
            throw new IllegalStateException();
        }
        return this.ejbObjReturnDesc_;
    }

    public Class getQueryMethodReturnType() throws Exception {
        return this.query_.getQueryMethodReturnType();
    }

    public boolean getQueryMethodReturnsSingleValue() {
        return this.query_.queryMethodReturnsSingleValue();
    }

    public boolean getQueryMethodReturnsCollection() {
        return this.query_.queryMethodReturnsCollection();
    }

    public boolean getQueryMethodReturnsSet() {
        return this.query_.queryMethodReturnsSet();
    }

    public boolean hasLocalReturnTypeMapping() {
        if (this.query_.isSelectQuery() && this.getReturnsEjb()) {
            return this.query_.hasLocalReturnTypeMapping();
        }
        throw new IllegalStateException("only applicable for select queries returning ejbs");
    }

    public boolean hasRemoteReturnTypeMapping() {
        return !this.hasLocalReturnTypeMapping();
    }

    public boolean getQueryHasDistinctResults() {
        return this.query_.hasDistinctResults();
    }

    public Class getReturnObjectType() throws Exception {
        Class<?> returnObjType = this.getQueryMethodReturnType();
        if (!this.getQueryMethodReturnsSingleValue()) {
            if (this.getReturnsCmpField()) {
                returnObjType = this.cmpFieldInfo_.type;
            } else if (this.getReturnsEjb()) {
                String returnTypeClassName = this.query_.getQueryReturnType();
                ClassLoader loader = this.query_.getEjbBundleClassLoader();
                returnObjType = loader.loadClass(returnTypeClassName);
            }
        }
        return returnObjType;
    }

    public List getQueryParams() {
        return this.queryParams_;
    }

    public void visitMemberOfExpression(OperatorExpression opExpression) {
        BinaryOperatorExpression binaryOpExpr = (BinaryOperatorExpression)opExpression;
        Expression firstExpr = binaryOpExpr.getFirstExpression();
        if (firstExpr.isInputParam()) {
            NavigationExpression secondExpr = (NavigationExpression)binaryOpExpr.getSecondExpression();
            AbstractSchemaName schema = secondExpr.getAbstractSchema();
            this.addPersistentObjectQueryParams((InputParam)firstExpr, schema.getPersDescriptor());
        }
    }

    public void visitOperatorExpression(OperatorExpression opExpression) {
        Operator operator = opExpression.getOperator();
        ListIterator iter = opExpression.getChildren(this.getTraversalType());
        boolean persistentObjectComparison = false;
        if (operator.equals(BinaryOperator.EQUAL) || operator.equals(BinaryOperator.NOT_EQUAL)) {
            BinaryOperatorExpression binaryOpExpr = (BinaryOperatorExpression)opExpression;
            Expression firstExpr = binaryOpExpr.getFirstExpression();
            Expression secondExpr = binaryOpExpr.getSecondExpression();
            if (secondExpr.isInputParam()) {
                if (firstExpr.isIdentificationVar()) {
                    IdentificationVar identVar = (IdentificationVar)firstExpr;
                    AbstractSchemaName abstractSchema = identVar.getAbstractSchema();
                    this.addPersistentObjectQueryParams((InputParam)secondExpr, abstractSchema.getPersDescriptor());
                    persistentObjectComparison = true;
                } else if (firstExpr.isNavigationExpression() && ((NavigationExpression)firstExpr).endsInCmrField()) {
                    NavigationExpression navExpr = (NavigationExpression)firstExpr;
                    CmrField cmrField = navExpr.getLastExpressionCmr();
                    this.addPersistentObjectQueryParams((InputParam)secondExpr, cmrField.getSinkPersistenceDescriptor());
                    persistentObjectComparison = true;
                }
            }
        }
        if (!persistentObjectComparison) {
            super.visitOperatorExpression(opExpression);
        }
    }

    private void addPersistentObjectQueryParams(InputParam inputParam, PersistenceDescriptor persistenceDesc) {
        int paramIndex = inputParam.getParamIndex();
        PersistentFieldInfo[] pkeyFieldInfo = persistenceDesc.getPkeyFieldInfo();
        int i2 = 0;
        while (i2 < pkeyFieldInfo.length) {
            QueryParam queryParam = new QueryParam(2);
            queryParam.setParamIndex(paramIndex);
            queryParam.setPersistenceDescriptor(persistenceDesc);
            if (!persistenceDesc.primaryKeyIsOneField()) {
                Field[] pkeyClassPkeyFields = persistenceDesc.getPkeyClassFields();
                if (pkeyClassPkeyFields != null) {
                    queryParam.setPkeyClassField(pkeyClassPkeyFields[i2]);
                } else {
                    System.out.println("Warning -- pkey class pkey fields not available for " + persistenceDesc.getName());
                }
            }
            this.queryParams_.add(queryParam);
            ++i2;
        }
    }

    public void visitLiteral(Literal literal) {
        QueryParam queryParam = null;
        if (literal.isInputParam()) {
            InputParam inputParam = (InputParam)literal;
            queryParam = new QueryParam(1);
            queryParam.setParamIndex(inputParam.getParamIndex());
        } else if (literal instanceof BooleanLiteral) {
            BooleanLiteral booleanLiteral = (BooleanLiteral)literal;
            queryParam = new QueryParam(3);
            queryParam.setBooleanValue((Boolean)booleanLiteral.getLiteral());
        }
        if (queryParam != null) {
            this.queryParams_.add(queryParam);
        }
    }

    public void visitSelectClause(SelectClause selectClause) {
        Expression selectExpr = selectClause.getExpression();
        NavigationExpression navExpr = null;
        if (selectExpr.isNavigationExpression()) {
            navExpr = (NavigationExpression)selectExpr;
            if (navExpr.endsInCmpField()) {
                CmpField cmpField = navExpr.getLastExpressionCmp();
                this.cmpFieldInfo_ = cmpField.getPersistentFieldInfo();
            } else {
                PersistenceDescriptor persistenceDesc;
                CmrField cmrField = navExpr.getLastExpressionCmr();
                this.ejbObjReturnDesc_ = persistenceDesc = cmrField.getSinkPersistenceDescriptor();
            }
        } else {
            IdentificationVar identVar = (IdentificationVar)selectExpr;
            AbstractSchemaName schema = identVar.getAbstractSchema();
            this.ejbObjReturnDesc_ = schema.getPersDescriptor();
        }
    }
}

