/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.AbstractSchemaName;
import com.sun.ejb.ejbql.EjbQLQuery;
import com.sun.ejb.ejbql.Element;
import com.sun.ejb.ejbql.Expression;
import com.sun.ejb.ejbql.FromClause;
import com.sun.ejb.ejbql.IdentificationVar;
import com.sun.ejb.ejbql.NavigationExpression;
import com.sun.ejb.ejbql.NavigationOperator;
import com.sun.ejb.ejbql.Operator;
import com.sun.ejb.ejbql.OperatorExpression;
import com.sun.ejb.ejbql.PrintingVisitor;
import com.sun.ejb.ejbql.SelectClause;
import com.sun.ejb.ejbql.UnaryOperator;
import com.sun.ejb.ejbql.UnaryOperatorExpression;
import com.sun.ejb.ejbql.VisitorAdapter;
import com.sun.ejb.ejbql.parser.ParseException;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;

public class ValidatingVisitor
extends VisitorAdapter {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$ejb$ejbql$ValidatingVisitor == null ? (class$com$sun$ejb$ejbql$ValidatingVisitor = ValidatingVisitor.class$("com.sun.ejb.ejbql.ValidatingVisitor")) : class$com$sun$ejb$ejbql$ValidatingVisitor);
    private EjbQLQuery query_;
    private List errors_;
    private PrintingVisitor printer_;
    private boolean foundTypeError_;
    private Vector ejbAbstractSchemaClasses_;
    static /* synthetic */ Class class$com$sun$ejb$ejbql$ValidatingVisitor;

    public ValidatingVisitor(EjbQLQuery query) {
        super(1);
        this.query_ = query;
        this.printer_ = new PrintingVisitor(query);
        this.ejbAbstractSchemaClasses_ = new Vector();
        this.init();
    }

    private void init() {
        EjbBundleDescriptor bundle = this.query_.getEjbBundleDescriptor();
        Set ejbs = bundle.getEjbs();
        Iterator iter = ejbs.iterator();
        while (iter.hasNext()) {
            EjbCMPEntityDescriptor cmpDescriptor;
            EjbDescriptor next = (EjbDescriptor)iter.next();
            if (!(next instanceof EjbCMPEntityDescriptor) || !(cmpDescriptor = (EjbCMPEntityDescriptor)next).isEJB20()) continue;
            this.ejbAbstractSchemaClasses_.add(cmpDescriptor.getEjbClassName());
        }
    }

    public List validate(Element element) {
        this.errors_ = new Vector();
        this.foundTypeError_ = false;
        element.accept(this);
        return this.errors_;
    }

    public void visitQuery(EjbQLQuery query) {
        super.visitQuery(query);
    }

    public void visitSelectClause(SelectClause selectClause) {
        Expression selectExpr = selectClause.getExpression();
        if (this.query_.isFinderQuery()) {
            AbstractSchemaName abstractSchema = null;
            if (selectExpr.isIdentificationVar()) {
                abstractSchema = ((IdentificationVar)selectExpr).getAbstractSchema();
            } else if (selectExpr.isNavigationExpression()) {
                NavigationExpression navExpr = (NavigationExpression)selectExpr;
                AbstractSchemaName abstractSchemaName = abstractSchema = navExpr.endsInCmrField() ? navExpr.getAbstractSchema() : null;
            }
            if (abstractSchema == null || !abstractSchema.equals(this.query_.getAbstractSchema())) {
                String error = localStrings.getLocalString("ValidatingVisitor.returntypemismatch", "");
                this.errors_.add(new ParseException(error));
                return;
            }
        }
        Class queryMethodReturnType = this.query_.getQueryMethodReturnType();
        String queryReturnType = this.query_.getQueryReturnType();
        this.validateReturnType(queryMethodReturnType, queryReturnType);
        super.visitSelectClause(selectClause);
    }

    public void visitFromClause(FromClause fromClause) {
        super.visitFromClause(fromClause);
    }

    private void validateReturnType(Class queryMethodReturnType, String queryReturnTypeName) {
        String queryMethodReturnTypeName;
        if (this.query_.queryMethodReturnsSingleValue() && !queryReturnTypeName.equals(queryMethodReturnTypeName = queryMethodReturnType.getName())) {
            boolean valid = false;
            ClassLoader loader = this.query_.getEjbBundleClassLoader();
            try {
                Class<?> queryReturnType = loader.loadClass(queryReturnTypeName);
                valid = queryMethodReturnType.isAssignableFrom(queryReturnType);
            }
            catch (ClassNotFoundException cnfe) {
                valid = false;
            }
            if (!valid) {
                String error = localStrings.getLocalString("ValidatingVisitor.selecttypemismatch", "");
                this.errors_.add(new ParseException(error));
            }
        }
    }

    public void visitNavigationExpression(NavigationExpression navigationExpr) {
        ListIterator children = navigationExpr.getChildren(this.getTraversalType());
        IdentificationVar identVar = (IdentificationVar)children.next();
        while (children.hasNext()) {
            Expression expression;
            NavigationOperator operator = (NavigationOperator)children.next();
            if (operator.operatesOn(expression = (Expression)children.next())) continue;
            String expressionStr = this.printer_.printToString(navigationExpr);
            String error = localStrings.getLocalString("ValidatingVisitor.illegalnav", "", new Object[]{expressionStr});
            this.errors_.add(new ParseException(error));
        }
    }

    public void visitOperatorExpression(OperatorExpression expression) {
        Operator operator = expression.getOperator();
        ListIterator iterator = expression.getChildren(this.getTraversalType());
        Vector children = new Vector();
        while (iterator.hasNext()) {
            children.add(iterator.next());
        }
        super.visitOperatorExpression(expression);
        if (operator.equals(UnaryOperator.IS_EMPTY)) {
            UnaryOperatorExpression unaryOpExpr = (UnaryOperatorExpression)expression;
            NavigationExpression isEmptyExpr = (NavigationExpression)unaryOpExpr.getExpression();
            FromClause fromClause = this.query_.getFromClause();
            Iterator identVars = fromClause.getIdentVars();
            while (identVars.hasNext()) {
                IdentificationVar next = (IdentificationVar)identVars.next();
                if (!isEmptyExpr.equals(next.getExpression())) continue;
                String expressionStr = this.printer_.printToString(isEmptyExpr);
                String error = localStrings.getLocalString("ValidatingVisitor.isemptyerror", "", new Object[]{expressionStr});
                this.errors_.add(new ParseException(error));
                break;
            }
        }
        if (!this.foundTypeError_ && !operator.operatesOn(children)) {
            this.foundTypeError_ = true;
            String expressionStr = this.printer_.printToString(expression);
            String error = localStrings.getLocalString("ValidatingVisitor.invalidexprtype", "", new Object[]{expressionStr});
            this.errors_.add(new ParseException(error));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

