/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.persistence;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.PMDeployer;
import com.sun.ejb.PersistenceUtils;
import com.sun.ejb.ejbql.EjbQLDriver;
import com.sun.ejb.ejbql.EjbQLQuery;
import com.sun.ejb.ejbql.RuntimeInfoVisitor;
import com.sun.ejb.persistence.PersistenceManagerImpl;
import com.sun.ejb.sqlgen.DBInfo;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.log.Log;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class PMDeployerImpl
implements PMDeployer {
    private static final boolean debug = false;
    private EjbBundleDescriptor ebd;
    static /* synthetic */ Class class$com$sun$ejb$sqlgen$DBInfo;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;

    public PMDeployerImpl(EjbBundleDescriptor ebd) {
        this.ebd = ebd;
    }

    public void ejbJarDeployed() {
        try {
            EjbQLDriver ejbqlDriver = null;
            if (this.ebd.getCMPResourceReference() != null) {
                ejbqlDriver = this.createEjbQLDriver();
            }
            HashSet allEjbqlRuntimeInfo = new HashSet();
            HashSet<PersistenceDescriptor> allPersistenceDescs = new HashSet<PersistenceDescriptor>();
            Iterator itr = this.ebd.getEjbs().iterator();
            while (itr.hasNext()) {
                EjbDescriptor ejbd = (EjbDescriptor)itr.next();
                if (!(ejbd instanceof EjbCMPEntityDescriptor)) continue;
                PersistenceDescriptor pers = ((EjbCMPEntityDescriptor)ejbd).getPersistenceDescriptor();
                if (pers.getCreateTableOnDeployment()) {
                    this.createTable(pers);
                }
                this.addForeignKeyFields(pers);
                allPersistenceDescs.add(pers);
            }
            itr = this.ebd.getRelationships().iterator();
            while (itr.hasNext()) {
                RelationshipDescriptor rd = (RelationshipDescriptor)itr.next();
                if (rd.isOneOne()) continue;
                JoinObjectDescriptor joinDesc = rd.getJoinDescriptor();
                PersistenceDescriptor pers = joinDesc.getPersistenceDescriptor();
                if (pers.getCreateTableOnDeployment()) {
                    this.createTable(pers);
                }
                this.addForeignKeyFields(pers);
                allPersistenceDescs.add(pers);
            }
            itr = allPersistenceDescs.iterator();
            while (itr.hasNext()) {
                PersistenceDescriptor pers = (PersistenceDescriptor)itr.next();
                this.populateEjbQlRuntimeInfo(pers, ejbqlDriver, allEjbqlRuntimeInfo);
            }
        }
        catch (Exception ex2) {
            EJBUtils.throwEJBException(ex2);
        }
    }

    public void ejbJarUnDeployed() {
        try {
            Iterator itr = this.ebd.getEjbs().iterator();
            while (itr.hasNext()) {
                PersistenceDescriptor pers;
                EjbDescriptor ejbd = (EjbDescriptor)itr.next();
                if (!(ejbd instanceof EjbCMPEntityDescriptor) || !(pers = ((EjbCMPEntityDescriptor)ejbd).getPersistenceDescriptor()).getDeleteTableOnUndeployment()) continue;
                try {
                    this.deleteTable(pers);
                }
                catch (SQLException sqlex) {
                    // empty catch block
                }
            }
            itr = this.ebd.getRelationships().iterator();
            while (itr.hasNext()) {
                JoinObjectDescriptor joinDesc;
                PersistenceDescriptor pers;
                RelationshipDescriptor rd = (RelationshipDescriptor)itr.next();
                if (rd.isOneOne() || !(pers = (joinDesc = rd.getJoinDescriptor()).getPersistenceDescriptor()).getDeleteTableOnUndeployment()) continue;
                try {
                    this.deleteTable(pers);
                }
                catch (SQLException sqlex) {
                    // empty catch block
                }
            }
            PersistenceUtils.removePersistenceManager(this.ebd);
            PersistenceUtils.removePMDeployer(this.ebd);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private EjbQLDriver createEjbQLDriver() throws Exception {
        InitialContext context = new InitialContext();
        Object objref = context.lookup("DatabaseInformation");
        DBInfo dbInfo = (DBInfo)PortableRemoteObject.narrow((Object)objref, (Class)(class$com$sun$ejb$sqlgen$DBInfo == null ? (class$com$sun$ejb$sqlgen$DBInfo = PMDeployerImpl.class$("com.sun.ejb.sqlgen.DBInfo")) : class$com$sun$ejb$sqlgen$DBInfo));
        return new EjbQLDriver(this.ebd);
    }

    private void populateEjbQlRuntimeInfo(PersistenceDescriptor pers, EjbQLDriver ejbqlDriver, Set allRuntimeInfo) throws Exception {
        Set allQueriedMethods = pers.getQueriedMethods();
        Iterator iter = allQueriedMethods.iterator();
        while (iter.hasNext()) {
            Method next = (Method)iter.next();
            QueryDescriptor queryDesc = pers.getQueryFor(next);
            if (!queryDesc.getIsEjbQl()) continue;
            String queryStr = queryDesc.getQuery();
            EjbQLQuery query = ejbqlDriver.parse(pers, next, queryStr);
            RuntimeInfoVisitor runtimeInfo = ejbqlDriver.getRuntimeInfo(query);
            allRuntimeInfo.add(runtimeInfo);
            queryDesc.setEjbQlRuntimeInfo(runtimeInfo);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createTable(PersistenceDescriptor pers) throws Exception {
        Connection dbCon;
        block8: {
            String createTableQuery = pers.getSqlStatementFor("createTable");
            if (createTableQuery == null) throw new EJBException("ERROR: SQL statement for creating table is empty for bean " + pers.getParentDescriptor().getName() + ". Possible cause: SQL Generator has not been run.");
            if (createTableQuery.equals("")) {
                throw new EJBException("ERROR: SQL statement for creating table is empty for bean " + pers.getParentDescriptor().getName() + ". Possible cause: SQL Generator has not been run.");
            }
            dbCon = null;
            Statement stmt = null;
            try {
                try {
                    dbCon = PersistenceManagerImpl.getConnection(pers);
                    stmt = dbCon.createStatement();
                    stmt.executeUpdate(createTableQuery);
                }
                catch (SQLException ex2) {
                    Log.err.println(ex2);
                    Object var7_6 = null;
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (dbCon == null) return;
                    dbCon.close();
                    return;
                }
                Object var7_5 = null;
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (stmt != null) {
                    stmt.close();
                }
                if (dbCon == null) throw throwable;
                dbCon.close();
                throw throwable;
            }
            stmt.close();
        }
        if (dbCon == null) return;
        dbCon.close();
    }

    private void deleteTable(PersistenceDescriptor pers) throws Exception {
        Connection dbCon;
        block5: {
            String deleteTableQuery = pers.getSqlStatementFor("deleteTable");
            dbCon = null;
            Statement stmt = null;
            try {
                dbCon = PersistenceManagerImpl.getConnection(pers);
                stmt = dbCon.createStatement();
                stmt.executeUpdate(deleteTableQuery);
                Object var6_5 = null;
                if (stmt == null) break block5;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (stmt != null) {
                    stmt.close();
                }
                if (dbCon != null) {
                    dbCon.close();
                }
                throw throwable;
            }
            stmt.close();
        }
        if (dbCon != null) {
            dbCon.close();
        }
    }

    public void addForeignKeyFields(PersistenceDescriptor pers) {
        Vector<PersistentFieldInfo> fkeyFields = new Vector<PersistentFieldInfo>();
        Set relns = pers.getRelationships();
        Iterator it = relns.iterator();
        while (it.hasNext()) {
            RelationshipDescriptor rd = (RelationshipDescriptor)it.next();
            RelationRoleDescriptor source = rd.getSource();
            RelationRoleDescriptor myrole = source.getPersistenceDescriptor() == pers ? source : rd.getSink();
            if (!rd.isOneOne()) continue;
            String cmrField = myrole.getCMRField();
            if (cmrField == null) {
                cmrField = "_reverse_" + myrole.getPartner().getCMRField();
            }
            PersistenceDescriptor partnerPers = myrole.getPartner().getPersistenceDescriptor();
            PersistentFieldInfo[] partnerPkeyFields = partnerPers.getPkeyFieldInfo();
            int i2 = 0;
            while (i2 < partnerPkeyFields.length) {
                PersistentFieldInfo pkeyInfo = partnerPkeyFields[i2];
                PersistentFieldInfo fkeyInfo = new PersistentFieldInfo();
                fkeyInfo.name = "_" + cmrField + "_" + pkeyInfo.name;
                fkeyInfo.type = !pkeyInfo.type.isPrimitive() ? pkeyInfo.type : this.getPrimitiveWrapper(pkeyInfo.type);
                fkeyInfo.relatedName = pkeyInfo.name;
                fkeyInfo.relatedObj = partnerPers;
                fkeyFields.add(fkeyInfo);
                ++i2;
            }
        }
        if (fkeyFields.size() > 0) {
            PersistentFieldInfo[] fkeyArray = new PersistentFieldInfo[fkeyFields.size()];
            fkeyFields.toArray(fkeyArray);
            pers.setFkeyFields(fkeyArray);
        }
    }

    private Class getPrimitiveWrapper(Class primClass) {
        if (primClass.getName().equals("boolean")) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = PMDeployerImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (primClass.getName().equals("byte")) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = PMDeployerImpl.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (primClass.getName().equals("short")) {
            return class$java$lang$Short == null ? (class$java$lang$Short = PMDeployerImpl.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (primClass.getName().equals("int")) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = PMDeployerImpl.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (primClass.getName().equals("long")) {
            return class$java$lang$Long == null ? (class$java$lang$Long = PMDeployerImpl.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (primClass.getName().equals("float")) {
            return class$java$lang$Float == null ? (class$java$lang$Float = PMDeployerImpl.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (primClass.getName().equals("double")) {
            return class$java$lang$Double == null ? (class$java$lang$Double = PMDeployerImpl.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (primClass.getName().equals("char")) {
            return class$java$lang$Character == null ? (class$java$lang$Character = PMDeployerImpl.class$("java.lang.Character")) : class$java$lang$Character;
        }
        throw new EJBException("Unknown class: " + primClass);
    }

    public Vector addJoinObjectDescriptors(PersistenceDescriptor pers) {
        Descriptor owner = pers.getParentDescriptor();
        String packagePrefix = this.getPackagePrefix(owner);
        Vector<JoinObjectDescriptor> joinObjDescs = new Vector<JoinObjectDescriptor>();
        EjbBundleDescriptor ebd = pers.getEjbBundleDescriptor();
        Iterator it = pers.getRelationships().iterator();
        while (it.hasNext()) {
            RelationshipDescriptor rd = (RelationshipDescriptor)it.next();
            if (rd.isOneOne()) continue;
            if (rd.getJoinDescriptor() != null) {
                joinObjDescs.add(rd.getJoinDescriptor());
                continue;
            }
            String sourceName = rd.getSource().getOwner().getName();
            String sinkName = rd.getSink().getOwner().getName();
            String sourceField = rd.getSource().getCMRField();
            String sinkField = rd.getSink().getCMRField();
            String name = "";
            if (sourceField != null) {
                name = packagePrefix + sourceName + "_" + sourceField + "_" + sinkName + "_";
                if (sinkField != null) {
                    name = name + sinkField;
                }
            } else {
                name = packagePrefix + sinkName + "_" + sinkField + "_" + sourceName + "_";
                if (sourceField != null) {
                    name = name + sourceField;
                }
            }
            JoinObjectDescriptor jo = this.createJoinObjDesc(rd, name);
            joinObjDescs.add(jo);
        }
        return joinObjDescs;
    }

    private JoinObjectDescriptor createJoinObjDesc(RelationshipDescriptor rd, String name) {
        RelationRoleDescriptor source = rd.getSource();
        RelationRoleDescriptor sink = rd.getSink();
        JoinObjectDescriptor dd2 = new JoinObjectDescriptor(name);
        rd.setJoinDescriptor(dd2);
        dd2.setRelationshipDesc(rd);
        dd2.setName(name);
        EjbBundleDescriptor bd2 = source.getOwner().getEjbBundleDescriptor();
        dd2.setEjbBundleDescriptor(bd2);
        PersistenceDescriptor ddPers = new PersistenceDescriptor();
        dd2.setPersistenceDescriptor(ddPers);
        HashSet<FieldDescriptor> persistentFields = new HashSet<FieldDescriptor>();
        HashSet<FieldDescriptor> pkeyFields = new HashSet<FieldDescriptor>();
        PersistenceDescriptor sourcePers = source.getPersistenceDescriptor();
        PersistentFieldInfo[] sourcePkeyFields = sourcePers.getPkeyFieldInfo();
        int i2 = 0;
        while (i2 < sourcePkeyFields.length) {
            String joinField = "_" + source.getOwner().getName() + "_" + sourcePkeyFields[i2].name;
            persistentFields.add(new FieldDescriptor(joinField));
            if (source.getIsMany()) {
                pkeyFields.add(new FieldDescriptor(joinField));
            }
            ++i2;
        }
        PersistenceDescriptor sinkPers = sink.getPersistenceDescriptor();
        PersistentFieldInfo[] sinkPkeyFields = sinkPers.getPkeyFieldInfo();
        int i3 = 0;
        while (i3 < sinkPkeyFields.length) {
            String joinField = "_" + sink.getOwner().getName() + "_" + sinkPkeyFields[i3].name;
            persistentFields.add(new FieldDescriptor(joinField));
            if (sink.getIsMany()) {
                pkeyFields.add(new FieldDescriptor(joinField));
            }
            ++i3;
        }
        ddPers.setCMPFields(persistentFields);
        ddPers.setPkeyFields(pkeyFields);
        return dd2;
    }

    public JoinObjectDescriptor createJoinObjDesc(String depName, Descriptor sourceDesc, String sourceField, Descriptor sinkDesc, String sinkField) {
        RelationshipDescriptor relnDesc = null;
        PersistenceDescriptor sourcePers = null;
        if (sourceDesc instanceof JoinObjectDescriptor) {
            sourcePers = ((JoinObjectDescriptor)sourceDesc).getPersistenceDescriptor();
        } else if (sourceDesc instanceof EjbCMPEntityDescriptor) {
            sourcePers = ((EjbCMPEntityDescriptor)sourceDesc).getPersistenceDescriptor();
        }
        Iterator it = sourcePers.getRelationships().iterator();
        while (it.hasNext()) {
            RelationshipDescriptor rd = (RelationshipDescriptor)it.next();
            RelationRoleDescriptor source = rd.getSource();
            RelationRoleDescriptor sink = rd.getSink();
            if ((!source.getOwner().getName().equals(sourceDesc.getName()) || source.getCMRField() == null || !source.getCMRField().equals(sourceField)) && (!sink.getOwner().getName().equals(sourceDesc.getName()) || sink.getCMRField() == null || !sink.getCMRField().equals(sourceField))) continue;
            relnDesc = rd;
            break;
        }
        if (relnDesc == null) {
            throw new RuntimeException("Unable to find RelationshipDescriptor for source=" + sourceDesc.getName() + " field=" + sourceField);
        }
        return this.createJoinObjDesc(relnDesc, depName);
    }

    private String getPackagePrefix(Descriptor owner) {
        String fullName = owner instanceof EjbCMPEntityDescriptor ? ((EjbCMPEntityDescriptor)owner).getEjbClassName() : ((JoinObjectDescriptor)owner).getJoinObjectClass();
        int lastDotIndex = fullName.lastIndexOf(46);
        String packagePrefix = lastDotIndex != -1 ? fullName.substring(0, lastDotIndex) + "." : "";
        return packagePrefix;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

