/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.persistence;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.PersistentState;
import com.sun.ejb.persistence.PartitionImpl;
import com.sun.ejb.persistence.RelationshipManager;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public final class PMSet
extends AbstractSet {
    private static final boolean debug = false;
    private static final String invalidMsg = "Collection may have been accessed after transaction completion.";
    private HashSet joinObjects;
    private PartitionImpl partition;
    private PersistentState sourceObj;
    private RelationRoleDescriptor role;
    private JoinObjectDescriptor joinDesc;
    private RelationshipManager rm;
    private ArrayList liveIterators = new ArrayList();
    private boolean isComplete;
    private boolean isValid = true;

    PMSet(PartitionImpl partition, PersistentState sourceObj, RelationRoleDescriptor role, RelationshipManager rm, HashSet joinObjects, boolean isComplete) {
        this.partition = partition;
        this.sourceObj = sourceObj;
        this.role = role;
        this.joinDesc = role.getRelationshipDescriptor().getJoinDescriptor();
        this.rm = rm;
        this.joinObjects = joinObjects;
        this.isComplete = isComplete;
    }

    public Iterator iterator() {
        if (!this.isValid) {
            throw new IllegalStateException(invalidMsg);
        }
        PMIterator itr = new PMIterator(this, this.joinObjects.iterator());
        this.liveIterators.add(itr);
        return itr;
    }

    public int size() {
        if (!this.isValid) {
            throw new IllegalStateException(invalidMsg);
        }
        return this.joinObjects.size();
    }

    public boolean add(Object sink) {
        if (!this.isValid) {
            throw new IllegalStateException(invalidMsg);
        }
        if (sink == null) {
            throw new IllegalArgumentException("Cannot add null to a relationship");
        }
        try {
            this.rm.checkCollectionSinkType(this.sourceObj, sink, this.role.getPartner());
            PersistentState joinObj = this.partition.getOrCreateJoinObject(this.sourceObj, this.role, sink, this.joinDesc, false);
            if (this.joinObjects.contains(joinObj)) {
                return false;
            }
            this.rm.collectionAdd(joinObj, this.joinDesc, this.sourceObj, sink, this.role, this.partition);
            this.partition.addJoinObject(joinObj, this.joinDesc, this.role);
            boolean wasAdded = this.joinObjects.add(joinObj);
            if (wasAdded) {
                if (joinObj.__getStatus() == 0) {
                    joinObj.__setStatus(2);
                } else {
                    joinObj.__setStatus(4);
                }
                this.invalidateIterators();
            }
            return wasAdded;
        }
        catch (Exception ex2) {
            EJBUtils.throwEJBException(ex2);
            return false;
        }
    }

    public boolean remove(Object sink) {
        if (!this.isValid) {
            throw new IllegalStateException(invalidMsg);
        }
        try {
            this.rm.checkCollectionSinkType(this.sourceObj, sink, this.role.getPartner());
            PersistentState joinObj = this.partition.getOrCreateJoinObject(this.sourceObj, this.role, sink, this.joinDesc, true);
            if (this.joinObjects.contains(joinObj)) {
                this.beforeRemove(joinObj);
                this.joinObjects.remove(joinObj);
                this.invalidateIterators();
                return true;
            }
        }
        catch (Exception ex2) {
            EJBUtils.throwEJBException(ex2);
        }
        return false;
    }

    private void invalidateIterators() {
        int i2 = 0;
        while (i2 < this.liveIterators.size()) {
            PMIterator itr = (PMIterator)this.liveIterators.get(i2);
            itr.collectionModified = true;
            ++i2;
        }
        this.liveIterators.clear();
    }

    void invalidate() {
        this.isValid = false;
        this.invalidateIterators();
    }

    void addJoinObject(Object joinObj) {
        this.joinObjects.add(joinObj);
        this.invalidateIterators();
    }

    void removeJoinObject(Object joinObj) {
        this.joinObjects.remove(joinObj);
        this.invalidateIterators();
    }

    RelationRoleDescriptor getRole() {
        return this.role;
    }

    boolean getIsComplete() {
        return this.isComplete;
    }

    void complete(HashSet newJoinObjs) {
        newJoinObjs.addAll(this.joinObjects);
        this.joinObjects = newJoinObjs;
        this.isComplete = true;
        this.invalidateIterators();
    }

    private Object getSink(Object joinObj) throws Exception {
        Object sink = this.partition.getJoinSink(joinObj, this.joinDesc, this.role);
        return sink;
    }

    private void beforeRemove(PersistentState joinObj) throws Exception {
        if (joinObj.__getStatus() == 2) {
            joinObj.__setStatus(0);
        } else {
            joinObj.__setStatus(3);
        }
        this.rm.collectionRemove(joinObj, this.joinDesc, this.role, this.partition);
    }

    private final class PMIterator
    implements Iterator {
        private static final String errMsg = "Collection modified or transaction completed";
        private PMSet pmset;
        private Iterator itr;
        private Object lastElem;
        private boolean collectionModified = false;

        PMIterator(PMSet c10, Iterator itr) {
            this.pmset = c10;
            this.itr = itr;
        }

        public boolean hasNext() {
            if (this.collectionModified) {
                throw new IllegalStateException(errMsg);
            }
            return this.itr.hasNext();
        }

        public Object next() {
            if (this.collectionModified) {
                throw new IllegalStateException(errMsg);
            }
            try {
                this.lastElem = this.itr.next();
                return this.pmset.getSink(this.lastElem);
            }
            catch (Exception ex2) {
                EJBUtils.throwEJBException(ex2);
                return null;
            }
        }

        public void remove() {
            if (this.collectionModified) {
                throw new IllegalStateException(errMsg);
            }
            try {
                this.pmset.beforeRemove((PersistentState)this.lastElem);
                this.itr.remove();
            }
            catch (Exception ex2) {
                EJBUtils.throwEJBException(ex2);
            }
        }
    }
}

