/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.persistence;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.PersistenceUtils;
import com.sun.ejb.PersistentInstance;
import com.sun.ejb.PersistentState;
import com.sun.ejb.persistence.PMSet;
import com.sun.ejb.persistence.PartitionImpl;
import com.sun.ejb.persistence.PersistenceManagerImpl;
import com.sun.enterprise.deployment.CMRFieldInfo;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EntityBean;
import javax.naming.InitialContext;

public class RelationshipManager {
    private static final boolean debug = false;
    private PersistenceManagerImpl pm;
    private InitialContext initialCtx;

    RelationshipManager(PersistenceManagerImpl pm) {
        this.pm = pm;
        try {
            this.initialCtx = new InitialContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void nullifyAllRelationships(PartitionImpl partition, PersistentInstance instance) {
        PersistentState obj = instance.__getPersistentState();
        try {
            PersistenceDescriptor pers = instance.__getPersistenceDescriptor();
            CMRFieldInfo[] cmrFields = pers.getCMRFieldInfo();
            int i2 = 0;
            while (i2 < cmrFields.length) {
                RelationRoleDescriptor sourceRole = cmrFields[i2].role;
                RelationRoleDescriptor sinkRole = sourceRole.getPartner();
                Field cmrField = cmrFields[i2].field;
                this.cmrGet(obj, pers, cmrFields[i2], partition);
                Object sink = cmrField.get(obj);
                EjbCMPEntityDescriptor sinkDesc = sinkRole.getOwner();
                if (!sinkRole.getIsMany()) {
                    this.cmrSet(obj, pers, cmrFields[i2], null, partition);
                    cmrField.set(obj, null);
                    if (sink != null && sinkRole.getCascadeDelete()) {
                        if (sink instanceof EJBLocalObject) {
                            PersistenceUtils.removeBean(sinkDesc, (EJBLocalObject)sink);
                        } else {
                            PersistenceUtils.removeBean(sinkDesc, sink);
                        }
                    }
                } else {
                    PMSet pmSet = (PMSet)sink;
                    Iterator it = pmSet.iterator();
                    while (it.hasNext()) {
                        Object sinkObj = it.next();
                        it.remove();
                        if (!sinkRole.getCascadeDelete()) continue;
                        PersistenceUtils.removeBean(sinkDesc, (EJBLocalObject)sinkObj);
                    }
                }
                ++i2;
            }
        }
        catch (Exception ex2) {
            EJBUtils.throwEJBException(ex2);
        }
    }

    void cmrSet(PersistentState obj, PersistenceDescriptor pers, CMRFieldInfo cmrFieldInfo, Object partner, PartitionImpl partition) throws Exception {
        PersistentInstance instance = obj.__getInstance();
        RelationRoleDescriptor myRole = cmrFieldInfo.role;
        RelationRoleDescriptor partnerRole = myRole.getPartner();
        PersistenceDescriptor partnerPers = partnerRole.getPersistenceDescriptor();
        if (!partnerRole.getIsMany()) {
            Object partnersCurrentPartner;
            PersistentState partnersCurrentPartnerState;
            PersistentState partnerState;
            if (partner != null && !(partner instanceof EJBLocalObject)) {
                throw new IllegalArgumentException("Argument must be a local object type.");
            }
            try {
                partnerState = this.getPersistentState(partner, partnerPers, partition);
            }
            catch (Exception ex2) {
                throw new IllegalArgumentException("Object has been deleted");
            }
            if (partnerState != null && partnerState.__getStatus() == 3) {
                throw new IllegalArgumentException("Object has been deleted");
            }
            Object prevPartner = this.loadCMRField(obj, pers, cmrFieldInfo, partition);
            PersistentState prevPartnerState = this.getPersistentState(prevPartner, partnerPers, partition);
            CMRFieldInfo partnerFieldInfo = partnerRole.getCMRFieldInfo();
            if (prevPartnerState != null) {
                if (!myRole.getIsMany()) {
                    this.setRelationship(prevPartnerState, null, null, partnerRole);
                } else {
                    PMSet prevPartnerColl = (PMSet)this.loadCMRField(prevPartnerState, partnerPers, partnerFieldInfo, partition);
                    prevPartnerColl.remove(obj);
                }
            }
            if (partnerState != null && !myRole.getIsMany() && (partnersCurrentPartnerState = this.getPersistentState(partnersCurrentPartner = this.loadCMRField(partnerState, partnerPers, partnerFieldInfo, partition), pers, partition)) != null) {
                this.setRelationship(partnersCurrentPartnerState, null, null, myRole);
            }
            if (partnerState == null) {
                if (!myRole.getIsMany()) {
                    this.setRelationship(obj, partnerState, null, myRole);
                } else {
                    cmrFieldInfo.field.set(obj, null);
                }
            } else if (!myRole.getIsMany()) {
                this.setRelationship(obj, partnerState, (EJBLocalObject)partner, myRole);
                EjbCMPEntityDescriptor ejbDesc = (EjbCMPEntityDescriptor)pers.getParentDescriptor();
                Object objRefOrKey = ejbDesc.isLocalInterfacesSupported() ? PersistenceUtils.getEJBLocalObject(ejbDesc, instance.__getPrimaryKey(), instance) : instance.__getPrimaryKey();
                this.setRelationship(partnerState, obj, objRefOrKey, partnerRole);
            } else {
                PMSet partnerColl = (PMSet)this.loadCMRField(partnerState, partnerPers, partnerFieldInfo, partition);
                partnerColl.add(obj);
            }
        } else {
            RelationRoleDescriptor otherRole;
            if (partner == null) {
                throw new IllegalArgumentException("Argument to Collection-valued set must not be null.");
            }
            if (!(partner instanceof Collection)) {
                throw new IllegalArgumentException("Argument to Collection-valued set must be a java.util.Collection type.");
            }
            Collection otherColl = (Collection)partner;
            PMSet myColl = (PMSet)this.loadCMRField(obj, pers, cmrFieldInfo, partition);
            if (myColl == otherColl) {
                return;
            }
            Iterator it = otherColl.iterator();
            while (it.hasNext()) {
                Object sinkElement = it.next();
                this.checkCollectionSinkType(obj, sinkElement, partnerRole);
            }
            myColl.clear();
            boolean shouldMove = false;
            if (!myRole.getIsMany() && otherColl instanceof PMSet && (otherRole = ((PMSet)otherColl).getRole()).equals(myRole)) {
                shouldMove = true;
            }
            Iterator itr = otherColl.iterator();
            while (itr.hasNext()) {
                Object element = itr.next();
                if (shouldMove) {
                    itr.remove();
                }
                myColl.add(element);
            }
        }
    }

    void checkCollectionSinkType(PersistentState source, Object sink, RelationRoleDescriptor sinkRole) throws Exception {
        if (sink instanceof PersistentState) {
            return;
        }
        PersistenceDescriptor sinkPers = sinkRole.getPersistenceDescriptor();
        EjbCMPEntityDescriptor sinkOwner = sinkRole.getOwner();
        EjbAbstractDescriptor dd2 = sinkOwner;
        Class<?> localClass = source.getClass().getClassLoader().loadClass(dd2.getLocalClassName());
        if (!localClass.isInstance(sink)) {
            throw new IllegalArgumentException("Bad argument type for collection add");
        }
    }

    private Object loadCMRField(PersistentState obj, PersistenceDescriptor pers, CMRFieldInfo cmrFieldInfo, PartitionImpl partition) throws Exception {
        Object value = cmrFieldInfo.field.get(obj);
        if (value == null) {
            this.cmrGet(obj, pers, cmrFieldInfo, partition);
            value = cmrFieldInfo.field.get(obj);
        } else if (value instanceof PMSet && !((PMSet)value).getIsComplete()) {
            this.cmrGet(obj, pers, cmrFieldInfo, partition);
        }
        return value;
    }

    PersistentState getPersistentState(Object obj, PersistenceDescriptor pers, PartitionImpl partition) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof PersistentState) {
            return (PersistentState)obj;
        }
        if (obj instanceof EntityBean) {
            return ((PersistentInstance)obj).__getPersistentState();
        }
        if (obj instanceof EJBLocalObject) {
            Object pkey = ((EJBLocalObject)obj).getPrimaryKey();
            return partition.getOrLoadPersistentState(pkey, pers, null);
        }
        return partition.getOrLoadPersistentState(obj, pers, null);
    }

    void cmrGet(PersistentState source, PersistenceDescriptor pers, CMRFieldInfo cmrFieldInfo, PartitionImpl partition) throws Exception {
        Object sourcePkey = this.pm.getPrimaryKey(source);
        Descriptor sourceDesc = pers.getParentDescriptor();
        RelationRoleDescriptor sourceRole = cmrFieldInfo.role;
        RelationRoleDescriptor sinkRole = sourceRole.getPartner();
        PersistenceDescriptor sinkPers = sinkRole.getPersistenceDescriptor();
        Field cmrField = cmrFieldInfo.field;
        if (sinkRole.getIsMany()) {
            PMSet coll = (PMSet)cmrField.get(source);
            if (coll != null && coll.getIsComplete()) {
                return;
            }
            HashSet joinObjs = this.pm.loadJoinObjects(source, sourcePkey, pers, cmrFieldInfo, partition);
            if (coll == null) {
                coll = new PMSet(partition, source, cmrFieldInfo.role, this, joinObjs, true);
                partition.addCollection(coll);
            } else {
                coll.complete(joinObjs);
            }
            cmrField.set(source, coll);
        } else {
            Object value = cmrField.get(source);
            if (value != null) {
                return;
            }
            Object sinkPkey = null;
            if (cmrFieldInfo.role.getIsMany()) {
                PersistentState joinObj = partition.getJoinObjForPkey(sourcePkey, sourceRole);
                if (joinObj != null) {
                    if (joinObj.__getStatus() == 3 || joinObj.__getStatus() == 0) {
                        return;
                    }
                } else if (joinObj == null) {
                    HashSet joinObjs = this.pm.loadJoinObjects(source, sourcePkey, pers, cmrFieldInfo, partition);
                    if (joinObjs.size() == 0) {
                        return;
                    }
                    if (joinObjs.size() == 1) {
                        joinObj = (PersistentState)joinObjs.iterator().next();
                    } else {
                        throw new EJBException("Error: Join Table has more than 1 row for many-1 relationship");
                    }
                }
                JoinObjectDescriptor joinDesc = sinkRole.getRelationshipDescriptor().getJoinDescriptor();
                Vector<PersistentFieldInfo> sinkfields = new Vector<PersistentFieldInfo>();
                PersistentFieldInfo[] joinFields = joinDesc.getPersistenceDescriptor().getPersistentFieldInfo();
                int i2 = 0;
                while (i2 < joinFields.length) {
                    if (joinFields[i2].relatedObj != pers) {
                        sinkfields.add(joinFields[i2]);
                    }
                    ++i2;
                }
                PersistentFieldInfo[] sinkJoinFields = sinkfields.toArray(new PersistentFieldInfo[sinkfields.size()]);
                sinkPkey = this.getPkeyFromForeignKey(joinObj, sinkPers, sinkJoinFields);
            } else {
                sinkPkey = this.getPkeyFromForeignKey(source, sinkPers, cmrFieldInfo.fkeyFields);
            }
            if (sinkPkey == null) {
                return;
            }
            EjbCMPEntityDescriptor partnerDesc = sinkRole.getOwner();
            Object sink = partnerDesc.isLocalInterfacesSupported() ? PersistenceUtils.getEJBLocalObject(partnerDesc, sinkPkey, null) : sinkPkey;
            cmrField.set(source, sink);
        }
    }

    void collectionRemove(Object joinObj, JoinObjectDescriptor joinDesc, RelationRoleDescriptor sourceRole, PartitionImpl partition) throws Exception {
        PersistentState sinkState = partition.getJoinSinkStateIfLoaded(joinObj, joinDesc, sourceRole);
        if (sinkState == null) {
            return;
        }
        RelationRoleDescriptor sinkRole = sourceRole.getPartner();
        PersistenceDescriptor sinkPers = sinkRole.getPersistenceDescriptor();
        String sinkCMRField = sinkRole.getCMRField();
        if (sinkCMRField == null) {
            sinkCMRField = "_reverse_" + sourceRole.getCMRField();
        }
        CMRFieldInfo sinkFieldInfo = sinkPers.getCMRFieldInfoByName(sinkCMRField);
        if (sourceRole.getIsMany()) {
            PMSet sinkColl = (PMSet)sinkFieldInfo.field.get(sinkState);
            if (sinkColl != null) {
                sinkColl.removeJoinObject(joinObj);
            }
        } else {
            sinkFieldInfo.field.set(sinkState, null);
        }
    }

    void collectionAdd(Object joinObj, JoinObjectDescriptor joinDesc, PersistentState source, Object sink, RelationRoleDescriptor sourceRole, PartitionImpl partition) throws Exception {
        RelationRoleDescriptor sinkRole = sourceRole.getPartner();
        PersistenceDescriptor sinkPers = sinkRole.getPersistenceDescriptor();
        PersistenceDescriptor sourcePers = sourceRole.getPersistenceDescriptor();
        CMRFieldInfo sinkFieldInfo = sinkRole.getCMRFieldInfo();
        PersistentState sinkState = this.getPersistentState(sink, sinkPers, partition);
        if (sourceRole.getIsMany()) {
            PMSet sinkColl = (PMSet)sinkFieldInfo.field.get(sinkState);
            if (sinkColl != null) {
                sinkColl.addJoinObject(joinObj);
            } else {
                HashSet<Object> joinObjs = new HashSet<Object>();
                joinObjs.add(joinObj);
                sinkColl = new PMSet(partition, sinkState, sinkRole, this, joinObjs, false);
                partition.addCollection(sinkColl);
                sinkFieldInfo.field.set(sinkState, sinkColl);
            }
        } else {
            PersistentState sinksCurrentPartnerState;
            Object sinksCurrentPartner = sinkFieldInfo.field.get(sinkState);
            if (sinksCurrentPartner == null) {
                this.cmrGet(sinkState, sinkPers, sinkFieldInfo, partition);
                sinksCurrentPartner = sinkFieldInfo.field.get(sinkState);
            }
            if ((sinksCurrentPartnerState = this.getPersistentState(sinksCurrentPartner, sourcePers, partition)) != null) {
                CMRFieldInfo sourceFieldInfo = sourceRole.getCMRFieldInfo();
                Collection coll = (Collection)sourceFieldInfo.field.get(sinksCurrentPartnerState);
                if (coll != null) {
                    coll.remove(sink);
                } else {
                    PersistentState oldJoinObj = partition.getOrCreateJoinObject(sinksCurrentPartnerState, sourceRole, sink, joinDesc, true);
                    if (oldJoinObj.__getStatus() == 2) {
                        oldJoinObj.__setStatus(0);
                    } else {
                        oldJoinObj.__setStatus(3);
                    }
                }
            }
            EjbCMPEntityDescriptor sourceDesc = (EjbCMPEntityDescriptor)sourcePers.getParentDescriptor();
            PersistentInstance bean = source.__getInstance();
            Object sourceRefOrKey = bean != null ? bean.__getPrimaryKey() : this.pm.getPrimaryKey(source);
            if (sourceDesc.isLocalInterfacesSupported()) {
                sourceRefOrKey = PersistenceUtils.getEJBLocalObject(sourceDesc, sourceRefOrKey, bean);
            }
            sinkFieldInfo.field.set(sinkState, sourceRefOrKey);
            PersistentFieldInfo[] joinFields = joinDesc.getPersistenceDescriptor().getPersistentFieldInfo();
            int i2 = 0;
            while (i2 < joinFields.length) {
                PersistentFieldInfo joinField = joinFields[i2];
                if (joinField.relatedObj == sourcePers) {
                    Field sourceField = source.getClass().getField(joinField.relatedName);
                    joinField.field.set(joinObj, sourceField.get(source));
                }
                ++i2;
            }
        }
    }

    private void setRelationship(PersistentState obj, PersistentState partnerState, Object partnerRefOrKey, RelationRoleDescriptor role) throws Exception {
        CMRFieldInfo cmrFieldInfo = role.getCMRFieldInfo();
        cmrFieldInfo.field.set(obj, partnerRefOrKey);
        PersistentFieldInfo[] fkeyFields = cmrFieldInfo.fkeyFields;
        if (partnerRefOrKey == null) {
            int i2 = 0;
            while (i2 < fkeyFields.length) {
                if (!fkeyFields[i2].field.getType().isPrimitive()) {
                    fkeyFields[i2].field.set(obj, null);
                }
                ++i2;
            }
        } else {
            Class<?> partnerClass = partnerState.getClass();
            int i3 = 0;
            while (i3 < fkeyFields.length) {
                Field pkeyField = partnerClass.getField(fkeyFields[i3].relatedName);
                fkeyFields[i3].field.set(obj, pkeyField.get(partnerState));
                ++i3;
            }
        }
        if (obj.__getStatus() == 1) {
            obj.__setStatus(4);
        }
    }

    private Object getPkeyFromForeignKey(PersistentState obj, PersistenceDescriptor partnerPers, PersistentFieldInfo[] fkeyFields) {
        try {
            Object pkey;
            if (partnerPers == null || partnerPers.primaryKeyIsOneField()) {
                pkey = fkeyFields[0].field.get(obj);
            } else {
                Class partnerPkeyClass = partnerPers.getPrimaryKeyClass();
                pkey = partnerPkeyClass.newInstance();
                int i2 = 0;
                while (i2 < fkeyFields.length) {
                    Object pkeyElement = fkeyFields[i2].field.get(obj);
                    if (pkeyElement == null) {
                        return null;
                    }
                    Field pkeyField = partnerPkeyClass.getField(fkeyFields[i2].relatedName);
                    pkeyField.set(pkey, pkeyElement);
                    ++i2;
                }
            }
            return pkey;
        }
        catch (Exception ex2) {
            throw new EJBException(ex2);
        }
    }
}

