/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.sqlgen;

import com.sun.ejb.PMDeployer;
import com.sun.ejb.PersistenceUtils;
import com.sun.ejb.ejbql.EjbQLDriver;
import com.sun.ejb.ejbql.EjbQLQuery;
import com.sun.ejb.sqlgen.DBInfo;
import com.sun.ejb.sqlgen.DBMetaData;
import com.sun.ejb.sqlgen.SQLTypeMapper;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.ejb.EJBException;

public final class SQLGenerator {
    private static final boolean debug = false;
    private PersistenceDescriptor pers;
    private String tableName;
    private String[] pkeyFieldNames;
    private String[] contMgFieldNames;
    private String[] contMgNoPkeyFieldNames;
    private String whereClause;
    private String createTableQuery;
    private String deleteTableQuery;
    private String loadRowQuery;
    private String storeRowQuery;
    private String createRowQuery;
    private String deleteRowQuery;
    private String findByPrimaryKeyQuery;
    private String findBySourceKeyQuery;
    private String findBySinkKeyQuery;
    private String nonPrimaryKeyFinderQuery;
    private Hashtable findQueryTable = new Hashtable();
    private SQLTypeMapper typeMapper;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$ejb$sqlgen$SQLGenerator == null ? (class$com$sun$ejb$sqlgen$SQLGenerator = SQLGenerator.class$("com.sun.ejb.sqlgen.SQLGenerator")) : class$com$sun$ejb$sqlgen$SQLGenerator);
    private boolean isMSSqlServer = false;
    static /* synthetic */ Class class$com$sun$ejb$sqlgen$SQLGenerator;

    private SQLGenerator(PersistenceDescriptor pers, String persClassName, SQLTypeMapper typeMapper, DBMetaData metadata) {
        this.pers = pers;
        this.typeMapper = typeMapper;
        PersistentFieldInfo[] persFields = pers.getPersistentFieldInfo();
        PersistentFieldInfo[] noPkeyPersFields = pers.getNonPkeyPersFieldInfo();
        PersistentFieldInfo[] pkeyFields = pers.getPkeyFieldInfo();
        String tableSuffix = "Table";
        int tableNameMax = metadata.maxTableNameLength - 2;
        int columnNameMax = metadata.maxColumnNameLength - 2;
        if (metadata.dbName.toLowerCase().indexOf("microsoft") != -1) {
            this.isMSSqlServer = true;
        }
        String fullName = persClassName;
        String className = fullName.substring(fullName.lastIndexOf(".") + 1);
        this.tableName = className + tableSuffix;
        if (this.tableName.length() > tableNameMax) {
            this.tableName = this.tableName.substring(0, tableNameMax);
        }
        this.tableName = "\"" + this.tableName + "\"";
        pers.setTableName(this.tableName);
        String[] colmNames = new String[persFields.length];
        int i2 = 0;
        while (i2 < persFields.length) {
            String name = persFields[i2].name;
            if (name.length() > columnNameMax) {
                Log.err.println(localStrings.getLocalString("ejb.sqlgen.fieldnamewillbetruncatedtomaxchars", "Warning: field name {0} will be truncated to {1} characters to get column name.", new Object[]{name, new Integer(columnNameMax)}));
                name = name.substring(0, columnNameMax);
            }
            colmNames[i2] = name = "\"" + name + "\"";
            persFields[i2].columnName = name;
            ++i2;
        }
        this.contMgFieldNames = colmNames;
        colmNames = new String[noPkeyPersFields.length];
        int i3 = 0;
        while (i3 < noPkeyPersFields.length) {
            String name = noPkeyPersFields[i3].name;
            if (name.length() > columnNameMax) {
                name = name.substring(0, columnNameMax);
            }
            colmNames[i3] = name = "\"" + name + "\"";
            noPkeyPersFields[i3].columnName = name;
            ++i3;
        }
        this.contMgNoPkeyFieldNames = colmNames;
        colmNames = new String[pkeyFields.length];
        int i4 = 0;
        while (i4 < pkeyFields.length) {
            String name = pkeyFields[i4].name;
            if (name.length() > columnNameMax) {
                name = name.substring(0, columnNameMax);
            }
            colmNames[i4] = name = "\"" + name + "\"";
            pkeyFields[i4].columnName = name;
            ++i4;
        }
        this.pkeyFieldNames = colmNames;
        try {
            this.generateWhereClause();
            this.generateCreateTableQuery();
            this.generateDeleteTableQuery();
            this.generateLoadRowQuery();
            this.generateStoreRowQuery();
            this.generateCreateRowQuery();
            this.generateDeleteRowQuery();
            this.generateFindByPrimaryKeyQuery();
            this.generateNonPrimaryKeyFinderQuery();
            if (pers.getParentDescriptor() instanceof JoinObjectDescriptor) {
                this.generateFindBySourceSinkKeyQuery();
            }
        }
        catch (Exception ex2) {
            throw new EJBException(ex2);
        }
    }

    public static void generateSQL(EjbBundleDescriptor ejbBundle, ResourceReferenceDescriptor rrd, boolean overWrite, DBInfo dbInfo) throws Exception {
        Object[] ejbs = ejbBundle.getEjbs().toArray();
        boolean foundCMPBeans = false;
        int i2 = 0;
        while (i2 < ejbs.length) {
            if (ejbs[i2] instanceof EjbCMPEntityDescriptor) {
                foundCMPBeans = true;
                break;
            }
            ++i2;
        }
        if (!foundCMPBeans) {
            return;
        }
        if (rrd == null || rrd.getResourcePrincipal() == null) {
            throw new RuntimeException("No database specified for CMP EntityBeans' persistent state");
        }
        ResourcePrincipal rp = rrd.getResourcePrincipal();
        DBMetaData metadata = dbInfo.getDBMetaData(rrd.getJndiName(), rp.getName(), rp.getPassword());
        SQLTypeMapper sqlt = new SQLTypeMapper();
        sqlt.initializeMapping(metadata);
        int i3 = 0;
        while (i3 < ejbs.length) {
            if (ejbs[i3] instanceof EjbCMPEntityDescriptor) {
                EjbCMPEntityDescriptor ent = (EjbCMPEntityDescriptor)ejbs[i3];
                SQLGenerator.generateSQL(ent, overWrite, metadata, sqlt);
            }
            ++i3;
        }
        EjbQLDriver ejbqlDriver = new EjbQLDriver(ejbBundle);
        int i4 = 0;
        while (i4 < ejbs.length) {
            if (ejbs[i4] instanceof EjbCMPEntityDescriptor) {
                EjbCMPEntityDescriptor ent = (EjbCMPEntityDescriptor)ejbs[i4];
                SQLGenerator.generateSQLForEjbQLQueries(ent.getPersistenceDescriptor(), ejbqlDriver);
            }
            ++i4;
        }
    }

    private static void generateSQL(EjbCMPEntityDescriptor entd, boolean overWrite, DBMetaData metadata, SQLTypeMapper sqlt) throws Exception {
        PersistenceDescriptor pers = entd.getPersistenceDescriptor();
        String persClassName = entd.getEjbClassName();
        EjbBundleDescriptor bundleDesc = pers.getEjbBundleDescriptor();
        PersistenceUtils.getPMDeployer(bundleDesc).addForeignKeyFields(pers);
        SQLGenerator sqlgen = new SQLGenerator(pers, persClassName, sqlt, metadata);
        sqlgen.storeIntoDescriptor(overWrite);
        SQLGenerator.generateJoinObjectSQL(pers, sqlt, metadata, overWrite);
    }

    private static void generateJoinObjectSQL(PersistenceDescriptor pers, SQLTypeMapper sqlt, DBMetaData metadata, boolean overWrite) {
        EjbBundleDescriptor bundleDesc = pers.getEjbBundleDescriptor();
        PMDeployer pmd = PersistenceUtils.getPMDeployer(bundleDesc);
        Vector joinObjs = pmd.addJoinObjectDescriptors(pers);
        int i2 = 0;
        while (i2 < joinObjs.size()) {
            JoinObjectDescriptor desc = (JoinObjectDescriptor)joinObjs.elementAt(i2);
            PersistenceDescriptor joinPers = desc.getPersistenceDescriptor();
            SQLGenerator sqlgen = new SQLGenerator(joinPers, desc.getJoinObjectClass(), sqlt, metadata);
            sqlgen.storeIntoDescriptor(overWrite);
            ++i2;
        }
    }

    private void storeIntoDescriptor(boolean overWrite) {
        Iterator i2 = this.pers.getAllSqlStatementedMethods().iterator();
        while (i2.hasNext()) {
            String operation = (String)i2.next();
            String prevSql = this.pers.getSqlStatementFor(operation);
            if (!overWrite && prevSql != null && !prevSql.equals("")) continue;
            if (operation.equals("createRow")) {
                this.pers.setSqlStatementFor(operation, this.createRowQuery);
                continue;
            }
            if (operation.equals("deleteRow")) {
                this.pers.setSqlStatementFor(operation, this.deleteRowQuery);
                continue;
            }
            if (operation.equals("storeRow")) {
                this.pers.setSqlStatementFor(operation, this.storeRowQuery);
                continue;
            }
            if (operation.equals("loadRow")) {
                this.pers.setSqlStatementFor(operation, this.loadRowQuery);
                continue;
            }
            if (operation.equals("findByPrimaryKey")) {
                this.pers.setSqlStatementFor(operation, this.findByPrimaryKeyQuery);
                continue;
            }
            if (operation.equals("findBySourceKey")) {
                this.pers.setSqlStatementFor(operation, this.findBySourceKeyQuery);
                continue;
            }
            if (operation.equals("findBySinkKey")) {
                this.pers.setSqlStatementFor(operation, this.findBySinkKeyQuery);
                continue;
            }
            if (operation.startsWith("createTable")) {
                this.pers.setSqlStatementFor(operation, this.createTableQuery);
                continue;
            }
            if (!operation.startsWith("deleteTable")) continue;
            this.pers.setSqlStatementFor(operation, this.deleteTableQuery);
        }
        Iterator it = this.pers.getAllPossibleQueriedMethods().iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            QueryDescriptor qd = this.pers.getQueryFor(method);
            if (qd == null) {
                qd = new QueryDescriptor();
                qd.setQueryMethod(method);
                this.pers.setQueryFor(method, qd);
            }
            if (qd.getIsEjbQl() || !overWrite && qd.getSQL() != null && !qd.getSQL().equals("")) continue;
            qd.setSQL(this.nonPrimaryKeyFinderQuery);
        }
    }

    private void printQueries() {
        System.err.println("findByPrimaryKey query: " + this.findByPrimaryKeyQuery);
        System.err.println("loadRowQuery query: " + this.loadRowQuery);
        System.err.println("storeRowQuery query: " + this.storeRowQuery);
        System.err.println("deleteRowQuery query: " + this.deleteRowQuery);
        System.err.println("createRowQuery query: " + this.createRowQuery);
        System.err.println("Table Create query: " + this.createTableQuery);
        System.err.println("Table Remove query: " + this.deleteTableQuery);
        if (this.pers.getParentDescriptor() instanceof JoinObjectDescriptor) {
            System.err.println("findBySourceKey query: " + this.findBySourceKeyQuery);
            System.err.println("findBySinkKey query: " + this.findBySinkKeyQuery);
        }
    }

    private void generateWhereClause() {
        String clause = " WHERE ";
        int i2 = 0;
        while (i2 < this.pkeyFieldNames.length) {
            if (i2 > 0) {
                clause = clause + " AND ";
            }
            clause = clause + this.pkeyFieldNames[i2] + " = ? ";
            ++i2;
        }
        this.whereClause = clause;
    }

    private void generateCreateTableQuery() {
        String query = "CREATE TABLE " + this.tableName + " (";
        int i2 = 0;
        while (i2 < this.contMgFieldNames.length) {
            int jdbcType;
            if (i2 > 0) {
                query = query + " , ";
            }
            Class javaObjClass = this.pers.getPersistentFieldInfo()[i2].type;
            String sqlType = this.typeMapper.getSQLTypeFor(javaObjClass);
            query = query + this.contMgFieldNames[i2] + " " + sqlType;
            if (javaObjClass.isPrimitive()) {
                query = query + " NOT NULL";
            } else if (this.isMSSqlServer && !this.isPkeyField(this.contMgFieldNames[i2]) && (jdbcType = this.typeMapper.getJDBCTypeFor(javaObjClass)) != -7) {
                query = query + " NULL";
            }
            ++i2;
        }
        String constraintName = "\"pk_" + this.tableName.substring(1, this.tableName.length() - 2) + "\"";
        query = query + ", CONSTRAINT " + constraintName + " PRIMARY KEY (";
        int i3 = 0;
        while (i3 < this.pkeyFieldNames.length) {
            if (i3 > 0) {
                query = query + " , ";
            }
            query = query + this.pkeyFieldNames[i3];
            ++i3;
        }
        this.createTableQuery = query = query + ") )";
    }

    private boolean isPkeyField(String fieldname) {
        int i2 = 0;
        while (i2 < this.pkeyFieldNames.length) {
            if (this.pkeyFieldNames[i2].equals(fieldname)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private void generateDeleteTableQuery() {
        this.deleteTableQuery = "DROP TABLE " + this.tableName;
    }

    private void generateNonPrimaryKeyFinderQuery() {
        this.nonPrimaryKeyFinderQuery = "SELECT ";
        int i2 = 0;
        while (i2 < this.pkeyFieldNames.length) {
            if (i2 > 0) {
                this.nonPrimaryKeyFinderQuery = this.nonPrimaryKeyFinderQuery + " , ";
            }
            this.nonPrimaryKeyFinderQuery = this.nonPrimaryKeyFinderQuery + this.pkeyFieldNames[i2];
            ++i2;
        }
        this.nonPrimaryKeyFinderQuery = this.nonPrimaryKeyFinderQuery + " FROM " + this.tableName;
    }

    private void generateFindByPrimaryKeyQuery() {
        this.findByPrimaryKeyQuery = "SELECT ";
        int i2 = 0;
        while (i2 < this.pkeyFieldNames.length) {
            if (i2 > 0) {
                this.findByPrimaryKeyQuery = this.findByPrimaryKeyQuery + " , ";
            }
            this.findByPrimaryKeyQuery = this.findByPrimaryKeyQuery + this.pkeyFieldNames[i2];
            ++i2;
        }
        this.findByPrimaryKeyQuery = this.findByPrimaryKeyQuery + " FROM " + this.tableName + this.whereClause;
    }

    private void generateFindBySourceSinkKeyQuery() {
        JoinObjectDescriptor joinDesc = (JoinObjectDescriptor)this.pers.getParentDescriptor();
        RelationshipDescriptor rd = joinDesc.getRelationshipDesc();
        RelationRoleDescriptor source = rd.getSource();
        RelationRoleDescriptor sink = rd.getSink();
        PersistenceDescriptor sourcePers = source.getPersistenceDescriptor();
        PersistenceDescriptor sinkPers = sink.getPersistenceDescriptor();
        PersistentFieldInfo[] joinFields = this.pers.getPersistentFieldInfo();
        this.findBySourceKeyQuery = "SELECT ";
        this.findBySinkKeyQuery = "SELECT ";
        int sourceCount = 0;
        int sinkCount = 0;
        int i2 = 0;
        while (i2 < joinFields.length) {
            if (joinFields[i2].relatedObj == sinkPers) {
                if (sourceCount > 0) {
                    this.findBySourceKeyQuery = this.findBySourceKeyQuery + " , ";
                }
                this.findBySourceKeyQuery = this.findBySourceKeyQuery + joinFields[i2].columnName;
                ++sourceCount;
            } else {
                if (sinkCount > 0) {
                    this.findBySinkKeyQuery = this.findBySinkKeyQuery + " , ";
                }
                this.findBySinkKeyQuery = this.findBySinkKeyQuery + joinFields[i2].columnName;
                ++sinkCount;
            }
            ++i2;
        }
        this.findBySourceKeyQuery = this.findBySourceKeyQuery + " FROM " + this.tableName;
        this.findBySinkKeyQuery = this.findBySinkKeyQuery + " FROM " + this.tableName;
        sourceCount = 0;
        sinkCount = 0;
        this.findBySourceKeyQuery = this.findBySourceKeyQuery + " WHERE ";
        this.findBySinkKeyQuery = this.findBySinkKeyQuery + " WHERE ";
        int i3 = 0;
        while (i3 < joinFields.length) {
            if (joinFields[i3].relatedObj == sinkPers) {
                if (sinkCount > 0) {
                    this.findBySinkKeyQuery = this.findBySinkKeyQuery + " AND ";
                }
                this.findBySinkKeyQuery = this.findBySinkKeyQuery + joinFields[i3].columnName + " = ? ";
                ++sinkCount;
            } else {
                if (sourceCount > 0) {
                    this.findBySourceKeyQuery = this.findBySourceKeyQuery + " AND ";
                }
                this.findBySourceKeyQuery = this.findBySourceKeyQuery + joinFields[i3].columnName + " = ? ";
                ++sourceCount;
            }
            ++i3;
        }
    }

    private void generateLoadRowQuery() {
        this.loadRowQuery = "SELECT ";
        int i2 = 0;
        while (i2 < this.contMgNoPkeyFieldNames.length) {
            if (i2 > 0) {
                this.loadRowQuery = this.loadRowQuery + " , ";
            }
            this.loadRowQuery = this.loadRowQuery + this.contMgNoPkeyFieldNames[i2];
            ++i2;
        }
        if (this.contMgNoPkeyFieldNames.length == 0) {
            this.loadRowQuery = this.loadRowQuery + " * ";
        }
        this.loadRowQuery = this.loadRowQuery + " FROM " + this.tableName + this.whereClause;
    }

    private void generateStoreRowQuery() {
        if (this.contMgNoPkeyFieldNames.length == 0) {
            this.storeRowQuery = " ";
            return;
        }
        this.storeRowQuery = "UPDATE " + this.tableName + " SET ";
        int i2 = 0;
        while (i2 < this.contMgNoPkeyFieldNames.length) {
            if (i2 > 0) {
                this.storeRowQuery = this.storeRowQuery + " , ";
            }
            this.storeRowQuery = this.storeRowQuery + this.contMgNoPkeyFieldNames[i2] + " = ? ";
            ++i2;
        }
        this.storeRowQuery = this.storeRowQuery + this.whereClause;
    }

    private void generateCreateRowQuery() {
        String query = "INSERT INTO " + this.tableName + " ( ";
        int i2 = 0;
        while (i2 < this.contMgFieldNames.length) {
            if (i2 > 0) {
                query = query + " , ";
            }
            query = query + this.contMgFieldNames[i2];
            ++i2;
        }
        query = query + " ) VALUES ( ";
        int i3 = 0;
        while (i3 < this.contMgFieldNames.length) {
            if (i3 > 0) {
                query = query + " , ";
            }
            query = query + " ? ";
            ++i3;
        }
        this.createRowQuery = query = query + " )";
    }

    private void generateDeleteRowQuery() {
        this.deleteRowQuery = "DELETE FROM " + this.tableName + this.whereClause;
    }

    private static void generateSQLForEjbQLQueries(PersistenceDescriptor pers, EjbQLDriver ejbqlDriver) throws Exception {
        Set allQueriedMethods = pers.getQueriedMethods();
        Iterator iter = allQueriedMethods.iterator();
        while (iter.hasNext()) {
            Method next = (Method)iter.next();
            QueryDescriptor queryDesc = pers.getQueryFor(next);
            if (!queryDesc.getIsEjbQl()) continue;
            String queryStr = queryDesc.getQuery();
            EjbQLQuery query = ejbqlDriver.parse(pers, next, queryStr);
            String generatedSql = ejbqlDriver.generateSql(query);
            System.out.println("Generated sql = " + generatedSql);
            queryDesc.setSQL(generatedSql);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

