/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient;

import com.sun.enterprise.appclient.AppContainer;
import com.sun.enterprise.security.ClientSecurityContext;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;

public class HttpAuthenticator
extends Authenticator {
    public static final boolean debug = false;
    private AppContainer container = null;

    public HttpAuthenticator(AppContainer container) {
        this.container = container;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        String user = null;
        String password = null;
        Subject subject = null;
        String scheme = this.getRequestingScheme();
        ClientSecurityContext cont = ClientSecurityContext.getCurrent();
        subject = cont.getSubject();
        user = this.getUserName(subject);
        password = this.getPassword(subject);
        if (user == null || password == null) {
            try {
                LoginContextDriver.doClientLogin(1, AppContainer.handler);
                cont = ClientSecurityContext.getCurrent();
                subject = cont.getSubject();
                user = this.getUserName(subject);
                password = this.getPassword(subject);
            }
            catch (Exception e10) {
                return null;
            }
        }
        return new PasswordAuthentication(user, password.toCharArray());
    }

    private String getUserName(Subject s2) {
        String user = null;
        if (s2 == null) {
            return null;
        }
        Set principalSet = s2.getPrincipals();
        Iterator itr = principalSet.iterator();
        if (itr.hasNext()) {
            Principal p2 = (Principal)itr.next();
            user = p2.getName();
        }
        return user;
    }

    private String getPassword(Subject s2) {
        Object o2;
        String password = null;
        if (s2 == null) {
            return null;
        }
        Set credentials = s2.getPrivateCredentials();
        Iterator credIter = credentials.iterator();
        if (credIter.hasNext() && (o2 = credIter.next()) instanceof PasswordCredential) {
            PasswordCredential pc = (PasswordCredential)o2;
            password = pc.getPassword();
        }
        return password;
    }
}

