/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class Application
extends Descriptor
implements NotificationListener,
Roles {
    private transient ApplicationArchivist applicationArchivist;
    private Set ejbBundleDescriptors = new HashSet();
    private Set webBundleDescriptors = new HashSet();
    private Set applicationClientDescriptors = new HashSet();
    private Set rarDescriptors = new HashSet();
    private Hashtable cmpDescriptors = null;
    private boolean isDirty;
    private RoleMapper roleMapper;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$Application == null ? (class$com$sun$enterprise$deployment$Application = Application.class$("com.sun.enterprise.deployment.Application")) : class$com$sun$enterprise$deployment$Application);
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Application;

    public Application(String name, File jar) {
        super(name, localStrings.getLocalString("enterprise.deployment.application.description", "Application description"));
        this.applicationArchivist = new ApplicationArchivist(jar, this);
    }

    public Application() {
        super("", localStrings.getLocalString("enterprise.deployment.application.description", "Application description"));
    }

    public Set getRoles() {
        HashSet roles = new HashSet();
        Iterator itr = this.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
            roles.addAll(wbd.getRoles());
        }
        Iterator itr2 = this.getEjbBundleDescriptors().iterator();
        while (itr2.hasNext()) {
            EjbBundleDescriptor ejbd = (EjbBundleDescriptor)itr2.next();
            roles.addAll(ejbd.getRoles());
        }
        return roles;
    }

    public void addRole(Role role) {
        Iterator itr = this.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
            wbd.addRole(role);
        }
        Iterator itr2 = this.getEjbBundleDescriptors().iterator();
        while (itr2.hasNext()) {
            EjbBundleDescriptor ejbd = (EjbBundleDescriptor)itr2.next();
            ejbd.addRole(role);
        }
        this.changed();
    }

    public void removeRole(Role role) {
        Iterator itr = this.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
            wbd.removeRole(role);
        }
        Iterator itr2 = this.getEjbBundleDescriptors().iterator();
        while (itr2.hasNext()) {
            EjbBundleDescriptor ejbd = (EjbBundleDescriptor)itr2.next();
            ejbd.removeRole(role);
        }
        this.changed();
    }

    public Set getResourceReferenceDescriptors() {
        HashSet resourceReferences = new HashSet();
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbd = (EjbBundleDescriptor)itr.next();
            resourceReferences.addAll(ejbd.getResourceReferenceDescriptors());
        }
        return resourceReferences;
    }

    void setApplicationArchivist(ApplicationArchivist applicationArchivist) {
        this.applicationArchivist = applicationArchivist;
    }

    public ApplicationArchivist getApplicationArchivist() {
        return this.applicationArchivist;
    }

    public void setName(String name) {
        name = name.replace('/', '-');
        name = name.replace('\\', '-');
        this.setDirty(true);
        super.setName(name);
        this.getRoleMapper().setName(name);
    }

    public void setDescription(String description) {
        this.setDirty(true);
        super.setDescription(description);
    }

    public void setLargeIconUri(String largeIconUri) {
        this.setDirty(true);
        super.setLargeIconUri(largeIconUri);
    }

    public void setSmallIconUri(String smallIconUri) {
        this.setDirty(true);
        super.setSmallIconUri(smallIconUri);
    }

    public int getWebComponentCount() {
        int count = 0;
        Iterator itr = this.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
            count += wbd.getWebDescriptors().size();
        }
        return count;
    }

    public int getEjbComponentCount() {
        int count = 0;
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbd = (EjbBundleDescriptor)itr.next();
            count += ejbd.getEjbs().size();
        }
        return count;
    }

    public int getRarComponentCount() {
        return this.getRarDescriptors().size();
    }

    public Vector getEjbReferenceDescriptors() {
        Vector ejbReferenceDescriptors = new Vector();
        Iterator itr = this.getNamedDescriptors().iterator();
        while (itr.hasNext()) {
            Object next = itr.next();
            if (!(next instanceof EjbReferenceDescriptor)) continue;
            ejbReferenceDescriptors.addElement(next);
        }
        return ejbReferenceDescriptors;
    }

    public EjbBundleDescriptor getEjbBundleByName(String name) {
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            if (!ejbBundleDescriptor.getName().equals(name)) continue;
            return ejbBundleDescriptor;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoejbjarnamed", "This application has no ejb jars of name {0}", new Object[]{name}));
    }

    public EjbBundleDescriptor getEjbBundleByUri(String name) {
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            if (!ejbBundleDescriptor.getArchivist().getArchiveUri().equals(name)) continue;
            return ejbBundleDescriptor;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoejbjarnamed", "This application has no ejb jars of name {0}", new Object[]{name}));
    }

    public EjbDescriptor getEjbByName(String ejbName) {
        Object ejbDescriptor = null;
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            if (!ejbBundleDescriptor.hasEjbByName(ejbName)) continue;
            return ejbBundleDescriptor.getEjbByName(ejbName);
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnobeannamed", "This application has no beans of name {0}", new Object[]{ejbName}));
    }

    public boolean hasEjbByName(String ejbName) {
        Object ejbDescriptor = null;
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            if (!ejbBundleDescriptor.hasEjbByName(ejbName)) continue;
            return true;
        }
        return false;
    }

    public ApplicationClientDescriptor getApplicationClientByName(String name) {
        Iterator itr = this.getApplicationClientDescriptors().iterator();
        while (itr.hasNext()) {
            ApplicationClientDescriptor next = (ApplicationClientDescriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoappclientname", "This application has no application clients of name {0}", new Object[]{name}));
    }

    public WebBundleDescriptor getWebBundleDescriptorByName(String name) {
        Iterator itr = this.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor next = (WebBundleDescriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnowebappname", "This application has no web app of name {0}", new Object[]{name}));
    }

    public WebBundleDescriptor getWebBundleDescriptorByUri(String name) {
        Iterator itr = this.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor next = (WebBundleDescriptor)itr.next();
            if (!next.getArchivist().getArchiveUri().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnowebappname", "This application has no web app of name {0}", new Object[]{name}));
    }

    public ConnectorDescriptor getRarDescriptorByUri(String name) {
        Iterator itr = this.getRarDescriptors().iterator();
        while (itr.hasNext()) {
            ConnectorDescriptor next = (ConnectorDescriptor)itr.next();
            if (!next.getArchivist().getArchiveUri().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(name);
    }

    public Set getJndiNameEnvironments() {
        HashSet jndiNameEnvironments = new HashSet();
        jndiNameEnvironments.addAll(this.getWebBundleDescriptors());
        jndiNameEnvironments.addAll(this.getApplicationClientDescriptors());
        jndiNameEnvironments.addAll(this.getEjbDescriptors());
        return jndiNameEnvironments;
    }

    public Set getWebBundleDescriptors() {
        if (this.webBundleDescriptors == null) {
            this.webBundleDescriptors = new HashSet();
        }
        return this.webBundleDescriptors;
    }

    public void addWebBundleDescriptor(WebBundleDescriptor webBundleDescriptor) {
        webBundleDescriptor.addNotificationListener(this);
        webBundleDescriptor.setApplication(this);
        this.getWebBundleDescriptors().add(webBundleDescriptor);
        this.changed(true);
    }

    public void removeWebBundleDescriptor(WebBundleDescriptor webBundleDescriptor) {
        webBundleDescriptor.removeNotificationListener(this);
        webBundleDescriptor.setApplication(null);
        this.getWebBundleDescriptors().remove(webBundleDescriptor);
        this.changed(true);
    }

    public Set getRarDescriptors() {
        if (this.rarDescriptors == null) {
            this.rarDescriptors = new HashSet();
        }
        return this.rarDescriptors;
    }

    public void addRarDescriptor(ConnectorDescriptor rarDescriptor) {
        rarDescriptor.addNotificationListener(this);
        rarDescriptor.setApplication(this);
        this.getRarDescriptors().add(rarDescriptor);
        this.changed(true);
    }

    public void removeRarDescriptor(ConnectorDescriptor rarDescriptor) {
        rarDescriptor.removeNotificationListener(this);
        rarDescriptor.setApplication(null);
        this.getRarDescriptors().remove(rarDescriptor);
        this.changed(true);
    }

    public Set getEjbBundleDescriptors() {
        if (this.ejbBundleDescriptors == null) {
            this.ejbBundleDescriptors = new HashSet();
        }
        return this.ejbBundleDescriptors;
    }

    public void addEjbBundleDescriptor(EjbBundleDescriptor ejbBundleDescriptor) {
        this.getEjbBundleDescriptors().add(ejbBundleDescriptor);
        ejbBundleDescriptor.addNotificationListener(this);
        ejbBundleDescriptor.setApplication(this);
        this.changed(true);
    }

    public void removeEjbBundleDescriptor(EjbBundleDescriptor ejbBundleDescriptor) {
        this.getEjbBundleDescriptors().remove(ejbBundleDescriptor);
        ejbBundleDescriptor.removeNotificationListener(this);
        ejbBundleDescriptor.setApplication(null);
        this.changed(true);
    }

    public Set getApplicationClientDescriptors() {
        if (this.applicationClientDescriptors == null) {
            this.applicationClientDescriptors = new HashSet();
        }
        return this.applicationClientDescriptors;
    }

    public void addApplicationClientDescriptor(ApplicationClientDescriptor applicationClientDescriptor) {
        this.getApplicationClientDescriptors().add(applicationClientDescriptor);
        applicationClientDescriptor.addNotificationListener(this);
        applicationClientDescriptor.setApplication(this);
        this.changed(true);
    }

    public void removeApplicationClientDescriptor(ApplicationClientDescriptor applicationClientDescriptor) {
        this.getApplicationClientDescriptors().remove(applicationClientDescriptor);
        applicationClientDescriptor.removeNotificationListener(this);
        applicationClientDescriptor.setApplication(null);
        this.changed(true);
    }

    public EjbCMPEntityDescriptor getCMPDescriptorFor(String className) {
        if (this.cmpDescriptors == null) {
            this.cmpDescriptors = new Hashtable();
            Iterator ejbBundles = this.getEjbBundleDescriptors().iterator();
            while (ejbBundles.hasNext()) {
                EjbBundleDescriptor bundle = (EjbBundleDescriptor)ejbBundles.next();
                Iterator ejbs = bundle.getEjbs().iterator();
                while (ejbs.hasNext()) {
                    EjbDescriptor ejb = (EjbDescriptor)ejbs.next();
                    if (!(ejb instanceof EjbCMPEntityDescriptor)) continue;
                    this.cmpDescriptors.put(ejb.getEjbClassName(), ejb);
                }
            }
        }
        return (EjbCMPEntityDescriptor)this.cmpDescriptors.get(className);
    }

    public Vector getNamedReferencePairs() {
        Vector pairs = new Vector();
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            pairs.addAll(ejbBundleDescriptor.getNamedReferencePairs());
        }
        Iterator itr2 = this.getWebBundleDescriptors().iterator();
        while (itr2.hasNext()) {
            WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)itr2.next();
            pairs.addAll(webBundleDescriptor.getNamedReferencePairs());
        }
        Iterator itr3 = this.getApplicationClientDescriptors().iterator();
        while (itr3.hasNext()) {
            ApplicationClientDescriptor applicationClientDescriptor = (ApplicationClientDescriptor)itr3.next();
            pairs.addAll(applicationClientDescriptor.getNamedReferencePairs());
        }
        return pairs;
    }

    public Collection getNamedDescriptors() {
        Vector namedDescriptors = new Vector();
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            namedDescriptors.addAll(ejbBundleDescriptor.getNamedDescriptors());
        }
        Iterator itr2 = this.getWebBundleDescriptors().iterator();
        while (itr2.hasNext()) {
            WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)itr2.next();
            namedDescriptors.addAll(webBundleDescriptor.getNamedDescriptors());
        }
        Iterator itr3 = this.getApplicationClientDescriptors().iterator();
        while (itr3.hasNext()) {
            ApplicationClientDescriptor applicationClientDescriptor = (ApplicationClientDescriptor)itr3.next();
            namedDescriptors.addAll(applicationClientDescriptor.getNamedDescriptors());
        }
        return namedDescriptors;
    }

    public Vector getEjbDescriptors() {
        Vector ejbDescriptors = new Vector();
        Iterator itr = this.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            ejbDescriptors.addAll(ejbBundleDescriptor.getEjbs());
        }
        return ejbDescriptors;
    }

    public void addApplication(Application application) {
        Iterator itr = application.getEjbBundleDescriptors().iterator();
        while (itr.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)itr.next();
            this.addEjbBundleDescriptor(ejbBundleDescriptor);
        }
        Iterator itr2 = application.getWebBundleDescriptors().iterator();
        while (itr2.hasNext()) {
            WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)itr2.next();
            this.addWebBundleDescriptor(webBundleDescriptor);
        }
        Iterator itr3 = application.getApplicationClientDescriptors().iterator();
        while (itr3.hasNext()) {
            ApplicationClientDescriptor acd = (ApplicationClientDescriptor)itr3.next();
            this.addApplicationClientDescriptor(acd);
        }
        Iterator itr4 = application.getRarDescriptors().iterator();
        while (itr4.hasNext()) {
            ConnectorDescriptor rarDescriptor = (ConnectorDescriptor)itr4.next();
            this.addRarDescriptor(rarDescriptor);
        }
    }

    public Set getArchivableDescriptors() {
        HashSet archivableDescriptors = new HashSet();
        archivableDescriptors.addAll(this.getEjbBundleDescriptors());
        archivableDescriptors.addAll(this.getWebBundleDescriptors());
        archivableDescriptors.addAll(this.getApplicationClientDescriptors());
        archivableDescriptors.addAll(this.getRarDescriptors());
        return archivableDescriptors;
    }

    public void setRoleMapper(RoleMapper roleMapper) {
        this.roleMapper = roleMapper;
        this.changed(true);
    }

    public boolean hasRuntimeInformation() {
        return true;
    }

    public RoleMapper getRoleMapper() {
        if (this.roleMapper == null) {
            this.roleMapper = RoleMapper.getRoleMapper(this.getName());
        }
        return this.roleMapper;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void addEjbJarFile(File ejbJarFile) throws Exception {
        this.applicationArchivist.addEjbJar(ejbJarFile);
        this.changed(true);
    }

    public void addWebJarFile(File ejbJarFile) throws Exception {
        this.applicationArchivist.addWebJar(ejbJarFile);
        this.changed(true);
    }

    public void addRarFile(File rarFile) throws Exception {
        this.applicationArchivist.addRar(rarFile, null, null);
        this.changed(true);
    }

    public void addAppClientJarFile(File jarFile) throws Exception {
        this.applicationArchivist.addApplicationClientJar(jarFile, new HashSet());
        this.changed(true);
    }

    public void notification(NotificationEvent ne) {
        this.changed(true);
    }

    public void changed() {
        NotificationEvent ne = new NotificationEvent(this, Descriptor.DESCRIPTOR_CHANGED, this);
        Vector listenersClone = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            listenersClone = (Vector)this.listeners.clone();
        }
        Enumeration e10 = listenersClone.elements();
        while (e10.hasMoreElements()) {
            NotificationListener nl = (NotificationListener)e10.nextElement();
            nl.notification(ne);
        }
    }

    public String toString() {
        String s2 = "Application";
        s2 = s2 + "\n name " + this.getName();
        s2 = s2 + "\n smallIcon " + super.getSmallIconUri();
        s2 = s2 + "\n archivist " + this.getApplicationArchivist();
        s2 = s2 + "\n EjbBundles: \n" + this.getEjbBundleDescriptors();
        s2 = s2 + "\n WebBundleDescriptors " + this.getWebBundleDescriptors();
        s2 = s2 + "\n applicationClientDescriptors " + this.getApplicationClientDescriptors();
        s2 = s2 + "\n roles " + this.getRoles();
        s2 = s2 + "\n RoleMapper " + this.getRoleMapper();
        return s2;
    }

    void doneSaving() {
        this.isDirty = false;
        this.changed(false);
    }

    public void doneOpening() {
        this.isDirty = false;
        this.changed(false);
    }

    private void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public void changed(boolean dirtyChange) {
        if (dirtyChange) {
            this.isDirty = true;
        }
        super.changed();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

