/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.AbstractArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ArchiveException;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.xml.ConnectorNode;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.xml.sax.SAXParseException;

public class ConnectorArchivist
extends Archivist {
    public static final String DESTINATION_CLASSES = "RA-INF" + File.separator + "classes";
    public static String DEPLOYMENT_DESCRIPTOR_ENTRY = "META-INF/ra.xml";
    public static final String RI_SPECIFIC_DESCRIPTOR_ENTRY = "META-INF/sun-j2ee-ri.xml";
    private ConnectorDescriptor connectorDescriptor;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$ConnectorArchivist == null ? (class$com$sun$enterprise$deployment$ConnectorArchivist = ConnectorArchivist.class$("com.sun.enterprise.deployment.ConnectorArchivist")) : class$com$sun$enterprise$deployment$ConnectorArchivist);
    Set rarContents = new OrderedSet();
    static /* synthetic */ Class class$com$sun$enterprise$deployment$ConnectorArchivist;

    public ConnectorArchivist(String archiveUri, ConnectorDescriptor connectorDescriptor) {
        this(true, archiveUri, connectorDescriptor);
    }

    public ConnectorArchivist(boolean hasArchiveFile, String archiveUri, ConnectorDescriptor connectorDescriptor, Set manifestClasspath) {
        super(archiveUri, hasArchiveFile);
        this.manifestClasspath = new HashSet(manifestClasspath);
        this.connectorDescriptor = connectorDescriptor;
        this.connectorDescriptor.setArchivist(this);
    }

    public ConnectorArchivist(boolean hasArchiveFile, String archiveUri, ConnectorDescriptor connectorDescriptor) {
        super(archiveUri, hasArchiveFile);
        this.connectorDescriptor = connectorDescriptor;
        this.connectorDescriptor.setArchivist(this);
    }

    public static String getConnectorDirectory() {
        String result = FileUtil.getAbsolutePath(ResourceInstaller.CONNECTOR_ADAPTER_DIR);
        return result;
    }

    public Descriptor getDescriptor() {
        return this.connectorDescriptor;
    }

    public static boolean isConnector(File jarFile) throws IOException {
        Archivist.checkExists(jarFile);
        JarFile jar = new JarFile(jarFile);
        ZipEntry ze = jar.getEntry(DEPLOYMENT_DESCRIPTOR_ENTRY);
        boolean isConnector = ze != null;
        jar.close();
        return isConnector;
    }

    protected File getArchiveFile() throws IOException {
        File archiveFile = new File(this.getArchiveUri());
        Application application = this.connectorDescriptor.getApplication();
        if (application != null) {
            ApplicationArchivist appArchivist = application.getApplicationArchivist();
            File applicationFile = appArchivist.getApplicationFile();
            archiveFile = Archivist.getConnectorTemp(Archivist.getDirectory(applicationFile));
            appArchivist.extractBundleToFile(this.connectorDescriptor, archiveFile);
            archiveFile.deleteOnExit();
        }
        return archiveFile;
    }

    private static void writeEntry(String entryName, FileInputStream fis, ZipOutputStream zipOut, File actualFile) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        entry.setTime(System.currentTimeMillis());
        fis = new FileInputStream(actualFile);
        zipOut.putNextEntry(entry);
        Archivist.copy(fis, zipOut);
        fis.close();
        zipOut.closeEntry();
    }

    public static ConnectorDescriptor open(File rarFile) throws IOException, ArchiveException {
        try {
            return ConnectorArchivist.open(rarFile, false);
        }
        catch (SAXParseException spe) {
            return null;
        }
    }

    public static ConnectorDescriptor open(File rarFile, boolean validateXML) throws IOException, ArchiveException, SAXParseException {
        if (!rarFile.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionrarinfodoesn'texist", "{0} does not exist", new Object[]{rarFile}));
        }
        JarFile rar = new JarFile(rarFile);
        ConnectorDescriptor descriptor = ConnectorArchivist.open(rarFile, DEPLOYMENT_DESCRIPTOR_ENTRY, rar, validateXML);
        rar.close();
        return descriptor;
    }

    static ConnectorDescriptor open(File rarFile, String descriptorEntryName, JarFile jarContainingDescriptor) throws IOException, ArchiveException {
        try {
            return ConnectorArchivist.open(rarFile, descriptorEntryName, jarContainingDescriptor, false);
        }
        catch (SAXParseException spe) {
            return null;
        }
    }

    static ConnectorDescriptor open(File rarFile, String descriptorEntryName, JarFile jarContainingDescriptor, boolean validateXML) throws IOException, ArchiveException, SAXParseException {
        if (!rarFile.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionappclientjarinfodoesn'texist", "{0} does not exist", new Object[]{rarFile}));
        }
        ZipEntry deploymentEntry = jarContainingDescriptor.getEntry(descriptorEntryName);
        if (deploymentEntry != null) {
            if (validateXML) {
                Archivist.validate(jarContainingDescriptor.getInputStream(deploymentEntry));
            }
            InputStream is = jarContainingDescriptor.getInputStream(deploymentEntry);
            ConnectorNode node = ConnectorNode.read(is);
            is.close();
            ConnectorDescriptor connectorDescriptor = node.getDescriptor();
            ConnectorArchivist archivist = new ConnectorArchivist(rarFile.toString(), connectorDescriptor);
            archivist.setManifestClasspaths(jarContainingDescriptor.getManifest());
            connectorDescriptor.setArchivist(archivist);
            connectorDescriptor.doneOpening();
            return connectorDescriptor;
        }
        throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionnodeployinfofoundatin", "No deployment info found at: {0} in {1}", new Object[]{descriptorEntryName, jarContainingDescriptor.getName()}));
    }

    public File getRarFile() {
        return new File(this.getArchiveUri());
    }

    public void save(File destinationFile) throws IOException {
        this.save(destinationFile, DEPLOYMENT_DESCRIPTOR_ENTRY, null);
    }

    void save(File destinationFile, String descriptorEntryName, ZipOutputStream descriptorOut) throws IOException {
        File tmpFile = Archivist.getRarTemp(Archivist.getDirectory(destinationFile));
        ZipOutputStream fileOut = new ZipOutputStream(new FileOutputStream(tmpFile));
        if (descriptorOut == null) {
            this.writeDeploymentInfo(fileOut, descriptorEntryName, false);
        } else {
            this.writeDeploymentInfo(descriptorOut, descriptorEntryName, true);
        }
        Manifest manifest = this.createManifest();
        Archivist.writeManifest(manifest, fileOut);
        Vector<String> entryNamesToSkip = new Vector<String>();
        if (descriptorOut == null) {
            entryNamesToSkip.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
            entryNamesToSkip.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        }
        entryNamesToSkip.addElement("META-INF/MANIFEST.MF");
        this.writeEntriesToOutput(fileOut, entryNamesToSkip);
        fileOut.close();
        destinationFile.delete();
        boolean renamed = tmpFile.renameTo(destinationFile);
        if (!renamed) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionerrorsavingrar", "Error saving RAR"));
        }
        this.setHasArchive(true, destinationFile.toString());
        this.connectorDescriptor.doneSaving();
    }

    private static String getRuntimeEntryNameFrom(String name) {
        return RI_SPECIFIC_DESCRIPTOR_ENTRY + name;
    }

    public void writeDeploymentInfo(ZipOutputStream zos, String descriptorEntryName, boolean externalDescriptor) throws IOException {
        Archivist.writeDocumentToJar(ConnectorNode.getDocument(this.connectorDescriptor), descriptorEntryName, zos);
    }

    public Set getAllJarFiles(File rarFile) {
        try {
            JarFile jar = new JarFile(rarFile);
            Enumeration<JarEntry> e10 = jar.entries();
            while (e10.hasMoreElements()) {
                JarEntry je = e10.nextElement();
                this.rarContents.add(je.getName());
            }
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        return this.rarContents;
    }

    public boolean isDeletable(String entryName) {
        boolean entryIsDeletable = true;
        if (entryName.equals("META-INF/MANIFEST.MF") || entryName.equals(DEPLOYMENT_DESCRIPTOR_ENTRY) || entryName.equals(RI_SPECIFIC_DESCRIPTOR_ENTRY)) {
            entryIsDeletable = false;
        }
        return entryIsDeletable;
    }

    public void updateFiles(Hashtable newFiles) throws IOException {
        super.updateFiles(newFiles);
        this.connectorDescriptor.changed();
    }

    public void removeEntries(Vector entriesToRemove) throws IOException {
        super.removeEntries(entriesToRemove);
        this.connectorDescriptor.changed();
    }

    public static void createPackage(FileContentsDescriptor classFcd, File descriptorFile, File destinationFile) throws IOException, ArchiveException {
        if (!descriptorFile.exists()) {
            throw new IOException("Cannot package web application: " + descriptorFile + "  does not exist.");
        }
        FileInputStream fis = new FileInputStream(descriptorFile);
        System.out.println("Reading connector nodes");
        ConnectorNode connectorNode = ConnectorNode.read(fis);
        System.out.println("Done reading connector nodes");
        ConnectorDescriptor descriptor = null;
        try {
            descriptor = connectorNode.getDescriptor();
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            fis.close();
            throw new IOException("Error reading connector xml: " + t2.getMessage());
        }
        if (descriptor != null) {
            ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(destinationFile));
            ConnectorArchivist archivist = new ConnectorArchivist(destinationFile.toString(), descriptor);
            fis.close();
            Enumeration e10 = classFcd.getFiles();
            while (e10.hasMoreElements()) {
                File nextRelativeFile = (File)e10.nextElement();
                File actualFile = classFcd.getFullFileFor(nextRelativeFile);
                String entryName = nextRelativeFile.toString().replace(File.separatorChar, '/');
                if (DEPLOYMENT_DESCRIPTOR_ENTRY.equals(entryName)) continue;
                ConnectorArchivist.writeEntry(entryName, fis, zipOut, actualFile);
            }
            ConnectorArchivist.writeEntry(DEPLOYMENT_DESCRIPTOR_ENTRY, fis, zipOut, descriptorFile);
            Manifest manifest = new Manifest();
            Archivist.writeManifest(manifest, zipOut);
            zipOut.close();
            System.out.println("Created Resource Adapter Archive: " + destinationFile);
        }
    }

    public static Set getClassList(FileContentsDescriptor contents) {
        OrderedSet classList = new OrderedSet();
        Enumeration e10 = contents.getFiles();
        while (e10.hasMoreElements()) {
            File f2 = (File)e10.nextElement();
            if (f2.toString().endsWith(".class") || !f2.toString().endsWith(".jar")) continue;
            try {
                JarFile jar = new JarFile(contents.getFullFileFor(f2).toString());
                Enumeration<JarEntry> j2 = jar.entries();
                while (j2.hasMoreElements()) {
                    JarEntry je = j2.nextElement();
                    if (!je.getName().endsWith(".class")) continue;
                    classList.add(FileUtil.classNameFromEntryName(je.getName()));
                }
            }
            catch (IOException ioe) {
                System.out.println("ConnectorArchivist.getClassList: " + ioe.toString());
            }
        }
        return classList;
    }

    public static Set getClassList(Set jarFiles) throws IOException {
        OrderedSet classList = new OrderedSet();
        OrderedSet jarContents = new OrderedSet();
        try {
            Iterator itr = jarFiles.iterator();
            while (itr.hasNext()) {
                String file = (String)itr.next();
                if (!file.toString().endsWith(".jar")) continue;
                JarFile jar = new JarFile(file);
                Enumeration<JarEntry> e10 = jar.entries();
                while (e10.hasMoreElements()) {
                    JarEntry je = e10.nextElement();
                    if (!je.getName().endsWith(".class")) continue;
                    String className = FileUtil.classNameFromEntryName(je.getName());
                    jarContents.add(className);
                }
                if (jarContents == null) continue;
                classList.addAll(jarContents);
                jarContents.clear();
            }
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        return classList;
    }

    /*
     * WARNING - void declaration
     */
    protected void makeArchiveClassLoadable(JarInputStream jis, AbstractArchive out) throws IOException {
        ZipEntry element;
        while ((element = jis.getNextEntry()) != null) {
            ZipEntry entry;
            void var3_3;
            if (!var3_3.getName().endsWith(".jar")) continue;
            JarInputStream jarIn = new JarInputStream(jis);
            while ((entry = jarIn.getNextEntry()) != null) {
                void var5_5;
                out.addEntry(var5_5.getName(), jarIn);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

