/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.AbstractArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.tools.deployment.backend.DeploymentSession;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DeploymentContext {
    private static File tmpSrcDir;
    private static File tmpBinaryDir;
    private Application application;
    private AbstractArchive archive = null;
    private File appTmpDir = null;
    private DeploymentSession session;

    public DeploymentContext(AbstractArchive archive, Application application) {
        this.application = application;
        this.archive = archive;
    }

    public Application getApplication() {
        return this.application;
    }

    public AbstractArchive getArchive() {
        return this.archive;
    }

    public File getTempDirectory() {
        if (this.appTmpDir == null) {
            this.appTmpDir = new File(tmpSrcDir, this.application.getName());
            this.appTmpDir.mkdirs();
        }
        return this.appTmpDir;
    }

    public void setSession(DeploymentSession session) {
        this.session = session;
    }

    public DeploymentSession getSession() {
        return this.session;
    }

    public String getFileName(String className) {
        return this.getTempDirectory() + File.separator + className.replace('.', File.separatorChar) + ".java";
    }

    public String getClassName(String fileName) {
        String className = fileName;
        if (className.startsWith(this.getTempDirectory().toString())) {
            className = className.substring(this.getTempDirectory().toString().length());
        }
        if (className.indexOf(".java") != -1) {
            className = className.substring(0, className.indexOf(".java"));
        } else if (className.indexOf(".class") != -1) {
            className = className.substring(0, className.indexOf(".class"));
        }
        className = className.replace(File.separatorChar, '.');
        if (className.charAt(0) == '.') {
            className = className.substring(1);
        }
        return className;
    }

    public OutputStream createOutputStream(String className) throws IOException {
        String fileName = this.getFileName(className);
        File file = new File(fileName);
        if (file.getParent() != null) {
            new File(file.getParent()).mkdirs();
        }
        return new FileOutputStream(fileName);
    }

    public File getOutputDirectory() {
        return this.archive.getWriteableDirectory();
    }

    public File getSourceDirectory() {
        return this.archive.getSourceDirectory();
    }

    public String getClassPath() {
        return System.getProperty("java.class.path") + File.pathSeparator + this.getOutputDirectory().toString() + File.pathSeparator + this.getTempDirectory().toString();
    }

    public ClassLoader getClassLoader() {
        return this.application.getApplicationArchivist().getClassLoader();
    }

    public static File createApplicationTempDirectory(String appName) {
        File appTmpDir = new File(tmpBinaryDir, appName);
        if (appTmpDir.exists()) {
            System.out.println("Warning, binary temp directory already exists, cleaning...");
            DeploymentContext.deleteDirectory(appTmpDir);
        }
        appTmpDir.mkdirs();
        return appTmpDir;
    }

    public static void deleteDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            int i2 = 0;
            while (i2 < files.length) {
                File child = files[i2];
                if (child.isDirectory()) {
                    DeploymentContext.deleteDirectory(child);
                }
                child.delete();
                ++i2;
            }
        }
        dir.delete();
    }

    static {
        String eHome = System.getProperty("com.sun.enterprise.home");
        if (eHome == null) {
            eHome = "tmp";
        }
        String hostname = Utility.getLocalHost();
        String root = eHome + File.separator + "repository" + File.separator + hostname + File.separator;
        tmpSrcDir = new File(root + "gnrtrTMP");
        if (!tmpSrcDir.exists()) {
            tmpSrcDir.mkdir();
        }
        if (!(tmpBinaryDir = new File(root + "explodeTMP")).exists()) {
            tmpBinaryDir.mkdir();
        }
    }
}

